/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemObjectNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrTreeNodeType;
import com.sanrad.swing.components.SrTreeComboBox;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;

public class SrSystemObjectComboBox
extends SrTreeComboBox {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final String theNonSelectionText = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_SYS_OBJ_COMBO_NON_SELECTION_TEXT);
    private SysNodeProperties mySysNodeProperties;
    private SystemObjectNode myRootNode;
    private boolean myIsRootVisible = false;
    private MainTreeListener myMainTreeListener = new MainTreeListener();
    public static final SysNodeProperties CLUSTER_PROPERTIES = new SingleTypeProperties(ClusterNode.class){

        @Override
        public String getDisabledToolTip(SrTreeNode aNode) {
            String errMsg = super.getDisabledToolTip(aNode);
            if (errMsg == null && aNode instanceof ClusterNode) {
                errMsg = ClusterManager.validateCreateVirtualizationOnCluster((ClusterNode)aNode);
            }
            return errMsg;
        }
    };

    public SrSystemObjectComboBox(SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext) {
        this(aRootNode, aSystemContext, new SingleTypeProperties(aSystemContext), false);
    }

    public SrSystemObjectComboBox(SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext, SysNodeProperties aSysObjConstraints) {
        this(aRootNode, aSystemContext, aSysObjConstraints, false);
    }

    public SrSystemObjectComboBox(SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext, SysNodeProperties aSysObjConstraints, boolean aIsRootVisible) {
        super(aSystemContext, aSysObjConstraints != null ? aSysObjConstraints : new SingleTypeProperties(aSystemContext));
        this.mySysNodeProperties = aSysObjConstraints;
        if (this.mySysNodeProperties == null) {
            this.mySysNodeProperties = new SingleTypeProperties(aSystemContext);
        }
        this.myIsRootVisible = aIsRootVisible;
        this.setRootNode(aRootNode);
        this.setNonSelectionText(theNonSelectionText);
        SrMainTreeModel.getInstance().addTreeModelListener(this.myMainTreeListener);
    }

    public void setRootVisible(boolean aVisible) {
        if (this.myIsRootVisible != aVisible) {
            this.myIsRootVisible = aVisible;
            this.removeAllItems();
            this.setRootNode(this.myRootNode);
        }
    }

    public boolean isRootVisible() {
        return this.myIsRootVisible;
    }

    public void removeListeners() {
        SrMainTreeModel.getInstance().removeTreeModelListener(this.myMainTreeListener);
    }

    private void setRootNode(SystemObjectNode aRootNode) {
        if (aRootNode == null) {
            throw new IllegalArgumentException("The root node cannot be null");
        }
        this.myRootNode = aRootNode;
        this.addParentAndChildren(aRootNode);
    }

    private boolean isValidSystemNode(SrTreeNode aTreeNode) {
        return this.mySysNodeProperties.isValid(aTreeNode);
    }

    private boolean hasValidSystemNodeChild(SrTreeNode aParent) {
        List<SystemObjectNode> contextSubTreeChildren = aParent.findAllInSubTree(SystemObjectNode.class);
        for (SystemObjectNode subTreeChild : contextSubTreeChildren) {
            if (!this.isValidSystemNode((SrTreeNode)((Object)subTreeChild))) continue;
            return true;
        }
        return false;
    }

    private void addParentAndChildren(SystemObjectNode parent) {
        boolean isValid = this.isValidSystemNode((SrTreeNode)((Object)parent));
        boolean hasValidChild = this.hasValidSystemNodeChild((SrTreeNode)((Object)parent));
        if ((isValid || hasValidChild) && (!parent.equals(this.myRootNode) || this.myIsRootVisible)) {
            this.addTreeNodeItem((SrTreeNode)((Object)parent));
        }
        List<SystemObjectNode> children = ((SrTreeNode)((Object)parent)).getChildrenOfType(SystemObjectNode.class);
        for (SystemObjectNode child : children) {
            this.addParentAndChildren(child);
        }
    }

    @Override
    protected int getIndentationForNode(Object aNode) {
        int depth = 0;
        if (this.myRootNode != null) {
            for (TreeNode parent = (TreeNode)aNode; parent != null && !parent.equals(this.myRootNode); parent = parent.getParent()) {
                ++depth;
            }
        }
        if (this.myIsRootVisible) {
            return depth;
        }
        return depth > 0 ? depth - 1 : 0;
    }

    public static class SingleTypeProperties
    extends SysNodeProperties {
        private Class<? extends SystemObjectNode> myContextType;

        public SingleTypeProperties(Class<? extends SystemObjectNode> aContextType) {
            if (aContextType == null) {
                throw new IllegalArgumentException("Context must be supplied");
            }
            this.myContextType = aContextType;
        }

        @Override
        protected boolean isItemInContext(Object aNode) {
            return this.myContextType.isAssignableFrom(aNode.getClass());
        }
    }

    public static abstract class SysNodeProperties
    implements SrTreeComboBox.TreeNodeProperties<SrTreeNode> {
        protected static final String theClusterInDiscoveryMsg = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.CLUSTER_IN_DISCOVERY_PROCESS);

        @Override
        public Icon getNodeIcon(SrTreeNode aNode) {
            if (aNode instanceof SrTreeNode) {
                return aNode.getNodeIcon();
            }
            return null;
        }

        @Override
        public String getTextForNode(SrTreeNode aNode) {
            if (aNode instanceof SystemObjectNode) {
                return ((SystemObjectNode)((Object)aNode)).getAlias();
            }
            return null;
        }

        @Override
        public String getDisabledToolTip(SrTreeNode aNode) {
            ClusterNode cluster = null;
            if (this.isItemInContext(aNode)) {
                cluster = (ClusterNode)aNode.getAncestorOfType(ClusterNode.class);
            }
            if (cluster != null && cluster.isInDiscoveryProcess()) {
                return theClusterInDiscoveryMsg;
            }
            if (!this.isItemInContext(aNode)) {
                return this.getContextDisabledMessage(SrTreeNodeType.getTypeDisplay(aNode));
            }
            return null;
        }

        boolean isValid(Object aNode) {
            return aNode instanceof SystemObjectNode;
        }

        protected abstract boolean isItemInContext(Object var1);

        public String getContextDisabledMessage(String aTypesInContext) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.ELEMENT_NOT_A_VALID_TYPE, aTypesInContext);
        }
    }

    private class MainTreeListener
    implements TreeModelListener {
        private MainTreeListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            SrSystemObjectComboBox.this.comboboxTreeNodesChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            Object[] childNodes = e.getChildren();
            if (childNodes != null) {
                for (Object node : childNodes) {
                    if (!(node instanceof SrTreeNode) || !this.isMyRootChild((SrTreeNode)node) || !SrSystemObjectComboBox.this.isValidSystemNode((SrTreeNode)node) && !SrSystemObjectComboBox.this.hasValidSystemNodeChild((SrTreeNode)node)) continue;
                    TreeNode[] newNodePath = ((SrTreeNode)node).getPath();
                    int myRootDepth = ((SrTreeNode)((Object)SrSystemObjectComboBox.this.myRootNode)).getLevel();
                    int lastAncestorIndex = -1;
                    for (int i = 0; i < newNodePath.length; ++i) {
                        SrTreeNode ancestor = (SrTreeNode)newNodePath[i];
                        if (myRootDepth >= ancestor.getLevel()) continue;
                        int ancestorIndex = SrSystemObjectComboBox.this.indexOf(ancestor);
                        lastAncestorIndex = ancestorIndex < 0 ? this.insertOrderedByName(ancestor, lastAncestorIndex) : ancestorIndex;
                    }
                }
            }
        }

        private boolean isMyRootChild(SrTreeNode aNode) {
            for (TreeNode parent = aNode.getParent(); parent != null; parent = parent.getParent()) {
                if (!SrSystemObjectComboBox.this.myRootNode.equals(parent)) continue;
                return true;
            }
            return false;
        }

        private int insertOrderedByName(SrTreeNode aNodeToInsert, int parentIndex) {
            int newChildIndex = parentIndex + 1;
            for (int i = parentIndex + 1; i < SrSystemObjectComboBox.this.getItemCount(); ++i) {
                TreeNode currChild = (TreeNode)SrSystemObjectComboBox.this.getItemAt(i);
                if (Util.equalsWithNull(currChild.getParent(), aNodeToInsert.getParent())) {
                    if (this.compareSysNodes(aNodeToInsert, currChild) < 0) {
                        newChildIndex = i;
                        break;
                    }
                } else if (parentIndex >= 0) {
                    newChildIndex = i;
                    break;
                }
                newChildIndex = i + 1;
            }
            SrSystemObjectComboBox.this.insertTreeNodeItemAt(aNodeToInsert, newChildIndex);
            return newChildIndex;
        }

        private int compareSysNodes(TreeNode aNode1, TreeNode aNode2) {
            if (aNode1 instanceof SiteNode && aNode2 instanceof ClusterNode) {
                return 1;
            }
            if (aNode2 instanceof SiteNode && aNode1 instanceof ClusterNode) {
                return -1;
            }
            return aNode1.toString().compareTo(aNode2.toString());
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            Object[] childNodes = e.getChildren();
            if (childNodes != null) {
                for (Object node : childNodes) {
                    SrSystemObjectComboBox.this.removeItem(node);
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            ItemListener[] listeners;
            Object selection = SrSystemObjectComboBox.this.getSelectedItem();
            for (ItemListener listener : listeners = SrSystemObjectComboBox.this.getItemListeners()) {
                SrSystemObjectComboBox.this.removeItemListener(listener);
            }
            SrSystemObjectComboBox.this.removeAllItems();
            SrSystemObjectComboBox.this.addParentAndChildren(SrSystemObjectComboBox.this.myRootNode);
            if (SrSystemObjectComboBox.this.indexOf(selection) >= 0) {
                SrSystemObjectComboBox.this.setSelectedItem(selection);
            }
            for (ItemListener listener : listeners) {
                SrSystemObjectComboBox.this.addItemListener(listener);
            }
            SrSystemObjectComboBox.this.setSelectedItem(selection);
        }
    }
}

