/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemObjectNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelFrame;
import com.sanrad.nms.client.gui.SrStatisticChart;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollChartPanel;
import com.sanrad.swing.SrSwingUtils;
import com.sanrad.swing.SrTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.util.Calendar;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartPanel;
import org.jvnet.substance.SubstanceLookAndFeel;

public abstract class SrStatisticsDialog<T extends SystemObjectNode>
extends SrOKCancelFrame<T> {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected static final int CLUSTER_MODE = 1;
    protected static final int VSWITCH_MODE = 2;
    protected static final int TARGET_MODE = 3;
    protected int myMode;
    protected VSwitchNode m_vswitchNode = null;
    protected SrTablePanel m_statisticsTablePanel = null;
    protected SrPanel m_statisticsDetailsPanel = null;
    protected SrTablePanel m_statisticsExtendedTablePanel = null;
    protected SrStatisticChart m_statisticChart = null;
    private ChartPanel m_chartPanel = null;
    private SrClientLabel m_lastUpdate;
    private SrClientLabel m_startAt;
    private boolean m_firstUpdateEvent = true;
    protected SrScrollChartPanel m_scrollChartPanel;
    private static final String TIME_SEPARATOR = ":";
    protected SrTreeNode myTreeNode;

    private static int nodeToMode(SrTreeNode aNode) {
        if (aNode instanceof ClusterNode) {
            return 1;
        }
        if (aNode instanceof VSwitchNode) {
            return 2;
        }
        if (aNode instanceof TargetNode) {
            return 3;
        }
        throw new IllegalArgumentException("The node " + aNode + " is not applicable");
    }

    protected SrStatisticsDialog(JFrame owner, String title, VSwitchNode vswitchNode) {
        this(owner, title, vswitchNode, null, 2);
    }

    protected SrStatisticsDialog(JFrame owner, String title, VSwitchNode vswitchNode, SrTreeNode aTreeNode, int aMode) {
        super(owner, title, SystemRootNode.getInstance().getCurrentClusterNode());
        this.myMode = aMode;
        this.m_vswitchNode = vswitchNode;
        this.myTreeNode = aTreeNode;
        this.initBtnsComponents();
        this.initDialogPanels();
        this.initDialogLayout();
    }

    protected SrStatisticsDialog(JFrame owner, String title, VSwitchNode vswitchNode, SrTreeNode aTreeNode) {
        this(owner, title, vswitchNode, aTreeNode, SrStatisticsDialog.nodeToMode(aTreeNode));
    }

    protected VSwitchNode getVswitchNode() {
        return this.m_vswitchNode;
    }

    protected abstract SrTablePanel getStatisticsTablePanel();

    protected abstract SrPanel getStatisticsDetailsPanel();

    protected abstract SrTablePanel getStatisticsExtendedTablePanel();

    protected abstract ChartPanel getStatisticsChartPanel();

    @Override
    protected void doOnOK() {
    }

    @Override
    public void removeListeners() {
        if (this.m_statisticChart != null) {
            this.m_statisticChart.removeListeners();
        }
        if (this.m_statisticsExtendedTablePanel != null) {
            this.m_statisticsExtendedTablePanel.getModel().removeListeners();
        }
        if (this.m_statisticsTablePanel != null) {
            this.m_statisticsTablePanel.getModel().removeListeners();
        }
        if (this.m_statisticsDetailsPanel != null) {
            this.m_statisticsDetailsPanel.removeListeners();
        }
    }

    @Override
    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    protected abstract void initDialogPanels();

    protected void initDialogLayout() {
        SrPanel northPanel = new SrPanel();
        SrPanel northWestPanel = new SrPanel(new BorderLayout());
        this.m_statisticsTablePanel = this.getStatisticsTablePanel();
        this.m_statisticsDetailsPanel = this.getStatisticsDetailsPanel();
        this.m_chartPanel = this.getStatisticsChartPanel();
        this.m_statisticsExtendedTablePanel = this.getStatisticsExtendedTablePanel();
        if (this.m_statisticsTablePanel != null) {
            if (this.m_statisticsDetailsPanel != null) {
                this.m_statisticsTablePanel.setPreferredSize(new Dimension(this.m_statisticsTablePanel.getPreferredSize().width - 130, this.m_statisticsDetailsPanel.getPreferredSize().height));
            }
            northWestPanel.add((Component)this.m_statisticsTablePanel, "North");
        }
        if (this.m_statisticsDetailsPanel != null) {
            JScrollPane panel = new JScrollPane(this.m_statisticsDetailsPanel);
            panel.setBorder(null);
            if (northWestPanel.getComponentCount() > 0) {
                northWestPanel.add((Component)panel, "Center");
            } else {
                northWestPanel.add(panel);
            }
        }
        if (this.m_chartPanel != null) {
            northPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.5;
            this.m_scrollChartPanel = new SrScrollChartPanel(this.m_chartPanel.getChart());
            if (northWestPanel.getComponentCount() > 0) {
                northPanel.add((Component)northWestPanel, constraints);
                if (northWestPanel.getComponentCount() > 1 || this.m_statisticsDetailsPanel != null && ((JScrollPane)northWestPanel.getComponents()[0]).getViewport().getView().equals(this.m_statisticsDetailsPanel)) {
                    ++constraints.gridx;
                } else {
                    ++constraints.gridy;
                    constraints.insets = new Insets(20, 10, 10, 10);
                }
                this.m_scrollChartPanel.setPreferredSize(new Dimension(this.m_chartPanel.getPreferredSize().width, this.m_chartPanel.getPreferredSize().height - 100));
            } else {
                constraints.insets = new Insets(0, 10, 20, 10);
                this.m_scrollChartPanel.setPreferredSize(new Dimension(this.m_chartPanel.getPreferredSize().width, this.m_chartPanel.getPreferredSize().height / 2));
            }
            northPanel.add((Component)this.m_scrollChartPanel, constraints);
        } else {
            northPanel.setLayout(new BorderLayout());
            northPanel.add((Component)northWestPanel, "Center");
        }
        SrPanel mainPanel = new SrPanel(new BorderLayout());
        mainPanel.add((Component)northPanel, "North");
        if (this.m_statisticsExtendedTablePanel != null) {
            mainPanel.add((Component)this.m_statisticsExtendedTablePanel, "Center");
        }
        SrPanel lastUpdatePanel = new SrPanel(new GridBagLayout());
        SrPanel wrapPanel = new SrPanel(new BorderLayout());
        SrClientLabel lastUpdateLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DIALOG_LAST_UPDATE_LABEL));
        Font currentFont = lastUpdateLbl.getFont();
        Map<TextAttribute, ?> fontMap = currentFont.getAttributes();
        fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        lastUpdateLbl.setFont(new Font(fontMap));
        this.m_lastUpdate = new SrClientLabel();
        SrClientLabel startAtLbl = new SrClientLabel(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DIALOG_START_AT_LABEL));
        startAtLbl.setFont(new Font(fontMap));
        this.m_startAt = new SrClientLabel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 10, 10, 10);
        lastUpdatePanel.add((Component)startAtLbl, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        lastUpdatePanel.add((Component)this.m_startAt, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.insets.left = 10;
        constraints.insets.right = 10;
        constraints.insets.top = 0;
        lastUpdatePanel.add((Component)lastUpdateLbl, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        lastUpdatePanel.add((Component)this.m_lastUpdate, constraints);
        wrapPanel.add((Component)lastUpdatePanel, "North");
        wrapPanel.add((Component)mainPanel, "Center");
        this.addCenterPanel(wrapPanel);
        this.setBackgroungColor(this.buttonsPanel);
        if (this.m_chartPanel != null) {
            SubstanceLookAndFeel.getCurrentWatermark().dispose();
            this.m_chartPanel.getChart().setBackgroundPaint(SrSwingUtils.getContainerBackground(this.m_scrollChartPanel));
        }
    }

    protected void setLastUpdateTime(Calendar time) {
        if (this.m_firstUpdateEvent) {
            this.m_startAt.setText(time.getTime().toString());
            this.m_firstUpdateEvent = false;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.formatTimeUnit(time.get(11)));
        buff.append(TIME_SEPARATOR);
        buff.append(this.formatTimeUnit(time.get(12)));
        buff.append(TIME_SEPARATOR);
        buff.append(this.formatTimeUnit(time.get(13)));
        this.m_lastUpdate.setText(buff.toString());
    }

    private String formatTimeUnit(int unit) {
        StringBuffer res = new StringBuffer();
        if (unit < 10) {
            res.append("0");
        }
        res.append(unit);
        return res.toString();
    }

    protected void initBtnsComponents() {
        this.btnOK.setVisible(false);
        this.btnCancel.setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLOSE_LABEL));
    }

    protected void initDialogLayout(SrPanel mainPanel) {
        this.addCenterPanel(mainPanel);
        this.setBackgroungColor(this.buttonsPanel);
    }

    protected void setDialogTitle(SrTreeNode aTreeNode, String aDialogSpecificTitle) {
        String title;
        if (this.myMode == 1) {
            title = aTreeNode != null ? ClientLoader.CLUSTER_DISPLAY_STRING + " " + ((ClusterNode)aTreeNode).getAlias() : ClientLoader.CLUSTER_DISPLAY_STRING;
        } else if (this.myMode == 2) {
            title = ClientLoader.VSWITCH_DISPLAY_STRING + " " + ((VSwitchNode)aTreeNode).getName();
        } else if (this.myMode == 3) {
            title = "Target " + (TargetNode)aTreeNode;
        } else {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Unsupported type for statistics dialog. " + aTreeNode.getClass().getName());
            title = "";
        }
        if (title.length() > 0) {
            title = title + " - ";
        }
        this.setTitle(title + aDialogSpecificTitle);
    }
}

