/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.Client;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrXYItemRenderer;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.util.SrResourceBundle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class SrStatisticChart {
    protected static final String PIT = "PointInTime";
    private String m_chartTitle;
    private String m_xAxisLabel;
    private String m_yAxisLabel;
    protected TimeSeriesCollection m_dataset;
    private ChartPanel m_chartPanel;
    private JFreeChart m_chart;
    private SrXYItemRenderer m_renderer;
    private HashMap m_item2Rates;
    protected boolean m_firstEvent;
    private HashMap<String, StatisticsCounter> myNameToStatisticsMgrMap = new HashMap();
    private int myStatisticsIntervalSec = 10;
    private final int MAX_NUMBER_OF_TICKS = Client.getStatisticsMaxData();

    public SrStatisticChart(int aPollingInterval) {
        this(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_STATISTICS_CHART_TITLE), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_STATISTICS_CHART_X), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_STATISTICS_CHART_Y), aPollingInterval);
    }

    public SrStatisticChart(String chartTitle, String xAxisLabel, String yAxisLabel, int aPollingInterval) {
        this.m_chartTitle = chartTitle;
        this.m_xAxisLabel = xAxisLabel;
        this.m_yAxisLabel = yAxisLabel;
        this.m_dataset = new TimeSeriesCollection();
        this.m_dataset.setDomainIsPointsInTime(false);
        this.m_item2Rates = new HashMap();
        this.setFirstEvent(true);
        this.myStatisticsIntervalSec = aPollingInterval;
    }

    public void addSeries(String seriesName) {
        TimeSeries hitsBySecondData = new TimeSeries(seriesName, Second.class);
        hitsBySecondData.setMaximumItemCount(this.MAX_NUMBER_OF_TICKS);
        this.m_dataset.addSeries(hitsBySecondData);
        this.myNameToStatisticsMgrMap.put(seriesName, new StatisticsCounter(hitsBySecondData, this.myStatisticsIntervalSec));
    }

    private void createChart() {
        this.m_chart = ChartFactory.createTimeSeriesChart(this.m_chartTitle, this.m_xAxisLabel, this.m_yAxisLabel, this.m_dataset, true, true, false);
        Font font = ClientLoader.UI_BUNDLE.getFontResource(SrDefaultUIBundleKeys.GENERAL_FONT);
        ((StandardLegend)this.m_chart.getLegend()).setItemFont(font);
        XYPlot plot = this.m_chart.getXYPlot();
        this.m_renderer = new SrXYItemRenderer(2, null, null, this.m_dataset);
        plot.setRenderer(this.m_renderer);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setTickUnit(new DateTickUnit(5, 10), true, false);
        axis.setDateFormatOverride(new SimpleDateFormat("HH:mm:ss"));
        axis.setTickLabelFont(font);
        axis.setVerticalTickLabels(true);
        plot.getRangeAxis().setTickLabelFont(font);
        Paint[] colors = this.createDefaultPaintArray();
        for (int i = 0; i < this.m_dataset.getSeriesCount(); ++i) {
            this.m_renderer.setSeriesPaint(i, colors[i]);
        }
        TextTitle title = new TextTitle(this.m_chartTitle, Font.decode(SrResourceBundle.getInstance(SrResourceBundle.DEFAULT_UI_BUNDLE_NAME, Locale.US).getString(SrDefaultUIBundleKeys.PANEL_TITLE_LABEL_FONT)));
        this.m_chart.setTitle(title);
    }

    public ChartPanel packChartToPanel() {
        this.createChart();
        this.m_chartPanel = new ChartPanel(this.m_chart, false, false, false, true, false);
        this.m_chartPanel.setMouseZoomable(true);
        return this.m_chartPanel;
    }

    public JLabel packChartToLabel(int chartWidth, int chartHeight) {
        this.createChart();
        BufferedImage image = this.m_chart.createBufferedImage(chartWidth, chartHeight);
        return new JLabel(new ImageIcon(image));
    }

    public void setSeriesValue(String seriesName, Date time, Number value) {
        TimeSeries series = this.m_dataset.getSeries(seriesName);
        if (seriesName.equals("In Receives/Sec")) {
            int i = 0;
            ++i;
        }
        series.addOrUpdate((RegularTimePeriod)new Second(time), value);
        this.m_renderer.setCurrentRateLabel(seriesName, value);
        StatisticsCounter mgr = this.myNameToStatisticsMgrMap.get(seriesName);
        mgr.notifyStatisticsDataAdded();
    }

    protected SrXYItemRenderer getSrChartRenderer() {
        return (SrXYItemRenderer)this.m_chart.getXYPlot().getRenderer();
    }

    private Paint[] createDefaultPaintArray() {
        return new Paint[]{Color.blue, Color.green, Color.orange, Color.magenta, Color.cyan, Color.pink, Color.gray, ChartColor.DARK_BLUE, ChartColor.DARK_GREEN, ChartColor.DARK_MAGENTA, ChartColor.DARK_CYAN, Color.darkGray, ChartColor.LIGHT_BLUE, ChartColor.LIGHT_GREEN, ChartColor.LIGHT_MAGENTA, ChartColor.LIGHT_CYAN, Color.lightGray, ChartColor.VERY_DARK_BLUE, ChartColor.VERY_DARK_GREEN, ChartColor.VERY_DARK_MAGENTA, ChartColor.VERY_DARK_CYAN, ChartColor.VERY_LIGHT_BLUE, ChartColor.VERY_LIGHT_GREEN, ChartColor.VERY_LIGHT_MAGENTA, ChartColor.VERY_LIGHT_CYAN};
    }

    public ChartPanel getChartPanel() {
        return this.m_chartPanel;
    }

    protected HashMap getItem2RatesMap() {
        return this.m_item2Rates;
    }

    protected void setFirstEvent(boolean flag) {
        this.m_firstEvent = flag;
    }

    protected boolean isFirstEvent() {
        return this.m_firstEvent;
    }

    public void removeListeners() {
    }

    protected void switchItemChartDisplay(List statisticsValues) {
        this.clearData();
        for (Object statisticElement : statisticsValues) {
            HashMap newItem = (HashMap)statisticElement;
            if (!newItem.containsKey(PIT)) {
                Date time = new Date();
                newItem.put(PIT, time);
            }
            this.updateStatisticsChart(newItem);
        }
    }

    protected void clearData() {
        for (int i = 0; i < this.m_dataset.getSeriesCount(); ++i) {
            this.m_dataset.getSeries(i).clear();
        }
    }

    protected void updateStatisticsChart(HashMap item) {
    }

    private static class StatisticsIntervalReader {
        private String[] myTimeAndIntervals;
        private int myIndex = -1;

        StatisticsIntervalReader(String aIntervals) {
            if (aIntervals == null) {
                throw new IllegalArgumentException("Statistics Intervals cannot be null");
            }
            if (aIntervals.matches(".*\\d[ ]+\\d.*")) {
                throw new IllegalArgumentException(aIntervals + " is not a valid input");
            }
            String intervals = aIntervals.replaceAll(" ", "");
            String timeAndIntervalRegex = "\\[\\d+[smhd]\\,\\d+[smhd]\\]";
            if (!intervals.matches("^(" + timeAndIntervalRegex + ")+$")) {
                throw new IllegalArgumentException(aIntervals + " is not a valid input");
            }
            intervals = intervals.replaceAll("[\\[|]", "");
            this.myTimeAndIntervals = intervals.split("[\\[|\\,|\\]]++");
        }

        boolean hasNextTimeAndInterval() {
            return this.myIndex + 2 < this.myTimeAndIntervals.length;
        }

        int[] getNextTimeAndInterval() {
            this.myIndex += 2;
            if (this.myIndex >= this.myTimeAndIntervals.length) {
                return null;
            }
            String timeStr = this.myTimeAndIntervals[this.myIndex - 1];
            String timeDigits = timeStr.replaceAll("\\D", "");
            String timeUnits = timeStr.replaceAll("\\d", "");
            String intervalStr = this.myTimeAndIntervals[this.myIndex];
            String intervalDigits = intervalStr.replaceAll("\\D", "");
            String intervalUnits = intervalStr.replaceAll("\\d", "");
            int[] retVal = new int[]{Integer.valueOf(timeDigits) * this.convertTimeUnitToSeconds(timeUnits.charAt(0)), Integer.valueOf(intervalDigits) * this.convertTimeUnitToSeconds(intervalUnits.charAt(0))};
            return retVal;
        }

        private int convertTimeUnitToSeconds(char aChar) {
            switch (aChar) {
                case 's': {
                    return 1;
                }
                case 'm': {
                    return 60;
                }
                case 'h': {
                    return 3600;
                }
                case 'd': {
                    return 86400;
                }
            }
            throw new IllegalArgumentException("The character " + aChar + " is not valid time unit");
        }
    }

    private static class StatisticsPolicy {
        private long myPolicyDurationSec;
        private int myPoilicyTimeIntervalSec;
        private int myStatisticsTimeIntervalSec;
        private int myCounter = -1;
        private boolean myIsActive = false;

        StatisticsPolicy(long aPolicyDurationSec, int aPolicyIntervalSec, int aStatisticsIntervalSec) {
            if (aPolicyDurationSec < (long)aPolicyIntervalSec && aPolicyDurationSec < (long)aStatisticsIntervalSec) {
                throw new IllegalArgumentException("Expiring time is less then statistics interval");
            }
            if (aPolicyIntervalSec < aStatisticsIntervalSec) {
                throw new IllegalArgumentException("Keeped-Readings Interval is less then statistics interval");
            }
            this.myPolicyDurationSec = aPolicyDurationSec;
            this.myPoilicyTimeIntervalSec = aPolicyIntervalSec;
            this.myStatisticsTimeIntervalSec = aStatisticsIntervalSec;
        }

        void increaseCounter() {
            if (!this.isActive()) {
                throw new IllegalStateException("Cannot increase counter when not active");
            }
            ++this.myCounter;
        }

        boolean acceptReading() {
            int policyRateToStatisticsRateRelation = this.myPoilicyTimeIntervalSec / this.myStatisticsTimeIntervalSec;
            return this.myCounter % policyRateToStatisticsRateRelation == 0;
        }

        long getDuration() {
            return this.myPolicyDurationSec;
        }

        void activete() {
            this.myIsActive = true;
        }

        boolean isActive() {
            return this.myIsActive;
        }

        int getCounter() {
            return this.myCounter;
        }
    }

    private static class StatisticsCounter {
        private long myStatisticsCounter = -1L;
        private ArrayList<Long> myStatisticsMetadata = new ArrayList();
        private int myStatisticsInterval;
        private ArrayList<StatisticsPolicy> myStatisticsPolicies = new ArrayList();
        private ArrayList<StatisticsPolicy> myActivePolicies = new ArrayList();
        private TimeSeries myTimeSeries;

        StatisticsCounter(TimeSeries aTimeSeries, int aStatInterval) {
            this.myStatisticsInterval = aStatInterval;
            this.myTimeSeries = aTimeSeries;
            String statIntervals = Client.getStatisticsIntervals();
            StatisticsIntervalReader reader = new StatisticsIntervalReader(statIntervals);
            while (reader.hasNextTimeAndInterval()) {
                int[] timeAndInterval = reader.getNextTimeAndInterval();
                this.myStatisticsPolicies.add(new StatisticsPolicy(timeAndInterval[0], timeAndInterval[1], aStatInterval));
            }
        }

        void increaseCounter() {
        }

        void notifyStatisticsDataAdded() {
            ++this.myStatisticsCounter;
            this.myStatisticsMetadata.add(this.myStatisticsCounter);
            for (int i = this.myTimeSeries.getMaximumItemCount(); i < this.myStatisticsMetadata.size(); ++i) {
                this.myStatisticsMetadata.remove(0);
            }
            StatisticsPolicy policy = this.getNextActivePolicy();
            if (policy != null) {
                policy.activete();
                this.myActivePolicies.add(policy);
            }
            for (StatisticsPolicy activePolicy : this.myActivePolicies) {
                int pointIndex;
                int indexInTimeSeries;
                activePolicy.increaseCounter();
                if (activePolicy.acceptReading() || (indexInTimeSeries = this.myStatisticsMetadata.indexOf(pointIndex = activePolicy.getCounter())) < 0) continue;
                this.myTimeSeries.delete(indexInTimeSeries, indexInTimeSeries);
                this.myStatisticsMetadata.remove(indexInTimeSeries);
            }
        }

        private StatisticsPolicy getNextActivePolicy() {
            long currentTimeSec = this.myStatisticsCounter * (long)this.myStatisticsInterval;
            for (StatisticsPolicy policy : this.myStatisticsPolicies) {
                if ((currentTimeSec -= policy.getDuration()) >= 0L) continue;
                return policy.isActive() ? null : policy;
            }
            return null;
        }
    }
}

