/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrDefaultPopupMenu;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.EmptyAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class SrPopupMenu
extends JPopupMenu {
    private static final SrLogger theLogger = SrLogger.getLogger();
    public static final String LICENSE_BLOCK_TOOL_TIP = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.LICENSE_OPERATION_BLOCK);
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    protected SrMenu alarmsMenu;
    protected SrMenuItem m_iscsiRemoteDiscoveryPortalsShowItem;
    protected SrMenuItem m_iscsiRemoteTargetShowItem;
    protected SrMenu m_iscsiSessionsMenu;
    protected SrMenuItem m_iscsiSessionsShowItem;
    protected SrMenuItem m_iscsiSessionsStatisticsItem;
    protected SrMenuItem m_iscsiConnectionsItem;
    protected SrMenu m_iscsiConnectedInitiatorsMenu;
    protected SrMenuItem m_iscsiConnectedInitiatorsShowItem;
    protected SrMenuItem m_iscsiConnectedInitiatorsStatisticsItem;
    protected SrMainTreePanel myWorkWith;

    public SrPopupMenu(SrMainTreePanel workWith) {
        this.myWorkWith = workWith;
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                SrPopupMenu.this.innerReset();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SrPopupMenu.this.innerReset();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.createBasicMenu();
    }

    protected abstract void innerReset();

    protected SrMenuItem getDeleteItem() {
        return new SrMenuItem(this.getDeleteAction());
    }

    protected static SrMenuItem createPropertiesItem(SrClientAction propertiesAction) {
        return new SrMenuItem(SrDefaultPopupMenu.asProperties(propertiesAction));
    }

    private void createBasicMenu() {
        this.createAlarmsMenu();
        this.m_iscsiRemoteDiscoveryPortalsShowItem = new SrMenuItem(this.myWorkWith.iscsiRemoteDiscoveryPortalsShowAction);
        this.m_iscsiRemoteTargetShowItem = new SrMenuItem(this.myWorkWith.iscsiRemoteTargetsShowAction);
        this.m_iscsiSessionsShowItem = new SrMenuItem(this.myWorkWith.openIscsiSessionsShowAction);
        this.m_iscsiSessionsMenu = new SrMenu(new EmptyAction(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_ISCSI_SESSIONS), true, true, SrLicenseTreePath.ISCSI_PATH));
        this.m_iscsiSessionsStatisticsItem = new SrMenuItem(this.myWorkWith.openIscsiSessionsStatisticsAction);
        this.m_iscsiConnectedInitiatorsMenu = new SrMenu(new EmptyAction(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_ISCSI_REMOTE_INITIATORS), true, true, SrLicenseTreePath.ISCSI_PATH));
        this.m_iscsiConnectionsItem = new SrMenuItem(this.myWorkWith.openIscsiConnectionsAction);
        this.m_iscsiConnectedInitiatorsShowItem = new SrMenuItem(this.myWorkWith.openIscsiConnectedInitiatorShowAction);
        this.m_iscsiConnectedInitiatorsStatisticsItem = new SrMenuItem(this.myWorkWith.openIscsiConnectedInitiatorsStatisticsAction);
    }

    protected void createAlarmsMenu() {
        AlarmAction specificAction;
        this.alarmsMenu = new SrMenu("Alarms");
        AlarmAction propagatedAction = this.getPropagatedAlarmAction();
        if (propagatedAction != null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, !propagatedAction.isSpecific(), new Object[]{"Propagated action is specific", this.getClass()});
            propagatedAction.setName("Propagated...");
            this.alarmsMenu.add(new SrMenuItem(propagatedAction));
        }
        if ((specificAction = this.getSpecificAlarmAction()) != null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, specificAction.isSpecific(), new Object[]{"Specific action is not specific", this.getClass()});
            specificAction.setName("Specific...");
            this.alarmsMenu.add(new SrMenuItem(specificAction));
        }
    }

    public abstract AlarmAction getSpecificAlarmAction();

    public abstract AlarmAction getPropagatedAlarmAction();

    protected abstract DeleteAction getDeleteAction();

    @Override
    public void show(Component invoker, int x, int y) {
        this.setSeparatorsVisibility(this);
        super.show(invoker, x, y);
    }

    private void setSeparatorsVisibility(JComponent menu) {
        int i;
        boolean foundVisibleItem = false;
        Component[] comps = menu.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JMenuItem) {
                if (comps[i].isVisible()) {
                    foundVisibleItem = true;
                }
                if (!(comps[i] instanceof JMenu)) continue;
                this.setSeparatorsVisibility(((JMenu)comps[i]).getPopupMenu());
                continue;
            }
            if (!(comps[i] instanceof JPopupMenu.Separator)) continue;
            comps[i].setVisible(foundVisibleItem);
            foundVisibleItem = false;
        }
        foundVisibleItem = false;
        i = comps.length;
        while (i-- > 0) {
            if (comps[i] instanceof JMenuItem) {
                if (!comps[i].isVisible()) continue;
                foundVisibleItem = true;
                continue;
            }
            if (!(comps[i] instanceof JPopupMenu.Separator)) continue;
            comps[i].setVisible(foundVisibleItem);
            break;
        }
    }

    public abstract class IscsiMenuAction<T>
    extends SrClientAction<T, Void> {
        public IscsiMenuAction(View<T> view) {
            super(true, true, view, SrLicenseTreePath.ISCSI_PATH, true);
            this.setName(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_ISCSI));
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Empty actions cannot be invoked");
            return Collections.singleton(new CompleteFuture("SrPopupMenu.IscsiMenuAction"));
        }
    }
}

