/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemObjectNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.components.ClientComponentsUtil;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.OKCancelFrame;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.Util;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;

public abstract class SrOKCancelFrame<T extends SystemObjectNode>
extends OKCancelFrame {
    protected ClusterNode m_workingCluster;
    private SrSystemObjectComboBox myTopContextBox;

    protected SrOKCancelFrame(JFrame owner, String title, ClusterNode workingCluster) {
        super(owner, title);
        this.m_workingCluster = workingCluster;
        this.setClusterTitle();
        this.setResizable(false);
    }

    protected void setClusterTitle() {
        String oldTitle = this.getTitle();
        if (this.m_workingCluster != null) {
            this.setTitle(SystemRootNode.getInstance().getClusterTitle(oldTitle, this.m_workingCluster));
        }
    }

    protected void setSiteTitle(String siteAlias) {
        String oldTitle = this.getTitle();
        this.setTitle(SystemRootNode.getInstance().getSiteTitle(oldTitle, siteAlias));
    }

    @Override
    public void show() {
        SrBITSConstant vswitchCapability = this.m_workingCluster != null ? this.m_workingCluster.getCapability() : null;
        ClientComponentsUtil.checkLicenseAvailability(this.getContentPane(), vswitchCapability);
        super.show();
    }

    private void addTopContextBox(String aLabel, SrSystemObjectComboBox aTopContextBox) {
        this.myTopContextBox = aTopContextBox;
        this.myTopContextBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && (e.getItem() == null || e.getItem() instanceof SystemObjectNode)) {
                    SrOKCancelFrame.this.systemNodeSelected((SystemObjectNode)e.getItem());
                }
            }
        });
        SrPanel p = new SrPanel(new FlowLayout(0));
        SrLabelField label = new SrLabelField(aLabel);
        p.setOpaque(false);
        p.add(label);
        p.add(this.myTopContextBox);
        Dimension boxPrefrredDim = this.myTopContextBox.getPreferredSize();
        boxPrefrredDim.width = Math.max(150, boxPrefrredDim.width);
        this.myTopContextBox.setPreferredSize(boxPrefrredDim);
        this.addNorthPanel(p);
    }

    protected final void addTopContextBox(String aLabel, SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext, int aSystemObjectComboMode) {
        SrSystemObjectComboBox box = new SrSystemObjectComboBox(aRootNode, aSystemContext);
        this.addTopContextBox(aLabel, box);
    }

    protected final void addTopContextBox(String aLabel, SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext) {
        SrSystemObjectComboBox box = new SrSystemObjectComboBox(aRootNode, aSystemContext);
        this.addTopContextBox(aLabel, box);
    }

    protected final void addTopContextBox(String aLabel, SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext, SrSystemObjectComboBox.SysNodeProperties aConstraints) {
        SrSystemObjectComboBox box = new SrSystemObjectComboBox(aRootNode, aSystemContext, aConstraints);
        this.addTopContextBox(aLabel, box);
    }

    protected final void addTopContextBox(String aLabel, SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext, int aSystemObjectComboMode, SrSystemObjectComboBox.SysNodeProperties aConstraints) {
        SrSystemObjectComboBox box = new SrSystemObjectComboBox(aRootNode, aSystemContext, aConstraints);
        this.addTopContextBox(aLabel, box);
    }

    protected final void setTopContextBoxSelection(SystemObjectNode aNode) {
        if (this.myTopContextBox == null) {
            throw new IllegalStateException("The Top-Context-ComboBox is not initialized");
        }
        Object currSelection = this.myTopContextBox.getSelectedItem();
        if (Util.equalsWithNull(currSelection, aNode)) {
            this.systemNodeSelected(aNode);
        } else {
            this.myTopContextBox.setSelectedItem((SrTreeNode)((Object)aNode));
        }
    }

    protected void systemNodeSelected(T aSysNode) {
    }

    @Override
    public void dispose() {
        if (this.myTopContextBox != null) {
            this.myTopContextBox.removeListeners();
        }
        super.dispose();
    }
}

