/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemObjectNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrSystemObjectComboBox;
import com.sanrad.nms.client.gui.components.ClientComponentsUtil;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;

public abstract class SrOKCancelDialog<T extends SystemObjectNode>
extends OKCancelDialog {
    private static final SrLogger theLogger = SrLogger.getLogger();
    protected ClusterNode m_workingCluster;
    private SrSystemObjectComboBox myTopContextBox;

    protected SrOKCancelDialog(JFrame owner, String title, ClusterNode workingCluster) {
        this((Window)owner, title, true, workingCluster);
    }

    protected SrOKCancelDialog(JDialog owner, String title, ClusterNode workingCluster) {
        this((Window)owner, title, true, workingCluster);
    }

    protected SrOKCancelDialog(JFrame frame, String title, boolean modal, ClusterNode workingCluster) {
        this((Window)frame, title, modal, workingCluster);
    }

    protected SrOKCancelDialog(JDialog dialog, String title, boolean modal, ClusterNode workingCluster) {
        this((Window)dialog, title, modal, workingCluster);
    }

    protected SrOKCancelDialog(Window owner, String title, boolean modal, ClusterNode workingCluster) {
        super(owner, title, modal);
        this.m_workingCluster = workingCluster;
        this.setClusterTitle();
    }

    public SrOKCancelDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public SrOKCancelDialog(JDialog dialog, String title, boolean modal) {
        super(dialog, title, modal);
    }

    protected void setClusterTitle() {
        String oldTitle = this.getTitle();
        if (this.m_workingCluster != null) {
            this.setTitle(SystemRootNode.getInstance().getClusterTitle(oldTitle, this.m_workingCluster));
        }
    }

    protected void setSiteTitle(String siteAlias) {
        theLogger.logAndAssert(SrLogCategories.ERROR, siteAlias != null, new Object[]{"site alias shouldn't be null"});
        String oldTitle = this.getTitle();
        this.setTitle(SystemRootNode.getInstance().getSiteTitle(oldTitle, siteAlias));
    }

    @Override
    public void show() {
        SrBITSConstant vswitchCapability = this.m_workingCluster != null ? this.m_workingCluster.getCapability() : null;
        ClientComponentsUtil.checkLicenseAvailability(this.getContentPane(), vswitchCapability);
        super.show();
    }

    protected void addTopContextBox(String aLabel, SrSystemObjectComboBox aTopContextBox, String aInfoTooltip) {
        this.myTopContextBox = aTopContextBox;
        SrPanel p = new SrPanel(new BorderLayout());
        SrLabelField label = new SrLabelField(aLabel);
        label.setBorder(new EmptyBorder(0, 10, 0, 0));
        p.setOpaque(false);
        SrPanel comboPanel = new SrPanel(new FlowLayout(0));
        if (aInfoTooltip != null) {
            SrClientLabel informationLabel = new SrClientLabel();
            informationLabel.setIcon(ClientImageObject.INFORMATION.getImageIcon());
            informationLabel.setToolTipText(aInfoTooltip);
            comboPanel.add(informationLabel);
        }
        comboPanel.add(label);
        comboPanel.add(this.myTopContextBox);
        p.add((Component)comboPanel, "Center");
        Dimension boxPrefrredDim = this.myTopContextBox.getPreferredSize();
        boxPrefrredDim.width = Math.max(150, boxPrefrredDim.width);
        this.myTopContextBox.setPreferredSize(boxPrefrredDim);
        this.addNorthPanel(p);
        this.myTopContextBox.setSelectedItem(null);
        this.myTopContextBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && (e.getItem() == null || e.getItem() instanceof SystemObjectNode)) {
                    SrOKCancelDialog.this.systemNodeSelected((SystemObjectNode)e.getItem());
                }
            }
        });
    }

    protected final void addTopContextBox(String aLabel, Class<? extends SystemObjectNode> aSystemContext, int aSystemObjectComboMode, String aInfoTooltip) {
        this.addTopContextBox(aLabel, SystemRootNode.getInstance(), aSystemContext, null, aInfoTooltip);
    }

    protected final void addTopContextBox(String aLabel, Class<? extends SystemObjectNode> aSystemContext, String aInfoTooltip) {
        this.addTopContextBox(aLabel, SystemRootNode.getInstance(), aSystemContext, null, aInfoTooltip);
    }

    protected final void addTopContextBox(String aLabel, Class<? extends SystemObjectNode> aSystemContext, SrSystemObjectComboBox.SysNodeProperties aConstraints, String aInfoTooltip) {
        this.addTopContextBox(aLabel, SystemRootNode.getInstance(), aSystemContext, aConstraints, aInfoTooltip);
    }

    protected final void addTopContextBox(String aLabel, SystemObjectNode aRootNode, Class<? extends SystemObjectNode> aSystemContext, SrSystemObjectComboBox.SysNodeProperties aConstraints, String aInfoTooltip) {
        SrSystemObjectComboBox box = new SrSystemObjectComboBox(aRootNode, aSystemContext, aConstraints);
        this.addTopContextBox(aLabel, box, aInfoTooltip);
    }

    protected final void setTopContextBoxSelection(SystemObjectNode aNode) {
        if (this.myTopContextBox == null) {
            throw new IllegalStateException("The Top-Context-ComboBox is not initialized");
        }
        Object currSelection = this.myTopContextBox.getSelectedItem();
        if (Util.equalsWithNull(currSelection, aNode)) {
            this.systemNodeSelected(aNode);
        } else {
            this.myTopContextBox.setSelectedItem((SrTreeNode)((Object)aNode));
        }
    }

    protected final T getTopContextBoxSelection() {
        if (this.myTopContextBox != null) {
            return (T)((SystemObjectNode)this.myTopContextBox.getEnabledSelectedItem());
        }
        return null;
    }

    protected void systemNodeSelected(T aSysNode) {
    }

    protected void addItemListenerToTopContextBox(ItemListener aListener) {
        if (this.myTopContextBox != null) {
            this.myTopContextBox.addItemListener(aListener);
        }
    }

    protected void removeItemListenerToTopContextBox(ItemListener aListener) {
        if (this.myTopContextBox != null) {
            this.myTopContextBox.removeItemListener(aListener);
        }
    }

    @Override
    protected void setOKAction(SrAction action) {
        if (this.myTopContextBox != null) {
            this.myTopContextBox.addItemListener(new View.ToggleButtonListener(action));
        }
        super.setOKAction(action);
    }

    @Override
    public void dispose() {
        if (this.myTopContextBox != null) {
            this.myTopContextBox.removeListeners();
        }
        super.dispose();
    }
}

