/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.volume.ExposedVolumesManager;
import com.sanrad.nms.client.data.volume.SrNotExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.VolumeCreationSelectionEvent;
import com.sanrad.nms.client.event.VolumeCreationSelectionListener;
import com.sanrad.nms.client.gui.SrNotExposedVolumeTree;
import com.sanrad.nms.client.gui.SrVolumeTreePanel;
import com.sanrad.nms.client.gui.VolumeTreeCellRenderer;
import com.sanrad.nms.client.gui.actions.ExposeInternalVolumeAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteTreeAction;
import com.sanrad.nms.client.gui.volume.SrNotExposedVolumeTreePopupMenu;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrTree;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrEventListenerManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class SrNotExposedVolumeTreePanel
extends SrVolumeTreePanel
implements MouseListener {
    private static final SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer<VolumeCreationSelectionListener, VolumeCreationSelectionEvent> clearTableSelectionInformer = new SrEventListenerManager.Informer<VolumeCreationSelectionListener, VolumeCreationSelectionEvent>(){

        @Override
        public void inform(VolumeCreationSelectionListener listener, VolumeCreationSelectionEvent event) {
            listener.clearTableSelection(event);
        }
    };
    SrEventListenerManager.Informer<TreeSelectionListener, TreeSelectionEvent> valueChangedInformer = new SrEventListenerManager.Informer<TreeSelectionListener, TreeSelectionEvent>(){

        @Override
        public void inform(TreeSelectionListener listener, TreeSelectionEvent event) {
            listener.valueChanged(event);
        }
    };
    private VolumeOperationHandler m_volOperHandler;
    private View<VolumeTreeNode> myView;
    private DeleteAction myDeleteAction;
    private ExposeInternalVolumeAction exposeVolumeAction;

    public SrNotExposedVolumeTreePanel(SrNotExposedVolumeTreeModel model, JFrame owner, VolumeOperationHandler volOperHandler) {
        super(model, owner);
        this.m_volOperHandler = volOperHandler;
        this.initTreeRenderer();
        this.setModel(model);
        this.getTreeObject().addMouseListener(this);
        this.getTreeObject().setOpaque(false);
    }

    @Override
    protected SrTree getTreeInstance(SrTreeModel model) {
        return new SrNotExposedVolumeTree(model, this);
    }

    @Override
    protected SrPopupMenu getPopupObject() {
        this.exposeVolumeAction = new ExposeInternalVolumeAction<VolumeTreeNode>(this.myOwner, this.getView(), SrLicenseTreePath.GENERAL_PATH);
        return new SrNotExposedVolumeTreePopupMenu(this);
    }

    private View<VolumeTreeNode> getView() {
        if (this.myView == null) {
            this.myView = new TreeView<VolumeTreeNode>(this.m_tree, VolumeTreeNode.class);
        }
        return this.myView;
    }

    @Override
    protected void onTreeSelectionEvent(TreeSelectionEvent event) {
    }

    @Override
    protected VolumeTreeCellRenderer initTreeRenderer() {
        VolumeTreeCellRenderer volumeTreeCellRenderer = new VolumeTreeCellRenderer(this.m_volOperHandler);
        this.getTreeObject().setCellRenderer(volumeTreeCellRenderer);
        return volumeTreeCellRenderer;
    }

    public void addVolumeCreationSelectionListener(VolumeCreationSelectionListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeVolumeCreationSelectionListener(VolumeCreationSelectionListener listener) {
        this.m_listeners.remove(listener);
    }

    public void addTreeToolBarSanityListener(TreeSelectionListener l) {
        this.m_listeners.add(l);
    }

    public void removeTreeToolBarSanityListener(TreeSelectionListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isControlDown()) {
            VolumeCreationSelectionEvent event = new VolumeCreationSelectionEvent(this);
            this.m_listeners.fireEvent(VolumeCreationSelectionListener.class, event, this.clearTableSelectionInformer);
        }
        this.m_listeners.fireEvent(TreeSelectionListener.class, null, this.valueChangedInformer);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public DeleteAction getDeleteAction() {
        if (this.myDeleteAction == null) {
            this.myDeleteAction = new DeleteTreeAction<VolumeTreeNode>(this.getView(), (OperationController)StatusPanel.getInstance()){

                @Override
                protected String validateTreeDeletion(VolumeTreeNode headNode) {
                    return null;
                }
            };
        }
        return this.myDeleteAction;
    }

    public final ExposeInternalVolumeAction getExposeVolumeAction() {
        return this.exposeVolumeAction;
    }

    @Override
    public void newClusterHasBeenSelected() {
        SrNotExposedVolumeTreeModel model = ExposedVolumesManager.getInstance().getNotExposedCurrentModel();
        this.setModel(model);
    }
}

