/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.IdentitiesNode;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupRootNode;
import com.sanrad.nms.client.data.dr.DRJournalRootNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRRootTreeNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.instance.ISCSIInstanceInfo;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.raid.GdrUnmanagedRaidNode;
import com.sanrad.nms.client.data.raid.ManagedRaidNode;
import com.sanrad.nms.client.data.raid.NexsanManagedRaidNode;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.raid.UnmanagedRaidNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.data.srv.radius.RadiusServerNode;
import com.sanrad.nms.client.data.storage.StorageNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.ExposedVolumesRootNode;
import com.sanrad.nms.client.data.volume.UnExposedVolumeRootNode;
import com.sanrad.nms.client.data.volume.VolumeRootNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.Neighbor;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.MainTreeEvent;
import com.sanrad.nms.client.event.MainTreeListener;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.MainTreeCellRenderer;
import com.sanrad.nms.client.gui.SANPopupMenu;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrMainTree;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.acl.dialogs.AclGlobalDialog;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.alarm.SrAlarmsTablePanel;
import com.sanrad.nms.client.gui.cluster.ClusterPopupMenu;
import com.sanrad.nms.client.gui.cluster.dialogs.ClusterPropertiesDialog;
import com.sanrad.nms.client.gui.cluster.dialogs.NewClusterDialog;
import com.sanrad.nms.client.gui.dr.SrDRTreePopupMenu;
import com.sanrad.nms.client.gui.dr.SrJournalTreePopupMenu;
import com.sanrad.nms.client.gui.hardware.VSwitchHardwareDataDialog;
import com.sanrad.nms.client.gui.identity.IdentitiesPopupMenu;
import com.sanrad.nms.client.gui.identity.dialogs.NewIdentityDialog;
import com.sanrad.nms.client.gui.initiator.SrISCSIInitiatorPortsShowDialog;
import com.sanrad.nms.client.gui.initiator.SrInitiatorPropertiesDlg;
import com.sanrad.nms.client.gui.iscsi.connection.ISCSIConnectionsShowDialog;
import com.sanrad.nms.client.gui.iscsi.instance.ISCSIInstanceInfoDialog;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorsShowDialog;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorsStatisticsDialog;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsShowDialog;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetsShowDialog;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrNewISCSIRemoteTargetDialog;
import com.sanrad.nms.client.gui.iscsi.session.show.ISCSISessionsShowDialog;
import com.sanrad.nms.client.gui.iscsi.session.statistics.ISCSISessionsStatisticsDialog;
import com.sanrad.nms.client.gui.site.NewSiteDialog;
import com.sanrad.nms.client.gui.site.SrSitePopupMenu;
import com.sanrad.nms.client.gui.srv.isns.ISNSServersDialog;
import com.sanrad.nms.client.gui.srv.radius.RadiusServersDialog;
import com.sanrad.nms.client.gui.storage.NexsanMgmtPopupMenu;
import com.sanrad.nms.client.gui.storage.StorageTreePopupMenu;
import com.sanrad.nms.client.gui.storage.dialogs.NewPhysStorageDeviceDialog;
import com.sanrad.nms.client.gui.storage.dialogs.RaidPropertiesDialog;
import com.sanrad.nms.client.gui.target.ExposedVolumesPopupMenu;
import com.sanrad.nms.client.gui.target.SCSITargetPortsStatisticsDialog;
import com.sanrad.nms.client.gui.target.TargetPopupMenu;
import com.sanrad.nms.client.gui.target.dialogs.NewTargetDialog;
import com.sanrad.nms.client.gui.target.dialogs.TargetPropertiesDialog;
import com.sanrad.nms.client.gui.vswitch.VSwitchPopupMenu;
import com.sanrad.nms.client.gui.vswitch.dialogs.AttachRaidDialog;
import com.sanrad.nms.client.gui.vswitch.dialogs.NewVSwitchDialog;
import com.sanrad.nms.client.gui.vswitch.dialogs.VSwitchPropertiesDialog;
import com.sanrad.nms.client.gui.vswitch.interfaces.fc.FCInterfacePropertiesDialog;
import com.sanrad.nms.client.gui.vswitch.interfaces.pscsi.PSCSIInterfacePropertiesDialog;
import com.sanrad.nms.client.gui.vswitch.statistics.icmp.ICMPStatisticsDialog;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.InterfacesStatisticsDialog;
import com.sanrad.nms.client.gui.vswitch.statistics.ip.IPStatisticsDialog;
import com.sanrad.nms.client.gui.vswitch.statistics.tcp.TCPStatisticsDialog;
import com.sanrad.nms.client.gui.vswitch.statistics.udp.UDPStatisticsDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.OKCancelFrame;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrDragAndDropTreePanel;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrTree;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BrowserLauncher;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrMainTreePanel
extends SrDragAndDropTreePanel
implements AlarmSourceSelectionListener {
    private static final String WAKE_ON_LAN = ClientLoader.UI_BUNDLE.getString(SrDefaultUIBundleKeys.WAKE_ON_LAN_AVAILABLE);
    private static final String CLUSTERS_WITH_MORE_THAN_2_V_SWITCHES_ARE_NOT_SUPPORTED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.REACHED_MAX_VSWITCHES_PER_CLUSTER);
    public static final String RAID_ACTION_FAILED_TO_EXECUTE = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RAID_ACTION_FAILED_TO_EXECUTE);
    public static final String THE_CLUSTER_CONTAINS_NO_V_SWITCHES = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.REACHED_MIN_VSWITCHES_PER_CLUSTER);
    private static final String RAID_PROPERTIES_DIALOG_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_PROPERTIES_DIALOG_TITLE);
    private static final String NO_V_SWITCH_IS_AVAILABLE = "No " + ClassID.VSWITCH + " available";
    private static SrLogger theLogger = SrLogger.getLogger();
    private TargetPopupMenu targetPopup;
    private ClusterPopupMenu clusterPopup;
    private VSwitchPopupMenu vSwitchPopup;
    private IdentitiesPopupMenu identitiesPopup;
    private ExposedVolumesPopupMenu exposedVolumesPopup;
    private StorageTreePopupMenu storageTreePopup;
    private NexsanMgmtPopupMenu myNexsanMgmtPopup;
    private SrDRTreePopupMenu m_drPopup;
    private SrJournalTreePopupMenu myJournalPopup = new SrJournalTreePopupMenu(this);
    private PopupTrigger popupTrigger;
    private boolean rootVisible = true;
    private JFrame myOwner;
    private SANPopupMenu sanPopup;
    private SrSitePopupMenu m_sitePopup;
    private static final String VSWITCH_ACTIVE_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_VSWITCH_ACTIVE_MSG);
    private static final String VSWITCH_ACTIVE_IN_CLUSTER_MSG = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_VSWITCH_ACTIVE_IN_CLUSTER_MSG);
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> newClusterHasBeenSelectedInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.newClusterHasBeenSelected(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showRootViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showRootView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showClusterViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showClusterView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showSiteViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showSiteView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showExposedVolumesViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showExposedVolumesView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showUnExposedVolumesViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showUnExposedVolumesView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showTargetViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showTargetView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showStorageViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showStorageMgmtView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showNexsanMgmtViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showNexsanMgmtView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showIdentitiesViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showIdentitiesView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showVSwitchViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showVSwitchView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showPairDetailsViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showPairDetailsView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showConsistencyGroupsViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showConsistencyGroupsView(event);
        }
    };
    SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent> showJournalsViewInformer = new SrEventListenerManager.Informer<MainTreeListener, MainTreeEvent>(){

        @Override
        public void inform(MainTreeListener listener, MainTreeEvent event) {
            listener.showJournalsView(event);
        }
    };
    public final SrClientAction newTargetAction = new SrClientAction<ClusterNode, Void>("New Target...", (Icon)ClientImageObject.TARGET.getImageIcon(), true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.GENERAL_PATH, true, false){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            new NewTargetDialog(SrMainTreePanel.this.myOwner, SystemRootNode.getInstance().getCurrentClusterNode());
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.newTargetAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (!SrMainTreeModel.isOneVSwitchAvailable(cluster)) {
                return NO_V_SWITCH_IS_AVAILABLE;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction newRemoteTargetAction = new SrClientAction<ClusterNode, Void>("iSCSI Remote Target...", (Icon)ClientImageObject.REMOTE_TARGET.getImageIcon(), true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.REMOTE_TARGET_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            final ClusterNode cluster = arg.iterator().next();
            final SiteNode site = (SiteNode)cluster.getParent();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SrNewISCSIRemoteTargetDialog dialog = new SrNewISCSIRemoteTargetDialog(SrMainTreePanel.this.myOwner, site.getAlias(), cluster);
                    dialog.show();
                }
            });
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.newRemoteTargetAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (SrMainTreeModel.getInstance().getNumberOfVswitches(cluster) == 0) {
                return THE_CLUSTER_CONTAINS_NO_V_SWITCHES;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction newStorageAction = new SrClientAction<ClusterNode, Void>("New Storage...", (Icon)ClientImageObject.GENERAL_SCSI_DEVICE.getImageIcon(), true, true, SystemRootNode.getInstance().getClusterView(), ClusterPopupMenu.createStoragePath){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new NewPhysStorageDeviceDialog(SrMainTreePanel.this.myOwner).show();
                }
            });
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.newStorageAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (SrMainTreeModel.getInstance().getNumberOfVswitches(cluster) == 0) {
                return THE_CLUSTER_CONTAINS_NO_V_SWITCHES;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction managedRaidAction = new SrClientAction<RaidNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POPUP_MENU_NEXSAN_MANAGE), (Icon)ClientImageObject.NEXSAN_MANAGE_ACTION.getImageIcon(), true, true, new TreeView<RaidNode>(this.getTreeObject(), RaidNode.class), ClusterPopupMenu.createStoragePath){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<RaidNode> arg) {
            if (arg == null || arg.isEmpty()) {
                String msg = ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.RAID_ACTION_FAILED_TO_EXECUTE, "manage");
                return Collections.singletonList(new FailedFuture(new IllegalArgumentException(msg), msg));
            }
            RaidNode raidNode = arg.iterator().next();
            if (raidNode instanceof RaidNode && raidNode.getType() == RaidSystem.Type.NEXSAN_MANAGED_RAID) {
                String url = ((NexsanManagedRaidNode)raidNode).getNexsanUrlForManage();
                if (!url.startsWith("http:\\\\") && !url.startsWith("http://")) {
                    url = "http://" + url;
                }
                final String urlWithHttp = url;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrowserLauncher.openURL(urlWithHttp);
                    }
                });
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.ManageRaidAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            RaidNode raidNode = (RaidNode)this.myView.getValue().iterator().next();
            if (raidNode.getType() == RaidSystem.Type.GENERAL_UNMANAGED_RAID || raidNode.getType() == RaidSystem.Type.GDR_UNMANAGED_RAID) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RAID_ACTION_NOT_SUPPORTED_FOR_RAID);
            }
            if (raidNode.getRaid().getCtrlIp1() == null && raidNode.getRaid().getCtrlIp2() == null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RAID_ACTION_NO_MGMT_IPS);
            }
            return null;
        }
    };
    public final SrClientAction showRaidPropertiesAction = new SrClientAction<RaidNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_INITIATOR_PROPERTIES), true, true, new TreeView<RaidNode>(this.getTreeObject(), RaidNode.class), ClusterPopupMenu.createStoragePath){

        @Override
        protected String derivedClientUpdateEnabled() {
            TreeNode raidNode = SrMainTreePanel.this.getSelectedNode();
            if (raidNode instanceof GdrUnmanagedRaidNode && ((RaidNode)raidNode).getType() == RaidSystem.Type.GDR_UNMANAGED_RAID) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.RAID_ACTION_NOT_SUPPORTED_FOR_RAID);
            }
            return null;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<RaidNode> arg) {
            if (arg == null || arg.isEmpty()) {
                String msg = ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.RAID_ACTION_FAILED_TO_EXECUTE, "show RAID Properties");
                return Collections.singletonList(new FailedFuture(new IllegalArgumentException(msg), msg));
            }
            RaidNode raidNode = arg.iterator().next();
            if (raidNode instanceof RaidNode) {
                final RaidNode raidNodeFinal = raidNode;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RaidPropertiesDialog props = new RaidPropertiesDialog(SrMainTreePanel.this.myOwner, RAID_PROPERTIES_DIALOG_TITLE, raidNodeFinal.getRaid());
                    }
                });
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openRaidProperties"));
        }
    };
    public final SrClientAction myNewSiteAction = new NewSiteAction();
    public final SrClientAction newIdentityAction = new SrClientAction<ClusterNode, Void>("New Host Group...", (Icon)ClientImageObject.IDENTITIES.getImageIcon(), true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            NewIdentityDialog newIdentityDialog = new NewIdentityDialog(SrMainTreePanel.this.myOwner, arg.iterator().next());
            newIdentityDialog.show();
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.newIdentityAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (!SrMainTreeModel.isOneVSwitchAvailable(cluster)) {
                return NO_V_SWITCH_IS_AVAILABLE;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction storageDiscoveryAction = new SrClientAction<ClusterNode, Void>("Storage Discovery", true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            String confirmTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLUSTER_POPUP_MENU_STORAGE_DISCOVERY_CONFIRM_TITLE);
            String confirmMsg = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLUSTER_POPUP_MENU_STORAGE_DISCOVERY_CONFIRM_MSG);
            int answer = SrOptionPaneUtil.showYesNoConfirmDialog(ClientLoader.getMainFrame(), confirmMsg, confirmTitle);
            if (answer == 1) {
                return Collections.singleton(new CompleteFuture("SrMainTreePanel.storageDiscoveryAction, not confirmed"));
            }
            ClusterNode clusterNode = arg.iterator().next();
            return Collections.singleton(ClientAOImpl.getInstance().manualDiscover((CommKeyClassId)clusterNode.getIdentifier()));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (!SrMainTreeModel.isOneVSwitchAvailable(cluster)) {
                return NO_V_SWITCH_IS_AVAILABLE;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction accessListAction = new SrClientAction<ClusterNode, Void>("Access List...", null, true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.GENERAL_PATH, true, false){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            new AclGlobalDialog(SrMainTreePanel.this.myOwner, arg.iterator().next()).show();
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.accessListAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction radiusAction = new SrClientAction<ClusterNode, Void>("RADIUS...", true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SrMainTreePanel.this.openRadiusDialog(arg.iterator().next());
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.radiusAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (!SrMainTreeModel.isOneVSwitchAvailable(cluster)) {
                return NO_V_SWITCH_IS_AVAILABLE;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction isnsAction = new SrClientAction<ClusterNode, Void>("iSNS...", true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SrMainTreePanel.this.openISNSDialog(arg.iterator().next());
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.isnsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (SrMainTreeModel.getInstance().getNumberOfVswitches(cluster) == 0) {
                return THE_CLUSTER_CONTAINS_NO_V_SWITCHES;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final AlarmAction myOpenSpecificAlarmsAction;
    public final AlarmAction myOpenPropagatedAlarmsAction;
    public final SrClientAction resetVSwitch = new SrClientAction<VSwitchNode, Void>("Reset", true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            ArrayList<CommKeyClassId> vSwitchIds = new ArrayList<CommKeyClassId>(arg.size());
            for (VSwitchNode vSwitch : arg) {
                vSwitchIds.add((CommKeyClassId)vSwitch.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().reset(vSwitchIds));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (VSwitchNode vSwitch : this.myView.getValue()) {
                String regularTest = SrMainTreePanel.regularVSwitchTest(vSwitch);
                if (regularTest == null) continue;
                return regularTest;
            }
            return null;
        }
    };
    public final SrClientAction attachRaidActionForCluster = new SrClientAction<ClusterNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_TREE_POPUP_CLUSTER_ATTACH_RAID), true, true, SystemRootNode.getInstance().getClusterView(), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClusterNode cluster = (ClusterNode)myView.getValue().iterator().next();
                    if (cluster != null) {
                        AttachRaidDialog.showDialog(ClientLoader.getMainFrame(), cluster);
                    }
                }
            });
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.attachRaidAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            String errorMsg = VSwitchManager.getInstance().validateConnectedVswitchExists(cluster);
            if (errorMsg != null) {
                return errorMsg;
            }
            List<RaidSystem> clusterRaids = RaidManager.getInstance().getRaids(cluster);
            if (clusterRaids.isEmpty()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.ATTACH_RAID_NO_RAIDS_DEFINED_FOR_THIS_CLUSTER);
            }
            return null;
        }

        @Override
        protected boolean shouldClientActionBeVisible() {
            return true;
        }
    };
    public final SrClientAction attachOrDetachRaidActionForVs = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_TREE_POPUP_CLUSTER_ATTACH_RAID), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode vs = (VSwitchNode)this.myView.getValue().iterator().next();
            final ClusterNode cluster = (ClusterNode)vs.getAncestorOfType(ClusterNode.class);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AttachRaidDialog.showDialog(ClientLoader.getMainFrame(), cluster);
                }
            });
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.attachOrDetachRaidActionForVs"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VSwitchNode vs = (VSwitchNode)this.myView.getValue().iterator().next();
            if (!vs.isConnected()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_DISCONNECTED);
            }
            ClusterNode cluster = (ClusterNode)vs.getAncestorOfType(ClusterNode.class);
            List<RaidSystem> clusterRaids = RaidManager.getInstance().getRaids(cluster);
            if (clusterRaids.isEmpty()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.ATTACH_RAID_NO_RAIDS_DEFINED_FOR_THIS_CLUSTER);
            }
            return null;
        }

        @Override
        protected boolean shouldClientActionBeVisible() {
            return true;
        }
    };
    public final SrClientAction shutdownVSwitch = new SrClientAction<VSwitchNode, Void>("Shutdown", true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            ArrayList<CommKeyClassId> vswitchId = new ArrayList<CommKeyClassId>(arg.size());
            VSwitchNode vSwitch = arg.iterator().next();
            boolean shutdownConfirmed = true;
            if (!vSwitch.isManagementInterfaceIsMgnt()) {
                InterfaceTableRowNode mgntInterface = vSwitch.getInterfaceOfManagementIP();
                String warnMsg = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.INTERFACE_SHUTDOWN_IS_NOT_MGNT_INTERFACE, mgntInterface.getName(), vSwitch.getName());
                int ret = JOptionPane.showConfirmDialog(null, warnMsg, ClientLoader.BUNDLE.getString(SrClientBundleKeys.INTERFACE_SHUTDOWN_IS_NOT_MGNT_INTERFACE_WARN_MSG_TITLE), 0, 2);
                shutdownConfirmed = ret == 0;
            }
            vswitchId.add((CommKeyClassId)vSwitch.getIdentifier());
            if (shutdownConfirmed) {
                return Collections.singleton(ClientAOImpl.getInstance().shutdown(vswitchId));
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VSwitchNode vSwitch = (VSwitchNode)this.myView.getValue().iterator().next();
            String retVal = SrMainTreePanel.regularVSwitchTest(vSwitch);
            if (retVal != null) {
                return retVal;
            }
            StringBuffer sb = new StringBuffer("");
            if (!VSwitchManager.getInstance().isVSwitchLegitimateForShutdown(vSwitch, sb)) {
                return sb.toString();
            }
            return null;
        }
    };
    public final SrClientAction wakeOnLANVSwitch = new SrClientAction<VSwitchNode, Void>("Wake on LAN", true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            ArrayList<CommKeyClassId> vswitchIds = new ArrayList<CommKeyClassId>(arg.size());
            for (VSwitchNode vSwitch : arg) {
                vswitchIds.add((CommKeyClassId)vSwitch.getIdentifier());
            }
            return Collections.singleton(ClientAOImpl.getInstance().wakeOnLAN(vswitchIds));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            for (VSwitchNode vSwitch : this.myView.getValue()) {
                String retVal = SrMainTreePanel.regularVSwitchTest(vSwitch, false);
                if (retVal != null) {
                    return retVal;
                }
                if (!vSwitch.isConnected()) continue;
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_WAKE_ON_LAN_VALIDATION_CONNECTED);
            }
            return null;
        }

        @Override
        protected boolean shouldClientActionBeVisible() {
            return WAKE_ON_LAN == null || Boolean.valueOf(WAKE_ON_LAN) != false;
        }
    };
    public final SrClientAction openPScsiProperties = new SrClientAction<VSwitchNode, Void>("Parallel SCSI...", true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            PSCSIInterfacePropertiesDialog props = new PSCSIInterfacePropertiesDialog(SrMainTreePanel.this.myOwner, arg.iterator().next());
            props.show();
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openPScsiProperties"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VSwitchNode vSwitch = (VSwitchNode)this.myView.getValue().iterator().next();
            String retVal = SrMainTreePanel.regularVSwitchTest(vSwitch);
            if (retVal != null) {
                return retVal;
            }
            if (!vSwitch.isPSCSIInterfaceExist()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_PSCSI_VALIDATION_NO_PSCSI_INTERFACE_EXISTED);
            }
            return null;
        }
    };
    public final SrClientAction openFCProperties = new SrClientAction<VSwitchNode, Void>("FibreChannel...", true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            FCInterfacePropertiesDialog props = new FCInterfacePropertiesDialog(SrMainTreePanel.this.myOwner, arg.iterator().next());
            props.show();
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openFCProperties"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VSwitchNode vSwitch = (VSwitchNode)this.myView.getValue().iterator().next();
            String retVal = SrMainTreePanel.regularVSwitchTest(vSwitch);
            if (retVal != null) {
                return retVal;
            }
            if (!vSwitch.isFCInterfaceExist()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_FC_VALIDATION_NO_FC_INTERFACE_EXISTED);
            }
            return null;
        }
    };
    public final SrClientAction mySynchronizeCluster = new SynchronizeElementAction<ClusterNode>(new TreeView<ClusterNode>(this.m_tree, ClusterNode.class), StatusPanel.getInstance());
    public SrClientAction rediscoverClusterAction = new SrClientAction<ClusterNode, Void>("Rediscover", true, true, new TreeView<ClusterNode>(this.m_tree, ClusterNode.class), SrLicenseTreePath.GENERAL_PATH, true){
        private Collection<ClusterNode> myLastArgs;

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            ClusterNode node = arg.iterator().next();
            theLogger.trace(SrLogCategories.LEGACY, "trying to re-discover Cluster ");
            this.myLastArgs = arg;
            return Collections.singleton(ClientAOImpl.getInstance().rediscover((CommKeyClassId)node.getIdentifier()));
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            if (35.isSuccessful(aFutures, 1)) {
                SrTransientWindowPane.showClusterRediscoverStarted(SrMainTreePanel.this.myOwner, this.myLastArgs.iterator().next(), new SrAlarmsTablePanel.SourceAction<ClusterNode>((View<ClusterNode>)new ConstantView<ClusterNode>(this.myLastArgs)));
            }
            this.myLastArgs = null;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (SrMainTreeModel.getInstance().getNumberOfVswitches(cluster) == 0) {
                return THE_CLUSTER_CONTAINS_NO_V_SWITCHES;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction rediscoverSiteAction = new SrClientAction<SiteNode, Void>("Rediscover", null, true, true, new TreeView<SiteNode>(this.m_tree, SiteNode.class), SrLicenseTreePath.GENERAL_PATH, true, true){
        private Collection<SiteNode> myLastArgs;
        {
            this.myLastArgs = null;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
            this.myLastArgs = arg;
            return Collections.singleton(ClientAOImpl.getInstance().rediscover((CommKeyClassId)arg.iterator().next().getIdentifier()));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String siteDisplayName;
            SiteNode selectedSite = (SiteNode)this.myView.getValue().iterator().next();
            String string = siteDisplayName = selectedSite instanceof SystemRootNode ? ClientLoader.PRODUCT_NAME : "Site " + selectedSite;
            if (!selectedSite.containsVSwitches()) {
                return siteDisplayName + " contains no " + ClientLoader.VSWITCHES_DISPLAY_STRING;
            }
            if (selectedSite.inDiscoveryProcess()) {
                return siteDisplayName + " is in discovery process";
            }
            return null;
        }

        @Override
        protected String getConfirmationString() {
            return ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_REDISCOVER_CONFIRM_MSG, ((SiteNode)this.myView.getValue().iterator().next()).getAlias());
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            if (!36.isSuccessful(aFutures, 1)) {
                return;
            }
            MainFrame owner = ClientLoader.getMainFrame();
            SiteNode site = this.myLastArgs.iterator().next();
            String siteAlias = site.getAlias();
            SrAlarmsTablePanel.SourceAction<SiteNode> action = new SrAlarmsTablePanel.SourceAction<SiteNode>((View<SiteNode>)new ConstantView<SiteNode>(this.myLastArgs));
            if (site instanceof SystemRootNode) {
                SrTransientWindowPane.showSystemRediscoverStarted(owner, siteAlias, action);
            } else {
                SrTransientWindowPane.showSiteRediscoverStarted(owner, siteAlias, action);
            }
            this.myLastArgs = null;
        }
    };
    public final DeleteAction myRemoveVswitchAction;
    public final DeleteAction myRemoveClusterAction;
    public final DeleteAction myRemoveSiteAction;
    public final SrClientAction openVSwitchProperties = new SrClientAction<VSwitchNode, Void>(true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            Object uo = node.getDialog(VSwitchPropertiesDialog.class);
            if (uo == null) {
                VSwitchPropertiesDialog dialog = new VSwitchPropertiesDialog(SrMainTreePanel.this.myOwner, node);
                node.addDialog(dialog);
                dialog.show();
            } else {
                ((VSwitchPropertiesDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openVSwitchProperties"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VSwitchNode vSwitch = (VSwitchNode)this.myView.getValue().iterator().next();
            ClusterNode clusterNode = (ClusterNode)vSwitch.getParent();
            return clusterNode.getInDiscoveryTooltip();
        }
    };
    public final SrClientAction vSwitchHardwareStatus = new SrClientAction<VSwitchNode, Void>("Hardware", true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            Object uo = node.getDialog(VSwitchHardwareDataDialog.class);
            if (uo == null) {
                VSwitchHardwareDataDialog d = new VSwitchHardwareDataDialog(SrMainTreePanel.this.myOwner, node);
                node.addDialog(d);
                d.show();
            } else {
                ((VSwitchHardwareDataDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.vSwitchHardwareStatus"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return SrMainTreePanel.regularVSwitchTest((VSwitchNode)this.myView.getValue().iterator().next());
        }
    };
    public final SrClientAction interfacesStatistics = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_INTERFACES), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            Object uo = node.getInterfacesStatisticsGroupNode().getDialog(InterfacesStatisticsDialog.class);
            if (uo == null) {
                InterfacesStatisticsDialog d = new InterfacesStatisticsDialog(SrMainTreePanel.this.myOwner, node);
                node.getInterfacesStatisticsGroupNode().addDialog(d);
                d.show();
            } else {
                ((InterfacesStatisticsDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.interfacesStatistics"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction ipStatistics = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_IP), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            Object uo = node.getIPStatistics().getDialog(IPStatisticsDialog.class);
            if (uo == null) {
                IPStatisticsDialog d = new IPStatisticsDialog(SrMainTreePanel.this.myOwner, node);
                node.getIPStatistics().addDialog(d);
                d.show();
            } else {
                ((IPStatisticsDialog)uo).requestFocus();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction icmpStatistics = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_ICMP), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            Object uo = node.getICMPStatistics().getDialog(ICMPStatisticsDialog.class);
            if (uo == null) {
                ICMPStatisticsDialog d = new ICMPStatisticsDialog(SrMainTreePanel.this.myOwner, node);
                node.getICMPStatistics().addDialog(d);
                d.show();
            } else {
                ((ICMPStatisticsDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.icmpStatistics"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction tcpStatistics = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_TCP), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            Object uo = node.getTCPStatistics().getDialog(TCPStatisticsDialog.class);
            if (uo == null) {
                TCPStatisticsDialog d = new TCPStatisticsDialog(SrMainTreePanel.this.myOwner, node);
                node.getTCPStatistics().addDialog(d);
                d.show();
            } else {
                ((TCPStatisticsDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.tcpStatistics"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction udpStatistics = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_UDP), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            Object uo = node.getUDPStatistics().getDialog(UDPStatisticsDialog.class);
            if (uo == null) {
                UDPStatisticsDialog d = new UDPStatisticsDialog(SrMainTreePanel.this.myOwner, node);
                node.getUDPStatistics().addDialog(d);
                d.show();
            } else {
                ((UDPStatisticsDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.udpStatistics"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openIscsiInstanceInfo = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_ISCSI_INFO), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.ISCSI_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            ISCSIInstanceInfo iscsiInfo = (ISCSIInstanceInfo)node.getISCSIInstanceInfos().elementAt(0);
            Object uo = iscsiInfo.getDialog(ISCSIInstanceInfoDialog.class);
            if (uo == null) {
                ISCSIInstanceInfoDialog d = new ISCSIInstanceInfoDialog(SrMainTreePanel.this.myOwner, node);
                iscsiInfo.addDialog(d);
                d.show();
            } else {
                ((ISCSIInstanceInfoDialog)uo).show();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openIscsiInstanceInfo"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openIscsiInitiator = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_INITIATOR_PROPERTIES), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.INITIATOR_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            final ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
            final VSwitchNode node = arg.iterator().next();
            final SrInitiatorNode initiatorNode = node.getISCSIInitiators()[0];
            Object uo = initiatorNode.getDialog(SrInitiatorPropertiesDlg.class);
            if (uo == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SrInitiatorPropertiesDlg dlg = new SrInitiatorPropertiesDlg(SrMainTreePanel.this.myOwner, ((SiteNode)clusterNode.getParent()).getAlias(), clusterNode, node, initiatorNode);
                        initiatorNode.addDialog(dlg);
                        dlg.show();
                    }
                });
            } else {
                ((SrInitiatorPropertiesDlg)uo).show();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openIscsiInitiator"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction iscsiInitiatorPortsStatistics = new SrClientAction<VSwitchNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_INITIATOR_PORT_COUNTERS), true, true, new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), SrLicenseTreePath.INITIATOR_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> arg) {
            VSwitchNode node = arg.iterator().next();
            SrInitiatorNode initiatorNode = node.getISCSIInitiators()[0];
            Object uo = initiatorNode.getDialog(SrISCSIInitiatorPortsShowDialog.class);
            if (uo == null) {
                SrISCSIInitiatorPortsShowDialog dlg = new SrISCSIInitiatorPortsShowDialog(SrMainTreePanel.this.myOwner, initiatorNode);
                initiatorNode.addDialog(dlg);
                dlg.show();
            } else {
                ((SrISCSIInitiatorPortsShowDialog)uo).show();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.iscsiInitiatorPortsStatistics"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction<SrTreeNode, JDialog> iscsiRemoteTargetsShowAction = new SrClientAction<SrTreeNode, JDialog>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_ISCSI_REMOTE_TARGETS), true, true, new TreeView<SrTreeNode>(this.m_tree, SrTreeNode.class), SrLicenseTreePath.REMOTE_TARGET_PATH){

        @Override
        public Collection<? extends SrFuture<JDialog>> derivedActionPerformed(Collection<SrTreeNode> arg) {
            SrTreeNode node = arg.iterator().next();
            SrISCSIRemoteTargetsShowDialog uo = (SrISCSIRemoteTargetsShowDialog)node.getDialog(SrISCSIRemoteTargetsShowDialog.class);
            if (uo == null) {
                SrOKCancelDialog iscsiRemoteTargetsShowDialog = null;
                if (node instanceof ClusterNode) {
                    ClusterNode clusterNode = (ClusterNode)node;
                    iscsiRemoteTargetsShowDialog = new SrISCSIRemoteTargetsShowDialog(SrMainTreePanel.this.myOwner, clusterNode, 0);
                } else if (node instanceof VSwitchNode) {
                    VSwitchNode vswitchNode = (VSwitchNode)node;
                    iscsiRemoteTargetsShowDialog = new SrISCSIRemoteTargetsShowDialog(SrMainTreePanel.this.myOwner, vswitchNode, 1);
                }
                node.addDialog(iscsiRemoteTargetsShowDialog);
                iscsiRemoteTargetsShowDialog.show();
                return Collections.singleton(new CompleteFuture<SrOKCancelDialog>(iscsiRemoteTargetsShowDialog, "SrMainTreePanel.iscsiRemoteTargetsShowAction, new"));
            }
            uo.requestFocus();
            return Collections.singleton(new CompleteFuture<SrISCSIRemoteTargetsShowDialog>(uo, "SrMainTreePanel.iscsiRemoteTargetsShowAction, existing"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction iscsiRemoteDiscoveryPortalsShowAction = new SrClientAction<SrTreeNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_ISCSI_REMOTE_DISCOVERY_PORTALS), null, true, true, new TreeView<SrTreeNode>(this.m_tree, SrTreeNode.class), SrLicenseTreePath.REMOTE_PORTAL_PATH, false, false){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SrTreeNode> arg) {
            SrTreeNode node = arg.iterator().next();
            Object uo = node.getDialog(SrISCSIRemoteDiscoveryPortalsShowDialog.class);
            if (uo == null) {
                SrOKCancelDialog iscsiRemoteDiscoveryPortalsShowDialog = null;
                if (node instanceof ClusterNode) {
                    ClusterNode clusterNode = (ClusterNode)node;
                    iscsiRemoteDiscoveryPortalsShowDialog = new SrISCSIRemoteDiscoveryPortalsShowDialog(SrMainTreePanel.this.myOwner, clusterNode, 0);
                } else if (node instanceof VSwitchNode) {
                    VSwitchNode vswitchNode = (VSwitchNode)node;
                    iscsiRemoteDiscoveryPortalsShowDialog = new SrISCSIRemoteDiscoveryPortalsShowDialog(SrMainTreePanel.this.myOwner, vswitchNode, 1);
                }
                node.addDialog(iscsiRemoteDiscoveryPortalsShowDialog);
                iscsiRemoteDiscoveryPortalsShowDialog.show();
            } else {
                ((SrISCSIRemoteDiscoveryPortalsShowDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.iscsiRemoteDiscoveryPortalsShowAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openIscsiSessionsShowAction = new SrClientAction<SrTreeNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_SHOW), true, true, new TreeView<SrTreeNode>(this.m_tree, SrTreeNode.class), SrLicenseTreePath.ISCSI_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SrTreeNode> arg) {
            SrTreeNode node = arg.iterator().next();
            Object uo = node.getDialog(ISCSISessionsShowDialog.class);
            if (uo == null) {
                SrOKCancelDialog iscsiSessionsShowDialog = null;
                if (node instanceof ClusterNode) {
                    ClusterNode clusterNode = (ClusterNode)node;
                    iscsiSessionsShowDialog = new ISCSISessionsShowDialog(SrMainTreePanel.this.myOwner, clusterNode, 0);
                } else if (node instanceof VSwitchNode) {
                    VSwitchNode vswitchNode = (VSwitchNode)node;
                    iscsiSessionsShowDialog = new ISCSISessionsShowDialog(SrMainTreePanel.this.myOwner, vswitchNode, 1);
                } else if (node instanceof TargetNode) {
                    TargetNode targetNode = (TargetNode)node;
                    iscsiSessionsShowDialog = new ISCSISessionsShowDialog(SrMainTreePanel.this.myOwner, targetNode, 2);
                }
                node.addDialog(iscsiSessionsShowDialog);
                iscsiSessionsShowDialog.show();
            } else {
                ((ISCSISessionsShowDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openIscsiSessionsShowAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openIscsiSessionsStatisticsAction = new SrClientAction<SrTreeNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_STATISTICS), true, true, new TreeView<SrTreeNode>(this.m_tree, SrTreeNode.class), SrLicenseTreePath.ISCSI_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SrTreeNode> arg) {
            SrTreeNode node = arg.iterator().next();
            Object uo = node.getDialog(ISCSISessionsStatisticsDialog.class);
            if (uo == null) {
                ISCSISessionsStatisticsDialog dialog = null;
                if (node.getClass().isAssignableFrom(ClusterNode.class)) {
                    dialog = new ISCSISessionsStatisticsDialog(SrMainTreePanel.this.myOwner, (ClusterNode)node);
                } else if (node.getClass().isAssignableFrom(VSwitchNode.class)) {
                    dialog = new ISCSISessionsStatisticsDialog(SrMainTreePanel.this.myOwner, (VSwitchNode)node);
                } else if (node.getClass().isAssignableFrom(TargetNode.class)) {
                    dialog = new ISCSISessionsStatisticsDialog(SrMainTreePanel.this.myOwner, (TargetNode)node);
                } else {
                    throw new IllegalArgumentException("Tree Node " + node + " is not applicable for ISCSISessionsStatisticsDialog");
                }
                node.addDialog(dialog);
                dialog.show();
            } else {
                ((ISCSISessionsStatisticsDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openIscsiSessionsStatisticsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openIscsiConnectionsAction = new SrClientAction<SrTreeNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_ISCSI_CONNECTIONS), true, true, new TreeView<SrTreeNode>(this.m_tree, SrTreeNode.class), SrLicenseTreePath.ISCSI_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SrTreeNode> arg) {
            SrTreeNode node = arg.iterator().next();
            Object uo = node.getDialog(ISCSIConnectionsShowDialog.class);
            if (uo == null) {
                SrOKCancelDialog iscsiConnectionsShowDialog = null;
                if (node instanceof ClusterNode) {
                    ClusterNode clusterNode = (ClusterNode)node;
                    iscsiConnectionsShowDialog = new ISCSIConnectionsShowDialog(SrMainTreePanel.this.myOwner, clusterNode, 0);
                } else if (node instanceof VSwitchNode) {
                    VSwitchNode vswitchNode = (VSwitchNode)node;
                    iscsiConnectionsShowDialog = new ISCSIConnectionsShowDialog(SrMainTreePanel.this.myOwner, vswitchNode, 1);
                } else if (node instanceof TargetNode) {
                    TargetNode targetNode = (TargetNode)node;
                    iscsiConnectionsShowDialog = new ISCSIConnectionsShowDialog(SrMainTreePanel.this.myOwner, targetNode, 2);
                }
                node.addDialog(iscsiConnectionsShowDialog);
                iscsiConnectionsShowDialog.show();
            } else {
                ((ISCSIConnectionsShowDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openIscsiConnectionsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openIscsiConnectedInitiatorShowAction = new SrClientAction<SrTreeNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_SHOW), true, true, new TreeView<SrTreeNode>(this.m_tree, SrTreeNode.class), SrLicenseTreePath.ISCSI_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SrTreeNode> arg) {
            SrTreeNode node = arg.iterator().next();
            Object uo = node.getDialog(ISCSIRemoteInitiatorsShowDialog.class);
            if (uo == null) {
                SrOKCancelDialog iscsiRemoteInitiatorsShowDialog = null;
                if (node instanceof ClusterNode) {
                    ClusterNode clusterNode = (ClusterNode)node;
                    iscsiRemoteInitiatorsShowDialog = new ISCSIRemoteInitiatorsShowDialog(SrMainTreePanel.this.myOwner, clusterNode, 0);
                } else if (node instanceof VSwitchNode) {
                    VSwitchNode vswitchNode = (VSwitchNode)node;
                    iscsiRemoteInitiatorsShowDialog = new ISCSIRemoteInitiatorsShowDialog(SrMainTreePanel.this.myOwner, vswitchNode, 1);
                } else if (node instanceof TargetNode) {
                    TargetNode targetNode = (TargetNode)node;
                    iscsiRemoteInitiatorsShowDialog = new ISCSIRemoteInitiatorsShowDialog(SrMainTreePanel.this.myOwner, targetNode, 2);
                }
                node.addDialog(iscsiRemoteInitiatorsShowDialog);
                iscsiRemoteInitiatorsShowDialog.show();
            } else {
                ((ISCSIRemoteInitiatorsShowDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.openIscsiConnectedInitiatorShowAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openIscsiConnectedInitiatorsStatisticsAction = new SrClientAction<SrTreeNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_STATISTICS), true, true, new TreeView<SrTreeNode>(this.m_tree, SrTreeNode.class), SrLicenseTreePath.ISCSI_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SrTreeNode> arg) {
            SrTreeNode node = arg.iterator().next();
            Object uo = node.getDialog(ISCSIRemoteInitiatorsStatisticsDialog.class);
            if (uo == null) {
                ISCSIRemoteInitiatorsStatisticsDialog iscsiRemoteInitiatorsStatisticsDialog = new ISCSIRemoteInitiatorsStatisticsDialog(SrMainTreePanel.this.myOwner, node);
                node.addDialog(iscsiRemoteInitiatorsStatisticsDialog);
                iscsiRemoteInitiatorsStatisticsDialog.show();
            } else {
                ((ISCSIRemoteInitiatorsStatisticsDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("com.sanrad.nms.client.gui.SrMainTreePanel.openIscsiConnectedInitiatorsStatisticsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openScsiTargetPortsStatisticsAction = new SrClientAction<TargetNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_POP_UP_MENU_STATISTICS), true, true, new TreeView<TargetNode>(this.m_tree, TargetNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<TargetNode> arg) {
            TargetNode targetNode = arg.iterator().next();
            Object uo = targetNode.getDialog(SCSITargetPortsStatisticsDialog.class);
            if (uo == null) {
                SCSITargetPortsStatisticsDialog targetPortsStatisticsDialog = new SCSITargetPortsStatisticsDialog(SrMainTreePanel.this.myOwner, targetNode);
                targetNode.addDialog(targetPortsStatisticsDialog);
                targetPortsStatisticsDialog.show();
            } else {
                ((SCSITargetPortsStatisticsDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("com.sanrad.nms.client.gui.SrMainTreePanel.openScsiTargetPortsStatisticsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction openClusterPropertiesAction = new SrClientAction<ClusterNode, Void>(true, true, new TreeView<ClusterNode>(this.m_tree, ClusterNode.class), SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            ClusterNode node = arg.iterator().next();
            Object uo = node.getDialog(ClusterPropertiesDialog.class);
            if (uo == null) {
                ClusterPropertiesDialog dialog = new ClusterPropertiesDialog(SrMainTreePanel.this.myOwner, node);
                node.addDialog(dialog);
                dialog.show();
            } else {
                ((ClusterPropertiesDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("com.sanrad.nms.client.gui.SrMainTreePanel.openClusterPropertiesAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (SrMainTreeModel.getInstance().getNumberOfVswitches(cluster) == 0) {
                return THE_CLUSTER_CONTAINS_NO_V_SWITCHES;
            }
            return cluster.getInDiscoveryTooltip();
        }
    };
    public final DeleteAction myDeleteTargetAction;
    public final SrClientAction targetPropertiesAction = new SrClientAction<TargetNode, Void>(null, null, true, true, new TreeView<TargetNode>(this.m_tree, TargetNode.class), SrLicenseTreePath.GENERAL_PATH, false, false){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<TargetNode> arg) {
            for (TargetNode targetNode : arg) {
                Object uo = targetNode.getDialog(TargetPropertiesDialog.class);
                if (uo == null) {
                    TargetPropertiesDialog targetPropertiesDialog = new TargetPropertiesDialog(SrMainTreePanel.this.myOwner, targetNode);
                    targetNode.addDialog(targetPropertiesDialog);
                    targetPropertiesDialog.show();
                    continue;
                }
                ((TargetPropertiesDialog)uo).requestFocus();
            }
            return Collections.singleton(new CompleteFuture("com.sanrad.nms.client.gui.SrMainTreePanel.targetPropertiesAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    };
    public final SrClientAction startEditAction = new SrClientAction<VSwitchGroupNode, Void>(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_RENAME_LBL), true, true, new TreeView<VSwitchGroupNode>(this.m_tree, VSwitchGroupNode.class), SrLicenseTreePath.GENERAL_PATH, true){

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchGroupNode> arg) {
            SrMainTreePanel.this.getTreeObject().startEditingAtPath(SrMainTreePanel.this.getTreeObject().getSelectionPath());
            return Collections.singleton(new CompleteFuture("com.sanrad.nms.client.gui.SrMainTreePanel.startEditAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            VSwitchGroupNode arg = (VSwitchGroupNode)this.myView.getValue().iterator().next();
            if (arg instanceof ClusterNode) {
                return ((ClusterNode)arg).getInDiscoveryTooltip();
            }
            return null;
        }
    };

    public SrMainTreePanel(MainFrame aOwner) {
        super(SrMainTreeModel.getInstance());
        this.getTreeObject().setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        TreeView<SrTreeNode> treeNodeView = new TreeView<SrTreeNode>(this.getTreeObject(), SrTreeNode.class);
        this.myOpenSpecificAlarmsAction = new AlarmAction<SrTreeNode>((View<SrTreeNode>)treeNodeView, true);
        this.myOpenPropagatedAlarmsAction = new AlarmAction<SrTreeNode>((View<SrTreeNode>)treeNodeView, false);
        this.myRemoveVswitchAction = new DeleteAction<VSwitchNode>(new TreeView<VSwitchNode>(this.m_tree, VSwitchNode.class), (OperationController)StatusPanel.getInstance(), null, true){
            private ClusterNode myLastClusterNode;
            private String myLastIP;
            {
                this.myLastClusterNode = null;
                this.myLastIP = null;
            }

            @Override
            public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> aArgs) {
                VSwitchNode vSwitch = aArgs.iterator().next();
                ClusterNode clusterNode = (ClusterNode)vSwitch.getParent();
                if (clusterNode.getVswitchesCount() > 1) {
                    this.myLastClusterNode = clusterNode;
                    this.myLastIP = vSwitch.getIPAddress();
                }
                return super.derivedActionPerformed(aArgs);
            }

            @Override
            protected String derivedClientUpdateEnabled() {
                VSwitchNode vSwitch = (VSwitchNode)this.myView.getValue().iterator().next();
                ClusterNode clusterNode = (ClusterNode)vSwitch.getParent();
                String inDiscoveryTooltip = clusterNode.getInDiscoveryTooltip();
                if (inDiscoveryTooltip != null) {
                    return inDiscoveryTooltip;
                }
                if (vSwitch.isConnected()) {
                    return VSWITCH_ACTIVE_MSG;
                }
                int total = clusterNode.getVswitchesCount();
                if (total < 2) {
                    return super.derivedClientUpdateEnabled();
                }
                Vector<VSwitchNode> others = ((SrMainTreeModel)SrMainTreePanel.this.getTreeModel()).getOtherVSwitches(vSwitch);
                List<Neighbor> nbrs = others.get(0).getNeighbors();
                if (!nbrs.isEmpty() && !AlarmsManager.getInstance().isRemovableVSwitch(others.get(0))) {
                    return VSWITCH_ACTIVE_IN_CLUSTER_MSG;
                }
                return super.derivedClientUpdateEnabled();
            }

            @Override
            protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
                super.onActionFinished(aFutures);
                if (this.myLastClusterNode != null) {
                    SrTransientWindowPane.showRemoveNeighborStarted(ClientLoader.getMainFrame(), this.myLastClusterNode.getAlias(), this.myLastIP, new SrAlarmsTablePanel.SourceAction<ClusterNode>((View<ClusterNode>)new ConstantView<ClusterNode>(Collections.singleton(this.myLastClusterNode))));
                    this.myLastClusterNode = null;
                    this.myLastIP = null;
                }
            }
        };
        this.myRemoveVswitchAction.setConfirmationString("Are you sure you want to delete the " + ClientLoader.VSWITCH_DISPLAY_STRING + " ?");
        this.myRemoveVswitchAction.setConfirmationTitle("Remove " + ClientLoader.VSWITCH_DISPLAY_STRING);
        this.myDeleteTargetAction = new DeleteAction<TargetNode>(new TreeView<TargetNode>(this.m_tree, TargetNode.class), StatusPanel.getInstance(), new DeleteAction.Confirmator());
        this.myRemoveClusterAction = new DeleteAction<ClusterNode>(new TreeView<ClusterNode>(this.m_tree, ClusterNode.class), StatusPanel.getInstance(), null, true);
        this.myRemoveClusterAction.setConfirmationString("Are you sure you want to delete the Cluster?");
        this.myRemoveClusterAction.setConfirmationTitle("Delete Cluster");
        this.myRemoveSiteAction = new DeleteAction<SiteNode>(new TreeView<SiteNode>(this.m_tree, SiteNode.class), StatusPanel.getInstance(), null, true);
        this.myOwner = aOwner;
        this.myRemoveSiteAction.setConfirmationString("Are you sure you want to delete the Site?");
        this.myRemoveSiteAction.setConfirmationTitle("Delete Site");
        this.storageDiscoveryAction.addControllerAsListener(StatusPanel.getInstance());
        this.storageDiscoveryAction.setConnectionErrorMessage("Failed to activate Storage Discovery.");
        this.rediscoverClusterAction.addControllerAsListener(StatusPanel.getInstance());
        this.rediscoverClusterAction.setConnectionErrorMessage("Failed in Rediscovery process.");
        this.rediscoverClusterAction.setConfirmationTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLUSTER_POPUP_MENU_REDISCOVER_CONFIRM_TITLE));
        this.rediscoverClusterAction.setConfirmationString(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_CLUSTER_POPUP_MENU_REDISCOVER_CONFIRM_MSG));
        this.rediscoverSiteAction.addControllerAsListener(StatusPanel.getInstance());
        this.rediscoverSiteAction.setConnectionErrorMessage("Failed in site rediscovery process.");
        this.rediscoverSiteAction.setConfirmationTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_REDISCOVER_CONFIRM_TITLE));
        this.resetVSwitch.addControllerAsListener(StatusPanel.getInstance());
        this.resetVSwitch.setConfirmationTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_RESET_CONFIRM_TITLE));
        this.resetVSwitch.setConfirmationString(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_VSWITCH_POP_UP_MENU_RESET_CONFIRM_MSG));
        this.shutdownVSwitch.addControllerAsListener(StatusPanel.getInstance());
        StringBuffer sb = new StringBuffer("Are you sure you want to shutdown the ");
        sb.append(ClientLoader.VSWITCH_DISPLAY_STRING);
        sb.append("?");
        this.shutdownVSwitch.setConfirmationString(sb.toString());
        this.shutdownVSwitch.setConfirmationTitle("Shutdown");
        this.wakeOnLANVSwitch.addControllerAsListener(StatusPanel.getInstance());
        this.vSwitchPopup = new VSwitchPopupMenu(this);
        this.identitiesPopup = new IdentitiesPopupMenu(this);
        this.exposedVolumesPopup = new ExposedVolumesPopupMenu(this);
        ToolTipManager.sharedInstance().registerComponent(this.getTreeObject());
        this.createTree();
        this.clusterPopup = new ClusterPopupMenu(this);
        this.sanPopup = new SANPopupMenu(this);
        this.storageTreePopup = new StorageTreePopupMenu(this);
        this.myNexsanMgmtPopup = new NexsanMgmtPopupMenu(this);
        this.popupTrigger = new PopupTrigger();
        this.getTreeObject().addMouseListener(this.popupTrigger);
        this.getTreeObject().setOpaque(false);
        this.getTreeObject().setFont(new Font("Verdana", 0, 9));
        AlarmsManager.getInstance().addAlarmSourceSelectionListener(this);
        this.m_drPopup = new SrDRTreePopupMenu(this);
        this.m_sitePopup = new SrSitePopupMenu(this);
        this.m_tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(final TreeModelEvent e) {
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        Object[] nodes = e.getChildren();
                        int i = nodes.length;
                        while (i-- > 0) {
                            if (nodes[i] instanceof ClusterNode) {
                                ClusterNode cluster = (ClusterNode)nodes[i];
                                SrMainTreePanel.this.m_tree.ensureVisibility(cluster.getStorageNode());
                                continue;
                            }
                            if (!(nodes[i] instanceof SiteNode)) continue;
                            SrMainTreePanel.this.m_tree.ensureVisibility((SiteNode)nodes[i]);
                        }
                    }
                });
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                block3: {
                    TreeNode node;
                    block2: {
                        node = (TreeNode)e.getTreePath().getLastPathComponent();
                        if (!(node instanceof ClusterNode)) break block2;
                        if (!node.equals(SystemRootNode.getInstance().getCurrentClusterNode())) break block3;
                        SrMainTreePanel.this.select((SrTreeNode)SystemRootNode.getInstance().findNodeInSubTree(ClusterNode.class));
                        break block3;
                    }
                    if (node instanceof SiteNode) {
                        Object[] clusters = e.getChildren();
                        int i = clusters.length;
                        while (i-- > 0) {
                            if (!clusters[i].equals(SystemRootNode.getInstance().getCurrentClusterNode())) continue;
                            SrMainTreePanel.this.select((SrTreeNode)SystemRootNode.getInstance().findNodeInSubTree(ClusterNode.class));
                            break;
                        }
                    }
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
    }

    @Override
    protected SrTree getTreeInstance(SrTreeModel model) {
        return new SrMainTree(model);
    }

    private void createTree() {
        this.getTreeObject().setShowsRootHandles(false);
        MainTreeCellRenderer mainTreeCellRenderer = new MainTreeCellRenderer();
        this.getTreeObject().setCellRenderer(mainTreeCellRenderer);
        MainTreeCellEditor mainTreeCellEditor = new MainTreeCellEditor(this.getTreeObject(), mainTreeCellRenderer);
        this.getTreeObject().setCellEditor(mainTreeCellEditor);
        this.setTreeSelection(1);
        this.getTreeObject().setRootVisible(this.rootVisible);
        this.expandTree();
    }

    @Override
    protected void onTreeSelectionEvent(TreeSelectionEvent event) {
        super.onTreeSelectionEvent(event);
        SrTreeNode node = (SrTreeNode)this.getTreeObject().getLastSelectedPathComponent();
        if (node == null) {
            node = SystemRootNode.getInstance();
        }
        ClusterNode currentlySelectedClusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
        ClusterNode previousSelectedClusterNode = SystemRootNode.getInstance().setCurrentClusterNode(node);
        MainTreeEvent cte = new MainTreeEvent(this);
        boolean hasVswitches = ((SrMainTreeModel)this.getTreeModel()).hasVSwitch();
        cte.setHasVswitches(hasVswitches);
        cte.setSelectedNode(node);
        this.getTreeObject().setEditable(node instanceof ClusterNode || node instanceof SiteNode && node != SystemRootNode.getInstance());
        if (currentlySelectedClusterNode != previousSelectedClusterNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.newClusterHasBeenSelectedInformer);
        }
        if (node instanceof SystemRootNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showRootViewInformer);
        } else if (node instanceof ClusterNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showClusterViewInformer);
        } else if (node instanceof SiteNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showSiteViewInformer);
        } else if (node instanceof ExposedVolumesRootNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showExposedVolumesViewInformer);
        } else if (node instanceof UnExposedVolumeRootNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showUnExposedVolumesViewInformer);
        } else if (node instanceof TargetNode) {
            cte.setTargetNode((TargetNode)node);
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showTargetViewInformer);
        } else if (node instanceof StorageNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showStorageViewInformer);
        } else if (node instanceof UnmanagedRaidNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showStorageViewInformer);
        } else if (node instanceof ManagedRaidNode) {
            switch (((RaidNode)node).getType()) {
                case GENERAL_MANAGED_RAID: {
                    this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showStorageViewInformer);
                    break;
                }
                case NEXSAN_MANAGED_RAID: {
                    String osName = System.getProperty("os.name");
                    if (osName == null || !osName.toLowerCase().contains("windows")) {
                        this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showStorageViewInformer);
                        break;
                    }
                    this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showNexsanMgmtViewInformer);
                }
            }
        } else if (node instanceof IdentitiesNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showIdentitiesViewInformer);
        } else if (node instanceof VSwitchNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showVSwitchViewInformer);
        } else if (node instanceof DRRootTreeNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showPairDetailsViewInformer);
        } else if (node instanceof ConsistencyGroupRootNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showConsistencyGroupsViewInformer);
        } else if (node instanceof DRJournalRootNode) {
            this.m_listeners.fireEvent(MainTreeListener.class, cte, this.showJournalsViewInformer);
        }
    }

    private void showSANPopup(int x, int y) {
        this.sanPopup.show(this.getTreeObject(), x, y);
    }

    private void showClusterPopup(ClusterNode clusterNode, int x, int y) {
        this.clusterPopup.buildMoveSubMenu();
        this.clusterPopup.show(this.getTreeObject(), x, y);
    }

    private void showExposedVolumesPopup(int x, int y) {
        this.exposedVolumesPopup.show(this.getTreeObject(), x, y);
    }

    private void showTargetPopup(int x, int y) {
        if (this.targetPopup == null) {
            this.targetPopup = new TargetPopupMenu(this);
        }
        this.targetPopup.show(this.getTreeObject(), x, y);
    }

    private void showVSwitchPopup(int x, int y) {
        VSwitchNode vSwitch = (VSwitchNode)this.getTreeObject().getLastSelectedPathComponent();
        if (!((ClusterNode)vSwitch.getParent()).isInDiscoveryProcess()) {
            theLogger.trace(SrLogCategories.LEGACY, "MainTree: according to AlarmsManager, ", ClientLoader.VSWITCH_DISPLAY_STRING, " is connected - ", vSwitch.isConnected());
        }
        this.vSwitchPopup.show(this.getTreeObject(), x, y);
    }

    private void showIdentitiesPopup(int x, int y) {
        this.identitiesPopup.show(this.getTreeObject(), x, y);
    }

    public void clear(ClusterNode clusterNode) {
        ((SrMainTreeModel)this.getTreeModel()).clear(clusterNode);
        this.closeClusterDialogs(clusterNode);
        VSwitchNode[] vswitches = clusterNode.getVSwitches();
        if (vswitches != null) {
            int i = vswitches.length;
            while (i-- > 0) {
                this.closeVSwitchDialogs(vswitches[i]);
            }
        }
    }

    public void clear() {
        Enumeration<ClusterNode> e = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            ((SrMainTreeModel)this.getTreeModel()).clear(clusterNode);
        }
        this.revalidate();
    }

    public void closeAllDialogs() {
        Vector<ClusterNode> clusterNodes = SystemRootNode.getInstance().getClusterNodes();
        for (int index1 = 0; index1 < clusterNodes.size(); ++index1) {
            ClusterNode clusterNode = clusterNodes.elementAt(index1);
            this.closeClusterDialogs(clusterNode);
        }
    }

    public void popUpAttachRaidDialog(ClusterNode aCluster) {
        final ClusterNode curCluster = aCluster;
        if (RaidManager.getInstance().getRaids(aCluster).isEmpty()) {
            return;
        }
        curCluster.setAttachedRaidDlgPopUpEnableFlag(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttachRaidDialog.showDialog(ClientLoader.getMainFrame(), curCluster);
            }
        });
    }

    public void closeClusterDialogs(ClusterNode clusterNode) {
        Window[] clusterDialogs = clusterNode.removeAllDialogs();
        int i = clusterDialogs.length;
        while (i-- > 0) {
            this.closeDialog(clusterDialogs[i]);
        }
        this.closeISCSISessionsShowDialog(clusterNode);
        this.closeISCSISessionsStatisticsDialog(clusterNode);
        this.closeISCSIConnectionsShowDialog(clusterNode);
        this.closeISCSIRemoteInitiatorsShowDialog(clusterNode);
        this.closeISCSIRemoteInitiatorsStatisticsDialog(clusterNode);
        this.closeISCSIRemoteTargetsDialog(clusterNode);
        this.closeISCSIRemoteDiscoveryPortalsDialog(clusterNode);
        List<VSwitchNode> vswitches = clusterNode.getClusterVSwitches();
        for (VSwitchNode vswitchNode : vswitches) {
            this.closeVSwitchDialogs(vswitchNode);
        }
        VolumeRootNode volumeRootNode = clusterNode.getExposedVolumesNode();
        Enumeration<TreeNode> volumeRootChildren = volumeRootNode.children();
        while (volumeRootChildren.hasMoreElements()) {
            TreeNode child = volumeRootChildren.nextElement();
            if (!(child instanceof TargetNode)) continue;
            TargetNode targetNode = (TargetNode)child;
            this.closeTargetDialogs(targetNode);
        }
    }

    private void closeVSwitchDialogs(VSwitchNode node) {
        Window[] dialogs = node.removeAllDialogs();
        int i = dialogs.length;
        while (i-- > 0) {
            this.closeDialog(dialogs[i]);
        }
        this.closeDialog(node, VSwitchPropertiesDialog.class);
        this.closeDialog(node, VSwitchHardwareDataDialog.class);
        this.closeDialog(node.getInterfacesStatisticsGroupNode(), InterfacesStatisticsDialog.class);
        this.closeDialog(node.getInterfacesStatisticsGroupNode(), InterfacesStatisticsDialog.class);
        if (node.isConnected()) {
            this.closeDialog(node.getIPStatistics(), IPStatisticsDialog.class);
            this.closeDialog(node.getICMPStatistics(), ICMPStatisticsDialog.class);
            this.closeDialog(node.getTCPStatistics(), TCPStatisticsDialog.class);
            this.closeDialog(node.getUDPStatistics(), UDPStatisticsDialog.class);
        }
        if (node.getISCSIInstanceInfos() != null && node.getISCSIInstanceInfos().size() > 0) {
            ISCSIInstanceInfo iscsiInfo = (ISCSIInstanceInfo)node.getISCSIInstanceInfos().elementAt(0);
            this.closeDialog(iscsiInfo, ISCSIInstanceInfoDialog.class);
        }
        SrInitiatorNode[] initiatorNodes = node.getISCSIInitiators();
        for (int index = 0; index < initiatorNodes.length; ++index) {
            this.closeDialog(initiatorNodes[index], SrInitiatorPropertiesDlg.class);
            this.closeDialog(initiatorNodes[index], SrISCSIInitiatorPortsShowDialog.class);
        }
        this.closeISCSISessionsShowDialog(node);
        this.closeISCSISessionsStatisticsDialog(node);
        this.closeISCSIConnectionsShowDialog(node);
        this.closeISCSIRemoteInitiatorsShowDialog(node);
        this.closeISCSIRemoteInitiatorsStatisticsDialog(node);
        this.closeISCSIRemoteTargetsDialog(node);
        this.closeISCSIRemoteDiscoveryPortalsDialog(node);
    }

    private void closeTargetDialogs(TargetNode node) {
        Window[] dialogs = node.removeAllDialogs();
        int i = dialogs.length;
        while (i-- > 0) {
            this.closeDialog(dialogs[i]);
        }
        this.closeISCSISessionsShowDialog(node);
        this.closeISCSISessionsStatisticsDialog(node);
        this.closeISCSIConnectionsShowDialog(node);
        this.closeISCSIRemoteInitiatorsShowDialog(node);
        this.closeISCSIRemoteInitiatorsStatisticsDialog(node);
        this.closeSCSITargetPortsStatisticsDialog(node);
    }

    private void closeDialog(SrTreeNode node, Class key) {
        if (node == null) {
            return;
        }
        Window dlg = node.removeDialog(key);
        this.closeDialog(dlg);
    }

    private void closeDialog(Window d) {
        if (d instanceof OKCancelDialog) {
            ((OKCancelDialog)d).doOnCancel();
            ((OKCancelDialog)d).dispose();
        } else if (d instanceof OKCancelFrame) {
            ((OKCancelFrame)d).doOnCancel();
            ((OKCancelFrame)d).dispose();
        } else if (d != null) {
            d.dispose();
        }
    }

    private void closeISCSISessionsShowDialog(SrTreeNode node) {
        this.closeDialog(node, ISCSISessionsShowDialog.class);
    }

    private void closeISCSISessionsStatisticsDialog(SrTreeNode node) {
        this.closeDialog(node, ISCSISessionsStatisticsDialog.class);
    }

    private void closeISCSIConnectionsShowDialog(SrTreeNode node) {
        this.closeDialog(node, ISCSIConnectionsShowDialog.class);
    }

    private void closeISCSIRemoteInitiatorsShowDialog(SrTreeNode node) {
        this.closeDialog(node, ISCSIRemoteInitiatorsShowDialog.class);
    }

    private void closeISCSIRemoteInitiatorsStatisticsDialog(SrTreeNode node) {
        this.closeDialog(node, ISCSIRemoteInitiatorsStatisticsDialog.class);
    }

    private void closeISCSIRemoteTargetsDialog(SrTreeNode node) {
        this.closeDialog(node, SrISCSIRemoteTargetsShowDialog.class);
    }

    private void closeISCSIRemoteDiscoveryPortalsDialog(SrTreeNode node) {
        this.closeDialog(node, SrISCSIRemoteDiscoveryPortalsShowDialog.class);
    }

    private void closeSCSITargetPortsStatisticsDialog(SrTreeNode node) {
        this.closeDialog(node, SCSITargetPortsStatisticsDialog.class);
    }

    public void addMainTreeListener(MainTreeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeMainTreeListener(MainTreeListener listener) {
        this.m_listeners.remove(listener);
    }

    private void refreshView() {
        this.revalidate();
        this.repaint();
        this.getTreeObject().setRootVisible(this.rootVisible);
    }

    public void refreshClusterView(ClusterNode clusterNode) {
        boolean isCurrentCluster = clusterNode.isCurrentCluster();
        ((SrMainTreeModel)this.getTreeModel()).refreshCluster(clusterNode);
        if (isCurrentCluster) {
            this.getTreeObject().setSelectionPath(clusterNode.getTreePath());
            this.expandTree();
        }
    }

    private void openRadiusDialog(ClusterNode cluster) {
        RadiusServersDialog d = (RadiusServersDialog)cluster.getDialog(RadiusServersDialog.class);
        if (d != null) {
            d.requestFocus();
        } else {
            d = new RadiusServersDialog(this.myOwner, cluster);
            cluster.addDialog(d);
            d.show();
        }
    }

    private void openISNSDialog(ClusterNode cluster) {
        ISNSServersDialog d = (ISNSServersDialog)cluster.getDialog(ISNSServersDialog.class);
        if (d != null) {
            d.requestFocus();
        } else {
            d = new ISNSServersDialog(this.myOwner, cluster);
            cluster.addDialog(d);
            d.show();
        }
    }

    public static String regularVSwitchTest(VSwitchNode vSwitch) {
        return SrMainTreePanel.regularVSwitchTest(vSwitch, true);
    }

    public static String regularVSwitchTest(VSwitchNode vSwitch, boolean shouldBeConnected) {
        if (shouldBeConnected && !vSwitch.isConnected()) {
            return "The " + ClientLoader.VSWITCH_DISPLAY_STRING + " is disconnected";
        }
        return ((ClusterNode)vSwitch.getParent()).getInDiscoveryTooltip();
    }

    @Override
    public void neighborSelected(AlarmSourceSelectionEvent e) {
        Neighbor neighbor = (Neighbor)e.getNode();
        VSwitchNode vswitchNode = neighbor.getVSWitchParent();
        Vector<VSwitchNode> others = ((SrMainTreeModel)this.getTreeModel()).getOtherVSwitches(vswitchNode);
        if (others != null && !others.isEmpty()) {
            this.select(others.get(0));
        } else {
            this.select(vswitchNode);
        }
    }

    @Override
    public void directAccessDeviceSelected(AlarmSourceSelectionEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(e.getNode());
        StorageNode storageNode = ((SrMainTreeModel)this.getTreeModel()).getStorageNode(clusterNode);
        this.select(storageNode);
    }

    @Override
    public void subDirectAccessDeviceSelected(AlarmSourceSelectionEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(e.getNode());
        StorageNode storageNode = ((SrMainTreeModel)this.getTreeModel()).getStorageNode(clusterNode);
        this.select(storageNode);
    }

    @Override
    public void siteSelected(AlarmSourceSelectionEvent e) {
        SiteNode node = (SiteNode)e.getNode();
        this.select(node);
    }

    @Override
    public void clusterSelected(AlarmSourceSelectionEvent e) {
        ClusterNode node = (ClusterNode)e.getNode();
        this.select(node);
    }

    @Override
    public void vswitchSelected(AlarmSourceSelectionEvent e) {
        VSwitchNode node = (VSwitchNode)e.getNode();
        this.select(node);
    }

    @Override
    public void targetSelected(AlarmSourceSelectionEvent e) {
        TargetNode node = (TargetNode)e.getNode();
        this.select(node);
    }

    @Override
    public void remoteTargetSelected(AlarmSourceSelectionEvent e) {
        SrISCSIRemoteTargetNode node = (SrISCSIRemoteTargetNode)e.getNode();
        AlarmNode selectedAlarm = e.getSelectedAlarm();
        VSwitchNode vswitch = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(selectedAlarm.getVSwitch());
        Set<VSwitchNode> arg = Collections.singleton(vswitch);
        try {
            SrISCSIRemoteTargetsShowDialog dialog = (SrISCSIRemoteTargetsShowDialog)this.iscsiRemoteTargetsShowAction.derivedActionPerformed(arg).iterator().next().get();
            dialog.getRemoteTargetsTablePanel().selectRemoteTarget(node);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void luSelected(AlarmSourceSelectionEvent e) {
        LUNode luNode = (LUNode)e.getNode();
        TargetNode targetNode = luNode.getTargetParent();
        this.select(targetNode);
    }

    @Override
    public void identitySelected(AlarmSourceSelectionEvent e) {
        this.select(((SrMainTreeModel)this.getTreeModel()).getIdentitiesNode());
    }

    @Override
    public void externalServerSelected(AlarmSourceSelectionEvent e) {
        ExternalServerNode serverNode = (ExternalServerNode)e.getNode();
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(serverNode);
        this.select(cluster);
        if (serverNode instanceof RadiusServerNode) {
            this.openRadiusDialog(cluster);
        } else {
            this.openISNSDialog(cluster);
        }
    }

    @Override
    public void volumeSelected(AlarmSourceSelectionEvent e) {
        VolumeTreeNode volumeNode = (VolumeTreeNode)e.getNode();
        if (volumeNode.isExposed()) {
            LUNode luNode;
            while (volumeNode.getParent() instanceof VolumeTreeNode) {
                volumeNode = (VolumeTreeNode)volumeNode.getParent();
            }
            LUNode lu = luNode = volumeNode.getLUNode();
            TargetNode node = lu.getTargetParent();
            this.select(node);
        } else {
            ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(volumeNode);
            this.select(cluster.getUnExposedVolumesNode());
        }
    }

    @Override
    public void drPairSelected(AlarmSourceSelectionEvent e) {
        DRPairNode pairNode = (DRPairNode)e.getNode();
        ((MainFrame)this.myOwner).showPairDetailsView(null);
        ((MainFrame)this.myOwner).selectPairInPairDetailsView(pairNode);
    }

    @Override
    public void extendedPairSelected(AlarmSourceSelectionEvent e) {
        ExtendedPairNode epNode = (ExtendedPairNode)e.getNode();
        ((MainFrame)this.myOwner).showPairDetailsView(null);
        ((MainFrame)this.myOwner).selectExtendedPairInPairDetailsView(epNode);
    }

    @Override
    public void consistencyGroupSelected(AlarmSourceSelectionEvent e) {
        ConsistencyGroupNode cpNode = (ConsistencyGroupNode)e.getNode();
        ((MainFrame)this.myOwner).showConsistencyGroupsView(null);
        ((MainFrame)this.myOwner).selectConsistencyGroupInConsistencyGroupsView(cpNode);
    }

    void select(SrTreeNode node) {
        Object[] path = ((SrMainTreeModel)this.getTreeModel()).getPathToRoot(node);
        if (path != null) {
            this.getTreeObject().setSelectionPath(new TreePath(path));
        }
    }

    private ClusterNode getTreeSelectionClusterNode() {
        return (ClusterNode)((SrTreeNode)this.getSelectedNode()).getAncestorOfType(ClusterNode.class);
    }

    public JFrame getOwner() {
        return this.myOwner;
    }

    @Override
    protected void mouseReleasedOutOfRange() {
    }

    class MainTreeCellEditor
    extends DefaultTreeCellEditor {
        public MainTreeCellEditor(JTree tree, DefaultTreeCellRenderer rend) {
            super(tree, rend);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            String strValue = value.toString();
            this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            return super.getTreeCellEditorComponent(tree, strValue, isSelected, expanded, leaf, row);
        }
    }

    class PopupTrigger
    extends MouseAdapter {
        PopupTrigger() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                TreePath selectedTreePath = SrMainTreePanel.this.getTreeObject().getClosestPathForLocation(e.getX(), e.getY());
                SrMainTreePanel.this.getTreeObject().setSelectionPath(selectedTreePath);
                SrTreeNode node = (SrTreeNode)SrMainTreePanel.this.getTreeObject().getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node instanceof SystemRootNode) {
                    SrMainTreePanel.this.showSANPopup(e.getX(), e.getY());
                } else if (node instanceof SiteNode) {
                    SrMainTreePanel.this.m_sitePopup.show(e);
                } else {
                    ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(node);
                    if (clusterNode == null || clusterNode.isInDiscoveryProcess()) {
                        // empty if block
                    }
                    if (node instanceof ClusterNode) {
                        SrMainTreePanel.this.showClusterPopup((ClusterNode)node, e.getX(), e.getY());
                    } else if (node instanceof ExposedVolumesRootNode) {
                        SrMainTreePanel.this.showExposedVolumesPopup(e.getX(), e.getY());
                    } else if (!(node instanceof UnExposedVolumeRootNode)) {
                        if (node instanceof TargetNode) {
                            SrMainTreePanel.this.showTargetPopup(e.getX(), e.getY());
                        } else if (node instanceof VSwitchNode) {
                            SrMainTreePanel.this.showVSwitchPopup(e.getX(), e.getY());
                        } else if (node instanceof IdentitiesNode) {
                            SrMainTreePanel.this.showIdentitiesPopup(e.getX(), e.getY());
                        } else if (node instanceof StorageNode) {
                            SrMainTreePanel.this.storageTreePopup.show(e);
                        } else if (node instanceof RaidNode) {
                            SrMainTreePanel.this.myNexsanMgmtPopup.show(e);
                        } else if (node instanceof DRJournalRootNode) {
                            SrMainTreePanel.this.myJournalPopup.show(e);
                        } else if (!(node instanceof ConsistencyGroupRootNode)) {
                            if (node instanceof DRRootTreeNode) {
                                SrMainTreePanel.this.m_drPopup.show(e);
                            } else {
                                theLogger.trace(SrLogCategories.LEGACY, "Undefined node ", node, " was selected");
                            }
                        }
                    }
                }
            }
        }
    }

    public class NewSiteAction
    extends SrClientAction<Void, Void> {
        public NewSiteAction() {
            super(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CREATE_NEW_SITE_POPUP_LABEL), ClientImageObject.SITE_NODE.getImageIcon(), true, false, null, SrLicenseTreePath.GDR_PATH, false, false);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            new NewSiteDialog(SrMainTreePanel.this.myOwner, SystemRootNode.getInstance());
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.NewSiteAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    public static class NewClusterAction
    extends SrClientAction<SiteNode, Void> {
        private JFrame myOwner;

        public NewClusterAction(View<SiteNode> view, JFrame owner) {
            super(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NEW_CLUSTER_LBL), ClientImageObject.CLUSTER.getImageIcon(), true, true, view, SrLicenseTreePath.GENERAL_PATH, true, false);
            this.myOwner = owner;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<SiteNode> arg) {
            SiteNode siteNode = arg.iterator().next();
            new NewClusterDialog(this.myOwner, siteNode);
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.NewClusterAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    public static class NewVswitchAction
    extends SrClientAction<VSwitchGroupNode, Void> {
        private boolean myIsSingleVswitch;
        private boolean myIsSiteVswitch;
        private boolean myAlwaysAllowAction;

        private static String getNewVSwitchActionName(boolean isSingleVswitch, boolean isSiteVswitch) {
            if (isSiteVswitch) {
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_SITE_POPUP_MENU_NEW_VSWITCH_LBL);
            }
            if (isSingleVswitch) {
                return ClientLoader.VSWITCH_DISPLAY_STRING + "...";
            }
            return "Neighbor " + ClientLoader.VSWITCH_DISPLAY_STRING + "...";
        }

        public NewVswitchAction(SrMainTreePanel treePanel, boolean isSingleVswitch, boolean isSiteVswitch) {
            super(NewVswitchAction.getNewVSwitchActionName(isSingleVswitch, isSiteVswitch), ClientImageObject.VSWITCH.getImageIcon(), true, true, new TreeView<VSwitchGroupNode>(treePanel.getTreeObject(), VSwitchGroupNode.class), SrLicenseTreePath.GENERAL_PATH, true, false);
            this.myIsSingleVswitch = isSingleVswitch;
            this.myIsSiteVswitch = isSiteVswitch;
        }

        public NewVswitchAction(View<VSwitchGroupNode> view) {
            super(NewVswitchAction.getNewVSwitchActionName(true, true), ClientImageObject.VSWITCH.getImageIcon(), true, true, view, SrLicenseTreePath.GENERAL_PATH, true, false);
            this.myAlwaysAllowAction = true;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchGroupNode> arg) {
            new NewVSwitchDialog((JFrame)ClientLoader.getMainFrame(), arg.iterator().next(), this.myIsSingleVswitch, this.myIsSiteVswitch);
            return Collections.singleton(new CompleteFuture("SrMainTreePanel.NewVswitchAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (this.myAlwaysAllowAction) {
                return null;
            }
            VSwitchGroupNode groupNode = (VSwitchGroupNode)this.myView.getValue().iterator().next();
            if (!(groupNode instanceof ClusterNode)) {
                return null;
            }
            ClusterNode cluster = (ClusterNode)groupNode;
            int numberOfVswitches = SrMainTreeModel.getInstance().getNumberOfVswitches(cluster);
            if (numberOfVswitches >= 2) {
                return CLUSTERS_WITH_MORE_THAN_2_V_SWITCHES_ARE_NOT_SUPPORTED;
            }
            if (numberOfVswitches == 1 && !cluster.getVSwitches()[0].isConnected()) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_DISCONNECTED_ADD_NEIGHBOR);
            }
            if (this.myIsSingleVswitch) {
                if (numberOfVswitches > 0) {
                    return "At least one " + ClientLoader.VSWITCH_DISPLAY_STRING + " already exists in the group";
                }
            } else if (numberOfVswitches == 0) {
                return "No " + ClientLoader.VSWITCH_DISPLAY_STRING + " exists in the group";
            }
            return cluster.getInDiscoveryTooltip();
        }
    }
}

