/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.SrExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.SrVolumeTreeModel;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrVolumeTreePanel;
import com.sanrad.nms.client.gui.actions.VolumeLUView;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import com.sanrad.nms.client.gui.actions.delete.UnexposeAction;
import com.sanrad.nms.client.gui.volume.SrExposedVolumeTreePopupMenu;
import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrTreeExpandSelectionRestorer;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.tree.SrRootTreeNode;
import com.sanrad.swing.tree.event.TreeNodeEvent;
import com.sanrad.swing.tree.event.TreeNodeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrExposedVolumeTreePanel
extends SrVolumeTreePanel
implements TreeModelListener {
    private static final SrLogger theLogger = SrLogger.getLogger();
    RootNodeListener m_rootNodeListener = new RootNodeListener();
    private VolumeLUView myLuNodeView;
    private DeleteAction myDeleteAction;

    public SrExposedVolumeTreePanel(SrExposedVolumeTreeModel model, JFrame owner) {
        super(model, owner);
        SrRootTreeNode rootNode = (SrRootTreeNode)model.getRoot();
        rootNode.addTreeNodeListener(this.m_rootNodeListener);
    }

    @Override
    protected SrPopupMenu getPopupObject() {
        return new SrExposedVolumeTreePopupMenu(this);
    }

    public void inProccess(String message) {
        StatusPanel.getInstance().setLevel(StatusPanel.NO_INFO);
    }

    @Override
    public DeleteAction getDeleteAction() {
        theLogger.logAndAssert(SrLogCategories.ERROR, this.m_tree != null, new Object[]{""});
        if (this.myDeleteAction == null) {
            this.myLuNodeView = new VolumeLUView<VolumeTreeNode>((View<VolumeTreeNode>)new TreeView<VolumeTreeNode>(this.m_tree, VolumeTreeNode.class));
            this.myDeleteAction = new UnexposeAction((View)this.myLuNodeView, StatusPanel.getInstance()){

                @Override
                protected String getContextMismatchTooltip() {
                    String luViewTooltip = SrExposedVolumeTreePanel.this.myLuNodeView.getContextMismatchTooltip();
                    if (luViewTooltip == null) {
                        return super.getContextMismatchTooltip();
                    }
                    return luViewTooltip;
                }
            };
        }
        return this.myDeleteAction;
    }

    @Override
    public void newClusterHasBeenSelected() {
    }

    public void updateTree(VolumeTreeNode[] selectedVolumes) {
        SrVolumeTreeModel treeModel = (SrVolumeTreeModel)this.getTreeModel();
        ArrayList<TreeNode> childrenList = new ArrayList<TreeNode>();
        SrRootTreeNode rootNode = (SrRootTreeNode)treeModel.getRoot();
        SrTreeExpandSelectionRestorer restorer = null;
        if (selectedVolumes.length != 0) {
            restorer = new SrTreeExpandSelectionRestorer(this.getTreeObject());
            restorer.save();
        }
        rootNode.removeTreeNodeListener(this.m_rootNodeListener);
        Enumeration<TreeNode> e = rootNode.children();
        while (e.hasMoreElements()) {
            childrenList.add(e.nextElement());
        }
        int i = childrenList.size();
        while (i-- > 0) {
            treeModel.removeNodeFromParent((SrTreeNode)childrenList.get(i));
        }
        for (i = 0; i < selectedVolumes.length; ++i) {
            if (!selectedVolumes[i].isExposed()) continue;
            treeModel.insertVolumeNodeToModel(selectedVolumes[i], rootNode);
        }
        this.getTreeObject().expandPath(new TreePath(treeModel.getPathToRoot(rootNode)));
        this.expandTree();
        rootNode.addTreeNodeListener(this.m_rootNodeListener);
        if (restorer != null) {
            restorer.restore();
        }
    }

    private class RootNodeListener
    implements TreeNodeListener {
        private RootNodeListener() {
        }

        @Override
        public void treeNodeRemoving(TreeNodeEvent e) {
        }

        @Override
        public void treeNodeRemoved(TreeNodeEvent e) {
            SrExposedVolumeTreePanel.this.getTreeModel().nodeStructureChanged((TreeNode)SrExposedVolumeTreePanel.this.getTreeModel().getRoot());
        }

        @Override
        public void treeNodeInserted(TreeNodeEvent e) {
        }
    }
}

