/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.gui.SrClientPopupMenu;
import com.sanrad.nms.client.gui.actions.AlarmAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.SynchronizeElementAction;
import com.sanrad.nms.client.gui.actions.delete.DeleteAction;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class SrDefaultPopupMenu
extends SrClientPopupMenu {
    private static SrLogger theLogger = SrLogger.getLogger();
    public static final String PROPAGATED = "Propagated...";
    public static final String SPECIFIC = "Specific...";
    public static final String PROPERTIES = "Properties...";
    public static final String ALARMS = "Alarms";
    protected Vector m_alarmActionVector;

    protected static SrClientAction asProperties(SrClientAction propertiesAct) {
        propertiesAct.setName(PROPERTIES);
        return propertiesAct;
    }

    protected SrDefaultPopupMenu(JComponent workWith) {
        super(workWith);
    }

    protected abstract SynchronizeElementAction getSynchronizeAction();

    public abstract DeleteAction getDeleteAction();

    protected final Vector getAlarmsMenu() {
        AlarmAction specificAlarmsAction;
        this.m_alarmActionVector = new Vector(3);
        this.m_alarmActionVector.add(ALARMS);
        AlarmAction propagatedAlarmsAction = this.getPropagatedAlarmsAction();
        if (propagatedAlarmsAction != null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, !propagatedAlarmsAction.isSpecific(), new Object[]{"Propagated action is specific", this.getClass()});
            propagatedAlarmsAction.setName(PROPAGATED);
            this.m_alarmActionVector.add(propagatedAlarmsAction);
        }
        if ((specificAlarmsAction = this.getSpecificAlarmsAction()) != null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, specificAlarmsAction.isSpecific(), new Object[]{"Specific action is not specific", this.getClass()});
            specificAlarmsAction.setName(SPECIFIC);
            this.m_alarmActionVector.add(specificAlarmsAction);
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, propagatedAlarmsAction != null || specificAlarmsAction != null, new Object[]{"Propagated alarms action is not supported by menu" + this.getClass()});
        return this.m_alarmActionVector;
    }

    public abstract AlarmAction getSpecificAlarmsAction();

    public abstract AlarmAction getPropagatedAlarmsAction();
}

