/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.SrClientPopupMenu;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.SrTreePanel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrClientTreePanel
extends SrTreePanel {
    ClientTreeSelectionModel selectionModel = new ClientTreeSelectionModel();
    TreeKeyListener keyListener = new TreeKeyListener();

    public SrClientTreePanel(DefaultMutableTreeNode root) {
        super(root);
        this.init();
    }

    public SrClientTreePanel(SrTreeModel model) {
        super(model);
        this.init();
    }

    private void init() {
        this.getTreeObject().setSelectionModel(this.selectionModel);
        this.getTreeObject().addKeyListener(this.keyListener);
    }

    protected ClusterNode getClusterNode() {
        return SystemRootNode.getInstance().getCurrentClusterNode();
    }

    @Override
    protected void showPopupMenu(MouseEvent e) {
        if (this.m_popup instanceof SrClientPopupMenu) {
            ((SrClientPopupMenu)this.m_popup).show(e, this.getClusterNode());
        } else {
            super.showPopupMenu(e);
        }
    }

    private class TreeKeyListener
    implements KeyListener {
        private TreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath nextPath;
            int lastSelect;
            if (e.getKeyCode() == 40) {
                TreePath nextPath2;
                int rowCount = SrClientTreePanel.this.getTreeObject().getRowCount();
                final int lastSelect2 = SrClientTreePanel.this.getTreeObject().getRowForPath(SrClientTreePanel.this.selectionModel.lastSelection);
                if (lastSelect2 + 2 < rowCount && !SrClientTreePanel.this.selectionModel.isPathEnabled(nextPath2 = SrClientTreePanel.this.getTreeObject().getPathForRow(lastSelect2 + 1))) {
                    EventDispatcherTask.submit(new Runnable(){

                        @Override
                        public void run() {
                            SrClientTreePanel.this.getTreeObject().setSelectionRow(lastSelect2 + 2);
                        }
                    });
                }
            } else if (e.getKeyCode() == 38 && (lastSelect = SrClientTreePanel.this.getTreeObject().getRowForPath(SrClientTreePanel.this.selectionModel.lastSelection)) - 2 >= 0 && !SrClientTreePanel.this.selectionModel.isPathEnabled(nextPath = SrClientTreePanel.this.getTreeObject().getPathForRow(lastSelect - 1))) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SrClientTreePanel.this.getTreeObject().setSelectionRow(lastSelect - 2);
                    }
                });
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class ClientTreeSelectionModel
    extends DefaultTreeSelectionModel {
        TreePath lastSelection;

        private ClientTreeSelectionModel() {
        }

        @Override
        public void clearSelection() {
            super.clearSelection();
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            if (paths != null) {
                ArrayList<TreePath> validPathList = new ArrayList<TreePath>();
                for (int i = 0; i < paths.length; ++i) {
                    if (!this.isPathEnabled(paths[i])) continue;
                    validPathList.add(paths[i]);
                }
                if (!validPathList.isEmpty()) {
                    TreePath[] validPaths = validPathList.toArray(new TreePath[validPathList.size()]);
                    this.lastSelection = validPaths[validPaths.length - 1];
                    super.addSelectionPaths(validPaths);
                }
            }
        }

        @Override
        public void setSelectionPaths(TreePath[] pPaths) {
            if (pPaths != null) {
                ArrayList<TreePath> validPathList = new ArrayList<TreePath>();
                for (int i = 0; i < pPaths.length; ++i) {
                    if (!this.isPathEnabled(pPaths[i])) continue;
                    validPathList.add(pPaths[i]);
                }
                if (!validPathList.isEmpty()) {
                    TreePath[] validPaths = validPathList.toArray(new TreePath[validPathList.size()]);
                    this.lastSelection = validPaths[validPaths.length - 1];
                    super.setSelectionPaths(validPaths);
                }
            }
        }

        private boolean isPathEnabled(TreePath path) {
            Object node = path.getLastPathComponent();
            return !(node instanceof SrTreeNode) || ((SrTreeNode)node).isEnabled();
        }

        private boolean isNodeInModel(TreeNode node) {
            DefaultTreeModel model = (DefaultTreeModel)SrClientTreePanel.this.getTreeObject().getModel();
            TreeNode[] pathToRoot = model.getPathToRoot(node);
            if (pathToRoot == null) {
                return false;
            }
            TreeNode firstNodeInPath = pathToRoot[0];
            if (firstNodeInPath == null) {
                return false;
            }
            Object modelRoot = model.getRoot();
            if (modelRoot == null) {
                return false;
            }
            return !firstNodeInPath.equals(node) || modelRoot.equals(node);
        }

        private void clearLastSelectionIfNeeded() {
            if (this.lastSelection != null && !this.isNodeInModel((TreeNode)this.lastSelection.getLastPathComponent())) {
                this.lastSelection = null;
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.clearLastSelectionIfNeeded();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.clearLastSelectionIfNeeded();
        }
    }
}

