/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.SrClientPopupMenu;
import com.sanrad.nms.client.gui.SrClientTableHeader;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrTableModel;
import com.sanrad.swing.SrTablePanel;
import java.awt.event.MouseEvent;

public abstract class SrClientTablePanel
extends SrTablePanel {
    public SrClientTablePanel(SrTableModel model) {
        this(model, true);
    }

    public SrClientTablePanel(SrTableModel model, boolean sort) {
        super(model, sort);
        this.checkLicensedColumns(null);
    }

    private void checkLicensedColumns(SrBITSConstant vswitchCapability) {
        Class tableHeaderClass = this.getTableHeaderClass();
        if (tableHeaderClass != null) {
            SrClientTableHeader[] headerObjects = SrClientTableHeader.getTableHeaders(tableHeaderClass);
            int i = headerObjects.length;
            while (i-- > 0) {
                boolean isVisible = LicenseManager.getInstance().isVisible(headerObjects[i].getLicensePath(), vswitchCapability);
                if (isVisible) continue;
                this.hideTableColumn(headerObjects[i].getColumnName());
            }
        }
    }

    protected abstract Class getTableHeaderClass();

    protected ClusterNode getClusterNode() {
        return SystemRootNode.getInstance().getCurrentClusterNode();
    }

    @Override
    protected void showPopupMenu(MouseEvent e) {
        SrPopupMenu popup = this.getTablePopUpMenuObject();
        if (popup instanceof SrClientPopupMenu) {
            ((SrClientPopupMenu)popup).show(e, this.getClusterNode());
        } else {
            super.showPopupMenu(e);
        }
    }
}

