/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.swing.SrPopupMenu;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.SrTreePanel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class SrClientPopupMenu
extends SrPopupMenu {
    private static final String LICENSE_BLOCK_TOOL_TIP = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.LICENSE_OPERATION_BLOCK);

    public SrClientPopupMenu(JComponent workWith) {
        super(workWith);
    }

    @Override
    public void show(MouseEvent e) {
        this.show(e, null);
    }

    public void show(MouseEvent e, ClusterNode cluster) {
        List currentActions = this.validateActions(e);
        if (currentActions != null && currentActions.size() > 0) {
            if (!this.m_lastActionSet.equals(currentActions)) {
                this.removeAllActions();
                this.addAllActions(this, currentActions);
                this.m_lastActionSet = new ArrayList();
                this.m_lastActionSet.addAll(currentActions);
            }
            this.setSeparatorsVisibility(this);
            JComponent invoker = this.m_comToWorkWith;
            if (this.m_comToWorkWith instanceof SrTreePanel) {
                invoker = ((SrTreePanel)this.m_comToWorkWith).getTreeObject();
            } else if (this.m_comToWorkWith instanceof SrTablePanel) {
                invoker = ((SrTablePanel)this.m_comToWorkWith).getTable();
            }
            if (this.hasVisibleComponents()) {
                this.show(invoker, e.getX(), e.getY());
            }
        }
    }

    private boolean hasVisibleComponents() {
        Component[] comps = this.getComponents();
        int i = comps.length;
        while (i-- > 0) {
            if (!comps[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    private void setSeparatorsVisibility(JComponent menu) {
        int i;
        boolean foundVisibleItem = false;
        Component[] comps = menu.getComponents();
        for (i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JMenuItem) {
                if (comps[i].isVisible()) {
                    foundVisibleItem = true;
                }
                if (!(comps[i] instanceof JMenu)) continue;
                this.setSeparatorsVisibility(((JMenu)comps[i]).getPopupMenu());
                continue;
            }
            if (!(comps[i] instanceof JPopupMenu.Separator)) continue;
            comps[i].setVisible(foundVisibleItem);
            foundVisibleItem = false;
        }
        foundVisibleItem = false;
        i = comps.length;
        while (i-- > 0) {
            if (comps[i] instanceof JMenuItem) {
                if (!comps[i].isVisible()) continue;
                foundVisibleItem = true;
                continue;
            }
            if (!(comps[i] instanceof JPopupMenu.Separator)) continue;
            comps[i].setVisible(foundVisibleItem);
            break;
        }
    }
}

