/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.swing.SrTree;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrLabelField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SrCheckBoxTreePanel
extends JPanel {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private SrTree myTree;
    private TreeNodeRendererProperties myRendererProperties;
    private Set<NodeCheckListener> myNodeChangeListeners = new HashSet<NodeCheckListener>();

    public SrCheckBoxTreePanel(TreeNodeRendererProperties aProp) {
        super(new BorderLayout());
        this.myRendererProperties = aProp;
        this.myTree = new SrTree(new CheckBoxTreeModel());
        this.myTree.setCellRenderer(new CheckBoxTreeRenderer(this.myRendererProperties));
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setInvokesStopCellEditing(true);
        this.myTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = SrCheckBoxTreePanel.this.myTree.getRowForLocation(e.getX(), e.getY());
                TreePath path = SrCheckBoxTreePanel.this.myTree.getPathForRow(row);
                if (path != null) {
                    CheckNode node = (CheckNode)path.getLastPathComponent();
                    if (SrCheckBoxTreePanel.this.myRendererProperties == null || SrCheckBoxTreePanel.this.myRendererProperties.getDisabledTooltip(node.getTreeNode()) == null) {
                        SrCheckBoxTreePanel.this.toggleNodeState(node);
                    }
                } else {
                    SrCheckBoxTreePanel.this.myTree.clearSelection();
                }
            }
        });
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] paths;
                if (e.getKeyCode() == 32 && (paths = SrCheckBoxTreePanel.this.myTree.getSelectionPaths()) != null && paths.length == 1) {
                    CheckNode node = (CheckNode)paths[0].getLastPathComponent();
                    if (SrCheckBoxTreePanel.this.myRendererProperties == null || SrCheckBoxTreePanel.this.myRendererProperties.getDisabledTooltip(node.getTreeNode()) == null) {
                        SrCheckBoxTreePanel.this.toggleNodeState(node);
                    }
                }
            }
        });
        JScrollPane treeScroll = new JScrollPane(this.myTree);
        this.add((Component)treeScroll, "Center");
    }

    public void addNodeCheckListener(NodeCheckListener aListener) {
        this.myNodeChangeListeners.add(aListener);
    }

    public void removeNodeCheckListener(NodeCheckListener aListener) {
        this.myNodeChangeListeners.remove(aListener);
    }

    private void toggleNodeState(CheckNode aNode) {
        boolean newSelectedValue = !aNode.isSelected();
        aNode.setSelected(newSelectedValue);
        this.getTreeModel().nodeChanged(aNode);
        if (newSelectedValue) {
            this.fireNodeChecked(aNode.getTreeNode());
        } else {
            this.fireNodeUnChecked(aNode.getTreeNode());
        }
    }

    private void fireNodeChecked(MutableTreeNode aNode) {
        for (NodeCheckListener listener : new HashSet<NodeCheckListener>(this.myNodeChangeListeners)) {
            listener.treeNodeChecked(aNode);
        }
    }

    private void fireNodeUnChecked(MutableTreeNode aNode) {
        for (NodeCheckListener listener : new HashSet<NodeCheckListener>(this.myNodeChangeListeners)) {
            listener.treeNodeUnChecked(aNode);
        }
    }

    public void setNodeChecked(MutableTreeNode node, boolean checked) {
        CheckNode checkNode = ((CheckBoxTreeModel)this.getTreeModel()).findCheckNode(node);
        if (checkNode == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Request to check ", checked, " the node ", node, ": node could not be found");
            return;
        }
        if (checkNode.isSelected() != checked) {
            checkNode.setSelected(checked);
            this.getTreeModel().nodeChanged(checkNode);
        }
    }

    public List<MutableTreeNode> getCheckedNodes() {
        return ((CheckBoxTreeModel)this.getTreeModel()).getCheckedNodes();
    }

    public MutableTreeNode getParentNode(MutableTreeNode aNode) {
        CheckNode realParentNode;
        CheckNode realNode = ((CheckBoxTreeModel)this.getTreeModel()).findCheckNode(aNode);
        if (realNode != null && (realParentNode = (CheckNode)realNode.getParent()) != null) {
            return realParentNode.getTreeNode();
        }
        return null;
    }

    public List<MutableTreeNode> getChildren(MutableTreeNode aNode) {
        ArrayList<MutableTreeNode> list = new ArrayList<MutableTreeNode>();
        CheckNode realNode = ((CheckBoxTreeModel)this.getTreeModel()).findCheckNode(aNode);
        Enumeration<TreeNode> realChildren = realNode.children();
        while (realChildren.hasMoreElements()) {
            list.add(((CheckNode)realChildren.nextElement()).getTreeNode());
        }
        return list;
    }

    public SrTree getTreeObject() {
        return this.myTree;
    }

    public SrTreeModel getTreeModel() {
        return (SrTreeModel)this.myTree.getModel();
    }

    public static interface NodeCheckListener {
        public void treeNodeChecked(MutableTreeNode var1);

        public void treeNodeUnChecked(MutableTreeNode var1);
    }

    public static interface TreeNodeRendererProperties {
        public String getDisabledTooltip(MutableTreeNode var1);

        public String getTreeCellText(MutableTreeNode var1);
    }

    private static class CheckBoxTreeRenderer
    extends JPanel
    implements TreeCellRenderer {
        SrCheckbox myCheckBox = new SrCheckbox();
        SrLabelField myLabel = new SrLabelField();
        TreeNodeRendererProperties myRendererProp;

        private CheckBoxTreeRenderer(TreeNodeRendererProperties aProp) {
            super(new FlowLayout(0, 0, 0));
            this.myRendererProp = aProp;
            this.add((Component)this.myCheckBox, "West");
            this.add((Component)this.myLabel, "East");
            this.setOpaque(false);
            this.myCheckBox.setBackground(UIManager.getColor("Tree.textBackground"));
            this.myLabel.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCheckBox.setEnabled(enabled);
            this.myLabel.setEnabled(enabled);
            if (!enabled) {
                this.myLabel.setForeground(UIManager.getColor("Label.disabledShadow"));
            } else {
                this.myLabel.setForeground(UIManager.getColor("Tree.textForeground"));
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CheckNode checkNode = (CheckNode)value;
            this.myCheckBox.setSelected(checkNode.isSelected());
            if (this.myRendererProp != null) {
                this.myLabel.setText(this.myRendererProp.getTreeCellText(checkNode.getTreeNode()));
                String tooltip = this.myRendererProp.getDisabledTooltip(checkNode.getTreeNode());
                this.setToolTipText(tooltip);
                this.setEnabled(tooltip == null);
            } else {
                this.myLabel.setText(value.toString());
            }
            if (checkNode.getTreeNode() instanceof SrTreeNode) {
                ImageIcon icon = ((SrTreeNode)checkNode.getTreeNode()).getNodeIcon();
                this.myLabel.setIcon(icon);
            }
            return this;
        }
    }

    private static class CheckNode
    extends DefaultMutableTreeNode {
        private MutableTreeNode myTreeNode;
        private boolean myIsSelected;

        CheckNode(MutableTreeNode aNode) {
            this.myTreeNode = aNode;
        }

        MutableTreeNode getTreeNode() {
            return this.myTreeNode;
        }

        boolean isSelected() {
            return this.myIsSelected;
        }

        void setSelected(boolean selected) {
            this.myIsSelected = selected;
        }

        @Override
        public String toString() {
            return this.myTreeNode.toString();
        }
    }

    private class CheckBoxTreeModel
    extends SrTreeModel {
        CheckBoxTreeModel() {
            super(new CheckNode(new DefaultMutableTreeNode("Root")));
        }

        @Override
        public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
            CheckNode parentNode = this.findCheckNode(parent);
            super.insertNodeInto(new CheckNode(newChild), parentNode, index);
        }

        @Override
        public void insertOrderedByName(DefaultMutableTreeNode parent, DefaultMutableTreeNode newChild) {
            CheckNode parentNode = this.findCheckNode(parent);
            super.insertOrderedByName(parentNode, newChild);
        }

        CheckNode findCheckNode(MutableTreeNode innerNode) {
            if (innerNode instanceof CheckNode) {
                return (CheckNode)innerNode;
            }
            CheckNode root = (CheckNode)this.getRoot();
            return this.findCheckNode(root, innerNode);
        }

        private CheckNode findCheckNode(CheckNode aParent, MutableTreeNode innerNode) {
            if (aParent.getTreeNode() == innerNode) {
                return aParent;
            }
            Enumeration<TreeNode> children = aParent.children();
            while (children.hasMoreElements()) {
                CheckNode child = (CheckNode)children.nextElement();
                CheckNode node = this.findCheckNode(child, innerNode);
                if (node == null) continue;
                return node;
            }
            return null;
        }

        List<MutableTreeNode> getCheckedNodes() {
            CheckNode root = (CheckNode)this.getRoot();
            ArrayList<MutableTreeNode> list = new ArrayList<MutableTreeNode>();
            this.getCheckedNodes(root, list);
            return list;
        }

        private void getCheckedNodes(CheckNode aParent, List<MutableTreeNode> aList) {
            if (aParent.isSelected()) {
                aList.add(aParent.getTreeNode());
            }
            Enumeration<TreeNode> e = aParent.children();
            while (e.hasMoreElements()) {
                this.getCheckedNodes((CheckNode)e.nextElement(), aList);
            }
        }
    }
}

