/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.data.SystemObjectNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;

public abstract class OKCancelRefreshDialog<T extends SystemObjectNode>
extends SrOKCancelDialog<T> {
    private JButton btnRefresh;
    private Timer refreshTimer = null;
    private Timer timerCounter = null;
    int counter = -1;

    protected OKCancelRefreshDialog(JFrame owner, String title) {
        this(owner, title, true);
    }

    protected OKCancelRefreshDialog(JFrame owner, String title, ClusterNode workingCluster) {
        this(owner, title, true, workingCluster);
    }

    protected OKCancelRefreshDialog(JDialog owner, String title) {
        this(owner, title, true);
    }

    protected OKCancelRefreshDialog(JDialog owner, String title, ClusterNode workingCluster) {
        this(owner, title, true, workingCluster);
    }

    protected OKCancelRefreshDialog(JFrame frame, String title, boolean modal) {
        this(frame, title, modal, null);
    }

    protected OKCancelRefreshDialog(JFrame frame, String title, boolean modal, ClusterNode workingCluster) {
        super(frame, title, modal, workingCluster);
    }

    protected OKCancelRefreshDialog(JDialog dialog, String title, boolean modal) {
        this(dialog, title, modal, null);
    }

    protected OKCancelRefreshDialog(JDialog frame, String title, boolean modal, ClusterNode workingCluster) {
        super(frame, title, modal, workingCluster);
    }

    @Override
    protected void setClusterTitle() {
    }

    @Override
    protected void setSiteTitle(String siteAlias) {
    }

    @Override
    protected void setButtons() {
        super.setButtons();
        this.btnRefresh = new JButton();
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OKCancelRefreshDialog.this.btnRefresh_actionPerformed(e);
            }
        });
        this.setLastUpdateText();
    }

    protected void setTimerDelay(int delay) {
        if (this.refreshTimer != null) {
            this.refreshTimer.setDelay(delay);
        }
    }

    protected void startRefreshTimer(int delay) {
        if (this.refreshTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SrClientAction.waitAndInvokeController(OKCancelRefreshDialog.this.refreshInvoked(), OKCancelRefreshDialog.this);
                }
            };
            this.refreshTimer = new Timer(delay, taskPerformer);
            this.refreshTimer.start();
            this.updateTimerCounterLabel();
        } else {
            this.refreshTimer.setDelay(delay);
            this.refreshTimer.restart();
        }
        SrClientAction.waitAndInvokeController(this.refreshInvoked(), this);
    }

    protected void stopTimer() {
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
            this.refreshTimer = null;
        }
        if (this.timerCounter != null) {
            this.timerCounter.stop();
            this.timerCounter = null;
        }
    }

    private void btnRefresh_actionPerformed(ActionEvent e) {
        SrClientAction.blockActions(this.refreshInvoked(), this);
    }

    private Collection<? extends SrFuture<Void>> refreshInvoked() {
        Collection<SrFuture<Void>> retVal = this.doOnRefresh();
        this.setLastUpdateText();
        return retVal;
    }

    private void setLastUpdateText() {
        String lastUpdate = new Date(System.currentTimeMillis()).toString();
        this.setMessageText("Last update: " + lastUpdate);
        if (this.refreshTimer != null) {
            this.counter = this.refreshTimer.getDelay() / 1000;
            this.updateTimerCounterLabel();
        }
    }

    private void updateTimerCounterLabel() {
    }

    protected abstract Collection<? extends SrFuture<Void>> doOnRefresh();

    @Override
    public void dispose() {
        this.stopTimer();
        super.dispose();
    }
}

