/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrTreeCellRenderer;
import com.sanrad.util.BundleKeysInterface;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public class MainTreeCellRenderer
extends SrTreeCellRenderer {
    public MainTreeCellRenderer() {
        this.setFont(new Font("Verdana", 0, 9));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ImageIcon icon = ((SrTreeNode)value).getNodeIcon();
        Icon alarmIcon = null;
        if (!(value instanceof SiteNode)) {
            alarmIcon = ((SrTreeNode)value).getAlarmIcon();
        }
        if (alarmIcon != null) {
            icon = this.getIcon((ImageIcon)alarmIcon, icon);
        }
        if (value instanceof ClusterNode) {
            ClusterNode cluster = (ClusterNode)value;
            String[] args = new String[]{cluster.getAlias()};
            String clusterDisplay = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_CLUSTER_NODE_DISPLAY_STRING, args);
            String singleSwitchDisplay = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_SINGLE_SWITCH_NODE_DISPLAY_STRING, args);
            String mode = cluster.isSingleVSwitchMode() ? singleSwitchDisplay : clusterDisplay;
            this.setText(mode);
            this.addGraphicalIndication(cluster);
        }
        if (value instanceof VSwitchNode) {
            VSwitchNode vSwitch = (VSwitchNode)value;
            this.setText(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_VSWITCH_NODE_DISPLAY_STRING, vSwitch.getName(), vSwitch.getBoxType()));
            this.addGraphicalIndication(vSwitch);
        }
        this.setLeafIcon(icon);
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setDisabledIcon(icon);
        this.setIcon(icon);
        this.setEnabled(((SrTreeNode)value).isEnabled());
        this.setLeafIcon(icon);
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setDisabledIcon(icon);
        this.setIcon(icon);
        String toolTip = ((SrTreeNode)value).getToolTipText();
        if (toolTip != null) {
            this.setToolTipText(toolTip);
        } else {
            this.setToolTipText(this.getText());
        }
        return this;
    }
}

