/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.MainFrameDropdownToolBar;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.actions.volume.VolumeActions;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import com.sanrad.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class MainMenuBar
extends JMenuBar {
    private static SrLogger thelogger = SrLogger.getLogger();
    private static final Color theBGColor = ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.MAIN_MENU_BAR_BACKGROUND_COLOR);
    private static final Color theBGColor2 = ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.MAIN_MENU_BAR_BACKGROUND_COLOR2);
    private static final String theConfigurationName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_CONFIG);
    private static final String theMonitorName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_MONITOR);
    private static final String theMonitorAlarms = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_ALARMS);
    private static final String theMonitorAlarmsCurrent = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_ALARMS_CURRENT);
    private static final String theMonitorStorageTrapsCurrent = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_STORAGE_TRAPS_CURRENT);
    private static final String theMonitorAlarmsHistory = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_ALARMS_HISTORY);
    private static final String theMonitorAlarmsNotification = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_ALARMS_NOTIFICATION);
    private static final String theMonitorAlarmsNotificationAddresses = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_ALARMS_NOTIFICATION_EMAIL_ADDR);
    private static final String theMonitorAlarmsNotificationSetup = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_ALARMS_NOTIFICATION_EMAIL_SETUP);
    private static final String theGDRName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_GDR);
    private static final String theSecurityName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_SECURITY);
    private static final String theSecurityUsers = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_SECURITY_USERS);
    private static final String theSecurityPassword = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_SECURITY_PASSWORD);
    private static final String theToolsName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS);
    private static final String theToolsImport = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS_IMPORT);
    private static final String theToolsExport = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS_EXPORT);
    private static final String theToolsLog = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS_LOG);
    private static final String theToolsTopologyName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS_TOPOLOGY);
    private static final String theToolsTopologyExport = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS_TOPOLOGY_EXPORT);
    private static final String theToolsTopologyView = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS_TOPOLOGY_VIEW);
    private static final String theHelpName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_HELP);
    private static final String theHelpTopics = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_HELP_TOPICS);
    private static final String theHelpAbout = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_HELP_ABOUT);
    private SrMainTreePanel myMainTree;
    private MainFrame myFrame;
    private ArrayList<JMenu> myMenuList = new ArrayList();

    MainMenuBar(SrMainTreePanel aMainTree) {
        this.myMainTree = aMainTree;
        this.myFrame = (MainFrame)aMainTree.getOwner();
        this.setLayout(new BoxLayout(this, 0));
        JLabel menuBarImageLabel = new JLabel(ClientImageObject.LOGO_NORTH.getImageIcon());
        this.add(menuBarImageLabel);
        this.setBackground(theBGColor);
        this.addConfigurationMenu();
        this.addMonitorMenu();
        this.addGDRMenu();
        this.addSecurityMenu();
        this.addToolsMenu();
        this.addHelpMenu();
        SrMainMenu exitMenu = this.createExitMenu();
        this.myMenuList.add(exitMenu);
        SrPanel exitPanel = new SrPanel(new BorderLayout());
        exitPanel.setOpaque(true);
        exitPanel.setBackground(theBGColor2);
        exitPanel.add((Component)exitMenu, "East");
        this.add(exitPanel);
    }

    @Override
    public JMenu add(JMenu c) {
        this.myMenuList.add(c);
        return super.add(c);
    }

    @Override
    public int getMenuCount() {
        if (this.myMenuList == null) {
            return 0;
        }
        return this.myMenuList.size();
    }

    @Override
    public Component getComponentAtIndex(int i) {
        if (i < 0 || i >= this.getMenuCount()) {
            return null;
        }
        return this.myMenuList.get(i);
    }

    @Override
    public int getComponentIndex(Component c) {
        return this.myMenuList.indexOf(c);
    }

    private void addConfigurationMenu() {
        SrMainMenu configMenu = new SrMainMenu(theConfigurationName);
        configMenu.add(MainFrameDropdownToolBar.createNewSystemMenu(this.myMainTree, this.myFrame));
        configMenu.add(new MainFrameDropdownToolBar.NetworkingAction(this.myFrame, (Icon)ClientImageObject.MENU_NETWORK.getImageIcon()));
        configMenu.add(new MainFrameDropdownToolBar.CreateVolumeAction(ClientImageObject.MENU_CREATE_VOLUME.getImageIcon()));
        configMenu.add(VolumeActions.getInstance().getExchangeVolumeWizardMainMenuAction());
        configMenu.add(new MainFrameDropdownToolBar.CreateJournalAction(ClientImageObject.MENU_CREATE_JOURNAL.getImageIcon()));
        configMenu.add(new MainFrameDropdownToolBar.CloneAction(ClientImageObject.MENU_CLONE_VOLUME.getImageIcon()));
        configMenu.add(new MainFrameDropdownToolBar.CreateVolumeAdvancedAction());
        configMenu.addSeparator();
        configMenu.add(new MainFrameDropdownToolBar.ConfigureRaidAction((Icon)ClientImageObject.MENU_CLONE_VOLUME.getImageIcon()){});
        this.add(configMenu);
    }

    private void addMonitorMenu() {
        SrMainMenu monitorMenu = new SrMainMenu(theMonitorName);
        SrMenu alarmsMenu = new SrMenu(theMonitorAlarms);
        alarmsMenu.add(new MainFrameDropdownToolBar.CurrentAlarmsAction(theMonitorAlarmsCurrent, ClientImageObject.MENU_CURRENT_ALARM.getImageIcon()));
        alarmsMenu.add(new MainFrameDropdownToolBar.HistoryAlarmsAction(theMonitorAlarmsHistory, ClientImageObject.MENU_HISTORY_ALARM.getImageIcon()));
        alarmsMenu.add(new MainFrameDropdownToolBar.CurrentStorageTrapsAction(theMonitorStorageTrapsCurrent, ClientImageObject.MENU_CURRENT_ALARM.getImageIcon()));
        monitorMenu.add(alarmsMenu);
        monitorMenu.add(new MainFrameDropdownToolBar.SessionsStatisticsAction(this.myFrame, (Icon)ClientImageObject.MENU_MONITOR_SESSION_STATISTICS.getImageIcon()));
        monitorMenu.add(new MainFrameDropdownToolBar.MirrorSyncAction(this.myFrame, (Icon)ClientImageObject.MENU_MONITOR_MIRROR_SYNC.getImageIcon()));
        monitorMenu.add(new MainFrameDropdownToolBar.OfflineCopyAction(this.myFrame, (Icon)ClientImageObject.MENU_MONITOR_OFFLINE_COPY.getImageIcon()));
        monitorMenu.add(new MainFrameDropdownToolBar.OpenSnapshotsAction(this.myFrame, (Icon)ClientImageObject.MENU_MONITOR_SNAPSHOT.getImageIcon()));
        monitorMenu.add(new MainFrameDropdownToolBar.MonitorJournalsAction(this.myFrame, (Icon)ClientImageObject.MENU_MONITOR_JOURNAL.getImageIcon()));
        monitorMenu.addSeparator();
        SrMenu alarmsNotifications = new SrMenu(theMonitorAlarmsNotification);
        alarmsNotifications.add(new MainFrameDropdownToolBar.AlarmsNotificationEmailParamsAction(theMonitorAlarmsNotificationAddresses));
        alarmsNotifications.add(new MainFrameDropdownToolBar.AlarmsNotificationSetupAction(theMonitorAlarmsNotificationSetup));
        monitorMenu.add(alarmsNotifications);
        this.add(monitorMenu);
    }

    private void addGDRMenu() {
        SrMainMenu gdrMenu = new SrMainMenu(theGDRName);
        gdrMenu.add(new MainFrameDropdownToolBar.CreatePairAction(this.myFrame, (Icon)ClientImageObject.MENU_GDR_CREATE_PAIR.getImageIcon()));
        gdrMenu.add(new MainFrameDropdownToolBar.GDRReplicationAction(ClientImageObject.MENU_GDR_START_REPLICATION.getImageIcon()));
        gdrMenu.add(new MainFrameDropdownToolBar.GDRMonitorAction(ClientImageObject.MENU_GDR_MONITOR.getImageIcon()));
        this.add(gdrMenu);
    }

    private void addSecurityMenu() {
        SrMainMenu securutyMenu = new SrMainMenu(theSecurityName);
        securutyMenu.add(new MainFrameDropdownToolBar.OpenNewIdentityAction(this.myFrame, (Icon)ClientImageObject.MENU_CREATE_IDENTITY.getImageIcon()));
        securutyMenu.add(new MainFrameDropdownToolBar.OpenGlobalACLAction(this.myFrame, (Icon)ClientImageObject.MENU_VIEW_ACL.getImageIcon()));
        securutyMenu.addSeparator();
        securutyMenu.add(new MainFrameDropdownToolBar.UsersAction(theSecurityUsers));
        securutyMenu.add(new MainFrameDropdownToolBar.PasswordAction(theSecurityPassword));
        this.add(securutyMenu);
    }

    private void addToolsMenu() {
        SrMainMenu toolsMenu = new SrMainMenu(theToolsName);
        toolsMenu.add(new MainFrameDropdownToolBar.ImportAction(theToolsImport));
        toolsMenu.add(new MainFrame.ExportAction(theToolsExport));
        toolsMenu.add(new MainFrameDropdownToolBar.LogAction(theToolsLog));
        SrMenu topologyMenu = new SrMenu(theToolsTopologyName);
        topologyMenu.add(new MainFrameDropdownToolBar.ExportTopologyAction(theToolsTopologyExport));
        topologyMenu.add(new MainFrameDropdownToolBar.ViewTopologyAction(theToolsTopologyView));
        toolsMenu.add(topologyMenu);
        this.add(toolsMenu);
    }

    private void addHelpMenu() {
        SrMainMenu helpMenu = new SrMainMenu(theHelpName);
        SrMenuItem helpTopicsItem = new SrMenuItem(theHelpTopics);
        this.attachHelpToMenu(helpTopicsItem);
        helpMenu.add(helpTopicsItem);
        helpMenu.add(new MainFrameDropdownToolBar.AboutDialogAction(theHelpAbout));
        this.add(helpMenu);
    }

    private SrMainMenu createExitMenu() {
        MainFrame.ExitAction exitAction = this.myFrame.new MainFrame.ExitAction();
        final SrMainMenu exitMenu = new SrMainMenu(exitAction);
        exitMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                exitMenu.getAction().actionPerformed(new ActionEvent(exitMenu, 1001, exitMenu.getText()));
            }
        });
        return exitMenu;
    }

    private void attachHelpToMenu(SrMenuItem item) {
        Util util = new Util();
        URL helpURL = util.getURL(ClientLoader.HELP_URL);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            HelpSet helpSet = new HelpSet(loader, helpURL);
            HelpBroker helpBroker = helpSet.createHelpBroker();
            helpBroker.enableHelpKey(this.myFrame.getRootPane(), ClientLoader.HELP_MAIN_PAGE, helpSet);
            helpBroker.enableHelpOnButton(item, ClientLoader.HELP_MAIN_PAGE, helpSet);
        }
        catch (HelpSetException hse) {
            thelogger.error(SrLogCategories.EXCEPTION, hse, new Object[0]);
        }
    }

    private static class SrMainMenu
    extends SrMenu {
        boolean isMouseOver = false;

        SrMainMenu(String aName) {
            super(aName);
            this.init();
        }

        SrMainMenu(Action a) {
            super(a);
            this.init();
        }

        private void init() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    SrMainMenu.this.isMouseOver = true;
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SrMainMenu.this.isMouseOver = false;
                }
            });
        }

        @Override
        public boolean isTopLevelMenu() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            if (!(this.isMouseOver || this.isArmed() || this.isSelected())) {
                Graphics scratchGraphics = g == null ? null : g.create();
                try {
                    ImageIcon icon;
                    int height = this.getHeight();
                    int width = this.getWidth();
                    scratchGraphics.setColor(theBGColor);
                    scratchGraphics.fillRect(0, 0, width, height);
                    String text = this.getText();
                    Font font = this.getFont();
                    scratchGraphics.setFont(font);
                    scratchGraphics.setColor(this.getForeground());
                    FontMetrics fm = this.getFontMetrics(font);
                    int strH = font.getSize() - fm.getDescent();
                    int strW = fm.stringWidth(text);
                    int shift = 0;
                    Action action = this.getAction();
                    int iconW = 0;
                    if (action != null && (icon = (ImageIcon)action.getValue("SmallIcon")) != null) {
                        Insets i = this.getInsets();
                        Insets m = this.getMargin();
                        Insets b = this.getBorder().getBorderInsets(this);
                        shift = i.left + m.left + b.left;
                        iconW = icon.getIconWidth();
                        scratchGraphics.drawImage(icon.getImage(), shift, (height - icon.getIconHeight()) / 2, null);
                    }
                    scratchGraphics.drawString(text, (width - strW) / 2 + iconW - shift, (height + strH) / 2);
                }
                finally {
                    scratchGraphics.dispose();
                }
            } else {
                super.paintComponent(g);
            }
        }
    }
}

