/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRJournalRootNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRRootTreeNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.log.LogParameterMgr;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.topology.ExportTopology;
import com.sanrad.nms.client.data.volume.VolumeCreationHandler;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.MainFrame;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.acl.dialogs.AclGlobalDialog;
import com.sanrad.nms.client.gui.actions.EmptyAction;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.volume.VolumeActions;
import com.sanrad.nms.client.gui.alarm.dialogs.AlarmNotificationConfigurationDialog;
import com.sanrad.nms.client.gui.alarm.dialogs.HistoryAlarmsDialog;
import com.sanrad.nms.client.gui.conf.dialogs.EmailParametersConfigDialog;
import com.sanrad.nms.client.gui.dr.SrSelectAndStartReplicateDialog;
import com.sanrad.nms.client.gui.dr.wizards.journal.SrJournalWizardFrame;
import com.sanrad.nms.client.gui.dr.wizards.pair.PairWizardValidations;
import com.sanrad.nms.client.gui.dr.wizards.pair.SrPairWizardFrame;
import com.sanrad.nms.client.gui.identity.dialogs.NewIdentityDialog;
import com.sanrad.nms.client.gui.iscsi.session.statistics.ISCSISessionsStatisticsDialog;
import com.sanrad.nms.client.gui.log.LogParameterConfigDialog;
import com.sanrad.nms.client.gui.login.ChangePasswordDialog;
import com.sanrad.nms.client.gui.login.UsersDialog;
import com.sanrad.nms.client.gui.topology.TopologyViewDialog;
import com.sanrad.nms.client.gui.volume.NewVolumeWindow;
import com.sanrad.nms.client.gui.volume.VolumeOperationFramePool;
import com.sanrad.nms.client.gui.volume.copy.dialogs.MirrorSyncOperationDialog;
import com.sanrad.nms.client.gui.volume.copy.dialogs.OfflineCopyOperationDialog;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotVolumesDialog;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotsVolumesDialogPool;
import com.sanrad.nms.client.gui.volume.wizard.clone.SrMigrateVolumeWizardFrame;
import com.sanrad.nms.client.gui.vswitch.dialogs.VSwitchPropertiesDialog;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.swing.AboutDialog;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrScrollPane;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrDropdownMenu;
import com.sanrad.swing.components.SrDropdownMenuBar;
import com.sanrad.swing.components.SrMenu;
import com.sanrad.swing.components.SrMenuItem;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;

public class MainFrameDropdownToolBar
extends JPanel {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String theConfigurationName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_CONFIG);
    private static final String theNewSystemName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CONFIG_NEW);
    private static final String theNetworkingName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CONFIG_NETWORKING);
    private static final String theCreateJournalName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CONFIG_JOURNAL);
    private static final String theCloneName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CLONE_VOLUME);
    private static final String theCreateVolumeName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CONFIG_VOLUME);
    private static final String theCreateVolumeAdvancedName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CONFIG_VOLUME_ADVANCED);
    private static final String theConfigureRaidName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_CONFIG_CONFIGURE_RAID);
    private static final String theMonitorName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_MONITOR);
    private static final String theMonitorAlarmsName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_MONITOR_ALARM);
    private static final String theMonitorStorageTrapsName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_MONITOR_STORAGE_TRAPS);
    private static final String theMonitorSessionsName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_MONITOR_SESSION);
    private static final String theMonitorMirrorsName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_MONITOR_MIRROR);
    private static final String theMonitorSnapshotsName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_MONITOR_SNAPSHOT);
    private static final String theMonitorOfflineCopyName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_MONITOR_COPY);
    private static final String theMonitorJournalName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_MONITOR_JOURNAL);
    private static final String theGDRName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_GDR);
    private static final String theGDRCreatePairName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_GDR_PAIR);
    private static final String theGDRStartReplicationName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_GDR_REPLICATION);
    private static final String theGDRMonitorName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_GDR_MONITOR);
    private static final String theSecurityName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_SECURITY);
    private static final String theSecurityNewHostName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_HOST_GROUP);
    private static final String theSecurityAccessName = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_DROP_DOWN_MENU_ITEM_ACCESS);
    private SrMainTreePanel myMainTree;
    private MainFrame myFrame;

    public MainFrameDropdownToolBar(SrMainTreePanel aMainTree) {
        super(new BorderLayout());
        this.myMainTree = aMainTree;
        this.myFrame = (MainFrame)aMainTree.getOwner();
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.setOpaque(false);
        SrDropdownMenuBar menuBar = new SrDropdownMenuBar();
        menuBar.setOpaque(false);
        this.createConfigurationMenu(menuBar);
        this.createMonitorMenu(menuBar);
        this.createGDRMenu(menuBar);
        this.createScurityMenu(menuBar);
        SrPanel innerPanel = new SrPanel();
        innerPanel.setOpaque(false);
        innerPanel.add(menuBar);
        SrScrollPane scroll = new SrScrollPane(innerPanel);
        scroll.getViewport().setOpaque(true);
        scroll.getViewport().setBackground(ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.MAIN_DROPDOWN_MENU_BACKGROUND_COLOR));
        scroll.setBorder(BorderFactory.createLoweredBevelBorder());
        scroll.setOpaque(false);
        this.add((Component)scroll, "Center");
    }

    private void createConfigurationMenu(SrDropdownMenuBar aMenuBar) {
        SrDropdownMenu configMenu = new SrDropdownMenu(new EmptyAction(theConfigurationName, false, false, SrLicenseTreePath.GENERAL_PATH));
        configMenu.addMenuItem(new CreateVolumeAction(ClientImageObject.DROPDOWN_MENU_VOLUME.getImageIcon()));
        configMenu.addMenuItem(VolumeActions.getInstance().getExchangeVolumeWizardDropdownMenuAction());
        configMenu.addMenuItem(new NetworkingAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_NETWORKING.getImageIcon()));
        configMenu.addMenu(MainFrameDropdownToolBar.createNewSystemMenu(this.myMainTree, this.myFrame, ClientImageObject.DROPDOWN_MENU_NEW_SYSTEM.getImageIcon()));
        configMenu.addMenuItem(new CreateJournalAction(ClientImageObject.DROPDOWN_MENU_CREATE_JOURNAL.getImageIcon()));
        configMenu.addMenuItem(new CloneAction(ClientImageObject.DROPDOWN_MENU_CLONE_VOLUME.getImageIcon()));
        configMenu.addMenuItem(new ConfigureRaidAction(ClientImageObject.DROPDOWN_MENU_NETWORKING.getImageIcon()));
        aMenuBar.addMenu(configMenu);
    }

    private void createMonitorMenu(SrDropdownMenuBar aMenuBar) {
        SrDropdownMenu monitorMenu = new SrDropdownMenu(new EmptyAction(theMonitorName, false, false, SrLicenseTreePath.GENERAL_PATH));
        monitorMenu.addMenuItem(new CurrentAlarmsAction(theMonitorAlarmsName, ClientImageObject.DROPDOWN_MENU_CURRENT_ALARMS.getImageIcon()));
        monitorMenu.addMenuItem(new CurrentStorageTrapsAction(theMonitorStorageTrapsName, ClientImageObject.DROPDOWN_MENU_CURRENT_ALARMS.getImageIcon()));
        monitorMenu.addMenuItem(new SessionsStatisticsAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_SESSION.getImageIcon()));
        monitorMenu.addMenuItem(new MirrorSyncAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_MIRROR.getImageIcon()));
        monitorMenu.addMenuItem(new OfflineCopyAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_OFFLINE_COPY.getImageIcon()));
        monitorMenu.addMenuItem(new OpenSnapshotsAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_SNAPSHOT.getImageIcon()));
        monitorMenu.addMenuItem(new MonitorJournalsAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_MONITOR_JOURNAL.getImageIcon()));
        aMenuBar.addMenu(monitorMenu);
    }

    private void createGDRMenu(SrDropdownMenuBar aMenuBar) {
        SrDropdownMenu gdrMenu = new SrDropdownMenu(new EmptyAction(theGDRName, false, false, SrLicenseTreePath.GDR_PATH));
        gdrMenu.addMenuItem(new CreatePairAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_GDR_PAIR.getImageIcon()));
        gdrMenu.addMenuItem(new GDRReplicationAction(ClientImageObject.DROPDOWN_MENU_GDR_REPLICATION.getImageIcon()));
        gdrMenu.addMenuItem(new GDRMonitorAction(ClientImageObject.DROPDOWN_MENU_GDR_MONITOR.getImageIcon()));
        aMenuBar.addMenu(gdrMenu);
    }

    private void createScurityMenu(SrDropdownMenuBar aMenuBar) {
        SrDropdownMenu securityMenu = new SrDropdownMenu(new EmptyAction(theSecurityName, false, false, SrLicenseTreePath.VOLUME_PATH));
        securityMenu.addMenuItem(new OpenNewIdentityAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_IDENTITY.getImageIcon()));
        securityMenu.addMenuItem(new OpenGlobalACLAction(this.myFrame, (Icon)ClientImageObject.DROPDOWN_MENU_ACL.getImageIcon()));
        aMenuBar.addMenu(securityMenu);
    }

    static SrMenu createNewSystemMenu(SrMainTreePanel aMainTree, MainFrame aFrame) {
        return MainFrameDropdownToolBar.createNewSystemMenu(aMainTree, aFrame, null);
    }

    static SrMenu createNewSystemMenu(SrMainTreePanel aMainTree, MainFrame aFrame, Icon aIcon) {
        SrMenu newItem = new SrMenu(new EmptyAction(theNewSystemName, true, false, SrLicenseTreePath.GENERAL_PATH));
        newItem.getAction().putValue("SmallIcon", aIcon);
        SrMainTreePanel.NewSiteAction newSiteAction = new SrMainTreePanel.NewSiteAction(aMainTree);
        SrMenuItem newSiteItem = new SrMenuItem(newSiteAction);
        newItem.add(newSiteItem);
        SrMainTreePanel.NewClusterAction newClusterAction = new SrMainTreePanel.NewClusterAction(aFrame.getMainTreeView(SiteNode.class), aFrame);
        SrMenuItem newClusterItem = new SrMenuItem(newClusterAction);
        newItem.add(newClusterItem);
        SrMainTreePanel.NewVswitchAction newVSwitchAction = new SrMainTreePanel.NewVswitchAction((View<VSwitchGroupNode>)aFrame.getMainTreeView(VSwitchGroupNode.class));
        newItem.add(new SrMenuItem(newVSwitchAction));
        return newItem;
    }

    private static ClusterNode getSelectedCluster() {
        ClusterNode cluster = SystemRootNode.getInstance().getCurrentClusterNode();
        if (cluster != null && VSwitchManager.getInstance().validateConnectedVswitchExists(cluster) == null) {
            return cluster;
        }
        return null;
    }

    static class ViewTopologyAction
    extends SrClientAction<Void, Void> {
        private static final long serialVersionUID = 1L;

        ViewTopologyAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            try {
                String xmlFileAndPath = LogParameterMgr.getInstance().getClientExportTopologyXMLDirectory() + System.getProperties().getProperty("file.separator") + LogParameterMgr.getInstance().getClientExportTopologyXMLFileName();
                File f = new File(xmlFileAndPath);
                if (!f.exists()) {
                    SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_EXPORT_TOPOLOGY_IS_MISSING_ERROR));
                    return Collections.EMPTY_LIST;
                }
                ExportTopology expTP = new ExportTopology();
                String xslLoc = LogParameterMgr.getInstance().getClientExportTopologyXSLFile();
                theLogger.info(SrLogCategories.INFORMATIVE, "The transform is on the following dir: ", xslLoc);
                expTP.transformXML2HTML(xmlFileAndPath, xslLoc);
                TopologyViewDialog viewDialog = new TopologyViewDialog((Window)ClientLoader.getMainFrame());
                viewDialog.loadPage("file:///" + xmlFileAndPath.replaceAll(".xml", ".html"));
            }
            catch (IOException e) {
                SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_VIEW_TOPOLOGY_GENERAL_ERROR));
                theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
            }
            catch (TransformerException e) {
                SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_VIEW_TOPOLOGY_GENERAL_ERROR));
                theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
            }
            catch (Exception e) {
                SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_VIEW_TOPOLOGY_GENERAL_ERROR));
                theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class ExportTopologyAction
    extends SrClientAction<Void, Void> {
        private static final long serialVersionUID = 1L;

        ExportTopologyAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            ExportTopology expTP = new ExportTopology();
            try {
                int choice;
                String destFileAndPath = LogParameterMgr.getInstance().getClientExportTopologyXMLDirectory() + System.getProperties().getProperty("file.separator") + LogParameterMgr.getInstance().getClientExportTopologyXMLFileName();
                File f = new File(destFileAndPath);
                if (f.exists() && (choice = SrOptionPaneUtil.showYesNoConfirmDialog(null, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXPORT_TOPOLOGY_OVERWRITE_WARNING_MSG), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_TOOLS_TOPOLOGY))) == 1) {
                    return Collections.EMPTY_LIST;
                }
                expTP.exportToXML(destFileAndPath);
            }
            catch (JAXBException e) {
                theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
                SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_EXPORT_TOPOLOGY_GENERAL_ERROR));
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class AboutDialogAction
    extends SrClientAction<Void, Void> {
        AboutDialogAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            int versionX = Integer.parseInt(ClientLoader.UI_BUNDLE.getString(SrDefaultUIBundleKeys.ABOUT_WINDOW_VERSION_X).trim());
            int versionY = Integer.parseInt(ClientLoader.UI_BUNDLE.getString(SrDefaultUIBundleKeys.ABOUT_WINDOW_VERSION_Y).trim());
            Color colorVersion = ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.ABOUT_WINDOW_VERSION_COLOR);
            Font fontVersion = ClientLoader.UI_BUNDLE.getFontResource(SrDefaultUIBundleKeys.ABOUT_WINDOW_VERSION_FONT);
            AboutDialog about = new AboutDialog(ClientLoader.getMainFrame(), ClientLoader.VERSION, ClientLoader.PRODUCT_NAME, ClientImageObject.ABOUT.getImageIcon(), versionX, versionY, colorVersion, fontVersion);
            about.setVisible(true);
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class LogAction
    extends SrClientAction<Void, Void> {
        LogAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogParameterConfigDialog dialog = new LogParameterConfigDialog((JFrame)ClientLoader.getMainFrame(), LogParameterMgr.getInstance());
                    dialog.show();
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class ImportAction
    extends SrClientAction<Void, Void> {
        ImportAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            ClientLoader.getMainFrame();
            MainFrame.transferFileToHost();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class PasswordAction
    extends SrClientAction<Void, Void> {
        PasswordAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new ChangePasswordDialog(ClientLoader.getMainFrame());
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class UsersAction
    extends SrClientAction<Void, Void> {
        UsersAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new UsersDialog(ClientLoader.getMainFrame());
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class OpenNewIdentityAction
    extends SrClientAction<ClusterNode, Void> {
        private MainFrame myFrame;

        public OpenNewIdentityAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        public OpenNewIdentityAction(MainFrame aFrame, Icon aIcon) {
            super(theSecurityNewHostName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH, true, false);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewIdentityDialog identityDialog = new NewIdentityDialog((JFrame)OpenNewIdentityAction.this.myFrame, MainFrameDropdownToolBar.getSelectedCluster());
                    identityDialog.show();
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String msg = ClusterManager.getInstance().validateClustersInSystem();
            if (msg != null) {
                return msg;
            }
            return null;
        }
    }

    static class OpenGlobalACLAction
    extends SrClientAction<ClusterNode, Void> {
        private MainFrame myFrame;

        public OpenGlobalACLAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        public OpenGlobalACLAction(MainFrame aFrame, Icon aIcon) {
            super(theSecurityAccessName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH, true, false);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> aArg) {
            AclGlobalDialog aclDialog = new AclGlobalDialog((JFrame)this.myFrame, MainFrameDropdownToolBar.getSelectedCluster());
            aclDialog.show();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return ClusterManager.getInstance().validateClustersInSystem();
        }
    }

    static class GDRMonitorAction
    extends SrClientAction<Void, Void> {
        GDRMonitorAction() {
            this((Icon)null);
        }

        GDRMonitorAction(Icon aIcon) {
            super(theGDRMonitorName, aIcon, true, true, null, SrLicenseTreePath.GDR_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            ClientLoader.getMainFrame().selectTreeNode(SrMainTreeModel.getInstance().getDRRootNode());
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class GDRReplicationAction
    extends SrClientAction<Void, Void> {
        GDRReplicationAction() {
            this((Icon)null);
        }

        GDRReplicationAction(Icon aIcon) {
            super(theGDRStartReplicationName, aIcon, true, true, null, SrLicenseTreePath.GDR_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SrSelectAndStartReplicateDialog dlg = new SrSelectAndStartReplicateDialog();
                    dlg.setVisible(true);
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            SiteNode[] systemSites = SystemRootNode.getInstance().getSiteNodes();
            ExtendedElementNode[] cgs = SrConsistencyGroupsTableModel.getInstance().getAllExtendedElementNodes();
            ArrayList<DRSyncPairNode> syncPairs = new ArrayList<DRSyncPairNode>();
            for (SiteNode site : systemSites) {
                syncPairs.addAll(SrPairDetailsTableModel.getInstance().getSyncPairsPrimaryOnSite(site));
            }
            if (cgs.length == 0 && syncPairs.size() == 0) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SYSTEM_NO_DR_ELEMENTS);
            }
            boolean isAnyGDRElementForReplication = false;
            for (SiteNode site : systemSites) {
                SrTreeNode[] drElementForReplication = DRManager.getInstance().getElementsForReplicate(site);
                if (drElementForReplication.length <= 0) continue;
                isAnyGDRElementForReplication = true;
                break;
            }
            if (!isAnyGDRElementForReplication) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SYSTEM_NO_DR_ELEMENTS_CAN_REPLICATE);
            }
            return null;
        }
    }

    public static class CreatePairAction
    extends SrClientAction<Void, Void> {
        private MainFrame myFrame;

        public CreatePairAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        CreatePairAction(MainFrame aFrame, Icon aIcon) {
            super(theGDRCreatePairName, aIcon, true, true, null, SrLicenseTreePath.GDR_PATH);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            SrPairWizardFrame frm = new SrPairWizardFrame(this.myFrame);
            frm.runWizard();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return PairWizardValidations.validateCanCreatePair();
        }
    }

    static class MonitorJournalsAction
    extends SrClientAction<ClusterNode, Void> {
        private MainFrame myFrame;

        MonitorJournalsAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        MonitorJournalsAction(MainFrame aFrame, Icon aIcon) {
            super(theMonitorJournalName, aIcon, true, true, null, SrLicenseTreePath.VOLUME_PATH);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> aArg) {
            DRRootTreeNode drRootNode = SrMainTreeModel.getInstance().getDRRootNode();
            this.myFrame.selectTreeNode((SrTreeNode)drRootNode.findNodeInSubTree(DRJournalRootNode.class));
            return Collections.singleton(new CompleteFuture("MainFrameDropdownToolBar.MonitorJournalsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class OpenSnapshotsAction
    extends SrClientAction<ClusterNode, Void> {
        private MainFrame myFrame;

        OpenSnapshotsAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        OpenSnapshotsAction(MainFrame aFrame, Icon aIcon) {
            super(theMonitorSnapshotsName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> aArg) {
            SnapshotVolumesDialog snapshotsVolumeDialog = SnapshotsVolumesDialogPool.getInstance().getSnapshotsVolumeDialog(this.myFrame, MainFrameDropdownToolBar.getSelectedCluster());
            snapshotsVolumeDialog.show();
            return Collections.singleton(new CompleteFuture("MainFrameDropdownToolBar.OfflineCopyAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return ClusterManager.getInstance().validateClustersInSystem();
        }
    }

    static class OfflineCopyAction
    extends SrClientAction<ClusterNode, Void> {
        private MainFrame myFrame;

        OfflineCopyAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        OfflineCopyAction(MainFrame aFrame, Icon aIcon) {
            super(theMonitorOfflineCopyName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> aArg) {
            OfflineCopyOperationDialog.getInstance(this.myFrame, MainFrameDropdownToolBar.getSelectedCluster()).show();
            return Collections.singleton(new CompleteFuture("MainFrameDropdownToolBar.OfflineCopyAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return ClusterManager.getInstance().validateClustersInSystem();
        }
    }

    static class MirrorSyncAction
    extends SrClientAction<ClusterNode, Void> {
        private MainFrame myFrame;

        MirrorSyncAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        MirrorSyncAction(MainFrame aFrame, Icon aIcon) {
            super(theMonitorMirrorsName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> aArg) {
            MirrorSyncOperationDialog.getInstance(this.myFrame, MainFrameDropdownToolBar.getSelectedCluster()).show();
            return Collections.singleton(new CompleteFuture("MainFrameDropdownToolBar.MirrorSyncAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return ClusterManager.getInstance().validateClustersInSystem();
        }
    }

    static class SessionsStatisticsAction
    extends SrClientAction<ClusterNode, Void> {
        private MainFrame myFrame;

        SessionsStatisticsAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        SessionsStatisticsAction(MainFrame aFrame, Icon aIcon) {
            super(theMonitorSessionsName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.ISCSI_PATH);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> aArg) {
            ISCSISessionsStatisticsDialog iscsiSessionsStatisticsDialog = new ISCSISessionsStatisticsDialog((JFrame)this.myFrame, MainFrameDropdownToolBar.getSelectedCluster());
            iscsiSessionsStatisticsDialog.show();
            return Collections.singleton(new CompleteFuture("MainFrameDropdownToolBar.SessionsStatisticsAction"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return ClusterManager.getInstance().validateClustersInSystem();
        }
    }

    static class AlarmsNotificationEmailParamsAction
    extends SrClientAction<Void, Void> {
        AlarmsNotificationEmailParamsAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            new EmailParametersConfigDialog(ClientLoader.getMainFrame()).show();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class AlarmsNotificationSetupAction
    extends SrClientAction<Void, Void> {
        AlarmsNotificationSetupAction(String aName) {
            super(aName, null, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            new AlarmNotificationConfigurationDialog(ClientLoader.getMainFrame()).show();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class HistoryAlarmsAction
    extends SrClientAction<Void, Void> {
        private static HistoryAlarmsDialog theHistoryAlarmsDialog;

        public HistoryAlarmsAction(String aName) {
            this(aName, (Icon)null);
        }

        public HistoryAlarmsAction(String aName, Icon aIcon) {
            super(aName, aIcon, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            if (theHistoryAlarmsDialog == null) {
                theHistoryAlarmsDialog = new HistoryAlarmsDialog(ClientLoader.getMainFrame());
                theHistoryAlarmsDialog.show();
            } else {
                theHistoryAlarmsDialog.initialize();
                theHistoryAlarmsDialog.setVisible(true);
                theHistoryAlarmsDialog.requestFocus();
                theHistoryAlarmsDialog.setButtonsEnable();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class CurrentStorageTrapsAction
    extends SrClientAction<Void, Void> {
        CurrentStorageTrapsAction(String aName) {
            this(aName, (Icon)null);
        }

        CurrentStorageTrapsAction(String aName, Icon aIcon) {
            super(aName, aIcon, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            ClientLoader.getMainFrame().showCurrentStorageTrapsDialog();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class CurrentAlarmsAction
    extends SrClientAction<Void, Void> {
        CurrentAlarmsAction(String aName) {
            this(aName, (Icon)null);
        }

        CurrentAlarmsAction(String aName, Icon aIcon) {
            super(aName, aIcon, false, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            ClientLoader.getMainFrame().showCurrentAlarmsDialog();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    static class CreateVolumeAdvancedAction
    extends SrClientAction<ClusterNode, Void> {
        public CreateVolumeAdvancedAction() {
            this((Icon)null);
        }

        public CreateVolumeAdvancedAction(Icon aIcon) {
            super(theCreateVolumeAdvancedName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH, true, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VolumeOperationFramePool.getInstance().openVolumeOperationFrame(null, new VolumeCreationHandler(MainFrameDropdownToolBar.getSelectedCluster()));
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String msg = null;
            ClusterNode cluster = (ClusterNode)this.myView.getValue().iterator().next();
            if (cluster != null && (msg = ClusterManager.validateCreateVirtualizationOnCluster(cluster)) != null) {
                return msg;
            }
            msg = ClusterManager.getInstance().validateClustersInSystem();
            if (msg != null) {
                return msg;
            }
            return msg;
        }
    }

    static class ConfigureRaidAction
    extends SrClientAction<Void, Void> {
        private static Process theProcess = null;
        private static String theConfigureRaidLocation = LogParameterMgr.getInstance().replaceFileSeparator(ClientLoader.getRaidConfigurationLocation());
        private static String theConfigureRaidFile = ClientLoader.getRaidConfigurationFile();
        private static ProcessExistsView theView = new ProcessExistsView();

        public ConfigureRaidAction(Icon aIcon) {
            super(theConfigureRaidName, aIcon, false, false, theView, SrLicenseTreePath.GENERAL_PATH, true, false);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            try {
                if (theProcess == null) {
                    ProcessBuilder procBuilder = new ProcessBuilder(theConfigureRaidLocation + "\\" + theConfigureRaidFile);
                    procBuilder.directory(new File(theConfigureRaidLocation));
                    theProcess = procBuilder.start();
                    Thread waitForTermination = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (theProcess != null) {
                                    theProcess.waitFor();
                                }
                            }
                            catch (InterruptedException exp) {
                                theLogger.error(SrLogCategories.ERROR, exp, "The configureRaidWaitThread has been interrupted.");
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    theProcess = null;
                                    ((ProcessExistsView)ConfigureRaidAction.this.myView).processStateChanged();
                                }
                            });
                        }
                    }, "ConfigureRaidWaitThread");
                    waitForTermination.start();
                }
                ((ProcessExistsView)this.myView).processStateChanged();
            }
            catch (IOException e) {
                SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), "Failed to find the Storage Management Application");
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (theProcess != null) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.STORAGE_MANAGEMENT_IS_ALREADY_RUNNING);
            }
            return ClusterManager.getInstance().validateVStorExists();
        }

        @Override
        protected boolean shouldClientActionBeVisible() {
            return this.derivedClientUpdateEnabled() == null;
        }

        private static class ProcessExistsView
        implements View<Void> {
            private SrEventListenerManager myListeners = new SrEventListenerManager();

            @Override
            public Collection<Void> getValue() {
                ArrayList<Void> retVal = new ArrayList<Void>();
                retVal.add(null);
                return retVal;
            }

            @Override
            public void addListener(SrAction<Void, ?> action) {
                this.myListeners.add(action);
            }

            @Override
            public void removeListener(SrAction<Void, ?> action) {
                this.myListeners.remove(action);
            }

            public void processStateChanged() {
                this.myListeners.fireEvent(SrAction.class, null, SrAction.theUpdateInformer);
            }
        }
    }

    static class CreateVolumeAction
    extends SrClientAction<ClusterNode, Void> {
        public CreateVolumeAction() {
            this((Icon)null);
        }

        public CreateVolumeAction(Icon aIcon) {
            super(theCreateVolumeName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH, true, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewVolumeWindow.show(ClientLoader.getMainFrame(), MainFrameDropdownToolBar.getSelectedCluster());
                }
            });
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String msg = null;
            msg = ClusterManager.getInstance().validateClustersInSystem();
            if (msg != null) {
                return msg;
            }
            return msg;
        }
    }

    static class CloneAction
    extends SrClientAction<ClusterNode, Void> {
        CloneAction() {
            this((Icon)null);
        }

        CloneAction(Icon aIcon) {
            super(theCloneName, aIcon, true, true, ConstantView.getEmptyView(ClusterNode.class), SrLicenseTreePath.VOLUME_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<ClusterNode> arg) {
            SrMigrateVolumeWizardFrame frm = new SrMigrateVolumeWizardFrame((JFrame)ClientLoader.getMainFrame(), MainFrameDropdownToolBar.getSelectedCluster(), null, false);
            frm.runWizard();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            if (SrWizardFrame.isAlreadyRunningWizard(SrMigrateVolumeWizardFrame.class)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_MIGRATE_WIZARD_IS_ALREADY_OPENED);
            }
            return ClusterManager.getInstance().validateClustersInSystem();
        }
    }

    public static class CreateJournalAction
    extends SrClientAction<DRJournalRootNode, Void> {
        public CreateJournalAction() {
            this((Icon)null);
        }

        CreateJournalAction(Icon aIcon) {
            super(theCreateJournalName, aIcon, true, true, null, SrLicenseTreePath.GDR_PATH);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<DRJournalRootNode> arg) {
            SrJournalWizardFrame frm = new SrJournalWizardFrame(ClientLoader.getMainFrame());
            frm.runWizard();
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            String message = ClusterManager.getInstance().validateClustersInSystem();
            if (message != null) {
                return message;
            }
            SiteNode[] sites = SystemRootNode.getInstance().getSiteNodes();
            boolean siteHasVSwitch = false;
            for (SiteNode site : sites) {
                if (!site.containsVSwitches()) continue;
                siteHasVSwitch = true;
                break;
            }
            if (!siteHasVSwitch) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_JOURNAL_CREATION_NO_SITES_CONFIGURED);
            }
            if (VolumeManager.getInstance().getJournalCreateAllowedCount() == 0) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_JOURNAL_CREATION_EVERY_VSWITCH_HAS_A_JOURNAL);
            }
            if (SrWizardFrame.isAlreadyRunningWizard(SrJournalWizardFrame.class)) {
                return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NO_JOURNAL_CREATION_WIZARD_IS_ALREADY_OPENED);
            }
            return null;
        }
    }

    static class NetworkingAction
    extends SrClientAction<VSwitchNode, Void> {
        private JFrame myFrame;

        public NetworkingAction(MainFrame aFrame) {
            this(aFrame, null);
        }

        public NetworkingAction(MainFrame aFrame, Icon aIcon) {
            super(theNetworkingName, aIcon, true, true, aFrame.getMainTreeView(VSwitchNode.class), SrLicenseTreePath.GENERAL_PATH);
            this.setName(theNetworkingName);
            this.myFrame = aFrame;
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<VSwitchNode> aArg) {
            VSwitchPropertiesDialog dialog = new VSwitchPropertiesDialog(this.myFrame, aArg.iterator().next(), true);
            dialog.show();
            return Collections.singleton(new CompleteFuture("MainFrameDropdownToolBar.openVSwitchProperties"));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return VSwitchManager.getInstance().validateVswitchExists();
        }
    }
}

