/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationErrorEvent;
import com.sanrad.nms.client.comm.CommunicationErrorListener;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.comm.CommunicationListener;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.alarm.AlarmsConfigurationTableModelCollection;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrLimitedAlarmsTableModel;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.identity.IdentitiesTableModelCollection;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.NexsanManagedRaidNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.srv.isns.ISNSServerManager;
import com.sanrad.nms.client.data.srv.isns.ISNSServersTableModelCollection;
import com.sanrad.nms.client.data.srv.radius.RadiusServerManager;
import com.sanrad.nms.client.data.srv.radius.RadiusServersTableModelCollection;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.StorageTableModelCollection;
import com.sanrad.nms.client.data.storage.traps.StorageNotificationManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.target.TargetTableModelCollection;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupsManager;
import com.sanrad.nms.client.data.volume.ExposedVolumesManager;
import com.sanrad.nms.client.data.volume.ExposedVolumesTableModelCollection;
import com.sanrad.nms.client.data.volume.NotExposedVolumeTreeModelCollection;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.UnExposedVolumesTableModelCollection;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncOperationNode;
import com.sanrad.nms.client.data.volume.copy.MirrorSyncTableModelCollection;
import com.sanrad.nms.client.data.volume.copy.OfflineCopyTableModelCollection;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.MainTreeEvent;
import com.sanrad.nms.client.event.MainTreeListener;
import com.sanrad.nms.client.event.SystemEvent;
import com.sanrad.nms.client.event.SystemListener;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.event.alarm.AlarmsListener;
import com.sanrad.nms.client.event.alarm.AlarmsManagerListener;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.cluster.ClusterListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.IdentitiesViewPanel;
import com.sanrad.nms.client.gui.MainFrameDropdownToolBar;
import com.sanrad.nms.client.gui.MainFrameEvent;
import com.sanrad.nms.client.gui.MainFrameListener;
import com.sanrad.nms.client.gui.MainMenuBar;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrMainTreePanel;
import com.sanrad.nms.client.gui.SrNotExposedVolumeTreePanel;
import com.sanrad.nms.client.gui.acl.dialogs.AclGlobalDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.actions.target.TargetActions;
import com.sanrad.nms.client.gui.actions.volume.VolumeActions;
import com.sanrad.nms.client.gui.alarm.SrAlarmsTablePanel;
import com.sanrad.nms.client.gui.alarm.dialogs.AlarmsDialog;
import com.sanrad.nms.client.gui.alarm.dialogs.CurrentAlarmsDialog;
import com.sanrad.nms.client.gui.alarm.dialogs.FilteredAlarmsDialogsPool;
import com.sanrad.nms.client.gui.cluster.ClusterViewPanel;
import com.sanrad.nms.client.gui.components.SrLicensedComponent;
import com.sanrad.nms.client.gui.dr.CGPairDetailsView;
import com.sanrad.nms.client.gui.dr.ConsistencyGroupsViewPanel;
import com.sanrad.nms.client.gui.dr.JournalsViewPanel;
import com.sanrad.nms.client.gui.dr.MainCGViewPanel;
import com.sanrad.nms.client.gui.dr.PairDetailsViewPanel;
import com.sanrad.nms.client.gui.dr.SrPairDetailsTablePanel;
import com.sanrad.nms.client.gui.site.SiteViewPanel;
import com.sanrad.nms.client.gui.storage.DiskGraphicViewPanel;
import com.sanrad.nms.client.gui.storage.StorageViewPanel;
import com.sanrad.nms.client.gui.storage.trap.dialog.StorageTrapsDialog;
import com.sanrad.nms.client.gui.target.TargetViewPanel;
import com.sanrad.nms.client.gui.volume.ExposedVolumesViewPanel;
import com.sanrad.nms.client.gui.volume.UnExposedVolumesViewPanel;
import com.sanrad.nms.client.gui.volume.VolumeOperationFramePool;
import com.sanrad.nms.client.gui.volume.VolumesViewPanel;
import com.sanrad.nms.client.gui.volume.copy.dialogs.CopyOperationDialog;
import com.sanrad.nms.client.gui.volume.copy.dialogs.MirrorSyncOperationDialog;
import com.sanrad.nms.client.gui.volume.copy.dialogs.OfflineCopyOperationDialog;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotVolumesDialog;
import com.sanrad.nms.client.gui.volume.snapshot.dialogs.SnapshotsVolumesDialogPool;
import com.sanrad.nms.client.gui.vswitch.VSwitchViewPanel;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.FrameView;
import com.sanrad.swing.LookAndFill;
import com.sanrad.swing.OKCancelDialog;
import com.sanrad.swing.SrDefaultUIBundleKeys;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.SrPanelTitle;
import com.sanrad.swing.SrSplitPane;
import com.sanrad.swing.SrTablePanel;
import com.sanrad.swing.StatusPanel;
import com.sanrad.swing.ToolBarListener;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.TreeView;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jvnet.substance.SubstanceLookAndFeel;

public class MainFrame
extends FrameView
implements MainTreeListener,
SystemListener,
ClusterListener,
VSwitchListener,
CommunicationErrorListener,
ToolBarListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String TITLE = ClientLoader.PRODUCT_NAME + " - " + ClientLoader.VENDOR_NAME + " Management Station ";
    private SrEventListenerManager m_listeners = new SrEventListenerManager();
    private PairDetailsViewPanel m_pairsViewPanel;
    private MainCGViewPanel m_consistencyGroupsViewPanel;
    private JournalsViewPanel m_journalsViewPanel;
    private SiteViewPanel mySiteViewPanel = new SiteViewPanel();
    private ClusterViewPanel clusterViewPanel = new ClusterViewPanel();
    private VolumesViewPanel exposedVolumesViewPanel;
    private VolumesViewPanel unExposedVolumesViewPanel;
    private StorageViewPanel storageViewPanel;
    private String myNexsanViewPanelUrl = null;
    private IdentitiesViewPanel identitiesViewPanel;
    private TargetViewPanel targetViewPanel;
    private VSwitchViewPanel vSwitchViewPanel = new VSwitchViewPanel();
    private SrPanel rightPanel = new SrPanel(new BorderLayout());
    private SrMainTreePanel mainTreePanel;
    private AclGlobalDialog aclDialog = null;
    private AlarmsLabel alarmsTitleLabel;
    private final int FORCE_DISCOVERY_TIME = 60000;
    public static final int BORDER_WIDTH = 5;
    private Timer timer = new Timer(60000, new ForceDiscoveryTask());
    private CurrentAlarmsDialog currAlarmsDialog;
    private StorageTrapsDialog myCurrStorageTrapsDialog;
    SrEventListenerManager.Informer<MainFrameListener, MainFrameEvent> exitMainFrameInformer = new SrEventListenerManager.Informer<MainFrameListener, MainFrameEvent>(){

        @Override
        public void inform(MainFrameListener listener, MainFrameEvent event) {
            listener.exitMainFrame(event);
        }
    };
    private boolean isSystemDiscoveryCompleted = true;
    private String myMainViewTitleText = "";
    private JPanel myTitlePanel;
    public final SrClientAction openOfflineCopyTableAction = new ShowCopyOperDialogBaseAction<ClusterNode>(SystemRootNode.getInstance().getClusterView(), (JFrame)this, true){

        @Override
        protected ClusterNode getClusterNode(Collection<ClusterNode> arg) {
            return arg.iterator().next();
        }

        @Override
        protected Collection<CopyOperationNode> getCopyOperations(Collection<ClusterNode> arg) {
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String getPreferredDisabledText() {
            return MainFrame.this.getPreferredDisabledTextForToolbar(this.myView.getValue());
        }
    };
    public final SrClientAction OPEN_MIRROR_SYNC_TABLE_ACTION = new OpenMirrorSyncTableAction<ClusterNode>(SystemRootNode.getInstance().getClusterView(), true, (JFrame)this){

        @Override
        protected ClusterNode getClusterNode(Collection<ClusterNode> aArg) {
            return aArg.iterator().next();
        }

        @Override
        protected Collection<CopyOperationNode> getCopyOperations(Collection<ClusterNode> aArg) {
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String getPreferredDisabledText() {
            return MainFrame.this.getPreferredDisabledTextForToolbar(this.myView.getValue());
        }
    };
    public final SrClientAction EXIT_ACTION = new ExitAction();

    public MainFrame(boolean applet, boolean refreshMode) throws RemoteException {
        super(false);
        CommunicationEventService.getInstance().addSystemListener(this);
        StorageManager.getInstance().readAllStorageDataFromServer();
        AttachedRaidManager.getInstance().readDataFromServer();
        TargetQosGroupsManager.getInstance().readDataFromServer();
        this.exposedVolumesViewPanel = new ExposedVolumesViewPanel(this);
        this.unExposedVolumesViewPanel = new UnExposedVolumesViewPanel(this);
        SnapshotSchedulerManager.getInstance().readDataFromServer();
        this.mainTreePanel = new SrMainTreePanel(this);
        this.storageViewPanel = new StorageViewPanel(this);
        this.initActions();
        IdentityManager.getInstance().readAllIdentities(false);
        SystemRootNode.getInstance().initAllPolicyManagers();
        this.identitiesViewPanel = new IdentitiesViewPanel(this);
        IdentityManager.getInstance().notifyIdentitiesCreated();
        this.targetViewPanel = new TargetViewPanel(this, this.mainTreePanel);
        DiskGraphicViewPanel.getInstance(this).addAlarmSourceSelectionListener();
        this.m_journalsViewPanel = new JournalsViewPanel(this);
        this.m_consistencyGroupsViewPanel = new MainCGViewPanel();
        this.m_pairsViewPanel = new PairDetailsViewPanel();
        this.currAlarmsDialog = new CurrentAlarmsDialog((Window)this);
        this.currAlarmsDialog.setVisible(false);
        this.myCurrStorageTrapsDialog = new StorageTrapsDialog();
        this.myCurrStorageTrapsDialog.setVisible(false);
        if (!ClientAOImpl.isUpdatedByServer()) {
            StatusPanel.getInstance().setConstantText("NOTE: This window will not be updated automatically by the server!");
        }
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.EXIT_ACTION.actionPerformed(null);
            }
        });
        this.init();
        if (refreshMode) {
            this.refreshView();
        }
        for (final ClusterNode clusterNode : SystemRootNode.getInstance().getClusterNodes()) {
            if (!clusterNode.shouldAttachedRaidDlgPopUpAppear()) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.mainTreePanel.popUpAttachRaidDialog(clusterNode);
                }
            });
        }
        this.newClusterHasBeenSelected(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SubstanceLookAndFeel.hideMenuSearchPanels();
            }
        });
    }

    private void initActions() {
        TargetActions.init(this);
        VolumeActions.init(this);
    }

    private void init() {
        this.mainTreePanel.addMainTreeListener(this);
        ClusterManager.getInstance().addClusterListener(this);
        VSwitchManager.getInstance().addVSwitchListener(this);
        CommunicationEventService.getInstance().addCommunicationErrorListener(this);
        EventTimer et = new EventTimer();
        CommunicationEventService.getInstance().addCommunicationListener(et);
        CommunicationEventService.getInstance().addAlarmsListener(et);
        this.mainTreePanel.select(SystemRootNode.getInstance());
        this.showRootView();
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent event) {
        StatusPanel.getInstance().setText("Resetting " + ClientLoader.VSWITCH_DISPLAY_STRING + "...", StatusPanel.INFO, this);
    }

    public static <T extends CopyOperationNode> ShowAndSelectCopyOperationAction<T> createShowConstantCopyOperationAction(Collection<T> nodes) {
        return new ShowAndSelectCopyOperationAction<T>("", new ConstantView<T>(nodes), ClientLoader.getMainFrame());
    }

    public static SrClientAction createShowConstantMirrorSyncOperationsAction(Collection<MirrorSyncOperationNode> toSelect) {
        return new OpenMirrorSyncTableAction<MirrorSyncOperationNode>(new ConstantView<MirrorSyncOperationNode>(toSelect), false, (JFrame)ClientLoader.getMainFrame()){

            @Override
            protected ClusterNode getClusterNode(Collection<MirrorSyncOperationNode> aArg) {
                return (ClusterNode)aArg.iterator().next().getVSwitch().getParent();
            }

            @Override
            protected Collection<? extends CopyOperationNode<?>> getCopyOperations(Collection<MirrorSyncOperationNode> aArg) {
                return aArg;
            }
        };
    }

    @Override
    public void discoverCompleted(ClusterEvent e) {
        ClusterNode clusterNode = e.getClusterNode();
        this.setSelectionInAllTables(true);
        this.setClusterDiscoveryProccesss(clusterNode, false);
        theLogger.trace(SrLogCategories.LEGACY, "clearing all data structures.");
        this.refreshView(clusterNode);
        if (clusterNode.shouldAttachedRaidDlgPopUpAppear()) {
            this.mainTreePanel.popUpAttachRaidDialog(clusterNode);
        }
    }

    private void setClusterDiscoveryProccesss(ClusterNode clusterNode, boolean discovery) {
        clusterNode.setDiscoveryProcess(discovery);
        SrMainTreeModel.getInstance().nodeChanged(clusterNode);
    }

    private void refreshView(ClusterNode clusterNode) {
        if (!clusterNode.isInDiscoveryProcess()) {
            String[] args = new String[]{clusterNode.toString()};
            StatusPanel.getInstance().setText(ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_STATUS_PANEL_READING_CLUSTER, args), StatusPanel.NO_INFO, this);
            this.clearAll(clusterNode);
            theLogger.info(SrLogCategories.INFORMATIVE, "Reading storage data.");
            ClusterManager.getInstance().readClusterDataFromServer(clusterNode);
            clusterNode.readRadiusServers(true);
            clusterNode.readISNSServers(true);
            StorageManager.getInstance().readStorageDataFromServer(clusterNode);
            AttachedRaidManager.getInstance().readDataFromServer(clusterNode);
            TargetQosGroupsManager.getInstance().readDataFromServer(clusterNode);
            SnapshotSchedulerManager.getInstance().readDataFromServer(clusterNode);
            ExposedVolumesManager.getInstance().init(clusterNode);
            theLogger.info(SrLogCategories.INFORMATIVE, "initializing Main tree.");
            this.mainTreePanel.refreshClusterView(clusterNode);
            this.setClusterDiscoveryProccesss(clusterNode, true);
            theLogger.info(SrLogCategories.INFORMATIVE, "reading all Host Groups from server.");
            IdentityManager.getInstance().readAllIdentities(clusterNode, true);
            if (clusterNode.getPolicyManager() == null) {
                clusterNode.initPolicyManager();
                clusterNode.getPolicyManager().addPolicyManagerListener(IdentitiesTableModelCollection.getInstance());
            }
            theLogger.info(SrLogCategories.INFORMATIVE, "reading all policy manager from server.");
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            policyMgr.readAllAclMapFromServer(true);
            IdentitiesTableModelCollection.getInstance().recalculateTotalReadWriteData(clusterNode);
            CopyOperManager.getInstance().getAllCopyOpersFromServer(clusterNode);
            theLogger.info(SrLogCategories.INFORMATIVE, "reading alarms from server.");
            this.m_journalsViewPanel.readFromServer(clusterNode);
            AlarmsManager.getInstance().getAllAlarmsFromServer(clusterNode, true);
            theLogger.info(SrLogCategories.INFORMATIVE, "set default cursor.");
            this.setClusterDiscoveryProccesss(clusterNode, false);
            if (!this.isSystemDiscoveryCompleted) {
                StatusPanel.getInstance().setText(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_STATUS_PANEL_DISCOVERING), StatusPanel.NO_INFO, this);
            } else {
                StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
            }
        }
    }

    public void refreshView() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.closeAllGeneralWindows();
        this.mainTreePanel.closeAllDialogs();
        AlarmsManager.getInstance().clearAllAlarms();
        for (ClusterNode clusterNode : SystemRootNode.getInstance().getClusterNodes()) {
            this.refreshView(clusterNode);
        }
        this.drRefresh();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void drRefresh() {
        DRConsistencyGroupManager.getInstance().init();
        DRASyncPairManager.getInstance().init();
        DRSyncPairManager.getInstance().init();
        AlarmsManager.getInstance().clearAllAlarms(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        AlarmsManager.getInstance().getAllDrAlarmsFromServer(true);
    }

    @Override
    public void discoverStarted(ClusterEvent e) {
        this.isSystemDiscoveryCompleted = false;
        ClusterNode clusterNode = e.getClusterNode();
        if (clusterNode.isCurrentCluster()) {
            this.setSelectionInAllTables(false);
            this.showClusterView();
        }
        this.setClusterDiscoveryProccesss(clusterNode, true);
        this.clearAll(clusterNode);
    }

    @Override
    public void refreshCluster(ClusterEvent e) {
        ClusterNode clusterNode = e.getClusterNode();
        this.refreshView(clusterNode);
    }

    @Override
    public void clusterStatusChanged(ClusterEvent event) {
        this.mainTreePanel.getTreeObject().repaint();
    }

    public void showCurrentAlarmsDialog() {
        this.currAlarmsDialog.setVisible(true);
        this.currAlarmsDialog.requestFocus();
    }

    public void showCurrentStorageTrapsDialog() {
        if (StorageNotificationManager.isInitializationExceptionOccured()) {
            SrOptionPaneUtil.showErrorMessage(this, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_PORT_162_OCCUPIED_ERROR));
            return;
        }
        this.myCurrStorageTrapsDialog.setVisible(true);
        this.myCurrStorageTrapsDialog.setState(0);
        this.myCurrStorageTrapsDialog.requestFocus();
    }

    private void showRootView() {
        this.showClusterView();
        this.setViewTitle(SystemRootNode.getInstance().toString());
    }

    private void refreshPanel(JPanel panel) {
        panel.revalidate();
        panel.repaint();
    }

    private void showSiteView(String aAlias) {
        this.switchToPanel(this.mySiteViewPanel);
        this.setViewTitle("Site " + aAlias);
        this.refreshPanel(this.rightPanel);
    }

    private void showClusterView() {
        this.switchToPanel(this.clusterViewPanel);
        this.setClusterRelatedViewTitle(ClientLoader.CLUSTER_DISPLAY_STRING);
        this.refreshPanel(this.rightPanel);
    }

    private void showVSwitchView(VSwitchNode node) {
        this.vSwitchViewPanel.setPanelForVSwitchType(node);
        this.switchToPanel(this.vSwitchViewPanel);
        this.setClusterRelatedViewTitle(ClientLoader.VSWITCH_DISPLAY_STRING);
        this.refreshPanel(this.rightPanel);
    }

    @Override
    public void showRootView(MainTreeEvent e) {
        this.showRootView();
    }

    @Override
    public void showClusterView(MainTreeEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        if (!clusterNode.isInDiscoveryProcess()) {
            this.showClusterView();
        }
    }

    @Override
    public void showSiteView(MainTreeEvent e) {
        SiteNode site = (SiteNode)e.getSelectedNode();
        this.showSiteView(site.getAlias());
    }

    @Override
    public void showStorageMgmtView(MainTreeEvent e) {
        this.storageViewPanel.showSubdisksPanel();
        this.showStorageView();
    }

    @Override
    public void showNexsanMgmtView(MainTreeEvent e) {
        NexsanManagedRaidNode raidNode = (NexsanManagedRaidNode)e.getSelectedNode();
        this.myNexsanViewPanelUrl = raidNode.getNexsanUrlForManage();
        this.storageViewPanel.showNexsanPanel(this.myNexsanViewPanelUrl);
        this.showStorageView();
    }

    private void showStorageView() {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        if (!clusterNode.isInDiscoveryProcess()) {
            this.switchToPanel(this.storageViewPanel);
            this.setClusterRelatedViewTitle("Storage");
            this.refreshPanel(this.rightPanel);
        }
    }

    @Override
    public void showVSwitchView(MainTreeEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        if (!clusterNode.isInDiscoveryProcess()) {
            VSwitchNode node = (VSwitchNode)e.getSelectedNode();
            this.showVSwitchView(node);
        }
    }

    @Override
    public void showIdentitiesView(MainTreeEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        if (!clusterNode.isInDiscoveryProcess()) {
            this.switchToPanel(this.identitiesViewPanel);
            this.setClusterRelatedViewTitle("Host Groups");
            this.refreshPanel(this.rightPanel);
        }
    }

    @Override
    public void showExposedVolumesView(MainTreeEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        if (!clusterNode.isInDiscoveryProcess()) {
            this.switchToPanel(this.exposedVolumesViewPanel);
            this.exposedVolumesViewPanel.refresh();
            this.setClusterRelatedViewTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.TARGETS_LUS_LABEL));
            this.refreshPanel(this.rightPanel);
        }
    }

    @Override
    public void showUnExposedVolumesView(MainTreeEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        if (!clusterNode.isInDiscoveryProcess()) {
            this.switchToPanel(this.unExposedVolumesViewPanel);
            this.setClusterRelatedViewTitle("Unexposed Volumes");
            SrNotExposedVolumeTreePanel tree = (SrNotExposedVolumeTreePanel)((UnExposedVolumesViewPanel)this.unExposedVolumesViewPanel).getVolumesDetailsViewPanel().getVolumeTree();
            tree.getTreeObject().revalidate();
            tree.getTreeObject().repaint();
            this.refreshPanel(this.rightPanel);
        }
    }

    @Override
    public void showTargetView(MainTreeEvent e) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        if (!clusterNode.isInDiscoveryProcess()) {
            TargetNode node = e.getTargetNode();
            this.showTargetView(node, e.hasVswitches());
        }
    }

    private void showTargetView(TargetNode node, boolean hasVswitches) {
        this.targetViewPanel.setTargetNode(node);
        this.switchToPanel(this.targetViewPanel);
        this.setClusterRelatedViewTitle("Target");
        this.refreshPanel(this.rightPanel);
    }

    @Override
    public void newClusterHasBeenSelected(MainTreeEvent e) {
        this.storageViewPanel.newClusterHasBeenSelected();
        this.identitiesViewPanel.newClusterHasBeenSelected();
        this.exposedVolumesViewPanel.newClusterHasBeenSelected();
        this.unExposedVolumesViewPanel.newClusterHasBeenSelected();
        this.targetViewPanel.newClusterHasBeenSelected();
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void clusterCreated(ClusterEvent e) {
        ClusterNode clusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
    }

    @Override
    public void clusterRemoved(ClusterEvent e) {
        ClusterNode clusterNode = e.getClusterNode();
        this.clearAll(clusterNode);
        this.removeModels(clusterNode);
    }

    @Override
    public void clusterPropertiesChanged(ClusterEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
        ClusterNode clusterNode = e.getClusterNode();
        this.setClusterDiscoveryProccesss(clusterNode, true);
        StatusPanel.getInstance().setText("Rediscovering " + ClientLoader.VSWITCH_DISPLAY_STRING + ": " + e.getName() + "...", this);
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
    }

    private void closeAllGeneralWindows() {
        OfflineCopyOperationDialog copyDialog;
        theLogger.trace(SrLogCategories.LEGACY, "closing all windows...");
        if (this.currAlarmsDialog != null) {
            theLogger.trace(SrLogCategories.LEGACY, "closing Current Alarms...");
            this.currAlarmsDialog.dispose();
        }
        if (this.myCurrStorageTrapsDialog != null) {
            theLogger.trace(SrLogCategories.LEGACY, "closing Current Storage Events...");
            this.myCurrStorageTrapsDialog.dispose();
        }
        theLogger.trace(SrLogCategories.LEGACY, "closing Filtered Alarms...");
        if (FilteredAlarmsDialogsPool.hasInstance()) {
            FilteredAlarmsDialogsPool.getInstance().disposeAll();
        }
        theLogger.trace(SrLogCategories.LEGACY, "closing Volume Operations windows...");
        if (VolumeOperationFramePool.hasInstance()) {
            VolumeOperationFramePool.getInstance().closeVolumeOperationFrame();
        }
        theLogger.trace(SrLogCategories.LEGACY, "closing Snapshot windows...");
        if (SnapshotsVolumesDialogPool.hasInstance()) {
            SnapshotsVolumesDialogPool.getInstance().closeAllDialogs();
        }
        theLogger.trace(SrLogCategories.LEGACY, "closing Volume Creation Frame...");
        this.storageViewPanel.closeVolumeCreationFrame();
        theLogger.trace(SrLogCategories.LEGACY, "closing Offline Copy and MirrorSync Windows...");
        MirrorSyncOperationDialog mirrDialog = MirrorSyncOperationDialog.getInstance();
        if (mirrDialog != null && mirrDialog.isVisible()) {
            mirrDialog.dispose();
        }
        if ((copyDialog = OfflineCopyOperationDialog.getInstance()) != null && copyDialog.isVisible()) {
            copyDialog.dispose();
        }
        if (this.aclDialog != null) {
            this.aclDialog.dispose();
            this.aclDialog = null;
        }
    }

    private void setSelectionInAllTables(boolean flag) {
        ConsistencyGroupsViewPanel cgTable;
        CGPairDetailsView cgPairDetailsTable;
        SrTablePanel pairsTablePanel = this.m_pairsViewPanel.getCurrentTablePanel();
        if (pairsTablePanel != null) {
            pairsTablePanel.getTable().setRowSelectionAllowed(flag);
        }
        if ((cgPairDetailsTable = this.m_consistencyGroupsViewPanel.getCgDetailsTable()) != null) {
            cgPairDetailsTable.getCurrentTablePanel().getTable().setRowSelectionAllowed(flag);
        }
        if ((cgTable = this.m_consistencyGroupsViewPanel.getCgTable()) != null) {
            cgTable.getCurrentTablePanel().getTable().setRowSelectionAllowed(flag);
        }
        this.m_journalsViewPanel.setRowSelectionAllowed(flag);
        this.exposedVolumesViewPanel.setRowSelectionAllowed(flag);
        this.unExposedVolumesViewPanel.setRowSelectionAllowed(flag);
        this.storageViewPanel.setRowSelectionAllowed(flag);
        this.identitiesViewPanel.setRowSelectionAllowed(flag);
        this.targetViewPanel.setRowSelectionAllowed(flag);
    }

    public static SrClientAction createShowConstantRestoreOperationAction(Collection<RestoreOperationNode> nodes) {
        return new OpenSnapshotsAction<RestoreOperationNode>(new ConstantView<RestoreOperationNode>(nodes), false, (JFrame)ClientLoader.getMainFrame()){

            @Override
            protected ClusterNode getClusterNode(Collection<RestoreOperationNode> arg) {
                return (ClusterNode)arg.iterator().next().getVSwitch().getParent();
            }

            @Override
            protected Collection<SnapshotVolumeNode> getVolumes(Collection<RestoreOperationNode> aArg) {
                ArrayList<SnapshotVolumeNode> volumes = new ArrayList<SnapshotVolumeNode>(aArg.size());
                for (RestoreOperationNode operations : aArg) {
                    volumes.add((SnapshotVolumeNode)operations.getSource());
                }
                return volumes;
            }
        };
    }

    public void clearAll() {
        this.closeAllGeneralWindows();
        this.mainTreePanel.closeAllDialogs();
        Vector<ClusterNode> clusters = SystemRootNode.getInstance().getClusterNodes();
        for (int i = 0; i < clusters.size(); ++i) {
            this.clearAll(clusters.get(i));
        }
    }

    private void clearAll(ClusterNode clusterNode) {
        boolean clusterNodeIsCurrentCluster = clusterNode.isCurrentCluster();
        this.closeAllGeneralWindows();
        this.mainTreePanel.closeClusterDialogs(clusterNode);
        AlarmsManager.getInstance().clearAllAlarms(clusterNode);
        AlarmsManager.getInstance().clearAllAlarms(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        AlarmsManager.getInstance().getAllDrAlarmsFromServer(true);
        PolicyManager policyMgr = clusterNode.getPolicyManager();
        if (policyMgr != null) {
            policyMgr.clear();
        }
        ExposedVolumesManager.getInstance().clear(clusterNode);
        this.m_journalsViewPanel.clear(clusterNode);
        this.exposedVolumesViewPanel.clear(clusterNode);
        this.unExposedVolumesViewPanel.clear(clusterNode);
        this.storageViewPanel.clearTable(clusterNode);
        this.mainTreePanel.clear(clusterNode);
        clusterNode.getStubToReference().clearAllButVSwitches();
        RadiusServerManager.getInstance().clearExternalServers(clusterNode);
        ISNSServerManager.getInstance().clearExternalServers(clusterNode);
        this.targetViewPanel.clear(clusterNode);
        if (SnapshotsVolumesDialogPool.hasInstance()) {
            SnapshotsVolumesDialogPool.getInstance().clearAllSnapshotVolumes();
        }
        VolumeManager.getInstance().getClusterSnapshotMap().clearAll(clusterNode);
        if (clusterNodeIsCurrentCluster) {
            this.rightPanel.revalidate();
            this.rightPanel.repaint();
            this.storageViewPanel.closeVolumeCreationFrame();
        }
    }

    private void removeModels(ClusterNode clusterNode) {
        AlarmsConfigurationTableModelCollection.getInstance().removeModel(clusterNode);
        MirrorSyncTableModelCollection.getInstance().removeModel(clusterNode);
        OfflineCopyTableModelCollection.getInstance().removeModel(clusterNode);
        IdentitiesTableModelCollection.getInstance().removeModel(clusterNode);
        ISNSServersTableModelCollection.getInstance().removeModel(clusterNode);
        NotExposedVolumeTreeModelCollection.getInstance().removeModel(clusterNode);
        RadiusServersTableModelCollection.getInstance().removeModel(clusterNode);
        StorageTableModelCollection.getInstance().removeModel(clusterNode);
        TargetTableModelCollection.getInstance().removeModel(clusterNode);
        ExposedVolumesTableModelCollection.getInstance().removeModel(clusterNode);
        UnExposedVolumesTableModelCollection.getInstance().removeModel(clusterNode);
    }

    private void initComponents() {
        this.setTitle(TITLE);
        this.setLocation(0, 0);
        int h = this.getToolkit().getScreenSize().height;
        int w = this.getToolkit().getScreenSize().width;
        this.setSize(w, h - 40);
        this.initMenuBar();
        JPanel logoPane = new JPanel(new BorderLayout());
        this.myTitlePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(ClientImageObject.UNDER_MENU_LINE.getImageIcon().getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
                g.setFont(LookAndFill.UPPER_PANEL_TITLE_LABEL_FONT);
                int strW = g.getFontMetrics().stringWidth(MainFrame.this.myMainViewTitleText);
                int strH = LookAndFill.UPPER_PANEL_TITLE_LABEL_FONT.getSize();
                g.drawString(MainFrame.this.myMainViewTitleText, (this.getWidth() - strW) / 2, (this.getHeight() + strH) / 2);
            }
        };
        logoPane.add((Component)new JLabel(ClientImageObject.LOGO_SOUTH.getImageIcon()), "West");
        logoPane.add((Component)this.myTitlePanel, "Center");
        this.clusterViewPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.vSwitchViewPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Dimension minDimension = new Dimension(10, 10);
        JPanel alarmsPanel = this.createAlarmsPanel();
        alarmsPanel.setMinimumSize(minDimension);
        this.rightPanel.setMinimumSize(minDimension);
        this.mainTreePanel.getPanelScrollPane().getViewport().setBackground(Color.white);
        this.mainTreePanel.setBackground(Color.white);
        this.mainTreePanel.setMinimumSize(minDimension);
        this.mainTreePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        SrSplitPane mainTreeAndComponentsViewSplitPanel = new SrSplitPane(1, this.mainTreePanel, this.rightPanel);
        mainTreeAndComponentsViewSplitPanel.setMinimumSize(minDimension);
        mainTreeAndComponentsViewSplitPanel.setDividerLocation(200);
        SrSplitPane totalViewSplitPanel = new SrSplitPane(0, mainTreeAndComponentsViewSplitPanel, alarmsPanel);
        totalViewSplitPanel.setDividerLocation(520);
        totalViewSplitPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        MainFrameDropdownToolBar toolBar = new MainFrameDropdownToolBar(this.mainTreePanel);
        int tollbarWidth = toolBar.getPreferredSize().width;
        SrSplitPane dropDownAndTotalViewSplitPanel = new SrSplitPane(1, toolBar, totalViewSplitPanel);
        dropDownAndTotalViewSplitPanel.setDividerLocation(tollbarWidth);
        dropDownAndTotalViewSplitPanel.setOneTouchExpandable(true);
        dropDownAndTotalViewSplitPanel.setOneTouchExpandMaxLocation(tollbarWidth);
        SrPanel mainSplitAndLogoPanel = new SrPanel(new BorderLayout());
        mainSplitAndLogoPanel.add((Component)dropDownAndTotalViewSplitPanel, "Center");
        mainSplitAndLogoPanel.add((Component)logoPane, "North");
        this.getMainPanel().setBorder(null);
        this.getMainPanel().add((Component)mainSplitAndLogoPanel, "Center");
        this.getContentPane().add((Component)StatusPanel.getInstance(), "South");
        this.getContentPane().setBackground(ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.MAIN_FRAME_BACKGROUND_COLOR));
    }

    private JPanel createAlarmsPanel() {
        JPanel alarmsPanel = new JPanel();
        alarmsPanel.setLayout(new BorderLayout());
        alarmsPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        alarmsPanel.setBackground(ClientLoader.UI_BUNDLE.getColorResource(SrDefaultUIBundleKeys.PANEL_BACKGROUND_COLOR));
        SrPanel alarmsTitlePanel = new SrPanel();
        alarmsTitlePanel.setLayout(new FlowLayout(0));
        this.alarmsTitleLabel = new AlarmsLabel();
        alarmsTitlePanel.add(this.alarmsTitleLabel);
        SrAlarmsTablePanel tablePan = new SrAlarmsTablePanel(SrLimitedAlarmsTableModel.getInstance());
        tablePan.getScrollPane().getViewport().setBackground(Color.white);
        alarmsPanel.add((Component)tablePan, "Center");
        alarmsPanel.add((Component)alarmsTitlePanel, "North");
        return alarmsPanel;
    }

    private void initMenuBar() {
        MainMenuBar menuBar = new MainMenuBar(this.mainTreePanel);
        this.setJMenuBar(menuBar);
    }

    @Override
    public void configurationError(CommunicationErrorEvent e) {
        boolean timerRunning = this.timer.isRunning();
        if (timerRunning) {
            this.timer.stop();
        }
        JOptionPane.showMessageDialog(this.getActiveWindow(), e.getErrorMessage(), "Configuration Error", 0);
        if (timerRunning) {
            this.timer.restart();
        }
    }

    @Override
    public void fatalConfigurationError(CommunicationErrorEvent e) {
        boolean timerRunning = this.timer.isRunning();
        if (timerRunning) {
            this.timer.stop();
        }
        if (this.storageViewPanel.isVolumeCreationFrameShown()) {
            JOptionPane.showMessageDialog(this.storageViewPanel.getVolumeCreationFrame(), e.getErrorMessage(), "Fatal Configuration Error", 0);
        } else {
            JOptionPane.showMessageDialog(this.getActiveWindow(), e.getErrorMessage(), "Fatal Configuration Error", 0);
        }
        if (timerRunning) {
            this.timer.restart();
        }
    }

    @Override
    public void snmpError(CommunicationErrorEvent e) {
        boolean timerRunning = this.timer.isRunning();
        if (timerRunning) {
            this.timer.stop();
        }
        if (this.storageViewPanel.isVolumeCreationFrameShown()) {
            JOptionPane.showMessageDialog(this.storageViewPanel.getVolumeCreationFrame(), e.getErrorMessage(), "SNMP Error", 0);
        } else {
            JOptionPane.showMessageDialog(this.getActiveWindow(), e.getErrorMessage(), "SNMP Error", 0);
        }
        if (timerRunning) {
            this.timer.restart();
        }
    }

    @Override
    public void eventSynchronizationError(CommunicationErrorEvent e) {
        this.refreshView();
    }

    @Override
    public void serverWasShutdown(CommunicationErrorEvent e) {
        theLogger.error(SrLogCategories.LEGACY, e.getErrorMessage());
        SrOptionPaneUtil.showErrorMessage(this.getActiveWindow(), e.getErrorMessage());
        StatusPanel.getInstance().setConstantText(e.getErrorMessage());
    }

    public void addMainFrameListener(MainFrameListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeMainFrameListener(MainFrameListener listener) {
        this.m_listeners.remove(listener);
    }

    private String getClusterPrefixTitle() {
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        StringBuffer titlePrefix = new StringBuffer();
        if (clusterNode != null) {
            String prefix = clusterNode.isSingleVSwitchMode() ? ClientLoader.VSWITCH_DISPLAY_STRING : ClientLoader.CLUSTER_DISPLAY_STRING;
            titlePrefix.append(prefix);
            titlePrefix.append(" ");
            titlePrefix.append(clusterNode.getAlias());
            titlePrefix.append(" - ");
        }
        return titlePrefix.toString();
    }

    private void setViewTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Title cannot be null");
        }
        this.myMainViewTitleText = title;
        this.myTitlePanel.repaint();
    }

    private void setClusterRelatedViewTitle(String title) {
        StringBuffer titleBuffer = new StringBuffer(this.getClusterPrefixTitle());
        titleBuffer.append(title);
        this.setViewTitle(titleBuffer.toString());
    }

    @Override
    public void showConsistencyGroupsView(MainTreeEvent e) {
        this.switchToPanel(this.m_consistencyGroupsViewPanel);
        this.setViewTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_VIEW_DESC));
        this.refreshPanel(this.rightPanel);
    }

    public void selectConsistencyGroupInConsistencyGroupsView(ConsistencyGroupNode node) {
        this.m_consistencyGroupsViewPanel.selectConsistencyGroup(node);
    }

    @Override
    public void showJournalsView(MainTreeEvent e) {
        this.switchToPanel(this.m_journalsViewPanel);
        this.setViewTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_JOURNALS_VIEW_DESC));
        this.refreshPanel(this.rightPanel);
    }

    @Override
    public void showPairDetailsView(MainTreeEvent e) {
        this.switchToPanel(this.m_pairsViewPanel);
        this.setViewTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_VIEW_DESC));
        this.refreshPanel(this.rightPanel);
    }

    public void selectPairInPairDetailsView(DRPairNode node) {
        ((SrPairDetailsTablePanel)this.m_pairsViewPanel.getCurrentTablePanel()).selectPairs(Collections.singleton(node));
    }

    public void selectExtendedPairInPairDetailsView(ExtendedPairNode epNode) {
        ((SrPairDetailsTablePanel)this.m_pairsViewPanel.getCurrentTablePanel()).selectExtendedPair(epNode);
    }

    private void switchToPanel(JComponent panel) {
        this.rightPanel.removeAll();
        if (panel != null) {
            this.rightPanel.add(panel);
            ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
            this.checkLicenseAvailability(panel, clusterNode != null ? clusterNode.getCapability() : null);
        }
    }

    private void checkLicenseAvailability(Container parent, SrBITSConstant vswitchCapability) {
        LicenseManager mgr = LicenseManager.getInstance();
        Component[] comps = parent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Container)) continue;
            if (comps[i] instanceof SrLicensedComponent) {
                SrLicenseTreePath[] invisiblePaths;
                SrLicensedComponent clientComp = (SrLicensedComponent)((Object)comps[i]);
                comps[i].setEnabled(mgr.isEnabled(clientComp.getLicensePath(), vswitchCapability));
                boolean isVisible = mgr.isVisible(clientComp.getLicensePath(), vswitchCapability);
                comps[i].setVisible(isVisible);
                Container parentContainer = comps[i].getParent();
                if (parentContainer instanceof JSplitPane) {
                    if (isVisible) {
                        int height;
                        JSplitPane split = (JSplitPane)parentContainer;
                        split.setDividerSize(UIManager.getLookAndFeelDefaults().getInt("SplitPane.dividerSize"));
                        if (split.getOrientation() == 1) {
                            int width = parentContainer.getWidth();
                            if (width > 0) {
                                split.setDividerLocation(width / 2);
                            }
                        } else if (split.getOrientation() == 0 && (height = parentContainer.getHeight()) > 0) {
                            split.setDividerLocation(height / 2);
                        }
                    } else {
                        ((JSplitPane)parentContainer).setDividerSize(0);
                    }
                }
                if ((invisiblePaths = clientComp.getInvisiblePaths()) != null) {
                    int j = invisiblePaths.length;
                    while (j-- > 0) {
                        boolean visible = mgr.isVisible(invisiblePaths[j], vswitchCapability);
                        if (!visible) continue;
                        comps[i].setVisible(false);
                        break;
                    }
                }
            }
            if (!comps[i].isVisible()) continue;
            this.checkLicenseAvailability((Container)comps[i], vswitchCapability);
        }
    }

    public Window getActiveWindow() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w instanceof SrWizardFrame || w instanceof OKCancelDialog || w instanceof AlarmsDialog || w instanceof FrameView) {
            return w;
        }
        return this;
    }

    private static File selectFile(String title, int selectionMode) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(title);
        FileFilter[] defaultFilters = chooser.getChoosableFileFilters();
        int i = defaultFilters.length;
        while (i-- > 0) {
            chooser.removeChoosableFileFilter(defaultFilters[i]);
        }
        chooser.setFileSelectionMode(selectionMode);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (!f.isDirectory() && !f.isFile()) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String importFileName = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.IMPORT_CONFIGURATION_FILE_NAME);
                return f.getName().toLowerCase().endsWith(importFileName.toLowerCase());
            }

            @Override
            public String getDescription() {
                return ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.IMPORT_CONFIGURATION_FILE_NAME);
            }
        };
        chooser.setFileFilter(ff);
        chooser.setDialogType(1);
        if (chooser.showDialog(ClientLoader.getMainFrame(), OKCancelDialog.OK) == 1) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public static void transferFileToHost() {
        final File file = MainFrame.selectFile(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_IMPORT_DIALOG_TITLE), 0);
        if (file != null) {
            try {
                byte[] buffer = new byte[(int)file.length()];
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file.getPath()));
                input.read(buffer, 0, buffer.length);
                input.close();
                SystemRootNode.getInstance().getFileInterfaceStub().uploadFile(buffer);
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        SrOptionPaneUtil.showInfoMsg(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_IMPORT_SUCCESS_MSG), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_IMPORT_SUCCESS_MSG_TITLE));
                    }
                });
            }
            catch (RemoteException e) {
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        String[] args = new String[]{e.getMessage()};
                        SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_MAIN_MENU_IMPORT_GENERAL_ERROR, args));
                    }
                });
            }
            catch (FileNotFoundException e) {
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        String[] args = new String[]{file.getPath()};
                        SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_MAIN_MENU_IMPORT_SOURCE_FILE_ERROR, args));
                    }
                });
            }
            catch (IOException e) {
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        String[] args = new String[]{e.getMessage()};
                        SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_MAIN_MENU_IMPORT_GENERAL_ERROR, args));
                    }
                });
            }
        }
    }

    public void selectTreeNode(SrTreeNode node) {
        this.mainTreePanel.select(node);
    }

    public <A extends SrTreeNode> TreeView<A> getMainTreeView(final Class<A> aClass) {
        return new TreeView<A>(this.mainTreePanel.getTreeObject(), aClass){

            @Override
            public Collection<A> getValue() {
                SrTreeNode selection = (SrTreeNode)MainFrame.this.mainTreePanel.getSelectedNode();
                SrTreeNode viewSelectedNode = null;
                if (selection != null) {
                    viewSelectedNode = (SrTreeNode)selection.getAncestorOfType(aClass);
                }
                ArrayList<SrTreeNode> retValues = new ArrayList<SrTreeNode>();
                retValues.add(viewSelectedNode);
                return retValues;
            }
        };
    }

    public SrMainTreePanel getMainTreePanel() {
        return this.mainTreePanel;
    }

    @Override
    public void systemDiscoveryCompleted(SystemEvent e) {
        this.isSystemDiscoveryCompleted = true;
        StatusPanel.getInstance().setText(StatusPanel.READY, StatusPanel.INFO, this);
    }

    private String getPreferredDisabledTextForToolbar(Collection<ClusterNode> aClusters) {
        boolean isNoConnectedVswitches = true;
        for (ClusterNode cluster : aClusters) {
            if (cluster.getConnectedVSwitches().length <= 0) continue;
            isNoConnectedVswitches = false;
        }
        if (isNoConnectedVswitches) {
            return SrMainTreePanel.THE_CLUSTER_CONTAINS_NO_V_SWITCHES;
        }
        return null;
    }

    class AlarmsLabel
    extends SrPanelTitle
    implements AlarmsManagerListener {
        final String text = "Last 10 Alarms (out of ";

        public AlarmsLabel() {
            this.text = "Last 10 Alarms (out of ";
            this.init();
        }

        public AlarmsLabel(String text) {
            super(text);
            this.text = "Last 10 Alarms (out of ";
            this.init();
        }

        private void init() {
            this.setText("Last 10 Alarms (out of " + this.total() + ")");
            AlarmsManager.getInstance().addAlarmListener(this);
        }

        private int total() {
            return AlarmsManager.getInstance().getTotalAlarmsCount();
        }

        protected void setText() {
            this.setText("Last 10 Alarms (out of " + this.total() + ")");
        }

        @Override
        public void alarmOpened(AlarmsEvent event) {
            this.setText();
        }

        @Override
        public void alarmClosed(AlarmsEvent event) {
            this.setText();
        }

        @Override
        public void alarmChanged(AlarmsEvent event) {
        }

        @Override
        public void alarmsDeleted(AlarmsEvent event) {
            this.setText();
        }

        @Override
        public void alarmsReadFromServer(AlarmsEvent event) {
            this.setText();
        }
    }

    class EventTimer
    implements CommunicationListener,
    AlarmsListener {
        @Override
        public void elementCreate(CommunicationEvent e) {
            if (e.getClusterNode().isInDiscoveryProcess()) {
                StatusPanel.getInstance().append(".");
                this.restartTimer();
            }
        }

        @Override
        public void elementRemove(CommunicationEvent e) {
            ClusterNode clusterNode = e.getClusterNode();
            if (clusterNode == null || clusterNode.isInDiscoveryProcess()) {
                this.restartTimer();
            }
        }

        @Override
        public void elementChanged(CommunicationEvent e) {
            if (e.getClusterNode().isInDiscoveryProcess()) {
                this.restartTimer();
            }
        }

        @Override
        public void discoverCompleted(CommunicationEvent e) {
            ClusterNode clusterNode = e.getClusterNode();
            if (clusterNode.isInDiscoveryProcess()) {
                theLogger.trace(SrLogCategories.LEGACY, "discovery proccess is completed.");
                MainFrame.this.setClusterDiscoveryProccesss(clusterNode, false);
                MainFrame.this.timer.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discoverStarted(CommunicationEvent e) {
            EventTimer eventTimer = this;
            synchronized (eventTimer) {
                MainFrame.this.timer.setInitialDelay(60000);
                MainFrame.this.timer.setRepeats(false);
                theLogger.trace(SrLogCategories.LEGACY, "scheduling a new timer for discovery proccess.");
                MainFrame.this.timer.start();
            }
        }

        @Override
        public void resetVSwitchStarted(CommunicationEvent e) {
        }

        @Override
        public void storageDiscoveryStarted(CommunicationEvent e) {
        }

        @Override
        public void loginSucceed(CommunicationEvent e) {
        }

        @Override
        public void alreadyKnownByVSwitch(CommunicationEvent e) {
            if (e.getClusterNode().isInDiscoveryProcess()) {
                this.restartTimer();
            }
        }

        public void elementRemovedFromVSwitch(CommunicationEvent e) {
        }

        @Override
        public void alarmOpened(AlarmsEvent event) {
            if (event.getClusterNode() != null && event.getClusterNode().isInDiscoveryProcess()) {
                this.restartTimer();
            }
        }

        @Override
        public void alarmClosed(AlarmsEvent event) {
            ClusterNode clusterNode = event.getClusterNode();
            if (clusterNode != null && clusterNode.isInDiscoveryProcess()) {
                this.restartTimer();
            }
        }

        @Override
        public void alarmChanged(AlarmsEvent event) {
            if (event.getClusterNode().isInDiscoveryProcess()) {
                this.restartTimer();
            }
        }

        private void restartTimer() {
            MainFrame.this.timer.setRepeats(false);
            MainFrame.this.timer.restart();
        }
    }

    class ForceDiscoveryTask
    implements ActionListener {
        ForceDiscoveryTask() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Enumeration<ClusterNode> nodes = SystemRootNode.getInstance().getClusterNodes().elements();
            while (nodes.hasMoreElements()) {
                ClusterNode clusterNode = nodes.nextElement();
                if (!clusterNode.isInDiscoveryProcess()) continue;
                theLogger.trace(SrLogCategories.LEGACY, "forcing refresh, discovery coul'd not end properly...");
                MainFrame.this.refreshView();
                MainFrame.this.timer.stop();
            }
        }
    }

    class ExitAction
    extends SrClientAction<Void, Void> {
        public ExitAction() {
            super(ClientLoader.BUNDLE.getString(SrClientBundleKeys.QUIT_PRODUCT_ACTION_NAME), ClientImageObject.EXIT.getImageIcon(), false, false, null, SrLicenseTreePath.GENERAL_PATH);
            this.setConfirmationString(ClientLoader.BUNDLE.getString(SrClientBundleKeys.QUIT_PRODUCT_CONFIRMATION_MESSAGE));
            this.setConfirmationTitle(ClientLoader.BUNDLE.getString(SrClientBundleKeys.QUIT_PRODUCT_CONFIRMATION_TITLE));
            this.setEnabledTooltip(ClientLoader.BUNDLE.getString(SrClientBundleKeys.QUIT_PRODUCT_TOOLTIP));
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            MainFrame.this.closeAllGeneralWindows();
            MainFrame.this.mainTreePanel.closeAllDialogs();
            MainFrameEvent event = new MainFrameEvent(this);
            MainFrame.this.m_listeners.fireEvent(MainFrameListener.class, event, MainFrame.this.exitMainFrameInformer);
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    private static abstract class OpenSnapshotsAction<T extends SrTreeNode>
    extends SrClientAction<T, Void> {
        private JFrame myOwner;

        public OpenSnapshotsAction(View<T> aView, boolean aIsSingleSelection, JFrame aOwner) {
            super("Snapshot", ClientImageObject.SNAPSHOT16.getImageIcon(), true, true, aView, SrLicenseTreePath.VOLUME_PATH);
            this.myOwner = aOwner;
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
            ClusterNode clusterNode = this.getClusterNode(arg);
            SnapshotVolumesDialog snapshotsVolumeDialog = SnapshotsVolumesDialogPool.getInstance().getSnapshotsVolumeDialog(this.myOwner, clusterNode);
            snapshotsVolumeDialog.setSelectedVolumeNodes(this.getVolumes(arg));
            snapshotsVolumeDialog.show();
            return Collections.EMPTY_LIST;
        }

        protected abstract Collection<SnapshotVolumeNode> getVolumes(Collection<T> var1);

        protected abstract ClusterNode getClusterNode(Collection<T> var1);

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }

    public static class ExportAction
    extends SrClientAction<Void, Void> {
        private File myDestinationZIPFile = null;

        public ExportAction(String aName) {
            super(aName, null, true, false, null, SrLicenseTreePath.GENERAL_PATH);
        }

        @Override
        public Collection<? extends SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            File destinationZIPDirectory = MainFrame.selectFile(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_MAIN_MENU_EXPORT_DIALOG_TITLE), 1);
            if (destinationZIPDirectory != null) {
                StringBuffer sb = new StringBuffer(destinationZIPDirectory.getPath());
                sb.append('\\');
                sb.append(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.IMPORT_CONFIGURATION_FILE_NAME));
                this.myDestinationZIPFile = new File(sb.toString());
                return Collections.singleton(ClientAOImpl.getInstance().exportConfigurationFile(this.myDestinationZIPFile));
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }

        @Override
        protected void onActionFinished(Collection<? extends SrFuture<Void>> aFutures) {
            super.onActionFinished(aFutures);
            for (SrFuture<Void> srFuture : aFutures) {
                try {
                    srFuture.get();
                }
                catch (InterruptedException e) {
                    theLogger.logAndAssert(SrLogCategories.EXCEPTION, e);
                }
                catch (ExecutionException e) {
                    String[] args;
                    if (e.getCause() instanceof FileNotFoundException) {
                        args = new String[]{this.myDestinationZIPFile.getPath()};
                        SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_MAIN_MENU_EXPORT_DESTINATION_DIR_ERROR, args));
                        continue;
                    }
                    if (!(e.getCause() instanceof IOException)) continue;
                    args = new String[]{e.getCause().getMessage()};
                    SrOptionPaneUtil.showErrorMessage(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_MAIN_MENU_EXPORT_GENERAL_ERROR, args));
                }
            }
            this.myDestinationZIPFile = null;
        }
    }

    private static abstract class OpenMirrorSyncTableAction<T extends SrTreeNode>
    extends ShowAndSelectCopyActions<T> {
        private JFrame myOwner;

        public OpenMirrorSyncTableAction(View<T> aView, boolean aSingleSelection, JFrame aOwner) {
            super("Mirror", ClientImageObject.ADD_MIRROR_OPERATION16.getImageIcon(), aView, aSingleSelection);
            this.setEnabledTooltip("Mirror Sync.");
            this.myOwner = aOwner;
        }

        protected abstract ClusterNode getClusterNode(Collection<T> var1);

        @Override
        protected CopyOperationDialog getCopyOperationDialog(Collection<T> aArg) {
            ClusterNode clusterNode = this.getClusterNode(aArg);
            return MirrorSyncOperationDialog.getInstance(this.myOwner, clusterNode);
        }
    }

    public static class ShowAndSelectCopyOperationAction<T extends CopyOperationNode>
    extends ShowCopyOperDialogBaseAction<T> {
        public ShowAndSelectCopyOperationAction(String aName, View<T> aView, JFrame aOwner) {
            super(aName, aView, aOwner, false);
        }

        @Override
        protected ClusterNode getClusterNode(Collection<T> arg) {
            return (ClusterNode)((CopyOperationNode)arg.iterator().next()).getVSwitch().getParent();
        }

        @Override
        protected Collection<T> getCopyOperations(Collection<T> arg) {
            return arg;
        }
    }

    private static abstract class ShowCopyOperDialogBaseAction<T extends SrTreeNode>
    extends ShowAndSelectCopyActions<T> {
        private JFrame myOwner;

        public ShowCopyOperDialogBaseAction(View<T> aView, JFrame aOwner, boolean aSingleSelection) {
            this("Copy", aView, aOwner, aSingleSelection);
        }

        public ShowCopyOperDialogBaseAction(String aName, View<T> aView, JFrame aOwner, boolean aSingleSelection) {
            super(aName, ClientImageObject.OFFLINE_COPY_OPERATION16.getImageIcon(), aView, aSingleSelection);
            this.myOwner = aOwner;
        }

        @Override
        protected CopyOperationDialog getCopyOperationDialog(Collection<T> aArg) {
            ClusterNode clusterNode = this.getClusterNode(aArg);
            return OfflineCopyOperationDialog.getInstance(this.myOwner, clusterNode);
        }

        protected abstract ClusterNode getClusterNode(Collection<T> var1);
    }

    private static abstract class ShowAndSelectCopyActions<T extends SrTreeNode>
    extends SrClientAction<T, Void> {
        public ShowAndSelectCopyActions(String aName, Icon aIcon, View<T> aView, boolean aSingleSelection) {
            super(aName, aIcon, true, true, aView, SrLicenseTreePath.VOLUME_PATH, aSingleSelection, true);
        }

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<T> arg) {
            CopyOperationDialog dialog = this.getCopyOperationDialog(arg);
            if (dialog != null) {
                Collection<CopyOperationNode> copyOperations = this.getCopyOperations(arg);
                dialog.setSelectedOperations(copyOperations);
                dialog.show();
            }
            return Collections.EMPTY_LIST;
        }

        protected abstract CopyOperationDialog getCopyOperationDialog(Collection<T> var1);

        protected abstract Collection<? extends CopyOperationNode> getCopyOperations(Collection<T> var1);

        @Override
        protected String derivedClientUpdateEnabled() {
            return null;
        }
    }
}

