/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.gui;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerNode;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrOKCancelDialog;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.target.dialogs.NewTargetDialog;
import com.sanrad.nms.client.gui.volume.NewVolumeWindow;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import com.sanrad.swing.SrOptionPane;
import com.sanrad.swing.SrOptionPaneUtil;
import com.sanrad.swing.SrPanel;
import com.sanrad.swing.actions.SrAction;
import com.sanrad.swing.actions.View;
import com.sanrad.swing.components.SrButton;
import com.sanrad.swing.components.SrCheckbox;
import com.sanrad.swing.components.SrComboBox;
import com.sanrad.swing.components.SrIntegerTextField;
import com.sanrad.swing.components.SrLabelField;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.SrFuture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ExposeVolumeDialog
extends SrOKCancelDialog
implements TargetListener,
LUListener {
    private static final long serialVersionUID = 959570964026669467L;
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static final int MAX_LUN_VALUE = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.MAX_LUN_VALUE));
    private static final String TARGET_SHOULD_BE_SELECTED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_TARGET_SHOULD_BE_SELECTED);
    private static final String EXPOSED_ON_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_EXPOSED_ON_LABEL_TEXT);
    private static final String NEW_TARGET_BUTTON_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_NEW_TARGET_BUTTON_TEXT);
    private static final String LU_AUTO_NUMBER_CHECKBOX_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_LU_AUTO_NUMBER_CHECKBOX_TEXT);
    private static final String LU_PANEL_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_LU_PANEL_TITLE);
    private static final String TARGET_PANEL_TITLE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_TARGET_PANEL_TITLE);
    private static final String LUN_SHOULD_BE_ENTERED = ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.NEW_VOLUME_WINDOW_LUN_SHOULD_BE_ENTERED);
    private static final String theTitle = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_EXPOSE_DIALOG_TITLE);
    private static final String TARGET_AUTO_NAME_CHECKBOX_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_TARGET_AUTO_NAME_CHECKBOX);
    private static final String LUN_LABEL_TEXT = ClientLoader.BUNDLE.getString(SrClientBundleKeys.NEW_VOLUME_WINDOW_LUN_LABEL_TEXT);
    private SrCheckbox myLuAutoNumberCheckbox = new SrCheckbox(LU_AUTO_NUMBER_CHECKBOX_TEXT);
    private SrIntegerTextField myLunTextField = new SrIntegerTextField();
    private SrComboBox<NewVolumeWindow.AutoTargetNameItem> myTargetComboBox = new SrComboBox();
    private SrCheckbox myTargetAutoNameCheckbox = new SrCheckbox(TARGET_AUTO_NAME_CHECKBOX_TEXT);
    private VolumeTreeNode myVolume;
    private NewVolumeWindow.AutoTargetNameItem myAutoTargetNameItem = new NewVolumeWindow.AutoTargetNameItem();
    SrAction myOKAction = new SrClientAction<Void, Void>(SrLicenseTreePath.GENERAL_PATH){

        @Override
        public Collection<SrFuture<Void>> derivedActionPerformed(Collection<Void> arg) {
            String title;
            Integer msgArg;
            String message;
            SrOptionPane.Option<String> choice;
            SnapshotSchedulerNode scheduler;
            if (ExposeVolumeDialog.this.myVolume instanceof SnapshotVolumeNode && (scheduler = SnapshotSchedulerManager.getInstance().getSchedulerOfSnapshot((SnapshotVolumeNode)ExposeVolumeDialog.this.myVolume)) != null && SrOptionPaneUtil.CANCEL_BUTTON.equals(choice = SrOptionPaneUtil.showOkCancelConfirmDialog(ExposeVolumeDialog.this, message = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_EXPOSE_SNAP_MSG, msgArg = new Integer(scheduler.isRunning() ? 0 : 1)), title = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_SNAPSHOT_SCHEDULE_EXPOSE_SNAP_MSG_CAPTION)))) {
                return Collections.EMPTY_LIST;
            }
            ClientConfigElementData ced = null;
            ced = ExposeVolumeDialog.this.createExposeVolumeCed(ClassID.GENERAL_VOLUME);
            return Collections.singleton(ClientAOImpl.getInstance().configureElementsTree(ced));
        }

        @Override
        protected String derivedClientUpdateEnabled() {
            return ExposeVolumeDialog.this.isValidForCreation();
        }
    };

    public ExposeVolumeDialog(JFrame owner, VolumeTreeNode aVolume) {
        super(owner, theTitle + " Volume " + aVolume.getAlias(), SystemRootNode.getInstance().getClusterNodeOfSource(aVolume));
        this.myVolume = aVolume;
        this.setOKAction();
        this.addCenterPanel(this.createTargetAndLuPanel());
        this.setTargetList();
        this.setDefaultTargetName();
        this.pack();
    }

    private void updateLuFieldItem() {
        this.myLunTextField.setValue(this.getNextLu());
    }

    private String getNextLu() {
        if (this.myTargetAutoNameCheckbox.isSelected()) {
            return "0";
        }
        Object selectedItem = this.myTargetComboBox.getSelectedItem();
        if (!(selectedItem instanceof TargetNode)) {
            return "N/A";
        }
        return String.valueOf(LUManager.getNextFreeLuNumber((TargetNode)selectedItem));
    }

    private SrPanel createLuPanel() {
        SrPanel retVal = new SrPanel(new GridBagLayout());
        final SrLabelField luNumberLabel = new SrLabelField(LUN_LABEL_TEXT);
        this.myLuAutoNumberCheckbox.setFocusPainted(false);
        this.myLuAutoNumberCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    luNumberLabel.setEnableComponent(false);
                    ExposeVolumeDialog.this.myLunTextField.setEnableComponent(false);
                    ExposeVolumeDialog.this.updateLuFieldItem();
                } else if (e.getStateChange() == 2) {
                    ExposeVolumeDialog.this.myLunTextField.setEnableComponent(true);
                    luNumberLabel.setEnableComponent(true);
                }
            }
        });
        this.myLuAutoNumberCheckbox.setSelected(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 18;
        retVal.add((Component)this.myLuAutoNumberCheckbox, c);
        c.insets.top = 5;
        c.insets.left = 23;
        c.gridx = 0;
        c.gridy = 1;
        this.myLunTextField.setMaxValue(MAX_LUN_VALUE);
        retVal.add((Component)this.myLunTextField, c);
        retVal.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LU_PANEL_TITLE, 0, 0));
        return retVal;
    }

    private SrPanel createTargetAndLuPanel() {
        SrPanel panel = new SrPanel(new BorderLayout(0, 5));
        SrPanel targetPanel = new SrPanel(new GridBagLayout());
        SrPanel luPanel = this.createLuPanel();
        final SrLabelField exposedOnLabel = new SrLabelField(EXPOSED_ON_LABEL_TEXT);
        final SrButton newTargetButton = new SrButton(new AbstractAction(NEW_TARGET_BUTTON_TEXT){

            @Override
            public void actionPerformed(ActionEvent e) {
                new NewTargetDialog((JDialog)ExposeVolumeDialog.this, ExposeVolumeDialog.this.m_workingCluster);
            }
        });
        this.myTargetAutoNameCheckbox.setFocusPainted(false);
        this.myTargetAutoNameCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ExposeVolumeDialog.this.myTargetComboBox.addItem(ExposeVolumeDialog.this.myAutoTargetNameItem);
                    ExposeVolumeDialog.this.myTargetComboBox.setSelectedItem(ExposeVolumeDialog.this.myAutoTargetNameItem);
                    ExposeVolumeDialog.this.myTargetComboBox.setEnableComponent(false);
                    exposedOnLabel.setEnableComponent(false);
                    newTargetButton.setEnableComponent(false);
                }
                if (e.getStateChange() == 2) {
                    ExposeVolumeDialog.this.myTargetComboBox.removeItem(ExposeVolumeDialog.this.myAutoTargetNameItem);
                    ExposeVolumeDialog.this.myTargetComboBox.setEnableComponent(true);
                    ExposeVolumeDialog.this.myTargetComboBox.setSelectedItem(null);
                    exposedOnLabel.setEnableComponent(true);
                    newTargetButton.setEnableComponent(true);
                }
                ExposeVolumeDialog.this.updateLuFieldItem();
            }
        });
        this.myTargetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ExposeVolumeDialog.this.myLuAutoNumberCheckbox.isSelected()) {
                    return;
                }
                ExposeVolumeDialog.this.updateLuFieldItem();
            }
        });
        this.myTargetAutoNameCheckbox.setSelected(true);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 5, 0);
        c.anchor = 18;
        c.gridwidth = 3;
        targetPanel.add((Component)this.myTargetAutoNameCheckbox, c);
        c.gridwidth = 1;
        c.insets.top = 5;
        c.insets.left = 23;
        c.gridx = 0;
        c.gridy = 1;
        targetPanel.add((Component)exposedOnLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        targetPanel.add(this.myTargetComboBox, c);
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        targetPanel.add((Component)newTargetButton, c);
        targetPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TARGET_PANEL_TITLE, 0, 0));
        panel.add((Component)targetPanel, "Center");
        panel.add((Component)luPanel, "South");
        panel.setBorder(new EmptyBorder(5, 0, 0, 0));
        return panel;
    }

    @Override
    public void addListeners() {
        TargetManager.getInstance().addTargetListener(this);
        LUManager.getInstance().addLUListener(this);
    }

    @Override
    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this);
        LUManager.getInstance().removeLUListener(this);
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
        this.updateAutoTargetNameItem();
        TargetNode newTarget = (TargetNode)e.getValue();
        this.myTargetComboBox.addItem((TargetNode)newTarget);
        if (!this.myTargetAutoNameCheckbox.isSelected()) {
            this.myTargetComboBox.setSelectedItem(newTarget);
        }
    }

    private void updateAutoTargetNameItem() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExposeVolumeDialog.this.myAutoTargetNameItem.setName(TargetManager.getInstance().getAutoTargetNameForVolume(ExposeVolumeDialog.this.myVolume.getAlias()));
                ExposeVolumeDialog.this.myTargetComboBox.refreshItem(ExposeVolumeDialog.this.myAutoTargetNameItem);
            }
        });
    }

    @Override
    public void targetRemove(TargetEvent e) {
        RemoteObject stub = e.getStub();
        this.updateAutoTargetNameItem();
        int count = this.myTargetComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            TargetNode tn = (TargetNode)this.myTargetComboBox.getItemAt(i);
            if (!((Target)tn.getStub()).equals(stub)) continue;
            this.myTargetComboBox.removeItemAt(i);
            break;
        }
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
        RemoteObject stub = e.getStub();
        this.updateAutoTargetNameItem();
        int count = this.myTargetComboBox.getItemCount();
        boolean changed = false;
        for (int i = 0; i < count; ++i) {
            TargetNode tn = (TargetNode)this.myTargetComboBox.getItemAt(i);
            if (!((Target)tn.getStub()).equals(stub)) continue;
            changed = true;
        }
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExposeVolumeDialog.this.myTargetComboBox.repaint();
                }
            });
        }
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
    }

    @Override
    public void luStatusChanged(LUEvent event) {
    }

    @Override
    public void luChanged(LUEvent event) {
    }

    @Override
    public void doOnCancel() {
    }

    private void setOKAction() {
        this.myLunTextField.getDocument().addDocumentListener(new View.ViewTextListener(this.myOKAction));
        this.myTargetComboBox.addItemListener(new View.ToggleButtonListener(this.myOKAction));
        this.setOKAction(this.myOKAction);
    }

    private String isValidForCreation() {
        Object target = this.myTargetComboBox.getSelectedItem();
        if (target == null) {
            return TARGET_SHOULD_BE_SELECTED;
        }
        String lun = this.myLunTextField.getText();
        if (lun.trim().equals("")) {
            return LUN_SHOULD_BE_ENTERED;
        }
        return null;
    }

    private ClientConfigElementData createExposeVolumeCed(ClassID aVolumeType) {
        ClientConfigElementData tgtCed = null;
        if (this.myTargetAutoNameCheckbox.isSelected()) {
            tgtCed = new ClientConfigElementData(ClassID.ISCSI_TARGET, (CommKeyClassId)this.m_workingCluster.getIdentifier(), ConfigOperation.CREATE);
            tgtCed.putValue(ClientParameterCode.TARGET_ALIAS, this.myAutoTargetNameItem.toString());
            tgtCed.putValue(ClientParameterCode.TARGET_NAME, this.myAutoTargetNameItem.toString());
            tgtCed.putValue(ClientParameterCode.TARGET_EXPOSED_ON, this.getExposedOnVswitch());
        }
        ClientConfigElementData ced = new ClientConfigElementData(ClassID.LUN, (CommKeyClassId)this.m_workingCluster.getIdentifier(), ConfigOperation.CREATE);
        ced.putValue(ClientParameterCode.LU_LUN, new Long(this.myLunTextField.getText()));
        ced.putValue(ClientParameterCode.LU_VOLUME_CHILD, this.myVolume.getIdentifier());
        if (tgtCed != null) {
            ced.putNestedElementData(ClientParameterCode.LU_PARENT_TARGET, tgtCed);
        } else {
            TargetNode selectedTgt = (TargetNode)this.myTargetComboBox.getSelectedItem();
            ced.putValue(ClientParameterCode.LU_PARENT_TARGET, selectedTgt.getIdentifier());
        }
        if (this.myVolume instanceof SnapshotVolumeNode) {
            SnapshotVolumeNode snapshot = (SnapshotVolumeNode)this.myVolume;
            SnapshotSchedulerNode scheduler = SnapshotSchedulerManager.getInstance().getSchedulerOfSnapshot(snapshot);
            if (scheduler != null) {
                SnapshotConfigFlagsConstant snapNodeFlags;
                ArrayList<ClientConfigElementData> preConfigCeds = new ArrayList<ClientConfigElementData>();
                if (scheduler.isRunning()) {
                    ClientConfigElementData stopScheduleCed = new ClientConfigElementData((CommKeyClassId)scheduler.getIdentifier(), (CommKeyClassId)this.m_workingCluster.getIdentifier(), ConfigOperation.CHANGE);
                    stopScheduleCed.putValue(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE, SnapshotSchedulerStateConstant.STOPPED);
                    preConfigCeds.add(stopScheduleCed);
                }
                if ((snapNodeFlags = snapshot.getConfigFlags()) != null) {
                    SnapshotConfigFlagsConstant flags = snapNodeFlags.turnOffBitConstant(SnapshotConfigFlagsConstant.SCHEDULED_BASED);
                    flags = flags.turnOffBitConstant(SnapshotConfigFlagsConstant.EXTERNAL_SCHEDULER);
                    ClientConfigElementData turnOffBitCed = new ClientConfigElementData((CommKeyClassId)snapshot.getIdentifier(), (CommKeyClassId)this.m_workingCluster.getIdentifier(), ConfigOperation.CHANGE);
                    turnOffBitCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, flags);
                    preConfigCeds.add(turnOffBitCed);
                } else {
                    theLogger.error(SrLogCategories.DB_CORRUPTION, "The snapshot ", snapshot, " has null config flags.");
                }
                if (!preConfigCeds.isEmpty()) {
                    ced.setPreConfigurationElement(preConfigCeds);
                }
            }
        }
        return ced;
    }

    private String getExposedOnVswitch() {
        VolumeTreeNode<?> sourceVolume;
        LUNode sourceVolLu;
        if (this.myVolume instanceof SnapshotVolumeNode && (sourceVolLu = (sourceVolume = ((SnapshotVolumeNode)this.myVolume).getSourceVolume()).getLUNode()) != null) {
            return sourceVolLu.getTargetParent().getExposedOnVSwitchName();
        }
        return this.m_workingCluster.getConnectedVSwitches()[0].getName();
    }

    private void setTargetList() {
        if (this.m_workingCluster != null) {
            List<TargetNode> targetList = this.m_workingCluster.findAllInSubTree(TargetNode.class);
            if (this.myVolume instanceof SnapshotVolumeNode) {
                targetList = VolumeManager.getInstance().filterTargetsForSnapshotVolume(targetList, (SnapshotVolumeNode)this.myVolume);
            }
            for (TargetNode target : targetList) {
                this.myTargetComboBox.addItem((TargetNode)target);
            }
        }
    }

    private void setDefaultTargetName() {
        this.myAutoTargetNameItem.setName(TargetManager.getInstance().getAutoTargetNameForVolume(this.myVolume.getAlias()));
        this.myTargetComboBox.setSelectedItem(this.myAutoTargetNameItem);
        this.myTargetComboBox.repaint();
    }

    @Override
    public void luCreated(LUEvent event) {
        this.updateAutoTargetNameItem();
        this.updateLuFieldItem();
    }

    @Override
    public void luRemoved(LUEvent event) {
        this.updateAutoTargetNameItem();
        this.updateLuFieldItem();
    }
}

