/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.event.volume.copy;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.event.cluster.ClusterAdapter;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.cluster.ClusterListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationEvent;
import com.sanrad.nms.client.gui.volume.copy.CopyOperationTableHeader;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public abstract class SrCopyOperationTableModel
extends SrTableModel {
    protected ClusterNode m_cluster;
    private ClusterListener myClusterListener = new ClusterAdapter(){

        @Override
        public void clusterRemoved(ClusterEvent event) {
            if (event.getClusterNode().equals(SrCopyOperationTableModel.this.m_cluster)) {
                SrCopyOperationTableModel.this.m_cluster = null;
            }
        }
    };

    public SrCopyOperationTableModel(ClusterNode cluster) {
        super(new SrDefaultTableColumns(CopyOperationTableHeader.getColumnNames()));
        this.m_cluster = cluster;
        this.initModel();
    }

    protected abstract Vector getAllOpersFromServer();

    protected void initModel() {
        this.createTable();
    }

    protected void createTable() {
        if (this.m_cluster == null) {
            return;
        }
        Vector allOpers = this.getAllOpersFromServer();
        if (allOpers != null) {
            for (int i = 0; i < allOpers.size(); ++i) {
                CopyOperationNode node = (CopyOperationNode)allOpers.get(i);
                Vector<Comparable> rowData = new Vector<Comparable>();
                rowData.addElement(node);
                rowData.addElement(node.getVSwitch());
                rowData.addElement(node.getSource());
                rowData.addElement(node.getDestination());
                rowData.addElement(node.getCopyStatus());
                rowData.addElement(node.getProgress());
                this.addRowQuetly(rowData.toArray(), -1);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    public void getAllCopyOperations(CopyOperationEvent e) {
        this.clear();
        this.createTable();
    }

    public void clear() {
        this.removeAllRows();
    }

    protected abstract boolean isMyCopyType(CopyOperationNode var1);

    public void copyOperationCreate(CopyOperationEvent e) {
        CopyOperationNode node = e.getNode();
        if (!this.isMyCopyType(node)) {
            return;
        }
        Vector<Comparable> rowData = new Vector<Comparable>();
        rowData.addElement(node);
        rowData.addElement(node.getVSwitch());
        rowData.addElement(node.getSource());
        rowData.addElement(node.getDestination());
        rowData.addElement(node.getCopyStatus());
        rowData.addElement(node.getProgress());
        this.addRow(rowData.toArray());
    }

    public void copyOperationRemove(CopyOperationEvent e) {
        if (!this.isMyCopyType(e.getNode())) {
            return;
        }
        CopyOperationNode node = e.getNode();
        int nodeColIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_NODE.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object src = this.getValueAt(i, nodeColIndex);
            if (!src.equals(node)) continue;
            this.removeRow(i);
            return;
        }
    }

    public void volumeStatusChanged(VolumeEvent e) {
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        int sourceCol = this.getColumnIndex(CopyOperationTableHeader.COPY_SRC.getColumnName());
        int destCol = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            Object sourceVol = this.getValueAt(i, sourceCol);
            Object destVol = this.getValueAt(i, destCol);
            if (!volume.equals(sourceVol) && !volume.equals(destVol)) continue;
            this.fireTableRowsUpdated(i, i);
        }
    }

    public void volumeAliasChanged(VolumeEvent e) {
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(e.getStub());
        int sourceCol = this.getColumnIndex(CopyOperationTableHeader.COPY_SRC.getColumnName());
        int destCol = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            Object sourceVol = this.getValueAt(i, sourceCol);
            Object destVol = this.getValueAt(i, destCol);
            if (!volume.equals(sourceVol) && !volume.equals(destVol)) continue;
            this.fireTableRowsUpdated(i, i);
        }
    }

    public Collection<? extends CopyOperationNode> getCopyOperations() {
        ArrayList<CopyOperationNode> retVal = new ArrayList<CopyOperationNode>(this.getRowCount());
        int nodeCol = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_NODE.getColumnName());
        for (int row = 0; row < this.getRowCount(); ++row) {
            retVal.add((CopyOperationNode)this.getValueAt(row, nodeCol));
        }
        return retVal;
    }

    public void copyOperationChange(CopyOperationEvent e) {
        if (!this.isMyCopyType(e.getNode())) {
            return;
        }
        CopyOperationNode node = e.getNode();
        int nodeIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_NODE.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            CopyOperationNode copyOperNode = (CopyOperationNode)this.getValueAt(i, nodeIndex);
            if (!copyOperNode.equals(node)) continue;
            if (e.getStatus() != null) {
                copyOperNode.setStatus(e.getStatus());
                this.setValueAt(e.getStatus(), i, this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName()));
            }
            if (e.getProgress() != null) {
                Integer progress = e.getProgress();
                copyOperNode.setProgress(progress);
                this.setValueAt(progress, i, this.getColumnIndex(CopyOperationTableHeader.COPY_PROGRESS.getColumnName()));
            }
            return;
        }
    }

    public boolean canBeAborted(int[] selectedRows) {
        int statusCol = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        boolean canAbort = selectedRows.length > 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            List<Object> rowData = this.getRow(selectedRows[i]);
            VolumeOperationOperStatusConstant operStat = (VolumeOperationOperStatusConstant)rowData.get(statusCol);
            if (this.operationStatusActive(operStat)) continue;
            canAbort = false;
            break;
        }
        return canAbort;
    }

    public boolean canBeRestarted(int[] selectedRows) {
        int statusCol = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int dstCol = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int srcCol = this.getColumnIndex(CopyOperationTableHeader.COPY_SRC.getColumnName());
        for (int i = 0; i < selectedRows.length; ++i) {
            List<Object> rowData = this.getRow(selectedRows[i]);
            VolumeTreeNode dst = (VolumeTreeNode)rowData.get(dstCol);
            VolumeTreeNode src = (VolumeTreeNode)rowData.get(srcCol);
            VolumeOperationOperStatusConstant operStat = (VolumeOperationOperStatusConstant)rowData.get(statusCol);
            if (this.operationStatusActive(operStat) || !this.canBeRestarted(src, dst)) continue;
            return true;
        }
        return false;
    }

    protected boolean operationStatusActive(VolumeOperationOperStatusConstant operStat) {
        return CopyOperManager.getInstance().operationStatusActive(operStat);
    }

    public boolean canBeRestarted(VolumeTreeNode src, VolumeTreeNode dst) {
        String volNonFunc = AlarmsManager.VOLUME_NON_FUNC;
        return !AlarmsManager.getInstance().isAlarmExist(dst, volNonFunc) && !AlarmsManager.getInstance().isAlarmExist(src, volNonFunc);
    }

    public boolean canBeDeleted(int[] selectedRows) {
        int statusCol = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        for (int i = 0; i < selectedRows.length; ++i) {
            List<Object> rowData = this.getRow(selectedRows[i]);
            VolumeOperationOperStatusConstant operStat = (VolumeOperationOperStatusConstant)rowData.get(statusCol);
            if (!this.operationStatusActive(operStat)) continue;
            return false;
        }
        return true;
    }

    public boolean isActiveCopyDst(VolumeTreeNode node) {
        int dstIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int statusIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object dst = this.getValueAt(i, dstIndex);
            Object status = this.getValueAt(i, statusIndex);
            if (!dst.equals(node) || !this.operationStatusActive((VolumeOperationOperStatusConstant)status)) continue;
            return true;
        }
        return false;
    }

    public boolean isActiveCopySrc(VolumeTreeNode node) {
        int srcIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_SRC.getColumnName());
        int statusIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            VolumeTreeNode src = (VolumeTreeNode)this.getValueAt(i, srcIndex);
            Object status = this.getValueAt(i, statusIndex);
            if (src == null || !src.equals(node) || !this.operationStatusActive((VolumeOperationOperStatusConstant)status)) continue;
            return true;
        }
        return false;
    }

    public boolean isAbortedCopySrc(VolumeTreeNode node) {
        int srcIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_SRC.getColumnName());
        int statusIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            VolumeTreeNode src = (VolumeTreeNode)this.getValueAt(i, srcIndex);
            Object status = this.getValueAt(i, statusIndex);
            if (src == null || !src.equals(node) || !status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED)) continue;
            return true;
        }
        return false;
    }

    public boolean isAbortedCopyDst(VolumeTreeNode node) {
        int dstIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int statusIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            VolumeTreeNode dst = (VolumeTreeNode)this.getValueAt(i, dstIndex);
            Object status = this.getValueAt(i, statusIndex);
            if (dst == null || !dst.equals(node) || !status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompletedCopyDst(VolumeTreeNode node) {
        int dstIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int statusIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object dst = this.getValueAt(i, dstIndex);
            Object status = this.getValueAt(i, statusIndex);
            if (!dst.equals(node) || !this.operationStatusActive((VolumeOperationOperStatusConstant)status)) continue;
            return true;
        }
        return false;
    }

    public boolean isCopyDst(VolumeTreeNode node) {
        return this.isActiveCopyDst(node) || this.isAbortedCopyDst(node);
    }

    public boolean isExistedAsCopyDstInTable(VolumeTreeNode node) {
        int dstIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object dst = this.getValueAt(i, dstIndex);
            if (!dst.equals(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isCopySrc(VolumeTreeNode node) {
        return this.isActiveCopySrc(node) || this.isAbortedCopySrc(node);
    }

    public boolean isExistedAsCopySrcInTable(VolumeTreeNode node) {
        int srcIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_SRC.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object src = this.getValueAt(i, srcIndex);
            if (!src.equals(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isMirrorSyncDst(VolumeTreeNode node) {
        int dstIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int statusIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object dst = this.getValueAt(i, dstIndex);
            Object status = this.getValueAt(i, statusIndex);
            if (!dst.equals(node) || !this.operationStatusActive((VolumeOperationOperStatusConstant)status)) continue;
            return true;
        }
        return false;
    }

    public boolean doesActiveOperationExist(VolumeTreeNode src, VolumeTreeNode dst) {
        int srcIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_SRC.getColumnName());
        int dstIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_DST.getColumnName());
        int statusIndex = this.getColumnIndex(CopyOperationTableHeader.COPY_OPER_STATUS.getColumnName());
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object stat;
            Object dest;
            VolumeTreeNode source = (VolumeTreeNode)this.getValueAt(i, srcIndex);
            if (!src.equals(source) || !dst.equals(dest = this.getValueAt(i, dstIndex)) || !this.operationStatusActive((VolumeOperationOperStatusConstant)(stat = this.getValueAt(i, statusIndex)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeListeners() {
        ClusterManager.getInstance().removeClusterListener(this.myClusterListener);
    }

    @Override
    public void addListeners() {
        ClusterManager.getInstance().addClusterListener(this.myClusterListener);
    }
}

