/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.event.raid;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.event.raid.RaidEvent;
import java.util.HashMap;
import java.util.Map;

public class RaidEventFactory {
    private static Map<Object, RaidEvent.EventCreator> theEventTypeOrCauseToTheFactoryMap = new HashMap<Object, RaidEvent.EventCreator>();

    public static void putFactory(RaidEvent.EventType aType, RaidEvent.EventCreator aSingleEventFactory) {
        if (aType == null) {
            throw new IllegalArgumentException("Adding RaidEvent Factory recieved nulled type");
        }
        if (aSingleEventFactory == null) {
            throw new IllegalArgumentException("Adding RaidEvent Factory recieved nulled factory");
        }
        theEventTypeOrCauseToTheFactoryMap.put((Object)aType, aSingleEventFactory);
    }

    public static void putFactory(RaidEvent.CauseType aCauseType, RaidEvent.EventCreator aSingleEventFactory) {
        if (aCauseType == null) {
            throw new IllegalArgumentException("Adding RaidEvent Factory recieved nulled cause type");
        }
        if (aSingleEventFactory == null) {
            throw new IllegalArgumentException("Adding RaidEvent Factory recieved nulled factory");
        }
        theEventTypeOrCauseToTheFactoryMap.put((Object)aCauseType, aSingleEventFactory);
    }

    private static RaidEvent.EventCreator getFactory(RaidEvent.CauseType aCauseType) {
        return theEventTypeOrCauseToTheFactoryMap.get((Object)aCauseType);
    }

    private static RaidEvent.EventCreator getFactory(RaidEvent.EventType aEventType) {
        return theEventTypeOrCauseToTheFactoryMap.get((Object)aEventType);
    }

    public static RaidEvent createEventForRaidCreation(Object aSource, RaidSystem aRaid) {
        return RaidEventFactory.getFactory(RaidEvent.EventType.RAID_CREATED).create(aSource, aRaid, new Object[0]);
    }

    public static RaidEvent createEventForRaidRemoval(Object aSource, RaidSystem aRaid) {
        return RaidEventFactory.getFactory(RaidEvent.EventType.RAID_REMOVED).create(aSource, aRaid, new Object[0]);
    }

    public static RaidEvent createEventForRaidAttached(Object aSource, RaidSystem aRaid) {
        return RaidEventFactory.getFactory(RaidEvent.EventType.RAID_ATTACHED).create(aSource, aRaid, new Object[0]);
    }

    public static RaidEvent createEventForRaidDetached(Object aSource, RaidSystem aRaid) {
        return RaidEventFactory.getFactory(RaidEvent.EventType.RAID_DETACHED).create(aSource, aRaid, new Object[0]);
    }

    public static RaidEvent createEventForRaidStatusChanged(Object aSource, RaidSystem aRaid) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.RAID_STATUS_CHANGED).create(aSource, aRaid, new Object[0]);
    }

    public static RaidEvent createEventForRaidNameChanged(Object aSource, RaidSystem aRaid) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.RAID_NAME_CHANGED).create(aSource, aRaid, new Object[0]);
    }

    public static RaidEvent createEventForDiskStatusChanged(Object aSource, RaidSystem aRaid, DirectAccessDeviceNode aChangedDisk) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.DISK_STATUS_CHANGED).create(aSource, aRaid, aChangedDisk);
    }

    public static RaidEvent createEventForDiskAdded(Object aSource, RaidSystem aRaid, DirectAccessDeviceNode aAddedDisk) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.DISK_ADDED).create(aSource, aRaid, aAddedDisk);
    }

    public static RaidEvent createEventForDiskRemoved(Object aSource, RaidSystem aRaid, DirectAccessDeviceNode aRemovedDisk) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.DISK_REMOVED).create(aSource, aRaid, aRemovedDisk);
    }

    public static RaidEvent createEventForClusterRemoved(Object aSource, RaidSystem aRaid, ClusterNode aRemovedCluster) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.CLUSTER_REMOVED).create(aSource, aRaid, aRemovedCluster);
    }

    public static RaidEvent createEventForClusterDiscovery(Object aSource, RaidSystem aRaid, ClusterNode aDiscoveringCluster, RaidNode aRaidNode) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.CLUSTER_DISCOVERY).create(aSource, aRaid, aDiscoveringCluster, aRaidNode);
    }

    public static RaidEvent createEventForClusterAdded(Object aSource, RaidSystem aRaid, ClusterNode aAddedCluster) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.CLUSTER_ADDED).create(aSource, aRaid, aAddedCluster);
    }

    public static RaidEvent createEventForRaidNodeRemoved(Object aSource, RaidSystem aRaid, RaidNode aRemovedRaidNode, ClusterNode aCluster) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.RAID_NODE_REMOVED).create(aSource, aRaid, aRemovedRaidNode, aCluster);
    }

    public static RaidEvent createEventForRaidNodeAdded(Object aSource, RaidSystem aRaid, RaidNode aAddedRaidNode, ClusterNode aCluster) {
        return RaidEventFactory.getFactory(RaidEvent.CauseType.RAID_NODE_ADDED).create(aSource, aRaid, aAddedRaidNode, aCluster);
    }

    static {
        RaidEventFactory.putFactory(RaidEvent.EventType.RAID_CREATED, (RaidEvent.EventCreator)new RaidEvent.RaidCreatedOrRemovedSingleEventCreator(RaidEvent.EventType.RAID_CREATED));
        RaidEventFactory.putFactory(RaidEvent.EventType.RAID_REMOVED, (RaidEvent.EventCreator)new RaidEvent.RaidCreatedOrRemovedSingleEventCreator(RaidEvent.EventType.RAID_REMOVED));
        RaidEventFactory.putFactory(RaidEvent.EventType.RAID_ATTACHED, (RaidEvent.EventCreator)new RaidEvent.RaidCreatedOrRemovedSingleEventCreator(RaidEvent.EventType.RAID_ATTACHED));
        RaidEventFactory.putFactory(RaidEvent.EventType.RAID_DETACHED, (RaidEvent.EventCreator)new RaidEvent.RaidCreatedOrRemovedSingleEventCreator(RaidEvent.EventType.RAID_DETACHED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.DISK_ADDED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.DISK_ADDED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.DISK_REMOVED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.DISK_REMOVED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.DISK_STATUS_CHANGED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.DISK_STATUS_CHANGED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.CLUSTER_ADDED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.CLUSTER_ADDED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.CLUSTER_REMOVED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.CLUSTER_REMOVED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.CLUSTER_DISCOVERY, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.CLUSTER_DISCOVERY));
        RaidEventFactory.putFactory(RaidEvent.CauseType.RAID_NODE_ADDED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.RAID_NODE_ADDED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.RAID_NODE_REMOVED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.RAID_NODE_REMOVED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.RAID_STATUS_CHANGED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.RAID_STATUS_CHANGED));
        RaidEventFactory.putFactory(RaidEvent.CauseType.RAID_NAME_CHANGED, (RaidEvent.EventCreator)new RaidEvent.RaidChangedSingleEventCreator(RaidEvent.CauseType.RAID_NAME_CHANGED));
    }
}

