/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.event.raid;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import java.util.EventObject;

public class RaidEvent
extends EventObject {
    private RaidSystem myRaid = null;
    private EventType myType = null;
    private CauseType myCause = null;
    private DirectAccessDeviceNode myDiskCause = null;
    private ClusterNode myClusterCause = null;
    private RaidNode myRaidNodeCause = null;
    private static final long serialVersionUID = 7427121596988368294L;

    private RaidEvent(Object source, RaidSystem aRaid) {
        super(source);
        this.myRaid = aRaid;
    }

    private RaidEvent(Object source, RaidSystem aRaid, EventType aType) {
        this(source, aRaid);
        this.myType = aType;
    }

    private RaidEvent(Object source, RaidSystem aRaid, CauseType aCause) {
        this(source, aRaid, EventType.RAID_CHANGED);
        this.myCause = aCause;
    }

    public RaidSystem getRaid() {
        return this.myRaid;
    }

    public EventType getType() {
        return this.myType;
    }

    public CauseType getCause() {
        return this.myCause;
    }

    public void setDisk(DirectAccessDeviceNode aDisk) {
        this.myDiskCause = aDisk;
    }

    public DirectAccessDeviceNode getDisk() {
        return this.myDiskCause;
    }

    public void setCluster(ClusterNode aCluster) {
        this.myClusterCause = aCluster;
    }

    public ClusterNode getCluster() {
        return this.myClusterCause;
    }

    public void setNode(RaidNode aRaidNode) {
        this.myRaidNodeCause = aRaidNode;
    }

    public RaidNode getNode() {
        return this.myRaidNodeCause;
    }

    public static class RaidChangedSingleEventCreator
    extends EventCreator {
        protected RaidChangedSingleEventCreator(CauseType aType) {
            super(aType);
        }

        @Override
        protected RaidEvent create(Object aSource, RaidSystem aRaid, Object ... aAdditionalObjects) {
            if (CauseType.RAID_STATUS_CHANGED.equals((Object)((CauseType)((Object)this.myType)))) {
                return new RaidEvent(aSource, aRaid, (CauseType)((Object)this.myType));
            }
            if (CauseType.RAID_NAME_CHANGED.equals((Object)((CauseType)((Object)this.myType)))) {
                return new RaidEvent(aSource, aRaid, (CauseType)((Object)this.myType));
            }
            if (aAdditionalObjects == null) {
                throw new IllegalArgumentException("RaidEvent for RaidChange, additional objects should not be nulled");
            }
            DirectAccessDeviceNode disk = null;
            ClusterNode cluster = null;
            RaidNode raidNode = null;
            for (Object obj : aAdditionalObjects) {
                if (obj instanceof DirectAccessDeviceNode) {
                    disk = (DirectAccessDeviceNode)obj;
                }
                if (obj instanceof ClusterNode) {
                    cluster = (ClusterNode)obj;
                }
                if (!(obj instanceof RaidNode)) continue;
                raidNode = (RaidNode)obj;
            }
            RaidEvent e = new RaidEvent(aSource, aRaid, (CauseType)((Object)this.myType));
            switch ((CauseType)((Object)this.myType)) {
                case DISK_ADDED: 
                case DISK_REMOVED: 
                case DISK_STATUS_CHANGED: {
                    if (disk == null) {
                        throw new IllegalArgumentException("Creation of RAID Event with cause " + this.myType + " has missing disk");
                    }
                    e.setDisk(disk);
                    break;
                }
                case CLUSTER_ADDED: 
                case CLUSTER_REMOVED: {
                    if (cluster == null) {
                        throw new IllegalArgumentException("Creation of RAID Event with cause " + this.myType + " has missing cluster");
                    }
                    e.setCluster(cluster);
                    break;
                }
                case CLUSTER_DISCOVERY: 
                case RAID_NODE_ADDED: 
                case RAID_NODE_REMOVED: {
                    if (raidNode == null || cluster == null) {
                        throw new IllegalArgumentException("Creation of RAID Event with cause " + this.myType + " has missing cluster or raidNode. raidNode = " + raidNode + "; cluster = " + cluster);
                    }
                    e.setCluster(cluster);
                    e.setNode(raidNode);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("RaidEvent for RaidChange recieved unsupported Cause Type = " + this.myType);
                }
            }
            return e;
        }
    }

    public static class RaidCreatedOrRemovedSingleEventCreator
    extends EventCreator {
        protected RaidCreatedOrRemovedSingleEventCreator(EventType aType) {
            super(aType);
        }

        @Override
        protected RaidEvent create(Object aSource, RaidSystem aRaid, Object ... aAdditionalObjects) {
            return new RaidEvent(aSource, aRaid, (EventType)((Object)this.myType));
        }
    }

    public static abstract class EventCreator {
        protected Object myType = null;

        protected abstract RaidEvent create(Object var1, RaidSystem var2, Object ... var3);

        protected EventCreator(EventType aType) {
            this.myType = aType;
        }

        protected EventCreator(CauseType aCauseType) {
            this.myType = aCauseType;
        }
    }

    public static enum CauseType {
        DISK_STATUS_CHANGED,
        DISK_REMOVED,
        DISK_ADDED,
        CLUSTER_ADDED,
        CLUSTER_REMOVED,
        CLUSTER_DISCOVERY,
        RAID_NODE_ADDED,
        RAID_NODE_REMOVED,
        RAID_STATUS_CHANGED,
        RAID_NAME_CHANGED;

    }

    public static enum EventType {
        RAID_REMOVED,
        RAID_CREATED,
        RAID_CHANGED,
        RAID_ATTACHED,
        RAID_DETACHED;

    }
}

