/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.udp;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPStatisticsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.util.SrEventListenerManager;
import java.util.HashMap;

public class UDPStatisticsManager
extends StatisticsManager<UDPStatisticsNode> {
    private static UDPStatisticsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<UDPStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(UDPStatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };

    private UDPStatisticsManager() {
    }

    public static synchronized UDPStatisticsManager getInstance() {
        if (m_instance == null) {
            m_instance = new UDPStatisticsManager();
        }
        return m_instance;
    }

    public void addUDPStatisticsListener(UDPStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeUDPStatisticsListener(UDPStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = e.getParameterList();
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            UDPStatisticsNode node = (UDPStatisticsNode)obj;
            this.fireUDPStatisticsChanged(node, map);
        }
    }

    private void fireUDPStatisticsChanged(UDPStatisticsNode node, HashMap changedValsMap) {
        StatisticsEvent event = new StatisticsEvent((Object)this, (Object)node, changedValsMap);
        this.m_listeners.fireEvent(UDPStatisticsListener.class, event, this.statisticsElementChangedInformer);
    }
}

