/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.udp;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPListenerTableRow;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPListenerTableEvent;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPListenerTableListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPListenerStatisticsTableRow;
import com.sanrad.util.SrEventListenerManager;
import java.net.Inet4Address;
import java.rmi.RemoteException;
import java.util.HashMap;

public class UDPListenerManager
extends ElementManager {
    private static UDPListenerManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer newTableRowCreatedInformer = new SrEventListenerManager.Informer<UDPListenerTableListener, UDPListenerTableEvent>(){

        @Override
        public void inform(UDPListenerTableListener listener, UDPListenerTableEvent event) {
            listener.newTableRowCreated(event);
        }
    };
    SrEventListenerManager.Informer tableRowRemovedInformer = new SrEventListenerManager.Informer<UDPListenerTableListener, UDPListenerTableEvent>(){

        @Override
        public void inform(UDPListenerTableListener listener, UDPListenerTableEvent event) {
            listener.tableRowRemoved(event);
        }
    };

    private UDPListenerManager() {
    }

    public static synchronized UDPListenerManager getInstance() {
        if (m_instance == null) {
            m_instance = new UDPListenerManager();
        }
        return m_instance;
    }

    public void addUDPListenerTableListener(UDPListenerTableListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeUDPListenerTableListener(UDPListenerTableListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            if (this.alreadyExist(element)) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "UDP Listener row created.");
            UDPListenerStatisticsTableRow rowStub = (UDPListenerStatisticsTableRow)element;
            HashMap map = this.getParameterList(e);
            Inet4Address addressObj = (Inet4Address)this.getObjectForParam(map, ClientParameterCode.UDP_LISTENER_ADDRESS, true);
            Integer portObj = (Integer)this.getObjectForParam(map, ClientParameterCode.UDP_LISTENER_PORT, true);
            VSwitch parentStub = null;
            parentStub = rowStub.getParentVSwitch();
            UDPListenerTableRow row = new UDPListenerTableRow(rowStub, parentStub, addressObj, portObj);
            SystemRootNode.getInstance().putRefAndStub(rowStub, row);
            this.fireUDPListenerTableRowCreated(row);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            UDPListenerManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "UDP Listener Table row removed .");
        UDPListenerStatisticsTableRow rowStub = (UDPListenerStatisticsTableRow)element;
        SrTreeNode row = SystemRootNode.getInstance().getRefByStub(rowStub);
        if (row != null) {
            VSwitch vswitch = ((UDPListenerTableRow)row).getParentStub();
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(vswitch);
            if (node != null) {
                ((VSwitchNode)node).getUDPListenersTable().remove(row);
                this.fireUDPListenerTableRowRemoved((UDPListenerTableRow)row);
            }
        }
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    private void fireUDPListenerTableRowCreated(UDPListenerTableRow row) {
        UDPListenerTableEvent event = new UDPListenerTableEvent(row);
        theLogger.trace(SrLogCategories.LEGACY, "fire event: UDP Listener Table row created .");
        this.m_listeners.fireEvent(UDPListenerTableListener.class, event, this.newTableRowCreatedInformer);
    }

    private void fireUDPListenerTableRowRemoved(UDPListenerTableRow row) {
        UDPListenerTableEvent event = new UDPListenerTableEvent(row);
        theLogger.trace(SrLogCategories.LEGACY, "fire event: UDP Listener Table row removed .");
        this.m_listeners.fireEvent(UDPListenerTableListener.class, event, this.tableRowRemovedInformer);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }
}

