/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.udp;

import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.udp.SrUPDListenerTableHeader;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPListenerManager;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPListenerTableRow;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPListenerTableEvent;
import com.sanrad.nms.client.event.vswitch.statistics.udp.UDPListenerTableListener;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPListenerStatisticsTableRow;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrUPDListenerTableModel
extends SrTableModel
implements UDPListenerTableListener {
    public SrUPDListenerTableModel(VSwitchNode vswitchNode) {
        super(new SrDefaultTableColumns(SrUPDListenerTableHeader.getColumnNames()));
        this.initModel(vswitchNode.getUDPListenersTable());
    }

    private void initModel(Vector listenerTable) {
        if (listenerTable != null) {
            for (int index = 0; index < listenerTable.size(); ++index) {
                UDPListenerTableRow row = (UDPListenerTableRow)listenerTable.get(index);
                this.addNewRow(row);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    private void addNewRow(UDPListenerTableRow row) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(row.getStub());
        rowData.addElement(row.getAddress());
        rowData.addElement(row.getPort());
        this.addRowQuetly(rowData.toArray(), -1);
    }

    @Override
    public void newTableRowCreated(UDPListenerTableEvent e) {
        UDPListenerTableRow newRow = (UDPListenerTableRow)e.getSource();
        this.addNewRow(newRow);
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    @Override
    public void tableRowRemoved(UDPListenerTableEvent e) {
        UDPListenerTableRow row = (UDPListenerTableRow)e.getSource();
        int stubCol = this.getColumnIndex(SrUPDListenerTableHeader.STUB.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object stub = this.getValueAt(i, stubCol);
            if (!((UDPListenerStatisticsTableRow)row.getStub()).equals(stub)) continue;
            this.removeRow(i);
            break;
        }
    }

    @Override
    public void removeListeners() {
        UDPListenerManager.getInstance().removeUDPListenerTableListener(this);
    }

    @Override
    public void addListeners() {
        UDPListenerManager.getInstance().addUDPListenerTableListener(this);
    }
}

