/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.tcp;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPStatisticsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.util.SrEventListenerManager;
import java.util.HashMap;

public class TCPStatisticsManager
extends StatisticsManager<TCPStatisticsNode> {
    private static TCPStatisticsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<TCPStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(TCPStatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };

    private TCPStatisticsManager() {
    }

    public static synchronized TCPStatisticsManager getInstance() {
        if (m_instance == null) {
            m_instance = new TCPStatisticsManager();
        }
        return m_instance;
    }

    public void addTCPStatisticsListener(TCPStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeTCPStatisticsListener(TCPStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = e.getParameterList();
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            TCPStatisticsNode node = (TCPStatisticsNode)obj;
            this.fireTCPStatisticsChanged(node, map);
        }
    }

    private void fireTCPStatisticsChanged(TCPStatisticsNode node, HashMap changedValsMaps) {
        StatisticsEvent event = new StatisticsEvent((Object)this, (Object)node, changedValsMaps);
        this.m_listeners.fireEvent(TCPStatisticsListener.class, event, this.statisticsElementChangedInformer);
    }
}

