/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.tcp;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPConnectionsTableRow;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPConnectionTableEvent;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPConnectionTableListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRow;
import com.sanrad.nms.server.util.types.constants.TCPConStateConstant;
import com.sanrad.util.SrEventListenerManager;
import java.net.Inet4Address;
import java.rmi.RemoteException;
import java.util.HashMap;

public class TCPConnectionsManager
extends ElementManager {
    private static TCPConnectionsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer newTableRowCreatedInformer = new SrEventListenerManager.Informer<TCPConnectionTableListener, TCPConnectionTableEvent>(){

        @Override
        public void inform(TCPConnectionTableListener listener, TCPConnectionTableEvent event) {
            listener.newTableRowCreated(event);
        }
    };
    SrEventListenerManager.Informer tableRowChangedInformer = new SrEventListenerManager.Informer<TCPConnectionTableListener, TCPConnectionTableEvent>(){

        @Override
        public void inform(TCPConnectionTableListener listener, TCPConnectionTableEvent event) {
            listener.tableRowChanged(event);
        }
    };
    SrEventListenerManager.Informer tableRowRemovedInformer = new SrEventListenerManager.Informer<TCPConnectionTableListener, TCPConnectionTableEvent>(){

        @Override
        public void inform(TCPConnectionTableListener listener, TCPConnectionTableEvent event) {
            listener.tableRowRemoved(event);
        }
    };

    private TCPConnectionsManager() {
    }

    public static synchronized TCPConnectionsManager getInstance() {
        if (m_instance == null) {
            m_instance = new TCPConnectionsManager();
        }
        return m_instance;
    }

    public void addTCPConnectionTableListener(TCPConnectionTableListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeTCPConnectionTableListener(TCPConnectionTableListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "TCP Connections Table row removed .");
        TCPConnectionStatisticsTableRow rowStub = (TCPConnectionStatisticsTableRow)element;
        SrTreeNode row = SystemRootNode.getInstance().getRefByStub(rowStub);
        if (row != null) {
            VSwitch vswitch = ((TCPConnectionsTableRow)row).getParentStub();
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(vswitch);
            if (node != null) {
                ((VSwitchNode)node).getTCPConnectionsTable().remove(row);
                this.fireTCPConnectionTableRowRemoved((TCPConnectionsTableRow)row);
            }
        }
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "TCPConnectionsManager: TCP Connections Table row changed .");
        HashMap params = this.getParameterList(e);
        Object state = this.getObjectForParam(params, ClientParameterCode.TCP_CONNECTION_STATE, false);
        if (state != null) {
            theLogger.trace(SrLogCategories.LEGACY, "TCPConnectionsManager: TCP Connections Table row state is changed - ", state);
            SrTreeNode tcpConnectionsTableRow = SystemRootNode.getInstance().getRefByStub(element);
            if (tcpConnectionsTableRow != null) {
                ((TCPConnectionsTableRow)tcpConnectionsTableRow).setState((TCPConStateConstant)state);
            }
            this.fireTCPConnectionTableRowChanged((TCPConnectionsTableRow)tcpConnectionsTableRow);
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        try {
            theLogger.trace(SrLogCategories.LEGACY, "TCP Connections row created .");
            TCPConnectionStatisticsTableRow rowStub = (TCPConnectionStatisticsTableRow)element;
            HashMap map = this.getParameterList(e);
            Inet4Address localAddressObj = (Inet4Address)this.getObjectForParam(map, ClientParameterCode.TCP_CONNECTION_LOCAL_ADDRESS, true);
            Integer localPortObj = (Integer)this.getObjectForParam(map, ClientParameterCode.TCP_CONNECTION_LOCAL_PORT, true);
            Inet4Address remoreAddressObj = (Inet4Address)this.getObjectForParam(map, ClientParameterCode.TCP_CONNECTION_REMOTE_ADDRESS, true);
            Integer remotePortObj = (Integer)this.getObjectForParam(map, ClientParameterCode.TCP_CONNECTION_REMOTE_PORT, true);
            TCPConStateConstant stateObj = (TCPConStateConstant)this.getObjectForParam(map, ClientParameterCode.TCP_CONNECTION_STATE, true);
            VSwitch parentStub = rowStub.getParentVSwitch();
            TCPConnectionsTableRow row = new TCPConnectionsTableRow(rowStub, parentStub, localAddressObj, localPortObj, remoreAddressObj, remotePortObj, stateObj);
            SystemRootNode.getInstance().putRefAndStub(rowStub, row);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(rowStub.getParentVSwitch());
            if (node != null) {
                VSwitchNode vswitchNode = (VSwitchNode)node;
                vswitchNode.getTCPConnectionsTable().addElement(row);
                theLogger.trace(SrLogCategories.LEGACY, "Add TCP connection - ", "Local Address: ", localAddressObj, " Local Port: ", localPortObj, " Remote Address: ", remoreAddressObj, " Remote Port: ", remotePortObj, " State: ", stateObj, " to ", ClientLoader.VSWITCH_DISPLAY_STRING, " - ", vswitchNode.getName());
            }
            this.fireTCPConnectionTableRowCreated(row);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            TCPConnectionsManager.onConnectionError("Failed to create IP.");
        }
    }

    private void fireTCPConnectionTableRowCreated(TCPConnectionsTableRow row) {
        TCPConnectionTableEvent event = new TCPConnectionTableEvent((Object)row, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: TCP Connections Table row created .");
        this.m_listeners.fireEvent(TCPConnectionTableListener.class, event, this.newTableRowCreatedInformer);
    }

    private void fireTCPConnectionTableRowChanged(TCPConnectionsTableRow row) {
        TCPConnectionTableEvent event = new TCPConnectionTableEvent((Object)row, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: TCP Connections Table row changed .");
        this.m_listeners.fireEvent(TCPConnectionTableListener.class, event, this.tableRowChangedInformer);
    }

    private void fireTCPConnectionTableRowRemoved(TCPConnectionsTableRow row) {
        TCPConnectionTableEvent event = new TCPConnectionTableEvent((Object)row, (RemoteObject)row.getStub(), row.getParentStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire event: TCP Connections Table row removed .");
        this.m_listeners.fireEvent(TCPConnectionTableListener.class, event, this.tableRowRemovedInformer);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }
}

