/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.tcp;

import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPConnectionsManager;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPConnectionsTableRow;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPConnectionTableEvent;
import com.sanrad.nms.client.event.vswitch.statistics.tcp.TCPConnectionTableListener;
import com.sanrad.nms.client.gui.vswitch.statistics.tcp.TCPStatisticsConnectionsTableHeader;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRow;
import com.sanrad.nms.server.util.types.constants.TCPConStateConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrTCPStatisticsConnectionsTableModel
extends SrTableModel
implements TCPConnectionTableListener {
    private VSwitchNode m_vSwitchNode;

    public SrTCPStatisticsConnectionsTableModel(VSwitchNode vSwitchNode) {
        super(new SrDefaultTableColumns(TCPStatisticsConnectionsTableHeader.getColumnNames()));
        this.m_vSwitchNode = vSwitchNode;
        this.initModel(vSwitchNode.getTCPConnectionsTable());
    }

    @Override
    public void addListeners() {
        TCPConnectionsManager.getInstance().addTCPConnectionTableListener(this);
    }

    @Override
    public void removeListeners() {
        TCPConnectionsManager.getInstance().removeTCPConnectionTableListener(this);
    }

    private void initModel(Vector connectionsTable) {
        if (connectionsTable != null) {
            for (int index = 0; index < connectionsTable.size(); ++index) {
                TCPConnectionsTableRow row = (TCPConnectionsTableRow)connectionsTable.get(index);
                this.addNewRow(row);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    private void addNewRow(TCPConnectionsTableRow row) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(row.getStub());
        rowData.addElement(row.getLocalAddress());
        rowData.addElement(row.getLocalPort());
        rowData.addElement(row.getRemoteAddress());
        rowData.addElement(row.getRemotePort());
        rowData.addElement(row.getState());
        this.addRowQuetly(rowData.toArray(), -1);
    }

    @Override
    public void newTableRowCreated(TCPConnectionTableEvent e) {
        if (this.verifySameVSwitch(e.getParentStub())) {
            TCPConnectionsTableRow newRow = (TCPConnectionsTableRow)e.getSource();
            this.addNewRow(newRow);
            this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
        }
    }

    @Override
    public void tableRowChanged(TCPConnectionTableEvent e) {
        TCPConnectionsTableRow row = (TCPConnectionsTableRow)e.getSource();
        TCPConStateConstant state = row.getState();
        int stateCol = this.getColumnIndex(TCPStatisticsConnectionsTableHeader.STATE.getColumnName());
        int stubCol = this.getColumnIndex(TCPStatisticsConnectionsTableHeader.STUB.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object stub = this.getValueAt(i, stubCol);
            if (!((TCPConnectionStatisticsTableRow)row.getStub()).equals(stub)) continue;
            this.setValueAt(state, i, stateCol);
            break;
        }
    }

    @Override
    public void tableRowRemoved(TCPConnectionTableEvent e) {
        TCPConnectionsTableRow row = (TCPConnectionsTableRow)e.getSource();
        int stubCol = this.getColumnIndex(TCPStatisticsConnectionsTableHeader.STUB.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object stub = this.getValueAt(i, stubCol);
            if (!((TCPConnectionStatisticsTableRow)row.getStub()).equals(stub)) continue;
            this.removeRow(i);
            break;
        }
    }

    private boolean verifySameVSwitch(Object vswitchStub) {
        return vswitchStub.equals(this.m_vSwitchNode.getStub());
    }
}

