/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.ip;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.ip.IPStatisticsNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.ip.IPStatisticsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.util.SrEventListenerManager;
import java.util.HashMap;

public class IPStatisticsManager
extends StatisticsManager<IPStatisticsNode> {
    private static IPStatisticsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<IPStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(IPStatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };

    private IPStatisticsManager() {
    }

    public static synchronized IPStatisticsManager getInstance() {
        if (m_instance == null) {
            m_instance = new IPStatisticsManager();
        }
        return m_instance;
    }

    public void addIPStatisticsListener(IPStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeIPStatisticsListener(IPStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = e.getParameterList();
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            IPStatisticsNode node = (IPStatisticsNode)obj;
            this.fireIPStatisticsChanged(node, map);
        }
    }

    private void fireIPStatisticsChanged(IPStatisticsNode node, HashMap changedValsMap) {
        StatisticsEvent event = new StatisticsEvent((Object)this, (Object)node, changedValsMap);
        this.m_listeners.fireEvent(IPStatisticsListener.class, event, this.statisticsElementChangedInformer);
    }
}

