/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.interfaces;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.InterfaceManager;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.SrInterfacesStatisticsTableColumns;
import com.sanrad.nms.client.event.InterfaceEvent;
import com.sanrad.nms.client.event.InterfaceListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfacesStatisticsListener;
import com.sanrad.nms.client.gui.vswitch.statistics.interfaces.InterfacesStatisticsTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.StorageSize;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SrInterfacesStatisticsTableModel
extends SrTableModel
implements InterfaceListener,
InterfacesStatisticsListener {
    private VSwitchNode m_vswitchNode;
    private Vector m_allInterfacesStatisticsNodes;
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrInterfacesStatisticsTableModel(VSwitchNode vswitchNode) {
        super(new SrInterfacesStatisticsTableColumns());
        this.m_vswitchNode = vswitchNode;
        this.m_allInterfacesStatisticsNodes = this.m_vswitchNode.getInterfacesStatisticsTableNodes();
        this.initModel(this.m_vswitchNode.getInterfaceTable());
    }

    @Override
    public void removeListeners() {
        InterfaceManager.getInstance().removeInterfaceListener(this);
        InterfacesStatisticsManager.getInstance().removeInterfacesStatisticsListener(this);
    }

    @Override
    public void addListeners() {
        InterfaceManager.getInstance().addInterfaceListener(this);
        InterfacesStatisticsManager.getInstance().addInterfacesStatisticsListener(this);
    }

    private void initModel(List<InterfaceTableRowNode> interfaceTable) {
        this.removeAllRows();
        for (int index = 0; index < interfaceTable.size(); ++index) {
            Vector<Object> rowData = new Vector<Object>();
            InterfaceTableRowNode row = interfaceTable.get(index);
            if (row != null && row.getType() != null) {
                if (!row.getType().equals(IANAifTypeConstant.IANA_IF_TYPE_FC.toDisplayString()) && !row.getType().equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI.toDisplayString()) && !row.getType().equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET.toDisplayString())) continue;
                rowData.addElement(new AliasObject(row.getAlias(), row.getStub()));
                rowData.addElement("0/0");
                rowData.addElement("0/0");
                rowData.addElement("0");
                this.addRowQuetly(rowData.toArray(), -1);
                continue;
            }
            theLogger.warn(SrLogCategories.LEGACY, "SrInterfacesStatisticsTableModel: InterfaceTableRow is null");
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    public void interfaceTableRowCreated(InterfaceEvent e) {
    }

    @Override
    public void interfaceTableRowChanged(InterfaceEvent e) {
        RemoteObject stub = e.getStub();
        int col = this.getColumnIndex(InterfacesStatisticsTableHeader.ALIAS.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            List<Object> rowData = this.getRow(i);
            AliasObject aliasObject = (AliasObject)rowData.get(col);
            InterfaceTableRow row = (InterfaceTableRow)aliasObject.getAdditionalValue();
            if (!row.equals(stub)) continue;
            if (!aliasObject.getValue().equals(e.getAlias())) {
                aliasObject.setValue(e.getAlias());
                this.fireTableRowsUpdated(i, i);
            }
            return;
        }
    }

    @Override
    public void interfaceTableRowParameterChanged(InterfaceEvent e) {
    }

    @Override
    public void interfaceTableRowOperStatusChanged(InterfaceEvent e) {
    }

    private HashMap getCurrentRowHashCounters(AliasObject currentRowAlias, Vector changedValsMaps) {
        for (int index = 0; index < changedValsMaps.size(); ++index) {
            HashMap currentRowHashCounters = (HashMap)changedValsMaps.elementAt(index);
            if (!currentRowAlias.getValue().equals(currentRowHashCounters.get(ClientParameterCode.INTERFACE_ALIAS))) continue;
            changedValsMaps.remove(currentRowHashCounters);
            return currentRowHashCounters;
        }
        return null;
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        InterfacesStatisticsNode statisticsNode = (InterfacesStatisticsNode)e.getStatisticsNode();
        HashMap changedValsMap = statisticsNode.getChangedValues();
        InterfaceTableRow interfaceRowStub = (InterfaceTableRow)changedValsMap.get(ClientParameterCode.INTERFACE_ID);
        int rows = this.getRowCount();
        int aliasCol = this.getColumnIndex(InterfacesStatisticsTableHeader.ALIAS.getColumnName());
        int octetsInOutCol = this.getColumnIndex(InterfacesStatisticsTableHeader.OCTETS_IN_OUT.getColumnName());
        int errorsInOutCol = this.getColumnIndex(InterfacesStatisticsTableHeader.ERRORS_IN_OUT.getColumnName());
        int discontinuityCol = this.getColumnIndex(InterfacesStatisticsTableHeader.DISCONTINUITY.getColumnName());
        for (int i = 0; i < rows; ++i) {
            AliasObject currentRowAlias = (AliasObject)this.getValueAt(i, aliasCol);
            if (!currentRowAlias.getAdditionalValue().equals(interfaceRowStub)) continue;
            String currentOctetsInOutGuiVal = (String)this.getValueAt(i, octetsInOutCol);
            String currentErrorsInOutGuiVal = (String)this.getValueAt(i, errorsInOutCol);
            String currentDiscontinuityGuiVal = (String)this.getValueAt(i, discontinuityCol);
            String currentOctetsIn = currentOctetsInOutGuiVal != null ? currentOctetsInOutGuiVal.substring(0, currentOctetsInOutGuiVal.indexOf(47)) : "";
            String currentOctetsOut = currentOctetsInOutGuiVal != null ? currentOctetsInOutGuiVal.substring(currentOctetsInOutGuiVal.indexOf(47) + 1) : "";
            String currentErrorsIn = currentErrorsInOutGuiVal != null ? currentErrorsInOutGuiVal.substring(0, currentErrorsInOutGuiVal.indexOf(47)) : "";
            String currentErrorsOut = currentErrorsInOutGuiVal != null ? currentErrorsInOutGuiVal.substring(currentErrorsInOutGuiVal.indexOf(47) + 1) : "";
            BigInteger octetsInVal = (BigInteger)changedValsMap.get(ClientParameterCode.IFC_STATISTICS_IN_OCTETS);
            BigInteger octetsOutVal = (BigInteger)changedValsMap.get(ClientParameterCode.IFC_STATISTICS_OUT_OCTETS);
            BigInteger errorsInVal = (BigInteger)changedValsMap.get(ClientParameterCode.IFC_STATISTICS_IN_ERRORS);
            BigInteger errorsOutVal = (BigInteger)changedValsMap.get(ClientParameterCode.IFC_STATISTICS_OUT_ERRORS);
            Long discontinuityVal = (Long)changedValsMap.get(ClientParameterCode.IFC_STATISTICS_DISCONTINUITY_TIME);
            BigDecimal mega = new BigDecimal(StorageSize.MEGA.getValue());
            if (octetsInVal != null || octetsOutVal != null) {
                String newOctetsInVal = octetsInVal == null ? currentOctetsIn : octetsInVal.toString();
                String newOctetsOutVal = octetsOutVal == null ? currentOctetsOut : octetsOutVal.toString();
                BigDecimal inMb = new BigDecimal(newOctetsInVal);
                inMb = inMb.multiply(new BigDecimal(8));
                inMb = inMb.divide(mega, 3, 6);
                BigDecimal outMb = new BigDecimal(newOctetsOutVal);
                outMb = outMb.multiply(new BigDecimal(8));
                outMb = outMb.divide(mega, 3, 6);
                currentOctetsInOutGuiVal = inMb + "/" + outMb;
                this.setValueAt(currentOctetsInOutGuiVal, i, octetsInOutCol);
            }
            if (errorsInVal != null || errorsOutVal != null) {
                String newErrorsInVal = errorsInVal == null ? currentErrorsIn : errorsInVal.toString();
                String newErrorsOutVal = errorsOutVal == null ? currentErrorsOut : errorsOutVal.toString();
                currentErrorsInOutGuiVal = newErrorsInVal + "/" + newErrorsOutVal;
                this.setValueAt(currentErrorsInOutGuiVal, i, errorsInOutCol);
            }
            if (discontinuityVal == null) continue;
            currentDiscontinuityGuiVal = discontinuityVal == null ? currentDiscontinuityGuiVal : discontinuityVal.toString();
            this.setValueAt(currentDiscontinuityGuiVal, i, discontinuityCol);
        }
    }

    public Vector getInterfacesStatisticsTableNodes() {
        return this.m_allInterfacesStatisticsNodes;
    }
}

