/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.interfaces;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.statistics.StatisticsNode;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRow;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Set;

public class InterfacesStatisticsNode
extends StatisticsNode<InterfaceStatisticsTableRow> {
    private HashMap m_allSetOfValuesForInterfaceStatistics = new HashMap();
    private String m_interfaceType;
    private HashMap m_values = new HashMap();
    private static SrLogger theLogger = SrLogger.getLogger();

    public InterfacesStatisticsNode(InterfaceStatisticsTableRow stub, VSwitchNode aVswitchNode) throws RemoteException {
        super(stub, aVswitchNode);
        this.initValues();
    }

    public String interfaceAlias() {
        try {
            return ((InterfaceStatisticsTableRow)this.getStub()).getInterfaceAlias();
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            return null;
        }
    }

    private void initValues() {
        try {
            this.m_interfaceType = ((InterfaceStatisticsTableRow)this.getStub()).getInterfaceType();
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
        }
        boolean isPSCSIInterface = this.m_interfaceType.equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI.getDescriptionName());
        boolean isFCInterface = this.m_interfaceType.equals(IANAifTypeConstant.IANA_IF_TYPE_FC.getDescriptionName());
        this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_DISCONTINUITY_TIME, new Long(0L));
        if (!isPSCSIInterface) {
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_OCTETS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_OCTETS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_ERRORS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_ERRORS, BigInteger.valueOf(0L));
        } else {
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_OCTETS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_OCTETS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_ERRORS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_ERRORS, "NA");
        }
        if (!isPSCSIInterface && !isFCInterface) {
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_UNICAST_PACKETS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_UNICAST_PACKETS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_DISCARDS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_DISCARDS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_MULTICAST_PACKETS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_MULTICAST_PACKETS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_BROADCAST_PACKETS, BigInteger.valueOf(0L));
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_BROADCAST_PACKETS, BigInteger.valueOf(0L));
        } else {
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_UNICAST_PACKETS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_UNICAST_PACKETS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_DISCARDS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_DISCARDS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_MULTICAST_PACKETS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_MULTICAST_PACKETS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_IN_BROADCAST_PACKETS, "NA");
            this.m_allSetOfValuesForInterfaceStatistics.put(ClientParameterCode.IFC_STATISTICS_OUT_BROADCAST_PACKETS, "NA");
        }
    }

    public String getInterfaceType() {
        return this.m_interfaceType;
    }

    public void setChangedValues(HashMap values) {
        if (values != null) {
            this.m_values.clear();
            this.m_values.putAll(values);
        }
        if (values != null) {
            Set keys = values.keySet();
            for (ClientParameterCode key : keys) {
                this.m_allSetOfValuesForInterfaceStatistics.put(key, values.get(key));
            }
        }
    }

    public HashMap getAllSetOfValuesForInterface() {
        return this.m_allSetOfValuesForInterfaceStatistics;
    }

    public HashMap getChangedValues() {
        return this.m_values;
    }

    @Override
    public String toString() {
        try {
            return "Interface Statistics Node: " + ((InterfaceStatisticsTableRow)this.getStub()).getInterfaceAlias();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return "Interface Statistics Node";
        }
    }
}

