/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.interfaces;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.statistics.StatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesGroupStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.statistics.interfaces.InterfacesStatisticsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.util.SrEventListenerManager;
import java.util.HashMap;

public class InterfacesStatisticsManager
extends StatisticsManager<InterfacesGroupStatisticsNode> {
    private static InterfacesStatisticsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<InterfacesStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(InterfacesStatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };

    private InterfacesStatisticsManager() {
    }

    public static synchronized InterfacesStatisticsManager getInstance() {
        if (m_instance == null) {
            m_instance = new InterfacesStatisticsManager();
        }
        return m_instance;
    }

    public void addInterfacesStatisticsListener(InterfacesStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeInterfacesStatisticsListener(InterfacesStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = e.getParameterList();
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            InterfacesStatisticsNode node = (InterfacesStatisticsNode)obj;
            node.setChangedValues(map);
            this.fireInterfacesStatisticsChanged(node, map);
        }
    }

    private void fireInterfacesStatisticsChanged(InterfacesStatisticsNode node, HashMap changedValsMap) {
        StatisticsEvent event = new StatisticsEvent((Object)this, (Object)node, changedValsMap);
        this.m_listeners.fireEvent(InterfacesStatisticsListener.class, event, this.statisticsElementChangedInformer);
    }
}

