/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.statistics.ethernet;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.statistics.ethernet.EthernetStatisticsNode;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.statistics.StatisticsListener;
import com.sanrad.nms.client.event.vswitch.statistics.ethernet.EthernetStatisticsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.util.SrEventListenerManager;
import java.util.HashMap;

public class EthernetStatisticsManager
extends ElementManager {
    private static EthernetStatisticsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<StatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(StatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };

    private EthernetStatisticsManager() {
    }

    public static synchronized EthernetStatisticsManager getInstance() {
        if (m_instance == null) {
            m_instance = new EthernetStatisticsManager();
        }
        return m_instance;
    }

    public void addEthernetStatisticsListener(EthernetStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeEthernetStatisticsListener(EthernetStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = this.getParameterList(e);
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            EthernetStatisticsNode node = (EthernetStatisticsNode)obj;
            this.fireEthernetStatisticsChanged(node, map);
        }
    }

    private void fireEthernetStatisticsChanged(EthernetStatisticsNode node, HashMap changedValsMap) {
        StatisticsEvent event = new StatisticsEvent((Object)this, (Object)node, changedValsMap);
        this.m_listeners.fireEvent(StatisticsListener.class, event, this.statisticsElementChangedInformer);
    }
}

