/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.interfaces.fc;

import java.util.Vector;

public class FCTopologyConstants
implements Comparable {
    private static Vector<FCTopologyConstants> topologies = new Vector();
    public static final FCTopologyConstants FABRIC_MODE = new FCTopologyConstants(1, "Fabric");
    public static final FCTopologyConstants P2P_MODE = new FCTopologyConstants(2, "P2P");
    public static final FCTopologyConstants PUBLIC_MODE = new FCTopologyConstants(3, "Public Loop");
    public static final FCTopologyConstants PRIVATE_MODE = new FCTopologyConstants(4, "Private Loop");
    public static final FCTopologyConstants AUTO_TOPOLOGY_MODE = new FCTopologyConstants(5, "Auto Topology");
    private int counter;
    private String value;

    private FCTopologyConstants(int counter, String value) {
        this.counter = counter;
        this.value = value;
        topologies.addElement(this);
    }

    public String getMode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FCTopologyConstants) {
            return ((FCTopologyConstants)obj).counter == this.counter;
        }
        return false;
    }

    public static Vector<FCTopologyConstants> getTopologies() {
        return topologies;
    }

    public static FCTopologyConstants getTopology(String topology) {
        for (int i = 0; i < topologies.size(); ++i) {
            FCTopologyConstants constant = topologies.get(i);
            if (!constant.value.equalsIgnoreCase(topology)) continue;
            return constant;
        }
        return null;
    }

    public static FCTopologyConstants getTopology(Integer topology) {
        for (int i = 0; i < topologies.size(); ++i) {
            FCTopologyConstants constant = topologies.get(i);
            if (constant.counter != topology) continue;
            return constant;
        }
        return null;
    }

    public String toString() {
        return this.value;
    }

    public int compareTo(Object o) {
        int answer = Integer.MIN_VALUE;
        if (o instanceof FCTopologyConstants) {
            FCTopologyConstants comp2 = (FCTopologyConstants)o;
            String val1 = this.getMode();
            answer = val1.compareTo(comp2.getMode());
        }
        return answer;
    }
}

