/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.PortalManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.SrTargetPortalTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.PortalEvent;
import com.sanrad.nms.client.event.PortalListener;
import com.sanrad.nms.client.gui.vswitch.dialogs.PortalTableHeader;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.List;
import java.util.Vector;

public class SrPortalTableModel
extends SrTableModel
implements PortalListener {
    private VSwitchNode m_vSwitchNode;

    public SrPortalTableModel(VSwitchNode vSwitchNode) {
        super(new SrDefaultTableColumns(PortalTableHeader.getColumnNames()));
        if (vSwitchNode != null) {
            this.init(vSwitchNode);
        }
    }

    @Override
    public void removeListeners() {
        PortalManager.getInstance().removePortalListener(this);
    }

    @Override
    public void addListeners() {
        PortalManager.getInstance().addPortalListener(this);
    }

    private void init(VSwitchNode vSwitchNode) {
        this.m_vSwitchNode = vSwitchNode;
        Vector<PortalTableRow> portalTable = vSwitchNode.getPortalTable();
        this.initModel(portalTable);
    }

    private void initModel(Vector portalTable) {
        this.removeAllRows();
        if (portalTable != null) {
            for (int i = 0; i < portalTable.size(); ++i) {
                Vector<Object> rowData = new Vector<Object>();
                PortalTableRow row = (PortalTableRow)portalTable.get(i);
                rowData.addElement(new AliasObject(row.getIPAddress(), row));
                if (row.isPortalRoleIncludeTarget()) {
                    rowData.addElement(((SrTargetPortalTableRow)row).getPort());
                    if (row.getTag() == null) {
                        rowData.addElement(ClientLoader.NOT_AVAILABLE);
                    } else {
                        rowData.addElement(row.getTag());
                    }
                } else {
                    rowData.addElement(ClientLoader.NOT_AVAILABLE);
                    rowData.addElement(ClientLoader.NOT_AVAILABLE);
                }
                rowData.addElement(row.getRole());
                this.addRowQuetly(rowData.toArray(), -1);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    public boolean listIsEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public void portalTableRowCreated(PortalEvent e) {
        SrTreeNode node;
        VSwitch parentStub = e.getParentStub();
        if (this.verifySameVSwitch(parentStub) && (node = SystemRootNode.getInstance().getRefByStub(parentStub)) != null) {
            Vector<PortalTableRow> portalTable = ((VSwitchNode)node).getPortalTable();
            this.initModel(portalTable);
        }
    }

    @Override
    public void portalTableRowRemoved(PortalEvent e) {
        SrTreeNode node;
        VSwitch parentStub = e.getParentStub();
        if (this.verifySameVSwitch(parentStub) && (node = SystemRootNode.getInstance().getRefByStub(parentStub)) != null) {
            Vector<PortalTableRow> portalTable = ((VSwitchNode)node).getPortalTable();
            this.initModel(portalTable);
        }
    }

    private boolean verifySameVSwitch(Object vswitchStub) {
        return vswitchStub.equals(this.m_vSwitchNode.getStub());
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object col2;
        Object col1;
        block13: {
            Object obj2;
            block12: {
                boolean isTableSortByTag;
                if (o1 == null && this.m_sortOrder == 0) {
                    return this.order(-1);
                }
                if (o2 == null) {
                    return this.order(1);
                }
                List list1 = (List)o1;
                List list2 = (List)o2;
                Object obj1 = list1.get(this.m_sortColumn);
                obj2 = list2.get(this.m_sortColumn);
                boolean isTableSortByPort = this.m_sortColumn == PortalTableHeader.getIndexOfColumnName(PortalTableHeader.PORT);
                boolean bl = isTableSortByTag = this.m_sortColumn == PortalTableHeader.getIndexOfColumnName(PortalTableHeader.TAG);
                if (isTableSortByPort || isTableSortByTag) {
                    if (obj1 != null && obj1 instanceof String) {
                        obj1 = new Integer(Integer.MIN_VALUE);
                    }
                    if (obj2 != null && obj2 instanceof String) {
                        obj2 = new Integer(Integer.MIN_VALUE);
                    }
                }
                col1 = null;
                try {
                    col1 = (Comparable)obj1;
                }
                catch (ClassCastException cce) {
                    if (obj1 == null) break block12;
                    col1 = obj1.toString();
                }
            }
            col2 = null;
            try {
                col2 = (Comparable)obj2;
            }
            catch (ClassCastException cce) {
                if (obj2 == null) break block13;
                col2 = obj2.toString();
            }
        }
        if (col1 == null) {
            return this.order(-1);
        }
        if (col2 == null) {
            return this.order(1);
        }
        int result = this.order(col1.compareTo(col2));
        if (result == 0 && this.m_sortColVec.size() > this.m_runningIndex + 1) {
            ++this.m_runningIndex;
            int saveSortCol = this.m_sortColumn;
            int saveSortOrder = this.m_sortOrder;
            this.m_sortColumn = ((int[])this.m_sortColVec.get(this.m_runningIndex))[0];
            this.m_sortOrder = ((int[])this.m_sortColVec.get(this.m_runningIndex))[1];
            result = this.compare(o1, o2);
            this.m_sortColumn = saveSortCol;
            this.m_sortOrder = saveSortOrder;
            --this.m_runningIndex;
        }
        return result;
    }
}

