/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.dialogs;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.InterfaceManager;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.dialogs.SrInterfaceTableColumns;
import com.sanrad.nms.client.event.InterfaceEvent;
import com.sanrad.nms.client.event.InterfaceListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.vswitch.dialogs.InterfaceTableHeader;
import com.sanrad.swing.SrTableModel;
import java.util.List;

public class SrInterfaceTableModel
extends SrTableModel
implements InterfaceListener {
    private VSwitchNode m_vSwitchNode;

    public SrInterfaceTableModel(VSwitchNode vSwitchNode) {
        super(new SrInterfaceTableColumns());
        this.m_vSwitchNode = vSwitchNode;
        if (this.m_vSwitchNode != null) {
            this.init();
        }
    }

    public VSwitchNode getCurrentVSwitch() {
        return this.m_vSwitchNode;
    }

    @Override
    public void addListeners() {
        InterfaceManager.getInstance().addInterfaceListener(this);
    }

    @Override
    public void removeListeners() {
        InterfaceManager.getInstance().removeInterfaceListener(this);
    }

    private void init() {
        List<InterfaceTableRowNode> interfaceTable = this.m_vSwitchNode.getInterfaceTable();
        this.initModel(interfaceTable);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        InterfaceTableRowNode ifRow;
        if (col == InterfaceTableHeader.ALIAS.getIndexInModel()) {
            return true;
        }
        return col == InterfaceTableHeader.MTU.getIndexInModel() && (ifRow = (InterfaceTableRowNode)this.getValueAt(row, InterfaceTableHeader.ALIAS.getIndexInModel())).isSupportsJumboMtu();
    }

    private void initModel(List<InterfaceTableRowNode> interfaceTable) {
        this.removeAllRows();
        for (InterfaceTableRowNode interfaceRow : interfaceTable) {
            Object[] row = this.buildRow(interfaceRow);
            this.addRow(row);
        }
    }

    private Object[] buildRow(InterfaceTableRowNode aInterface) {
        Object[] row = new Object[InterfaceTableHeader.getColumnNames().size()];
        row[InterfaceTableHeader.ALIAS.getIndexInModel()] = aInterface;
        row[InterfaceTableHeader.NAME.getIndexInModel()] = aInterface.getName();
        row[InterfaceTableHeader.TYPE.getIndexInModel()] = aInterface.getType();
        row[InterfaceTableHeader.DESCRIPTOR.getIndexInModel()] = aInterface.getDescriptor();
        row[InterfaceTableHeader.PHYS_ADDRESS.getIndexInModel()] = aInterface.getPhysAddress();
        row[InterfaceTableHeader.MTU.getIndexInModel()] = aInterface.getJumboMtu();
        row[InterfaceTableHeader.HIGH_SPEED.getIndexInModel()] = aInterface.getHighSpeed();
        String operStatus = aInterface.getOperStatus();
        row[InterfaceTableHeader.OPER_STATUS.getIndexInModel()] = operStatus != null ? operStatus : ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
        return row;
    }

    private void udpateRow(InterfaceEvent e) {
        InterfaceTableRowNode interfaceRow = e.getInterface();
        int rowIndex = this.findRow(interfaceRow.getName(), InterfaceTableHeader.NAME.getColumnName());
        Object[] rowData = this.buildRow(interfaceRow);
        this.editRow(rowIndex, rowData);
    }

    @Override
    public void interfaceTableRowCreated(InterfaceEvent e) {
    }

    @Override
    public void interfaceTableRowParameterChanged(InterfaceEvent e) {
        this.udpateRow(e);
    }

    @Override
    public void interfaceTableRowChanged(InterfaceEvent e) {
        this.udpateRow(e);
    }

    @Override
    public void interfaceTableRowOperStatusChanged(InterfaceEvent e) {
        this.udpateRow(e);
    }

    public void interfaceTableRowStatisticsChanged(InterfaceEvent e) {
    }
}

