/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.dialogs;

import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.IPTableManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.IPTableEvent;
import com.sanrad.nms.client.event.IPTableListener;
import com.sanrad.nms.client.gui.vswitch.dialogs.IPTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrIPTableModel
extends SrTableModel
implements IPTableListener {
    private VSwitchNode m_vSwitchNode;

    public SrIPTableModel(VSwitchNode vSwitchNode) {
        super(new SrDefaultTableColumns(IPTableHeader.getColumnNames()));
        if (vSwitchNode != null) {
            this.init(vSwitchNode);
        }
    }

    @Override
    public void addListeners() {
        IPTableManager.getInstance().addIPTableListener(this);
    }

    @Override
    public void removeListeners() {
        IPTableManager.getInstance().removeIPTableListener(this);
    }

    private void init(VSwitchNode vSwitchNode) {
        this.m_vSwitchNode = vSwitchNode;
        Vector ipTable = vSwitchNode.getIPTable();
        this.initModel(ipTable);
    }

    private void initModel(Vector ipTable) {
        this.removeAllRows();
        if (ipTable != null) {
            for (int i = 0; i < ipTable.size(); ++i) {
                Vector<Object> rowData = new Vector<Object>();
                IPTableRow row = (IPTableRow)ipTable.get(i);
                rowData.addElement(new AliasObject(row.getIPAddress(), row));
                rowData.addElement(row.getIPMask());
                rowData.addElement(row.getActivity());
                rowData.addElement(row.getInterface());
                this.addRowQuetly(rowData.toArray(), -1);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    @Override
    public void ipTableRowCreated(IPTableEvent e) {
        SrTreeNode vswitchNode;
        if (this.verifySameVSwitch(e.getParentStub()) && (vswitchNode = SystemRootNode.getInstance().getRefByStub(e.getParentStub())) != null) {
            Vector ipTable = ((VSwitchNode)vswitchNode).getIPTable();
            this.initModel(ipTable);
        }
    }

    @Override
    public void ipTableRowChanged(IPTableEvent e) {
        if (this.verifySameVSwitch(e.getParentStub())) {
            int ipCol = this.getColumnIndex(IPTableHeader.IP_ADDRESS.getColumnName());
            int activityCol = this.getColumnIndex(IPTableHeader.ACTIVITY.getColumnName());
            for (int i = 0; i < this.getRowCount(); ++i) {
                AliasObject aliasObject = (AliasObject)this.getValueAt(i, ipCol);
                IPTableRow row = (IPTableRow)aliasObject.getAdditionalValue();
                if (!((com.sanrad.nms.server.logic.vswitch.IPTableRow)row.getStub()).equals(e.getStub())) continue;
                this.setValueAt(e.getActivity(), i, activityCol);
            }
        }
    }

    @Override
    public void ipTableRowRemoved(IPTableEvent e) {
        SrTreeNode vswitchNode;
        if (this.verifySameVSwitch(e.getParentStub()) && (vswitchNode = SystemRootNode.getInstance().getRefByStub(e.getParentStub())) != null) {
            Vector ipTable = ((VSwitchNode)vswitchNode).getIPTable();
            this.initModel(ipTable);
        }
    }

    private boolean verifySameVSwitch(Object vswitchStub) {
        return vswitchStub.equals(this.m_vSwitchNode.getStub());
    }
}

