/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch.dialogs;

import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.IPRouteTableManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.IPRouteTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.IPRouteTableEvent;
import com.sanrad.nms.client.event.IPRouteTableListener;
import com.sanrad.nms.client.gui.vswitch.dialogs.IPRouteTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrIPRouteTableModel
extends SrTableModel
implements IPRouteTableListener {
    private VSwitchNode m_vSwitchNode;

    public SrIPRouteTableModel(VSwitchNode vSwitchNode) {
        super(new SrDefaultTableColumns(IPRouteTableHeader.getColumnNames()));
        if (vSwitchNode != null) {
            this.init(vSwitchNode);
        }
    }

    @Override
    public void addListeners() {
        IPRouteTableManager.getInstance().addIPRouteTableListener(this);
    }

    @Override
    public void removeListeners() {
        IPRouteTableManager.getInstance().removeIPRouteTableListener(this);
    }

    private void init(VSwitchNode vSwitchNode) {
        Vector ipRouteTable = vSwitchNode.getIPRouteTable();
        this.m_vSwitchNode = vSwitchNode;
        this.initModel(ipRouteTable);
    }

    private void initModel(Vector ipRouteTable) {
        this.removeAllRows();
        if (ipRouteTable != null) {
            for (int i = 0; i < ipRouteTable.size(); ++i) {
                Vector<Object> rowData = new Vector<Object>();
                IPRouteTableRow row = (IPRouteTableRow)ipRouteTable.get(i);
                rowData.addElement(new AliasObject(row.getDestIPAddress(), row));
                rowData.addElement(row.getDestIPMask());
                rowData.addElement(row.getGateway());
                rowData.addElement(row.getInterface());
                this.addRowQuetly(rowData.toArray(), -1);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    @Override
    public void ipRouteTableRowCreated(IPRouteTableEvent e) {
        SrTreeNode vswitchNode;
        if (this.verifySameVSwitch(e.getParentStub()) && (vswitchNode = SystemRootNode.getInstance().getRefByStub(e.getParentStub())) != null) {
            Vector table = ((VSwitchNode)vswitchNode).getIPRouteTable();
            this.initModel(table);
        }
    }

    @Override
    public void ipRouteTableRowRemoved(IPRouteTableEvent e) {
        SrTreeNode vswitchNode;
        if (this.verifySameVSwitch(e.getParentStub()) && (vswitchNode = SystemRootNode.getInstance().getRefByStub(e.getParentStub())) != null) {
            Vector table = ((VSwitchNode)vswitchNode).getIPRouteTable();
            this.initModel(table);
        }
    }

    private boolean verifySameVSwitch(Object vswitchStub) {
        return vswitchStub.equals(this.m_vSwitchNode.getStub());
    }
}

