/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemObjectNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.hardware.HardwareData;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.instance.ISCSIInstanceInfo;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorStatisticsNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.RemoteInitiatorsGroupStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.SessionsGroupStatisticsNode;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.Neighbor;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.statistics.icmp.ICMPStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesGroupStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.ip.IPStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.IfOperStatConstant;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosActivityConstant;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosRateTypeConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchStatusConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchSysOID;
import com.sanrad.swing.SrSwingUtils;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class VSwitchNode
extends SrTreeNode<VSwitch, CommKeyClassId>
implements SystemObjectNode {
    private static final String MGNT_INTERFACE_NAME = "mgnt";
    private VSwitchSysOID m_systemOid;
    private String ipAddress;
    private boolean isConnected = false;
    private String name;
    private String manageIPAddress;
    private String mask = "255.255.255.0";
    private int retries;
    private String readCommunity;
    private int snmpPort;
    private SnmpVersion version;
    private long timeout;
    private int trapPort;
    private String writeCommunity;
    private String contact;
    private Date date;
    private String description;
    private Date lastReset;
    private String location;
    private VSwitchStatusConstant myStatus;
    private IscsiTgtQosActivityConstant myQosEnable;
    private IscsiTgtQosRateTypeConstant myQosRateType;
    private BigInteger myQosLimit;
    private Vector<IPTableRow> ipTable = new Vector();
    private Vector m_tcpConnectionsTable = new Vector();
    private Vector m_udpListenersTable = new Vector();
    private Vector ipRouteTable = new Vector();
    private List<InterfaceTableRowNode> interfaceTable = new ArrayList<InterfaceTableRowNode>();
    private Vector<PortalTableRow> portalTable = new Vector();
    private List ethernetInterfaces = new ArrayList();
    private BigInteger telnetPort;
    private List<Neighbor> neighbors = new ArrayList<Neighbor>();
    private Long lastKeepAlive;
    private Integer keepAlive;
    private Integer suspiciousInterval;
    private Integer faultyInterval;
    private Boolean failoverEnable;
    private SDTakeOverStateConstant takeoverState = null;
    private Integer switchId;
    private Boolean reportLUNsDiscoveryEnable;
    private String functions;
    private String wwnn;
    private TempetureUnitConstant m_tempUnits = null;
    private HardwareData m_hardwareData;
    private Vector m_iscsiInstanceInfo;
    private ArrayList m_initiatorNodes = new ArrayList();
    private Vector m_iscsiSessionsTableNodes;
    private Vector m_iscsiRemoteInitiatorsTableNodes;
    private RemoteInitiatorsGroupStatisticsNode m_remoteInitiatorsGroupStatisticsNode;
    private Vector m_remoteInitiatorsStatisticsTableNodes;
    private SessionsGroupStatisticsNode m_sessionsGroupStatisticsNode;
    private Vector m_sessionsStatisticsTableNodes;
    private int myStatisticsPoolIntervalSec;
    private InterfacesGroupStatisticsNode m_interfacesGroupStatisticsNode;
    private Vector m_interfacesStatisticsTableNodes;
    private IPStatisticsNode m_ipStatisticsNode;
    private ICMPStatisticsNode m_icmpStatisticsNode;
    private TCPStatisticsNode m_tcpStatisticsNode;
    private UDPStatisticsNode m_udpStatisticsNode;
    private Integer m_targetCount;
    private static ImageIcon CONNECTED_VSWITCH_ICON = ClientImageObject.VSWITCH.getImageIcon();
    private static ImageIcon DISCONNECTED_VSWITCH_ICON = SrSwingUtils.drawRedStringOnIcon(CONNECTED_VSWITCH_ICON, "X");

    public VSwitchNode(VSwitch stub) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.m_systemOid = stub.getVSwitchType();
        this.nodeIcon = CONNECTED_VSWITCH_ICON;
    }

    public boolean isVSwitch2000() {
        return VSwitchSysOID.VSWITCH_SYS_OID_2000.equals(this.m_systemOid);
    }

    public boolean isVSwitch3000() {
        return VSwitchSysOID.VSWITCH_SYS_OID_3000.equals(this.m_systemOid);
    }

    public boolean isVStor() {
        if (this.m_systemOid == null) {
            return false;
        }
        return this.m_systemOid.isVStor();
    }

    public boolean isNexsan() {
        if (this.m_systemOid == null) {
            return false;
        }
        return this.m_systemOid.isNexsan();
    }

    public VSwitchSysOID getVSwitchType() {
        return this.m_systemOid;
    }

    public boolean isSupportSFP() {
        return !this.isVSwitch2000() && !this.isVSwitch3000();
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getContact() {
        return this.contact;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLastReset(Date lastReset) {
        this.lastReset = lastReset;
    }

    public Date getLastReset() {
        return this.lastReset;
    }

    @Override
    public String type() {
        return ClientLoader.VSWITCH_DISPLAY_STRING;
    }

    public void setSnmpVersion(SnmpVersion version) {
        this.version = version;
    }

    public SnmpVersion getSnmpVersion() {
        return this.version;
    }

    public void setManagedIPAddress(String manageIPAddress) {
        this.manageIPAddress = manageIPAddress;
    }

    public String getManagedIPAddress() {
        return this.manageIPAddress;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setReadCommunity(String readCommunity) {
        this.readCommunity = readCommunity;
    }

    public String getReadCommunity() {
        return this.readCommunity;
    }

    public void setSNMPPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public int getSNMPPort() {
        return this.snmpPort;
    }

    public void setWriteCommunity(String writeCommunity) {
        this.writeCommunity = writeCommunity;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTrapPort(int trapPort) {
        this.trapPort = trapPort;
    }

    public int getTrapPort() {
        return this.trapPort;
    }

    public void setIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
        this.nodeIcon = connected ? CONNECTED_VSWITCH_ICON : DISCONNECTED_VSWITCH_ICON;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addRowToIPTable(IPTableRow ipTableRow) {
        this.ipTable.addElement(ipTableRow);
    }

    public void removeRowFromIPTable(Object ipTableRow) {
        this.ipTable.remove(ipTableRow);
    }

    public Vector getIPTable() {
        return this.ipTable;
    }

    public void setIPTable(Vector<IPTableRow> ipTable) {
        this.ipTable = ipTable;
    }

    public Vector getTCPConnectionsTable() {
        return this.m_tcpConnectionsTable;
    }

    public void setTCPConnectionsTable(Vector udpListenersTable) {
        this.m_tcpConnectionsTable = udpListenersTable;
    }

    public Vector getUDPListenersTable() {
        return this.m_udpListenersTable;
    }

    public void setUDPListenersTable(Vector tcpConnectionsTable) {
        this.m_udpListenersTable = tcpConnectionsTable;
    }

    public void setIPRouteTable(Vector ipRouteTable) {
        this.ipRouteTable = ipRouteTable;
    }

    public Vector getIPRouteTable() {
        return this.ipRouteTable;
    }

    public List<InterfaceTableRowNode> getInterfaceTable() {
        return this.interfaceTable;
    }

    public void setInterfaceTable(List<InterfaceTableRowNode> interfaceTable) {
        this.interfaceTable = interfaceTable;
    }

    public Vector<PortalTableRow> getPortalTable() {
        return this.portalTable;
    }

    public void setPortalTable(Vector<PortalTableRow> portalTable) {
        this.portalTable = portalTable;
    }

    public void setEthernetInterfaces(List ethernetInterfaces) {
        this.ethernetInterfaces = ethernetInterfaces;
    }

    public List getEthernetInterfaces() {
        return this.ethernetInterfaces;
    }

    public void setTelnetPort(BigInteger telnetPort) {
        this.telnetPort = telnetPort;
    }

    public BigInteger getTelnetPort() {
        return this.telnetPort;
    }

    public void setLastKeepAlive(Long lastKeepAlive) {
        this.lastKeepAlive = lastKeepAlive;
    }

    public Long getLastKeepAlive() {
        return this.lastKeepAlive;
    }

    public List<Neighbor> getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(List<Neighbor> neighbors) {
        this.neighbors = neighbors;
    }

    public void setFaultyInterval(Integer faultyInterval) {
        this.faultyInterval = faultyInterval;
    }

    public Integer getFaultyInterval() {
        return this.faultyInterval;
    }

    public void setSuspiciousInterval(Integer suspiciousInterval) {
        this.suspiciousInterval = suspiciousInterval;
    }

    public Integer getSuspiciousInterval() {
        return this.suspiciousInterval;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    public void setTakeoverState(SDTakeOverStateConstant state) {
        this.takeoverState = state;
    }

    public boolean isUnderTakeover() {
        if (this.takeoverState != null) {
            return this.takeoverState.equals(SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER);
        }
        return false;
    }

    public SDTakeOverStateConstant getTakeoverState() {
        return this.takeoverState;
    }

    public void setFailoverEnable(Boolean enable) {
        this.failoverEnable = enable;
    }

    public Boolean isFailoverEnable() {
        return this.failoverEnable;
    }

    public void clearParameters() {
        this.ipTable.clear();
        this.ipRouteTable.clear();
        this.interfaceTable.clear();
        this.portalTable.clear();
        this.m_tcpConnectionsTable.clear();
        this.m_udpListenersTable.clear();
        if (this.m_iscsiInstanceInfo != null) {
            this.m_iscsiInstanceInfo.clear();
        }
        if (this.m_iscsiSessionsTableNodes != null) {
            this.m_iscsiSessionsTableNodes.clear();
        }
        if (this.m_iscsiRemoteInitiatorsTableNodes != null) {
            this.m_iscsiRemoteInitiatorsTableNodes.clear();
        }
        if (this.m_remoteInitiatorsStatisticsTableNodes != null) {
            this.m_remoteInitiatorsStatisticsTableNodes.clear();
        }
        if (this.m_sessionsStatisticsTableNodes != null) {
            this.m_sessionsStatisticsTableNodes.clear();
        }
    }

    public void setSwitchID(Integer switchId) {
        this.switchId = switchId;
    }

    public Integer getSwitchID() {
        return this.switchId;
    }

    public void setReportLUNsDiscoveryEnable(Boolean enable) {
        this.reportLUNsDiscoveryEnable = enable;
    }

    public Boolean isReportLUNsDiscoveryEnable() {
        return this.reportLUNsDiscoveryEnable;
    }

    public void setFunctions(String functions) {
        this.functions = functions;
    }

    public String getFunctions() {
        return this.functions;
    }

    public String getWWNN() {
        return this.wwnn;
    }

    public void setWWNN(String wwnn) {
        this.wwnn = wwnn;
    }

    public boolean isPSCSIInterfaceExist() {
        for (int i = 0; i < this.interfaceTable.size(); ++i) {
            InterfaceTableRowNode interfaceRow = this.interfaceTable.get(i);
            if (!interfaceRow.getType().equals("ultra")) continue;
            return true;
        }
        return false;
    }

    public boolean isFCInterfaceExist() {
        for (int i = 0; i < this.interfaceTable.size(); ++i) {
            InterfaceTableRowNode interfaceRow = this.interfaceTable.get(i);
            if (!interfaceRow.getType().equals("fibreChannel")) continue;
            return true;
        }
        return false;
    }

    public boolean isMgntInterfaceDown() {
        InterfaceTableRowNode interfaceRow = this.getMgntInterface();
        if (interfaceRow != null) {
            String operStatus = interfaceRow.getOperStatus();
            return operStatus.equals(IfOperStatConstant.IF_OPER_STAT_DOWN.toDisplayString());
        }
        return false;
    }

    public void setTempUnits(TempetureUnitConstant temperatureUnits) {
        this.m_tempUnits = temperatureUnits;
    }

    public TempetureUnitConstant getTempUnits() {
        return this.m_tempUnits;
    }

    public void setHardwareData(HardwareData hardwareData) {
        this.m_hardwareData = hardwareData;
    }

    public HardwareData getHardwareData() {
        return this.m_hardwareData;
    }

    public void setInterfacesStatisticsGroupNode(InterfacesGroupStatisticsNode interfacesGroupStatisticsNode) {
        this.m_interfacesGroupStatisticsNode = interfacesGroupStatisticsNode;
    }

    public InterfacesGroupStatisticsNode getInterfacesStatisticsGroupNode() {
        return this.m_interfacesGroupStatisticsNode;
    }

    public void setInterfacesStatisticsTableNodes(Vector interfacesStatisticsTableNodes) {
        this.m_interfacesStatisticsTableNodes = interfacesStatisticsTableNodes;
    }

    public Vector getInterfacesStatisticsTableNodes() {
        return this.m_interfacesStatisticsTableNodes;
    }

    public InterfacesStatisticsNode getInterfacesStatisticsTableNodes(int index) {
        return (InterfacesStatisticsNode)this.m_interfacesStatisticsTableNodes.elementAt(index);
    }

    public void setIPStatistics(IPStatisticsNode ipStatisticsNode) {
        this.m_ipStatisticsNode = ipStatisticsNode;
    }

    public IPStatisticsNode getIPStatistics() {
        return this.m_ipStatisticsNode;
    }

    public void setICMPStatistics(ICMPStatisticsNode icmpStatisticsNode) {
        this.m_icmpStatisticsNode = icmpStatisticsNode;
    }

    public ICMPStatisticsNode getICMPStatistics() {
        return this.m_icmpStatisticsNode;
    }

    public void setTCPStatistics(TCPStatisticsNode tcpStatisticsNode) {
        this.m_tcpStatisticsNode = tcpStatisticsNode;
    }

    public TCPStatisticsNode getTCPStatistics() {
        return this.m_tcpStatisticsNode;
    }

    public void setUDPStatistics(UDPStatisticsNode udpStatisticsNode) {
        this.m_udpStatisticsNode = udpStatisticsNode;
    }

    public UDPStatisticsNode getUDPStatistics() {
        return this.m_udpStatisticsNode;
    }

    public void setISCSIInstanceInfo(Vector iscsiInstanceInfos) {
        this.m_iscsiInstanceInfo = iscsiInstanceInfos;
    }

    public Vector getISCSIInstanceInfos() {
        return this.m_iscsiInstanceInfo;
    }

    public void addISCSIInstanceInfo(ISCSIInstanceInfo iscsiInstanceInfo) {
        this.m_iscsiInstanceInfo.add(iscsiInstanceInfo);
    }

    public void setISCSIInitiators(ArrayList initiatorNodes) {
        this.m_initiatorNodes.clear();
        this.m_initiatorNodes.addAll(initiatorNodes);
    }

    public SrInitiatorNode[] getISCSIInitiators() {
        SrInitiatorNode[] array = new SrInitiatorNode[this.m_initiatorNodes.size()];
        return this.m_initiatorNodes.toArray(array);
    }

    public void addISCSIInitiator(SrInitiatorNode initiatorNode) {
        if (!this.m_initiatorNodes.contains(initiatorNode)) {
            this.m_initiatorNodes.add(initiatorNode);
        }
    }

    public void removeISCSIInitiator(SrInitiatorNode initiatorNode) {
        this.m_initiatorNodes.add(initiatorNode);
    }

    public void addISCSISessionNode(ISCSISessionNode sessionNode) {
        this.m_iscsiSessionsTableNodes.add(sessionNode);
    }

    public void removeISCSISessionNode(ISCSISessionNode sessionNode) {
        this.m_iscsiSessionsTableNodes.remove(sessionNode);
    }

    public void removeISCSISessionStatisticsNodeBySessionNode(ISCSISessionNode sessionNode) {
        for (int index = 0; index < this.m_sessionsStatisticsTableNodes.size(); ++index) {
            ISCSISessionStatisticsNode sessionStatisticsNode = (ISCSISessionStatisticsNode)this.m_sessionsStatisticsTableNodes.elementAt(index);
            ISCSISession sessionStub = sessionStatisticsNode.getSessionShowStub();
            if (!((ISCSISession)sessionNode.getStub()).equals(sessionStub)) continue;
            this.removeISCSISessionStatisticsNode(sessionStatisticsNode);
            break;
        }
    }

    public void addISCSISessionStatisticsNode(ISCSISessionStatisticsNode sessionNode) {
        this.m_sessionsStatisticsTableNodes.add(sessionNode);
    }

    public void removeISCSISessionStatisticsNode(ISCSISessionStatisticsNode sessionNode) {
        this.m_sessionsStatisticsTableNodes.remove(sessionNode);
    }

    public void removeISCSIInstanceInfo(ISCSIInstanceInfo iscsiInstanceInfo) {
        this.m_iscsiInstanceInfo.remove(iscsiInstanceInfo);
    }

    public void setISCSISessionsTableNodes(Vector iscsiSessionsTableNodes) {
        this.m_iscsiSessionsTableNodes = iscsiSessionsTableNodes;
    }

    public Vector getISCSISessionsTableNodes() {
        return this.m_iscsiSessionsTableNodes;
    }

    public void setISCSIRemoteInitiatorsTableNodes(Vector iscsiRemoteInitiatorsTableNodes) {
        this.m_iscsiRemoteInitiatorsTableNodes = iscsiRemoteInitiatorsTableNodes;
    }

    public Vector getISCSIRemoteInitiatorsTableNodes() {
        return this.m_iscsiRemoteInitiatorsTableNodes;
    }

    public void addISCSIRemoteInitiator(ISCSIRemoteInitiatorNode initiatorNode) {
        if (!this.m_iscsiRemoteInitiatorsTableNodes.contains(initiatorNode)) {
            this.m_iscsiRemoteInitiatorsTableNodes.add(initiatorNode);
        }
    }

    public void removeISCSIRemoteInitiator(ISCSIRemoteInitiatorNode initiatorNode) {
        this.m_iscsiRemoteInitiatorsTableNodes.remove(initiatorNode);
    }

    public void setISCSIRemoteInitiatorsGroupNode(RemoteInitiatorsGroupStatisticsNode remoteInitiatorsGroupStatisticsNode) {
        this.m_remoteInitiatorsGroupStatisticsNode = remoteInitiatorsGroupStatisticsNode;
    }

    public RemoteInitiatorsGroupStatisticsNode getISCSIRemoteInitiatorsGroupNode() {
        return this.m_remoteInitiatorsGroupStatisticsNode;
    }

    public void setISCSIRemoteInitiatorsStatisticsTableNodes(Vector remoteInitiatorsStatisticsTableNodes) {
        this.m_remoteInitiatorsStatisticsTableNodes = remoteInitiatorsStatisticsTableNodes;
    }

    public void addISCSIRemoteInitiatorStatisticsTableNode(ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode) {
        this.m_remoteInitiatorsStatisticsTableNodes.add(remoteInitiatorStatisticsNode);
    }

    public Vector getISCSIRemoteInitiatorsStatisticsTableNodes() {
        return this.m_remoteInitiatorsStatisticsTableNodes;
    }

    public void addISCSIRemoteInitiatorStatistics(ISCSIRemoteInitiatorStatisticsNode initiatorStatisticsNode) {
        if (!this.m_remoteInitiatorsStatisticsTableNodes.contains(initiatorStatisticsNode)) {
            this.m_remoteInitiatorsStatisticsTableNodes.add(initiatorStatisticsNode);
        }
    }

    public void removeISCSIRemoteInitiatorStatistics(ISCSIRemoteInitiatorStatisticsNode initiatorStatisticsNode) {
        this.m_remoteInitiatorsStatisticsTableNodes.remove(initiatorStatisticsNode);
    }

    public void setISCSISessionsGroupNode(SessionsGroupStatisticsNode sessionsGroupStatisticsNode) {
        this.m_sessionsGroupStatisticsNode = sessionsGroupStatisticsNode;
    }

    public SessionsGroupStatisticsNode getISCSISessionsGroupNode() {
        return this.m_sessionsGroupStatisticsNode;
    }

    public void setISCSISessionsStatisticsTableNodes(Vector sessionsStatisticsTableNodes) {
        this.m_sessionsStatisticsTableNodes = sessionsStatisticsTableNodes;
    }

    public Vector getISCSISessionsStatisticsTableNodes() {
        return this.m_sessionsStatisticsTableNodes;
    }

    @Override
    public String getToolTipText() {
        return this.getIPAddress();
    }

    public IPTableRow getIPRowByIPAddress(String ipAddress) {
        for (int i = 0; i < this.ipTable.size(); ++i) {
            IPTableRow row = this.ipTable.get(i);
            String ip = row.getIPAddress();
            if (!ip.equals(ipAddress)) continue;
            return row;
        }
        return null;
    }

    public Integer getTargetCount() {
        return this.m_targetCount;
    }

    public void setTargetCount(Integer targetCount) {
        this.m_targetCount = targetCount;
    }

    @Override
    public String getAlias() {
        return this.name;
    }

    public InterfaceTableRowNode getMgntInterface() {
        for (InterfaceTableRowNode interfaceRow : this.interfaceTable) {
            if (!interfaceRow.getType().equals("ethernetCsmacd") || !interfaceRow.isMgntInterface()) continue;
            return interfaceRow;
        }
        return null;
    }

    public InterfaceTableRowNode getInterfaceOfManagementIP() {
        for (IPTableRow ipRow : this.ipTable) {
            if (!this.getManagedIPAddress().equals(ipRow.getIPAddress())) continue;
            return ipRow.getInterface();
        }
        return null;
    }

    public boolean isManagementInterfaceIsMgnt() {
        InterfaceTableRowNode interfaceRow = this.getInterfaceOfManagementIP();
        if (interfaceRow != null) {
            return interfaceRow.getName().equals(MGNT_INTERFACE_NAME);
        }
        return false;
    }

    public String getBoxType() {
        return this.m_systemOid == null ? VSwitchSysOID.VSWITCH_SYS_OID_UNKNOWN.getDescriptionName() : this.m_systemOid.getDescriptionName();
    }

    public VSwitchStatusConstant getVSwitchStatus() {
        return this.myStatus;
    }

    public void setVSwitchStatus(VSwitchStatusConstant aStatus) {
        this.myStatus = aStatus;
    }

    public void setQosEnable(IscsiTgtQosActivityConstant aQosEnable) {
        this.myQosEnable = aQosEnable;
    }

    public IscsiTgtQosActivityConstant getQosEnable() {
        return this.myQosEnable;
    }

    public void setQosRateType(IscsiTgtQosRateTypeConstant aQosRateType) {
        this.myQosRateType = aQosRateType;
    }

    public IscsiTgtQosRateTypeConstant getQosRateType() {
        return this.myQosRateType;
    }

    public void setQosLimit(BigInteger aLimit) {
        this.myQosLimit = aLimit;
    }

    public BigInteger getQosLimit() {
        return this.myQosLimit;
    }

    public void setStatisticsPollInterval(int aInterval) {
        this.myStatisticsPoolIntervalSec = aInterval;
    }

    public int getStatisticsPollInterval() {
        return this.myStatisticsPoolIntervalSec;
    }

    public ClusterNode getParentCluster() {
        return (ClusterNode)this.getParent();
    }

    @Override
    public String getProblemOnDeletion() {
        return null;
    }
}

