/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.IPRouteTableManager;
import com.sanrad.nms.client.data.IPTableManager;
import com.sanrad.nms.client.data.InterfaceManager;
import com.sanrad.nms.client.data.PortalManager;
import com.sanrad.nms.client.data.SrMainTreeModel;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.hardware.HardwareData;
import com.sanrad.nms.client.data.hardware.HardwareManager;
import com.sanrad.nms.client.data.initiator.SrInitiatorManager;
import com.sanrad.nms.client.data.iscsi.instance.ISCSIInstancesManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorsManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorsStatisticsManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.RemoteInitiatorsGroupStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionsStatisticsManager;
import com.sanrad.nms.client.data.iscsi.session.statistics.SessionsGroupStatisticsNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.vswitch.IPRouteTableRow;
import com.sanrad.nms.client.data.vswitch.IPTableRow;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.Neighbor;
import com.sanrad.nms.client.data.vswitch.NeighborManager;
import com.sanrad.nms.client.data.vswitch.PortalTableRow;
import com.sanrad.nms.client.data.vswitch.SrTargetPortalTableRow;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.data.vswitch.interfaces.ethernet.EthernetInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.interfaces.fc.FCInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.interfaces.pscsi.PSCSIInterfaceTableRow;
import com.sanrad.nms.client.data.vswitch.statistics.ethernet.EthernetStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.icmp.ICMPStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.icmp.ICMPStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesGroupStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.interfaces.InterfacesStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.ip.IPStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.ip.IPStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPConnectionsTableRow;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.tcp.TCPStatisticsNode;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPListenerTableRow;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsManager;
import com.sanrad.nms.client.data.vswitch.statistics.udp.UDPStatisticsNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.hardware.Hardware;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.IPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPListenerStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatistics;
import com.sanrad.nms.server.util.types.constants.InterfaceSFPConnectorConstant;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosActivityConstant;
import com.sanrad.nms.server.util.types.constants.IscsiTgtQosRateTypeConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.TCPConStateConstant;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchStatusConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchSysOID;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class VSwitchManager
extends ElementManager {
    private static VSwitchManager instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer vSwitchRediscoveredInformer = new SrEventListenerManager.Informer<VSwitchListener, VSwitchEvent>(){

        @Override
        public void inform(VSwitchListener listener, VSwitchEvent event) {
            listener.vSwitchRediscovered(event);
        }
    };
    SrEventListenerManager.Informer resetVSwitchStartedInformer = new SrEventListenerManager.Informer<VSwitchListener, VSwitchEvent>(){

        @Override
        public void inform(VSwitchListener listener, VSwitchEvent event) {
            listener.resetVSwitchStarted(event);
        }
    };
    SrEventListenerManager.Informer vSwitchPropertiesChangedInformer = new SrEventListenerManager.Informer<VSwitchListener, VSwitchEvent>(){

        @Override
        public void inform(VSwitchListener listener, VSwitchEvent event) {
            listener.vSwitchPropertiesChanged(event);
        }
    };
    SrEventListenerManager.Informer vSwitchCreatedInformer = new SrEventListenerManager.Informer<VSwitchListener, VSwitchEvent>(){

        @Override
        public void inform(VSwitchListener listener, VSwitchEvent event) {
            listener.vSwitchCreated(event);
        }
    };
    SrEventListenerManager.Informer vSwitchRemovedInformer = new SrEventListenerManager.Informer<VSwitchListener, VSwitchEvent>(){

        @Override
        public void inform(VSwitchListener listener, VSwitchEvent event) {
            listener.vSwitchRemoved(event);
        }
    };

    private VSwitchManager() {
        InterfaceManager.getInstance();
        IPTableManager.getInstance();
        IPRouteTableManager.getInstance();
        PortalManager.getInstance();
        NeighborManager.getInstance();
        HardwareManager.getInstance();
        InterfacesStatisticsManager.getInstance();
        IPStatisticsManager.getInstance();
        ICMPStatisticsManager.getInstance();
        TCPStatisticsManager.getInstance();
        UDPStatisticsManager.getInstance();
        ISCSIInstancesManager.getInstance();
        ISCSIRemoteInitiatorsManager.getInstance();
        ISCSIRemoteInitiatorsStatisticsManager.getInstance();
        ISCSISessionsManager.getInstance();
        ISCSISessionsStatisticsManager.getInstance();
        SrInitiatorManager.getInstance();
    }

    public static synchronized VSwitchManager getInstance() {
        if (instance == null) {
            instance = new VSwitchManager();
        }
        return instance;
    }

    public Vector<VSwitchNode> getAvailableVSwitches(ClusterNode clusterNode) {
        if (clusterNode == null) {
            return new Vector<VSwitchNode>(0);
        }
        return new Vector<VSwitchNode>(clusterNode.getStubToReference().getAvailableVSwitches());
    }

    public Long getLastKeepAlive(VSwitchNode vswitchNode) {
        try {
            VSwitch vs = (VSwitch)vswitchNode.getStub();
            return vs.getLastKeepAlive();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get 'Lask Keep Alive' property.");
            return null;
        }
    }

    public List<VSwitchNode> readVSwitchesFromServer(ClusterNode clusterNode) {
        ArrayList<VSwitchNode> nodes = new ArrayList<VSwitchNode>();
        try {
            Cluster clusterStub = (Cluster)clusterNode.getStub();
            List<? extends VSwitch> vSwitches = clusterStub.getVSwitches();
            if (vSwitches != null) {
                for (int i = 0; i < vSwitches.size(); ++i) {
                    VSwitch vSwitch = vSwitches.get(i);
                    VSwitchNode node = new VSwitchNode(vSwitch);
                    SystemRootNode.getInstance().putRefAndStub(vSwitch, node);
                    nodes.add(node);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to read all " + ClientLoader.VSWITCHES_DISPLAY_STRING + " from Server.");
        }
        this.initVSwitchDataFromServer(nodes);
        return nodes;
    }

    private void initVSwitchDataFromServer(List<VSwitchNode> aVSwitches) {
        try {
            for (VSwitchNode node : aVSwitches) {
                Object trapPort;
                VSwitch vSwitch = (VSwitch)node.getStub();
                String ipAddress = vSwitch.getMgmIPAddr();
                HashMap paramsList = null;
                try {
                    paramsList = vSwitch.getClientParameterList();
                }
                catch (IllegalValueException e) {
                    theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
                }
                String manageIPAddress = vSwitch.getMgmIPAddr();
                String mask = vSwitch.getMgmMask();
                SnmpVersion version = vSwitch.getSnmpVersion();
                String contact = vSwitch.getContact();
                Vector<? extends com.sanrad.nms.server.logic.vswitch.IPTableRow> ipTable = vSwitch.getIPTable();
                Vector<? extends com.sanrad.nms.server.logic.vswitch.IPRouteTableRow> ipRouteTable = vSwitch.getIPRouteTable();
                Vector<? extends InterfaceTableRow> interfaceTable = vSwitch.getInterfaceTable();
                Vector<? extends com.sanrad.nms.server.logic.vswitch.PortalTableRow> portalTable = vSwitch.getPortalTable();
                TempetureUnitConstant temperatureUnits = vSwitch.getTempUnits();
                SDTakeOverStateConstant takeOverState = vSwitch.getTakeOverState();
                Boolean reportLUNsDiscoveryEnable = vSwitch.isReportLUNsDiscoveryEnable();
                Integer targetCount = (Integer)paramsList.get(ClientParameterCode.VSWITCH_TARGETS_COUNT);
                Vector<? extends TCPConnectionStatisticsTableRow> tcpConnectionsTable = vSwitch.getTCPConnectionStatisticsTable();
                Vector<? extends UDPListenerStatisticsTableRow> udpListenerStatisticsTable = vSwitch.getUDPListenerStatisticsTable();
                Vector nodeInterfaceTable = this.getInterfaceTable(interfaceTable);
                Vector<IPTableRow> nodeIPTable = this.getIPTable(ipTable);
                Vector nodeIPRouteTable = this.getIPRouteTable(ipRouteTable);
                Vector nodePortalTable = this.getPortalTable(portalTable);
                Vector nodeTCPConnectionsTable = this.getTCPConnectionsTable(tcpConnectionsTable);
                Vector nodeUDPListenerTable = this.getUDPListenerTable(udpListenerStatisticsTable);
                Vector nodeInterfacesStatisticsTable = this.getInterfacesStatisticsTable(node);
                HardwareData hardwareData = this.getHardwareData(vSwitch);
                Vector iscsiInstanceInfoTable = this.getISCSIInstanceInfoTable(vSwitch);
                ArrayList initiatorsTable = this.getInitiatorTable(vSwitch);
                Vector nodeISCSIRemoteInitiatorsTable = this.getISCSIRemoteInitiatorsTable(vSwitch);
                Vector nodeISCSIRemoteInitiatorsStatisticsTable = this.getISCSIRemoteInitiatorsStatisticsTable(vSwitch);
                Vector nodeISCSISessionsTable = this.getISCSISessionsTable(vSwitch);
                Vector nodeISCSISessionsStatisticsTable = this.getISCSISessionsStatisticsTable(vSwitch);
                String location = vSwitch.getLocation();
                Vector<? extends InterfaceTableRow> ethernetInterfaces = vSwitch.getEthernetInterfaces();
                Vector<? extends com.sanrad.nms.server.logic.vswitch.Neighbor> neighbors = vSwitch.getNeighborTable();
                String wwnn = vSwitch.getWWNN();
                String functions = vSwitch.getFunctions();
                Long dateAndTime = vSwitch.getDateAndTime();
                if (dateAndTime != null) {
                    node.setDate(new Date(dateAndTime));
                }
                node.setWWNN(wwnn);
                node.setFunctions(functions);
                node.setIPTable(nodeIPTable);
                node.setIPRouteTable(nodeIPRouteTable);
                node.setInterfaceTable(nodeInterfaceTable);
                node.setPortalTable(nodePortalTable);
                node.setEthernetInterfaces(ethernetInterfaces);
                node.setIPAddress(ipAddress);
                node.setName((String)paramsList.get(ClientParameterCode.VSWITCH_NAME));
                node.setManagedIPAddress(manageIPAddress);
                node.setMask(mask);
                Object retries = paramsList.get(ClientParameterCode.VSWITCH_RETRIES);
                if (retries != null) {
                    node.setRetries((Integer)retries);
                }
                node.setReadCommunity((String)paramsList.get(ClientParameterCode.VSWITCH_READ_COMMUNITY));
                node.setWriteCommunity((String)paramsList.get(ClientParameterCode.VSWITCH_WRITE_COMMUNITY));
                Object snmpPort = paramsList.get(ClientParameterCode.VSWITCH_SNMP_PORT);
                if (snmpPort != null) {
                    node.setSNMPPort((Integer)snmpPort);
                }
                node.setSnmpVersion(version);
                Object timeOut = paramsList.get(ClientParameterCode.VSWITCH_TIMEOUT);
                if (timeOut != null) {
                    node.setTimeout((Long)timeOut);
                }
                if ((trapPort = paramsList.get(ClientParameterCode.VSWITCH_TRAP_PORT)) != null) {
                    node.setTrapPort((Integer)trapPort);
                }
                node.setContact(contact);
                Date lastReset = null;
                Object lLastReset = paramsList.get(ClientParameterCode.VSWITCH_LAST_RESET);
                if (lLastReset != null) {
                    lastReset = new Date((Long)lLastReset);
                }
                node.setLastReset(lastReset);
                node.setLocation(location);
                node.setDescription((String)paramsList.get(ClientParameterCode.VSWITCH_DESCRIPTION));
                IscsiTgtQosActivityConstant qosEnable = (IscsiTgtQosActivityConstant)paramsList.get(ClientParameterCode.VSWITCH_TGT_QOS_ACTIVITY);
                node.setQosEnable(qosEnable);
                BigInteger qosLimit = (BigInteger)paramsList.get(ClientParameterCode.VSWITCH_TGT_QOS_MAX_RATE_LIMIT);
                node.setQosLimit(qosLimit);
                Double statisticsPollIntervalMinutes = (Double)paramsList.get(ClientParameterCode.VSWITCH_STATISTICS_POLL_INTERVAL);
                if (statisticsPollIntervalMinutes != null) {
                    node.setStatisticsPollInterval((int)(statisticsPollIntervalMinutes * 60.0));
                }
                IscsiTgtQosRateTypeConstant qosRateType = (IscsiTgtQosRateTypeConstant)paramsList.get(ClientParameterCode.VSWITCH_TGT_QOS_RATE_TYPE);
                node.setQosRateType(qosRateType);
                node.setConnected(vSwitch.isConnected());
                Object telnetPort = paramsList.get(ClientParameterCode.VSWITCH_TELNET_PORT);
                if (telnetPort != null) {
                    node.setTelnetPort((BigInteger)telnetPort);
                }
                node.setTempUnits(temperatureUnits);
                node.setTakeoverState(takeOverState);
                Object vsID = paramsList.get(ClientParameterCode.VSWITCH_SWITCH_ID);
                if (vsID != null) {
                    node.setSwitchID((Integer)vsID);
                }
                node.setReportLUNsDiscoveryEnable(reportLUNsDiscoveryEnable);
                node.setStatus(VSwitchManager.getSeverity(vSwitch.getPropagatedState()));
                node.setVSwitchStatus((VSwitchStatusConstant)paramsList.get(ClientParameterCode.VSWITCH_STATUS));
                theLogger.trace(SrLogCategories.LEGACY, "creating neighbors, during reading Vswitches from server.");
                node.setNeighbors(this.createNeighbors(neighbors, node));
                node.setInterfacesStatisticsTableNodes(nodeInterfacesStatisticsTable);
                node.setHardwareData(hardwareData);
                node.setTCPConnectionsTable(nodeTCPConnectionsTable);
                node.setUDPListenersTable(nodeUDPListenerTable);
                node.setISCSIInstanceInfo(iscsiInstanceInfoTable);
                node.setISCSIInitiators(initiatorsTable);
                node.setISCSIRemoteInitiatorsTableNodes(nodeISCSIRemoteInitiatorsTable);
                node.setISCSIRemoteInitiatorsStatisticsTableNodes(nodeISCSIRemoteInitiatorsStatisticsTable);
                node.setISCSISessionsTableNodes(nodeISCSISessionsTable);
                node.setISCSISessionsStatisticsTableNodes(nodeISCSISessionsStatisticsTable);
                node.setTargetCount(targetCount);
                this.readVSwitchStatisticsFromServer(node);
                this.updateClusterProperties(node);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to read all " + ClientLoader.VSWITCHES_DISPLAY_STRING + " from Server.");
        }
    }

    private void readVSwitchStatisticsFromServer(VSwitchNode aVswitch) throws RemoteException {
        InterfacesGroupStatisticsNode interfacesGroupStatisticsNode = this.getInterfacesGroupStatistics(aVswitch);
        aVswitch.setInterfacesStatisticsGroupNode(interfacesGroupStatisticsNode);
        RemoteInitiatorsGroupStatisticsNode remoteInitiatorsGroupStatisticsNode = this.getRemoteInitiatorsGroupStatistics(aVswitch);
        aVswitch.setISCSIRemoteInitiatorsGroupNode(remoteInitiatorsGroupStatisticsNode);
        SessionsGroupStatisticsNode sessionsGroupStatisticsNode = this.getSessionsGroupStatistics(aVswitch);
        aVswitch.setISCSISessionsGroupNode(sessionsGroupStatisticsNode);
        if (aVswitch.isConnected()) {
            aVswitch.setIPStatistics(this.getIPStatistics(aVswitch));
            aVswitch.setICMPStatistics(this.getICMPStatistics(aVswitch));
            aVswitch.setTCPStatistics(this.getTCPStatistics(aVswitch));
            aVswitch.setUDPStatistics(this.getUDPStatistics(aVswitch));
        }
    }

    private List<Neighbor> createNeighbors(List stubs, VSwitchNode nodeParent) throws RemoteException {
        ArrayList<Neighbor> neighbors = new ArrayList<Neighbor>();
        if (stubs == null || stubs.isEmpty()) {
            return neighbors;
        }
        for (Object stub : stubs) {
            com.sanrad.nms.server.logic.vswitch.Neighbor neighbor = (com.sanrad.nms.server.logic.vswitch.Neighbor)stub;
            Neighbor nbr = (Neighbor)SystemRootNode.getInstance().getRefByStub(neighbor);
            if (nbr == null) {
                nbr = new Neighbor(neighbor);
                nbr.setIPAddress(neighbor.getIPAddress());
                nbr.setLastKeepAliveReceived(neighbor.getLastKeepAliveReceived());
                nbr.setName(neighbor.getName());
                nbr.setNeighborStatus(neighbor.getStatus());
                SystemRootNode.getInstance().putRefAndStub(neighbor, nbr);
            }
            nbr.setVSwitchParent(nodeParent);
            neighbors.add(nbr);
        }
        return neighbors;
    }

    private Vector getPortalTable(Vector<? extends com.sanrad.nms.server.logic.vswitch.PortalTableRow> portalTable) {
        Vector<SrTargetPortalTableRow> nodePortalTable = new Vector<SrTargetPortalTableRow>();
        try {
            if (portalTable != null && !portalTable.isEmpty()) {
                for (com.sanrad.nms.server.logic.vswitch.PortalTableRow portalTableRow : portalTable) {
                    IscsiPortalRolesConstant role = portalTableRow.getRole();
                    PortalTableRow nodePortalTableRow = IscsiPortalRolesConstant.TARGET.equals(role) || IscsiPortalRolesConstant.TARGET_AND_INITIATOR.equals(role) ? new SrTargetPortalTableRow(portalTableRow, portalTableRow.getParentVSwitch(), portalTableRow.getIPAddress(), portalTableRow.getPort(), portalTableRow.getTag(), portalTableRow.getRole()) : new PortalTableRow(portalTableRow, portalTableRow.getParentVSwitch(), portalTableRow.getIPAddress(), portalTableRow.getTag(), portalTableRow.getRole());
                    SystemRootNode.getInstance().putRefAndStub(portalTableRow, nodePortalTableRow);
                    nodePortalTable.addElement((SrTargetPortalTableRow)nodePortalTableRow);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get the Portal Table from the Server.");
        }
        return nodePortalTable;
    }

    private Vector<IPTableRow> getIPTable(Vector<? extends com.sanrad.nms.server.logic.vswitch.IPTableRow> ipTable) {
        Vector<IPTableRow> nodeIPTable = new Vector<IPTableRow>();
        try {
            if (ipTable != null && !ipTable.isEmpty()) {
                for (com.sanrad.nms.server.logic.vswitch.IPTableRow iPTableRow : ipTable) {
                    IPTableRow nodeIPTableRow = new IPTableRow(iPTableRow, iPTableRow.getParentVSwitch(), iPTableRow.getIPAddress(), iPTableRow.getIPMask(), iPTableRow.getActivity(), iPTableRow.getInterface());
                    SystemRootNode.getInstance().putRefAndStub(iPTableRow, nodeIPTableRow);
                    nodeIPTable.addElement(nodeIPTableRow);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get IP table from the Server.");
        }
        return nodeIPTable;
    }

    private Vector getTCPConnectionsTable(Vector tcpConnectionsTable) {
        Vector<TCPConnectionsTableRow> nodeTCPConnectionsTable = new Vector<TCPConnectionsTableRow>();
        try {
            if (tcpConnectionsTable != null && !tcpConnectionsTable.isEmpty()) {
                for (int j = 0; j < tcpConnectionsTable.size(); ++j) {
                    TCPConnectionStatisticsTableRow row = (TCPConnectionStatisticsTableRow)tcpConnectionsTable.get(j);
                    HashMap rowVals = row.getClientParameterList();
                    TCPConnectionsTableRow nodeTCPConn = new TCPConnectionsTableRow(row, row.getParentVSwitch(), (Inet4Address)rowVals.get(ClientParameterCode.TCP_CONNECTION_LOCAL_ADDRESS), (Integer)rowVals.get(ClientParameterCode.TCP_CONNECTION_LOCAL_PORT), (Inet4Address)rowVals.get(ClientParameterCode.TCP_CONNECTION_REMOTE_ADDRESS), (Integer)rowVals.get(ClientParameterCode.TCP_CONNECTION_REMOTE_PORT), (TCPConStateConstant)rowVals.get(ClientParameterCode.TCP_CONNECTION_STATE));
                    SystemRootNode.getInstance().putRefAndStub(row, nodeTCPConn);
                    nodeTCPConnectionsTable.addElement(nodeTCPConn);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get TCP Connections table from the Server.");
        }
        catch (IllegalValueException re) {
            theLogger.trace(SrLogCategories.LEGACY, re.getMessage());
        }
        return nodeTCPConnectionsTable;
    }

    private Vector getUDPListenerTable(Vector udpListenerTable) {
        Vector<UDPListenerTableRow> nodeUDPListenerTable = new Vector<UDPListenerTableRow>();
        try {
            if (udpListenerTable != null && !udpListenerTable.isEmpty()) {
                for (int j = 0; j < udpListenerTable.size(); ++j) {
                    UDPListenerStatisticsTableRow row = (UDPListenerStatisticsTableRow)udpListenerTable.get(j);
                    HashMap rowVals = row.getClientParameterList();
                    UDPListenerTableRow nodeUDPListener = new UDPListenerTableRow(row, row.getParentVSwitch(), (Inet4Address)rowVals.get(ClientParameterCode.UDP_LISTENER_ADDRESS), (Integer)rowVals.get(ClientParameterCode.UDP_LISTENER_PORT));
                    SystemRootNode.getInstance().putRefAndStub(row, nodeUDPListener);
                    nodeUDPListenerTable.addElement(nodeUDPListener);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get UDP Listener table from the Server.");
        }
        catch (IllegalValueException re) {
            theLogger.trace(SrLogCategories.LEGACY, re.getMessage());
        }
        return nodeUDPListenerTable;
    }

    private Vector getIPRouteTable(Vector ipRouteTable) {
        Vector<IPRouteTableRow> nodeIPRouteTable = new Vector<IPRouteTableRow>();
        try {
            if (ipRouteTable != null && !ipRouteTable.isEmpty()) {
                for (int k = 0; k < ipRouteTable.size(); ++k) {
                    com.sanrad.nms.server.logic.vswitch.IPRouteTableRow row = (com.sanrad.nms.server.logic.vswitch.IPRouteTableRow)ipRouteTable.get(k);
                    IPRouteTableRow nodeIPRouteTableRow = new IPRouteTableRow(row, row.getParentVSwitch(), row.getDestIPAdress(), row.getDestIPMask(), row.getGateway(), row.getInterface());
                    SystemRootNode.getInstance().putRefAndStub(row, nodeIPRouteTableRow);
                    nodeIPRouteTable.addElement(nodeIPRouteTableRow);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get IP Route Table from the Server.");
        }
        return nodeIPRouteTable;
    }

    private Vector getInterfaceTable(Vector interfaceTable) {
        Vector<InterfaceTableRowNode> nodeInterfaceTable = new Vector<InterfaceTableRowNode>();
        try {
            if (interfaceTable != null && !interfaceTable.isEmpty()) {
                for (int x = 0; x < interfaceTable.size(); ++x) {
                    InterfaceTableRow row = (InterfaceTableRow)interfaceTable.get(x);
                    String type = row.getType();
                    InterfaceTableRowNode nodeInterfaceTableRow = null;
                    if (type != null) {
                        if (type.equals("fibreChannel")) {
                            com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRow fcRow = (com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRow)row;
                            nodeInterfaceTableRow = new FCInterfaceTableRow(fcRow, fcRow.getParentVSwitch(), fcRow.getAlias(), fcRow.getDescriptor(), fcRow.getHighSpeedMbits(), fcRow.getName(), fcRow.getPhysicalAddress(), fcRow.getType(), fcRow.getOperationalStatus());
                            ((FCInterfaceTableRow)nodeInterfaceTableRow).setPortType(fcRow.getOperType());
                            ((FCInterfaceTableRow)nodeInterfaceTableRow).setSpeed(fcRow.getAdminSpeed());
                            ((FCInterfaceTableRow)nodeInterfaceTableRow).setTopology(fcRow.getConnectMode());
                            ((FCInterfaceTableRow)nodeInterfaceTableRow).setWWPN(fcRow.getWWPN());
                            if (fcRow.getConnectedSFPType() == null) {
                                ((FCInterfaceTableRow)nodeInterfaceTableRow).setSFPType(InterfaceSFPConnectorConstant.UNKNOWN);
                            } else {
                                ((FCInterfaceTableRow)nodeInterfaceTableRow).setSFPType(fcRow.getConnectedSFPType());
                                ((FCInterfaceTableRow)nodeInterfaceTableRow).setSFPVendorName(fcRow.getConnectedSFPVendorName());
                                ((FCInterfaceTableRow)nodeInterfaceTableRow).setSFPSpeed(fcRow.getConnectedSFPSpeedMbits());
                                ((FCInterfaceTableRow)nodeInterfaceTableRow).setSFPVendorOUI(fcRow.getConnectedSFPVendorOUI());
                            }
                        } else if (type.equals("ethernetCsmacd")) {
                            com.sanrad.nms.server.logic.vswitch.ethernet.EthernetInterfaceTableRow ethernetRow = (com.sanrad.nms.server.logic.vswitch.ethernet.EthernetInterfaceTableRow)row;
                            nodeInterfaceTableRow = new EthernetInterfaceTableRow(ethernetRow, ethernetRow.getParentVSwitch(), ethernetRow.getAlias(), ethernetRow.getDescriptor(), ethernetRow.getHighSpeedMbits(), ethernetRow.getName(), ethernetRow.getPhysicalAddress(), ethernetRow.getType(), ethernetRow.getOperationalStatus());
                            if (ethernetRow.getConnectedSFPType() == null) {
                                ((EthernetInterfaceTableRow)nodeInterfaceTableRow).setSFPType(InterfaceSFPConnectorConstant.UNKNOWN);
                            } else if (!nodeInterfaceTableRow.isMgntInterface()) {
                                ((EthernetInterfaceTableRow)nodeInterfaceTableRow).setSFPType(ethernetRow.getConnectedSFPType());
                                ((EthernetInterfaceTableRow)nodeInterfaceTableRow).setSFPVendorName(ethernetRow.getConnectedSFPVendorName());
                                ((EthernetInterfaceTableRow)nodeInterfaceTableRow).setSFPSpeed(ethernetRow.getConnectedSFPSpeedMbits());
                                ((EthernetInterfaceTableRow)nodeInterfaceTableRow).setSFPVendorOUI(ethernetRow.getConnectedSFPVendorOUI());
                            }
                        } else if (type.equals("ultra")) {
                            com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRow pscsiRow = (com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRow)row;
                            nodeInterfaceTableRow = new PSCSIInterfaceTableRow(pscsiRow, pscsiRow.getParentVSwitch(), pscsiRow.getAlias(), pscsiRow.getDescriptor(), pscsiRow.getHighSpeedMbits(), pscsiRow.getName(), pscsiRow.getPhysicalAddress(), pscsiRow.getType(), pscsiRow.getOperationalStatus());
                            ((PSCSIInterfaceTableRow)nodeInterfaceTableRow).setBusId(pscsiRow.getBusId());
                        } else {
                            nodeInterfaceTableRow = new InterfaceTableRowNode<InterfaceTableRow>(row, row.getParentVSwitch(), row.getAlias(), row.getDescriptor(), row.getHighSpeedMbits(), row.getName(), row.getPhysicalAddress(), row.getType(), row.getOperationalStatus());
                        }
                        nodeInterfaceTableRow.setJumboMtu(row.getJumboMtu());
                        SystemRootNode.getInstance().putRefAndStub(row, nodeInterfaceTableRow);
                        nodeInterfaceTable.addElement(nodeInterfaceTableRow);
                        continue;
                    }
                    theLogger.error(SrLogCategories.LEGACY, "Type of interface ", row.getAlias(), " is null");
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get Interface Table from the Server.");
        }
        return nodeInterfaceTable;
    }

    private Vector getInterfacesStatisticsTable(VSwitchNode aVSwitchNode) {
        VSwitch vSwitch = (VSwitch)aVSwitchNode.getStub();
        Vector<InterfacesStatisticsNode> nodeInterfacesStatisticsTable = new Vector<InterfacesStatisticsNode>();
        try {
            Vector<? extends InterfaceStatisticsTableRow> interfacesStatisticsTable = vSwitch.getInterfacesStatisticsTable();
            if (interfacesStatisticsTable != null && !interfacesStatisticsTable.isEmpty()) {
                for (int index = 0; index < interfacesStatisticsTable.size(); ++index) {
                    InterfaceStatisticsTableRow row = interfacesStatisticsTable.get(index);
                    InterfacesStatisticsNode interfaceStatisticsTableRowNode = new InterfacesStatisticsNode(row, aVSwitchNode);
                    SystemRootNode.getInstance().putRefAndStub(row, interfaceStatisticsTableRowNode);
                    nodeInterfacesStatisticsTable.addElement(interfaceStatisticsTableRowNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get Interfaces Statistics Table from the Server.");
        }
        return nodeInterfacesStatisticsTable;
    }

    private EthernetStatisticsNode getEthernetStatistics(VSwitchNode aVSwitchNode) {
        return null;
    }

    private IPStatisticsNode getIPStatistics(VSwitchNode vSwitch) {
        try {
            IPStatistics ipStatistics = ((VSwitch)vSwitch.getStub()).getIPStatistics();
            if (ipStatistics == null) {
                theLogger.trace(SrLogCategories.CLIENT_SERVER_INTERFACE, "Failed to create IP Statistics, the IpStatistics is null.");
                return null;
            }
            IPStatisticsNode ipStatisticsNode = new IPStatisticsNode(ipStatistics, vSwitch);
            SystemRootNode.getInstance().putRefAndStub(ipStatistics, ipStatisticsNode);
            return ipStatisticsNode;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, "Failed to create IP Statistics.");
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to create IP Statistics.");
            return null;
        }
    }

    private ICMPStatisticsNode getICMPStatistics(VSwitchNode vSwitch) {
        try {
            ICMPStatistics icmpStatistics = ((VSwitch)vSwitch.getStub()).getICMPStatistics();
            if (icmpStatistics == null) {
                theLogger.trace(SrLogCategories.CLIENT_SERVER_INTERFACE, "Failed to create ICMP Statistics, the ICMPStatistics are null");
                return null;
            }
            ICMPStatisticsNode icmpStatisticsNode = new ICMPStatisticsNode(icmpStatistics, vSwitch);
            SystemRootNode.getInstance().putRefAndStub(icmpStatistics, icmpStatisticsNode);
            return icmpStatisticsNode;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, "Failed to create ICMP Statistics.");
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to create ICMP Statistics.");
            return null;
        }
    }

    private TCPStatisticsNode getTCPStatistics(VSwitchNode aVSwitchNode) {
        try {
            TCPStatistics tcpStatistics = ((VSwitch)aVSwitchNode.getStub()).getTCPStatistics();
            if (tcpStatistics == null) {
                theLogger.trace(SrLogCategories.CLIENT_SERVER_INTERFACE, "Failed to create TCP Statistics, the tcpStatistics are null");
                return null;
            }
            TCPStatisticsNode tcpStatisticsNode = new TCPStatisticsNode(tcpStatistics, aVSwitchNode);
            SystemRootNode.getInstance().putRefAndStub(tcpStatistics, tcpStatisticsNode);
            return tcpStatisticsNode;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, "Failed to create TCP Statistics.");
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to create TCP Statistics.");
            return null;
        }
    }

    private UDPStatisticsNode getUDPStatistics(VSwitchNode aVSwitchNode) {
        try {
            UDPStatistics udpStatistics = ((VSwitch)aVSwitchNode.getStub()).getUDPStatistics();
            if (udpStatistics == null) {
                theLogger.trace(SrLogCategories.CLIENT_SERVER_INTERFACE, "Failed to create UDP Statistics, the udpStatistics are null");
                return null;
            }
            UDPStatisticsNode udpStatisticsNode = new UDPStatisticsNode(udpStatistics, aVSwitchNode);
            SystemRootNode.getInstance().putRefAndStub(udpStatistics, udpStatisticsNode);
            return udpStatisticsNode;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, "Failed to create UDP Statistics.");
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to create UDP Statistics.");
            return null;
        }
    }

    private InterfacesGroupStatisticsNode getInterfacesGroupStatistics(VSwitchNode vSwitch) throws RemoteException {
        InterfacesGroupStatistics interfacesGroupStatistics = ((VSwitch)vSwitch.getStub()).getInterfacesGroupStatistics();
        InterfacesGroupStatisticsNode interfacesGroupStatisticsNode = new InterfacesGroupStatisticsNode(interfacesGroupStatistics, vSwitch);
        SystemRootNode.getInstance().putRefAndStub(interfacesGroupStatistics, interfacesGroupStatisticsNode);
        return interfacesGroupStatisticsNode;
    }

    private HardwareData getHardwareData(VSwitch vSwitch) {
        try {
            Hardware hardware = vSwitch.getHardware();
            HardwareData hardwareData = null;
            if (hardware != null) {
                hardwareData = new HardwareData(hardware);
                hardwareData.setMaxNumOfPowerSuppliers(hardware.getMaxNumOfPowerSuppliers());
                hardwareData.setCurrNumOfWorkingPowerSuppliers(hardware.getCurrentNumOfWorkingPowerSuppliers());
                hardwareData.setMaxNumOfFANs(hardware.getMaxNumOfFans());
                hardwareData.setCurrNumOfWorkingFANs(hardware.getCurrentNumOfWorkingFans());
                hardwareData.setOnboardTemp(hardware.getOnBoardTemp());
                hardwareData.setCPUTemp(hardware.getCPUTemp());
                hardwareData.setOnboardFactoryTempThresh(hardware.getOnBoardFactoryTempThresh());
                hardwareData.setCpuFactoryTempThresh(hardware.getCPUFactoryTempThresh());
                hardwareData.setOnboardWarningTempThresh(hardware.getOnBoardWarningTempThresh());
                hardwareData.setCPUWarningTempThresh(hardware.getCPUWarningTempThresh());
                hardwareData.setOnboardTempStatus(hardware.getOnBoardTempStatus());
                hardwareData.setCPUTempStatus(hardware.getCPUTempStatus());
                SystemRootNode.getInstance().putRefAndStub(hardware, hardwareData);
            }
            return hardwareData;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, "Failed to create Neighbors.");
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to create Neighbors.");
            return null;
        }
    }

    private Vector getISCSIInstanceInfoTable(VSwitch vSwitch) {
        Vector iscsiInfosNodes = ISCSIInstancesManager.getInstance().readAllISCSIInstances(vSwitch);
        return iscsiInfosNodes;
    }

    private ArrayList getInitiatorTable(VSwitch vSwitch) {
        ArrayList initiatorNodes = SrInitiatorManager.getInstance().readAllInitiators(vSwitch);
        return initiatorNodes;
    }

    private Vector getISCSIRemoteInitiatorsTable(VSwitch vSwitch) {
        Vector iscsiRemoteInitiatorsTableNodes = ISCSIRemoteInitiatorsManager.getInstance().readAllISCSIRemoteInitiators(vSwitch);
        return iscsiRemoteInitiatorsTableNodes;
    }

    private RemoteInitiatorsGroupStatisticsNode getRemoteInitiatorsGroupStatistics(VSwitchNode aVSwitchNode) {
        RemoteInitiatorsGroupStatisticsNode iscsiRemoteInitiatorsStatisticsGroupNode = ISCSIRemoteInitiatorsStatisticsManager.getInstance().readISCSIRemoteInitiatorsGroupStatistics(aVSwitchNode);
        return iscsiRemoteInitiatorsStatisticsGroupNode;
    }

    private Vector getISCSIRemoteInitiatorsStatisticsTable(VSwitch vSwitch) {
        Vector iscsiRemoteInitiatorsStatisticsTableNodes = ISCSIRemoteInitiatorsStatisticsManager.getInstance().readAllISCSIRemoteInitiatorsStatistics(vSwitch);
        return iscsiRemoteInitiatorsStatisticsTableNodes;
    }

    private Vector getISCSISessionsTable(VSwitch vSwitch) {
        Vector iscsiSessionsTableNodes = ISCSISessionsManager.getInstance().readAllISCSISessions(vSwitch);
        return iscsiSessionsTableNodes;
    }

    private SessionsGroupStatisticsNode getSessionsGroupStatistics(VSwitchNode aVSwitchNode) {
        SessionsGroupStatisticsNode iscsiSessionsStatisticsGroupNode = ISCSISessionsStatisticsManager.getInstance().readISCSISessionsGroupStatistics(aVSwitchNode);
        return iscsiSessionsStatisticsGroupNode;
    }

    private Vector getISCSISessionsStatisticsTable(VSwitch vSwitch) {
        Vector iscsiSessionsStatisticsTableNodes = ISCSISessionsStatisticsManager.getInstance().readAllISCSISessionsStatistics(vSwitch);
        return iscsiSessionsStatisticsTableNodes;
    }

    public Date getDateAndTimeFromServer(VSwitchNode node) {
        try {
            Long l;
            Object obj = node.getStub();
            if (obj != null && (l = ((VSwitch)obj).getDateAndTime()) != null) {
                return new Date(l);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to get Date and Time from the Server.");
        }
        return null;
    }

    private void fireRediscoverStarted(VSwitch vswitch) {
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(vswitch);
        if (obj != null) {
            VSwitchEvent event = this.createEvent((VSwitchNode)obj);
            this.m_listeners.fireEvent(VSwitchListener.class, event, this.vSwitchRediscoveredInformer);
        }
    }

    public void addVSwitchListener(VSwitchListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeVSwitchListener(VSwitchListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void resetVSwitchStarted(CommunicationEvent e) {
        RemoteObject obj = e.getElement();
        if (obj != null) {
            theLogger.trace(SrLogCategories.LEGACY, "Reset ", ClientLoader.VSWITCH_DISPLAY_STRING, " started.");
            VSwitchEvent event = new VSwitchEvent(this, obj);
            this.m_listeners.fireEvent(VSwitchListener.class, event, this.resetVSwitchStartedInformer);
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            theLogger.trace(SrLogCategories.LEGACY, "VSwitch created. ");
            VSwitch vSwitch = (VSwitch)element;
            HashMap params = this.getParameterList(e);
            VSwitchNode vSwitchNode = this.createVSwitchNode(vSwitch, params);
            ClusterNode clusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(vSwitch.getCluster());
            if (VSwitchManager.isThereOtherConnectedVSwitch(vSwitchNode, clusterNode, false)) {
                clusterNode.addGraphicalIndication(clusterNode, ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.ADDING_NEIGHBOR, vSwitchNode.getIPAddress()));
            }
            this.fireVSwitchCreatedEvent(vSwitchNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            VSwitchManager.onConnectionError();
        }
    }

    private VSwitchNode createVSwitchNode(VSwitch vSwitch, HashMap params) throws RemoteException {
        VSwitchNode vSwitchNode = new VSwitchNode(vSwitch);
        try {
            Object mgmIPAddr = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_MGM_IP_ADDRESS", true);
            Object nameObj = this.getObjectForParam(params, ClientParameterCode.VSWITCH_NAME, true);
            Object mgmMask = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_MGM_MASK", true);
            Object readCommunity = this.getObjectForParam(params, ClientParameterCode.VSWITCH_READ_COMMUNITY, true);
            Object numOfRetries = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_NUMBER_OF_RETRIES", true);
            Object snmpPort = this.getObjectForParam(params, ClientParameterCode.VSWITCH_SNMP_PORT, true);
            Object timeout = this.getObjectForParam(params, ClientParameterCode.VSWITCH_TIMEOUT, true);
            Object trapPort = this.getObjectForParam(params, ClientParameterCode.VSWITCH_TRAP_PORT, true);
            Object writeCommunity = this.getObjectForParam(params, ClientParameterCode.VSWITCH_WRITE_COMMUNITY, true);
            Object contact = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_CONTACT", true);
            Object location = this.getObjectForParam(params, ClientParameterCode.VSWITCH_LOCATION, true);
            Object telnetPort = this.getObjectForParam(params, ClientParameterCode.VSWITCH_TELNET_PORT, true);
            Object switchId = this.getObjectForParam(params, ClientParameterCode.VSWITCH_SWITCH_ID, true);
            Object reportLUNsDiscoveryEnable = this.getObjectForParam(params, ClientParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, true);
            Object propagatedState = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
            Vector<? extends com.sanrad.nms.server.logic.vswitch.Neighbor> neighborTable = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_NEIGHBOR_TABLE", true);
            Vector<? extends InterfaceTableRow> ethernetInterfaces = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_ETHERNET_INTERFACES", true);
            Object dateAndTime = this.getObjectForParam(params, ClientParameterCode.VSWITCH_DATE_AND_TIME, true);
            Object lastReset = this.getObjectForParam(params, ClientParameterCode.VSWITCH_LAST_RESET, true);
            Object description = this.getObjectForParam(params, ClientParameterCode.VSWITCH_DESCRIPTION, true);
            Object takeOverState = this.getObjectForParam(params, ClientParameterCode.TAKEOVER_STATE, true);
            Object snmpVersion = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_SNMP_VERSION", true);
            Object functions = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_FUNCTIONS", true);
            Object wwnn = this.getObjectForParam(params, "Missing code - ClientParameterCode.VSWITCH_WWNN", true);
            Integer targetCount = (Integer)this.getObjectForParam(params, ClientParameterCode.VSWITCH_TARGETS_COUNT, true);
            VSwitchStatusConstant status = (VSwitchStatusConstant)this.getObjectForParam(params, ClientParameterCode.VSWITCH_STATUS, true);
            IscsiTgtQosActivityConstant qosEnable = (IscsiTgtQosActivityConstant)this.getObjectForParam(params, ClientParameterCode.VSWITCH_TGT_QOS_ACTIVITY, false);
            IscsiTgtQosRateTypeConstant qosRateType = (IscsiTgtQosRateTypeConstant)this.getObjectForParam(params, ClientParameterCode.VSWITCH_TGT_QOS_RATE_TYPE, false);
            BigInteger qosLimit = (BigInteger)this.getObjectForParam(params, ClientParameterCode.VSWITCH_TGT_QOS_MAX_RATE_LIMIT, false);
            Double statisticsPollIntervalMinutes = (Double)this.getObjectForParam(params, ClientParameterCode.VSWITCH_STATISTICS_POLL_INTERVAL, false);
            if (mgmIPAddr == null) {
                mgmIPAddr = vSwitch.getMgmIPAddr();
            }
            if (nameObj == null) {
                nameObj = vSwitch.getName();
            }
            if (mgmMask == null) {
                mgmMask = vSwitch.getMgmMask();
            }
            if (readCommunity == null) {
                readCommunity = vSwitch.getReadCommunity();
            }
            if (numOfRetries == null) {
                numOfRetries = new Integer(vSwitch.getNumberOfRetries());
            }
            if (snmpPort == null) {
                snmpPort = new Integer(vSwitch.getSnmpPort());
            }
            if (timeout == null) {
                timeout = new Long(vSwitch.getTimeout());
            }
            if (trapPort == null) {
                trapPort = vSwitch.getTrapPort();
            }
            if (writeCommunity == null) {
                writeCommunity = vSwitch.getWriteCommunity();
            }
            if (contact == null) {
                contact = vSwitch.getContact();
            }
            if (location == null) {
                location = vSwitch.getLocation();
            }
            if (telnetPort == null) {
                telnetPort = vSwitch.getTelnetPort();
            }
            if (switchId == null) {
                switchId = vSwitch.getSwitchID();
            }
            if (reportLUNsDiscoveryEnable == null) {
                reportLUNsDiscoveryEnable = vSwitch.isReportLUNsDiscoveryEnable();
            }
            if (propagatedState == null) {
                propagatedState = vSwitch.getPropagatedState();
            }
            if (neighborTable == null) {
                neighborTable = vSwitch.getNeighborTable();
            }
            if (ethernetInterfaces == null) {
                ethernetInterfaces = vSwitch.getEthernetInterfaces();
            }
            if (dateAndTime == null) {
                dateAndTime = vSwitch.getDateAndTime();
            }
            if (lastReset == null) {
                lastReset = vSwitch.getLastReset();
            }
            if (description == null) {
                description = vSwitch.getDescription();
            }
            if (snmpVersion == null) {
                snmpVersion = vSwitch.getSnmpVersion();
            }
            if (functions == null) {
                functions = vSwitch.getFunctions();
            }
            if (wwnn == null) {
                wwnn = vSwitch.getWWNN();
            }
            if (takeOverState == null) {
                takeOverState = vSwitch.getTakeOverState();
            }
            vSwitchNode.setIPAddress((String)mgmIPAddr);
            vSwitchNode.setName((String)nameObj);
            vSwitchNode.setManagedIPAddress((String)mgmIPAddr);
            vSwitchNode.setMask((String)mgmMask);
            vSwitchNode.setReadCommunity((String)readCommunity);
            vSwitchNode.setRetries((Integer)numOfRetries);
            vSwitchNode.setSNMPPort((Integer)snmpPort);
            vSwitchNode.setTimeout((Long)timeout);
            vSwitchNode.setTrapPort((Integer)trapPort);
            vSwitchNode.setWriteCommunity((String)writeCommunity);
            vSwitchNode.setContact((String)contact);
            vSwitchNode.setLocation((String)location);
            vSwitchNode.setTelnetPort((BigInteger)telnetPort);
            vSwitchNode.setSwitchID((Integer)switchId);
            vSwitchNode.setReportLUNsDiscoveryEnable((Boolean)reportLUNsDiscoveryEnable);
            vSwitchNode.setStatus(VSwitchManager.getSeverity((AlarmSeverity)propagatedState));
            vSwitchNode.setVSwitchStatus(status);
            vSwitchNode.setQosEnable(qosEnable);
            vSwitchNode.setQosRateType(qosRateType);
            vSwitchNode.setQosLimit(qosLimit);
            if (statisticsPollIntervalMinutes != null) {
                vSwitchNode.setStatisticsPollInterval((int)(statisticsPollIntervalMinutes * 60.0));
            }
            List neighbors = neighborTable;
            theLogger.trace(SrLogCategories.LEGACY, "creating neighbors, after VSWITCH elementCreate()");
            List<Neighbor> nbrs = this.createNeighbors(neighbors, vSwitchNode);
            vSwitchNode.setNeighbors(nbrs);
            theLogger.trace(SrLogCategories.LEGACY, "setting neighbors vector of size: ", nbrs.size());
            vSwitchNode.setEthernetInterfaces(ethernetInterfaces);
            if (dateAndTime != null) {
                vSwitchNode.setDate(new Date((Long)dateAndTime));
            }
            if (lastReset != null) {
                vSwitchNode.setLastReset(new Date((Long)lastReset));
            }
            vSwitchNode.setDescription((String)description);
            vSwitchNode.setSnmpVersion((SnmpVersion)snmpVersion);
            vSwitchNode.setFunctions((String)functions);
            vSwitchNode.setWWNN((String)wwnn);
            vSwitchNode.setConnected(vSwitch.isConnected());
            vSwitchNode.setTakeoverState((SDTakeOverStateConstant)takeOverState);
            vSwitchNode.setTargetCount(targetCount);
            SystemRootNode.getInstance().putRefAndStub(vSwitch, vSwitchNode);
            this.updateClusterProperties(vSwitchNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to create the " + ClientLoader.VSWITCH_DISPLAY_STRING);
            throw re;
        }
        return vSwitchNode;
    }

    private void updateClusterProperties(VSwitchNode vSwitchNode) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(vSwitchNode);
        try {
            Cluster clusterStub = (Cluster)clusterNode.getStub();
            clusterNode.setKeepAlive(clusterStub.getKeepAlive());
            clusterNode.setFaultyInterval(clusterStub.getKeepAlive());
            clusterNode.setFaultyInterval(clusterStub.getFaultyInterval());
            clusterNode.setSuspiciousInterval(clusterStub.getSuspiciousInterval());
            clusterNode.setTotalCapacity(clusterStub.getTotalCapacity());
            clusterNode.setAccessibleSpace(clusterStub.getAccessibleSpace());
            clusterNode.setTakeoverState(clusterStub.getTakeoverState());
            clusterNode.setFailoverEnable(clusterStub.isFailoverEnable());
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed to update cluster properties (Cluster: " + clusterNode + ", " + ClientLoader.VSWITCH_DISPLAY_STRING + ": " + vSwitchNode);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        VSwitchNode node = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(element);
        theLogger.trace(SrLogCategories.LEGACY, "VSwitch removed. ");
        if (node != null) {
            VolumeManager.getInstance().clearVSwitchJournals(node);
            ClusterNode cluster = (ClusterNode)node.getParent();
            if (cluster != null && VSwitchManager.isThereOtherConnectedVSwitch(node, cluster, true)) {
                cluster.addGraphicalIndication(cluster, ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.REMOVING_NEIGHBOR, node.getIPAddress()));
            }
            this.fireVSwitchRemovedEvent(node);
        }
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    private static boolean isThereOtherConnectedVSwitch(VSwitchNode aVSwitchNode, ClusterNode cluster, boolean aIsMustContainAsNeighbor) {
        VSwitchNode[] switches;
        for (VSwitchNode otherNode : switches = cluster.getVSwitches()) {
            if (otherNode.equals(aVSwitchNode) || !otherNode.isConnected()) continue;
            if (!aIsMustContainAsNeighbor) {
                return true;
            }
            for (Neighbor neighbor : otherNode.getNeighbors()) {
                if (!neighbor.getIPAddress().equals(aVSwitchNode.getIPAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public void elementRemovedFromVSwitch(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = this.getParameterList(e);
        Object changedContact = this.getObjectForParam(map, ClientParameterCode.VSWITCH_CONTACT, false);
        Object changedDate = this.getObjectForParam(map, ClientParameterCode.VSWITCH_DATE_AND_TIME, false);
        Object changedLocation = this.getObjectForParam(map, ClientParameterCode.VSWITCH_LOCATION, false);
        Object changedName = this.getObjectForParam(map, ClientParameterCode.VSWITCH_NAME, false);
        Object changedReadCommunity = this.getObjectForParam(map, ClientParameterCode.VSWITCH_READ_COMMUNITY, false);
        Object changedRetries = this.getObjectForParam(map, ClientParameterCode.VSWITCH_RETRIES, false);
        Object changedSnmpPort = this.getObjectForParam(map, ClientParameterCode.VSWITCH_SNMP_PORT, false);
        Object changedTimeout = this.getObjectForParam(map, ClientParameterCode.VSWITCH_TIMEOUT, false);
        Object changedTrapPort = this.getObjectForParam(map, ClientParameterCode.VSWITCH_TRAP_PORT, false);
        Object changedWriteCommunity = this.getObjectForParam(map, ClientParameterCode.VSWITCH_WRITE_COMMUNITY, false);
        Object changedLastReset = this.getObjectForParam(map, ClientParameterCode.VSWITCH_LAST_RESET, false);
        Object changedDescription = this.getObjectForParam(map, ClientParameterCode.VSWITCH_DESCRIPTION, false);
        Object changedConnectionStatus = this.getObjectForParam(map, ClientParameterCode.VSWITCH_CONNECTED, false);
        Object changedTelnetPort = this.getObjectForParam(map, ClientParameterCode.VSWITCH_TELNET_PORT, false);
        Object changedSwitchId = this.getObjectForParam(map, ClientParameterCode.VSWITCH_SWITCH_ID, false);
        Object reportLUNsDiscoveryEnable = this.getObjectForParam(map, ClientParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, false);
        Object faultyInterval = this.getObjectForParam(map, ClientParameterCode.FAULTY_INTERVAL, false);
        Object susInterval = this.getObjectForParam(map, ClientParameterCode.SUSPICIOUS_INTERVAL, false);
        Object keepAlive = this.getObjectForParam(map, ClientParameterCode.KEEP_ALIVE, false);
        Object failoverEnable = this.getObjectForParam(map, ClientParameterCode.FAILOVER_ENABLE, false);
        Object takeoverState = this.getObjectForParam(map, ClientParameterCode.TAKEOVER_STATE, false);
        Object temperatureUnits = this.getObjectForParam(map, ClientParameterCode.HW_TEMPERATURE_UNITS, false);
        Integer targetCount = (Integer)this.getObjectForParam(map, ClientParameterCode.VSWITCH_TARGETS_COUNT, false);
        VSwitchStatusConstant status = (VSwitchStatusConstant)this.getObjectForParam(map, ClientParameterCode.VSWITCH_STATUS, false);
        BigInteger qosLimit = (BigInteger)this.getObjectForParam(map, ClientParameterCode.VSWITCH_TGT_QOS_MAX_RATE_LIMIT, false);
        IscsiTgtQosActivityConstant qosEnable = (IscsiTgtQosActivityConstant)this.getObjectForParam(map, ClientParameterCode.VSWITCH_TGT_QOS_ACTIVITY, false);
        IscsiTgtQosRateTypeConstant qosRateType = (IscsiTgtQosRateTypeConstant)this.getObjectForParam(map, ClientParameterCode.VSWITCH_TGT_QOS_RATE_TYPE, false);
        Double statisticsPollIntervalMinutes = (Double)this.getObjectForParam(map, ClientParameterCode.VSWITCH_STATISTICS_POLL_INTERVAL, false);
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            VSwitchNode node = (VSwitchNode)obj;
            if (changedConnectionStatus != null) {
                Boolean connected = (Boolean)changedConnectionStatus;
                node.setConnected(connected);
            }
            if (changedContact != null) {
                node.setContact(changedContact.toString());
            }
            if (changedLastReset != null) {
                Long lastReset = (Long)changedLastReset;
                node.setLastReset(new Date(lastReset));
            }
            if (changedDescription != null) {
                node.setDescription(changedDescription.toString());
            }
            if (changedWriteCommunity != null) {
                node.setWriteCommunity(changedWriteCommunity.toString());
            }
            if (changedTrapPort != null) {
                node.setTrapPort((Integer)changedTrapPort);
            }
            if (changedTimeout != null) {
                node.setTimeout((Long)changedTimeout);
            }
            if (changedSnmpPort != null) {
                node.setSNMPPort((Integer)changedSnmpPort);
            }
            if (changedRetries != null) {
                node.setRetries((Integer)changedRetries);
            }
            if (changedName != null) {
                node.setName(changedName.toString());
            }
            if (changedLocation != null) {
                node.setLocation(changedLocation.toString());
            }
            if (changedDate != null) {
                long time = (Long)changedDate;
                Date date = new Date(time);
                node.setDate(date);
            }
            if (changedReadCommunity != null) {
                node.setReadCommunity(changedReadCommunity.toString());
            }
            if (changedTelnetPort != null) {
                node.setTelnetPort((BigInteger)changedTelnetPort);
            }
            if (changedSwitchId != null) {
                node.setSwitchID((Integer)changedSwitchId);
            }
            if (reportLUNsDiscoveryEnable != null) {
                Boolean enable = (Boolean)reportLUNsDiscoveryEnable;
                node.setReportLUNsDiscoveryEnable(enable);
            }
            if (temperatureUnits != null) {
                node.setTempUnits((TempetureUnitConstant)temperatureUnits);
            }
            if (susInterval != null) {
                node.setSuspiciousInterval((Integer)susInterval);
                ((ClusterNode)node.getParent()).setSuspiciousInterval((Integer)susInterval);
            }
            if (faultyInterval != null) {
                node.setFaultyInterval((Integer)faultyInterval);
                ((ClusterNode)node.getParent()).setFaultyInterval((Integer)faultyInterval);
            }
            if (keepAlive != null) {
                node.setKeepAlive((Integer)keepAlive);
                ((ClusterNode)node.getParent()).setKeepAlive((Integer)keepAlive);
            }
            if (failoverEnable != null) {
                Integer intValue = (Integer)failoverEnable;
                Boolean boolValue = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
                ((ClusterNode)node.getParent()).setFailoverEnable(boolValue);
            }
            if (takeoverState != null) {
                node.setTakeoverState((SDTakeOverStateConstant)takeoverState);
                ((ClusterNode)node.getParent()).setTakeoverState((SDTakeOverStateConstant)takeoverState);
            }
            if (targetCount != null) {
                node.setTargetCount(targetCount);
            }
            if (status != null) {
                node.setVSwitchStatus(status);
            }
            if (qosEnable != null) {
                node.setQosEnable(qosEnable);
            }
            if (qosRateType != null) {
                node.setQosRateType(qosRateType);
            }
            if (qosLimit != null) {
                node.setQosLimit(qosLimit);
            }
            if (statisticsPollIntervalMinutes != null) {
                node.setStatisticsPollInterval((int)(statisticsPollIntervalMinutes * 60.0));
            }
            this.fireVswitchPropertiesChanged(node);
            this.fireVSwitchTreeNodeChanged(node);
        }
    }

    private void fireVswitchPropertiesChanged(VSwitchNode vswitch) {
        VSwitchEvent event = this.createEvent(vswitch);
        this.m_listeners.fireEvent(VSwitchListener.class, event, this.vSwitchPropertiesChangedInformer);
    }

    @Override
    public void discoverCompleted(CommunicationEvent e) {
        super.discoverCompleted(e);
        RemoteObject element = e.getElement();
        try {
            if (element instanceof Cluster) {
                List<? extends VSwitch> vswitches = ((Cluster)element).getVSwitches();
                for (int i = 0; i < vswitches.size(); ++i) {
                    VSwitch vswitch = vswitches.get(i);
                    SrTreeNode vSwitchNode = SystemRootNode.getInstance().getRefByStub(vswitch);
                    if (vSwitchNode == null) continue;
                    ((VSwitchNode)vSwitchNode).setEthernetInterfaces(vswitch.getEthernetInterfaces());
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError();
        }
    }

    @Override
    public void discoverStarted(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        try {
            if (element instanceof Cluster) {
                List<? extends VSwitch> vswitches = ((Cluster)element).getVSwitches();
                for (int i = 0; i < vswitches.size(); ++i) {
                    VSwitch vswitch = vswitches.get(i);
                    SrTreeNode vSwitchNode = SystemRootNode.getInstance().getRefByStub(vswitch);
                    if (vSwitchNode == null || !((VSwitchNode)vSwitchNode).isConnected()) continue;
                    ((VSwitchNode)vSwitchNode).getIPRouteTable().clear();
                    ((VSwitchNode)vSwitchNode).getIPTable().clear();
                    ((VSwitchNode)vSwitchNode).getInterfaceTable().clear();
                    ((VSwitchNode)vSwitchNode).getPortalTable().clear();
                    ((VSwitchNode)vSwitchNode).getEthernetInterfaces().clear();
                    this.fireVSwitchTreeNodeChanged((VSwitchNode)vSwitchNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            VSwitchManager.onConnectionError("Failed in discovery proccess.");
        }
        if (element instanceof VSwitch) {
            this.fireRediscoverStarted((VSwitch)element);
        }
    }

    private void fireVSwitchCreatedEvent(VSwitchNode vSwitchNode) {
        VSwitchEvent event = this.createEvent(vSwitchNode);
        this.m_listeners.fireEvent(VSwitchListener.class, event, this.vSwitchCreatedInformer);
    }

    private void fireVSwitchRemovedEvent(VSwitchNode vSwitchNode) {
        VSwitchEvent event = this.createEvent(vSwitchNode);
        this.m_listeners.fireEvent(VSwitchListener.class, event, this.vSwitchRemovedInformer);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof VSwitch) {
            if (SystemRootNode.getInstance().getRefByStub(element) == null) {
                theLogger.trace(SrLogCategories.LEGACY, "VSwitchManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "VSwitchManager: VSwitch propagated state changed.");
            super.propagatedStateChanged(e);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
            if (node != null) {
                this.fireVswitchPropertiesChanged((VSwitchNode)node);
            }
        }
    }

    private VSwitchEvent createEvent(VSwitchNode vSwitch) {
        Date lastReset;
        VSwitchEvent event = new VSwitchEvent(this, (RemoteObject)vSwitch.getStub());
        event.setIPAddress(vSwitch.getManagedIPAddress());
        String name = vSwitch.getName();
        event.setName(name);
        event.setManagedIPAddress(vSwitch.getManagedIPAddress());
        event.setMask(vSwitch.getMask());
        String read = vSwitch.getReadCommunity();
        event.setReadCommunity(read);
        int retries = vSwitch.getRetries();
        event.setRetries(retries);
        int snmpPort = vSwitch.getSNMPPort();
        event.setSNMPPort(snmpPort);
        long timeout = vSwitch.getTimeout();
        event.setTimeout(timeout);
        int trapPort = vSwitch.getTrapPort();
        event.setTrapPort(trapPort);
        String write = vSwitch.getWriteCommunity();
        event.setWriteCommunity(write);
        String contact = vSwitch.getContact();
        event.setContact(contact);
        String location = vSwitch.getLocation();
        event.setLocation(location);
        BigInteger telnetPort = vSwitch.getTelnetPort();
        event.setTelnetPort(telnetPort);
        TempetureUnitConstant temperatureUnits = vSwitch.getTempUnits();
        event.setTemperatureUnits(temperatureUnits);
        Vector ipTable = vSwitch.getIPTable();
        event.setIPTable(ipTable);
        Vector ipRouteTable = vSwitch.getIPRouteTable();
        event.setIPRouteTable(ipRouteTable);
        event.setEthernetInterfaces(vSwitch.getEthernetInterfaces());
        List<InterfaceTableRowNode> interfaceTable = vSwitch.getInterfaceTable();
        event.setInterfaceTable(interfaceTable);
        Vector<PortalTableRow> portalTable = vSwitch.getPortalTable();
        event.setPortalTable(portalTable);
        Date dateAndTime = vSwitch.getDate();
        if (dateAndTime != null) {
            event.setDate(dateAndTime);
        }
        if ((lastReset = vSwitch.getLastReset()) != null) {
            event.setLastReset(lastReset);
        }
        String desc = vSwitch.getDescription();
        event.setDescription(desc);
        SnmpVersion ver = vSwitch.getSnmpVersion();
        event.setSnmpVersion(ver);
        event.setVSwitchEnabled(vSwitch.isConnected());
        return event;
    }

    public SrFuture<Void> editVSwitches(Collection<VSwitchNode> nodes, HashMap params) {
        ArrayList ids = new ArrayList(nodes.size());
        for (VSwitchNode node : nodes) {
            theLogger.trace(SrLogCategories.LEGACY, "Trying to edit ", ClientLoader.VSWITCH_DISPLAY_STRING, " properties: ", node.getName());
            ids.add(node.getIdentifier());
        }
        return ClientAOImpl.getInstance().changeElements(ids, params);
    }

    public SrFuture<Void> editAllVSwitchesInCluster(ClusterNode clusterNode, HashMap params) {
        return this.editVSwitches(Arrays.asList(clusterNode.getVSwitches()), params);
    }

    public boolean isVSwitchLegitimateForShutdown(VSwitchNode vswitch, StringBuffer sb) {
        if (!vswitch.isConnected()) {
            sb.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.VSWITCH_SHUTDOWN_VALIDATION_NOT_CONNECTED));
            return false;
        }
        if (vswitch.isVSwitch3000() || vswitch.isVSwitch2000()) {
            String vsTypeString = vswitch.isVSwitch3000() ? VSwitchSysOID.VSWITCH_SYS_OID_3000.getDescriptionName() : VSwitchSysOID.VSWITCH_SYS_OID_2000.getDescriptionName();
            String[] args = new String[]{vsTypeString};
            sb.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.VSWITCH_SHUTDOWN_VALIDATION_NOT_SUPPORTED, args));
            return false;
        }
        return true;
    }

    public boolean isVSwitchShutdownVisible(VSwitchNode vswitch) {
        if (!vswitch.isConnected()) {
            return false;
        }
        return !vswitch.isVSwitch3000() && !vswitch.isVSwitch2000();
    }

    private void fireVSwitchTreeNodeChanged(VSwitchNode node) {
        SrMainTreeModel.getInstance().notifyNodeChanged(node);
    }

    public String validateVswitchExists() {
        for (ClusterNode cluster : SystemRootNode.getInstance().getClusterNodes()) {
            if (cluster.getVswitchesCount() <= 0) continue;
            return null;
        }
        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SYSTEM_NO_VSWITCHES);
    }

    public String validateConnectedVswitchExists(ClusterNode aCluster) {
        if (!aCluster.hasConnectedVSwitches()) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.CLUSTER_NO_CONNECTED_VSWITCHES, aCluster.getAlias());
        }
        return null;
    }
}

