/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;

public abstract class TableRowNode<T extends LogicObject>
extends SrTreeNode<T, CommKeyClassId> {
    protected static SrLogger theLogger = SrLogger.getLogger();
    private VSwitchNode vSwitchParent;
    private String m_vswitchName;

    protected TableRowNode(T stub, VSwitch vSwitchParentStub) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.setParent(vSwitchParentStub);
    }

    private void setParent(VSwitch vSwitchParentStub) {
        this.vSwitchParent = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vSwitchParentStub);
    }

    public VSwitch getParentStub() {
        return (VSwitch)this.getParent().getStub();
    }

    @Override
    public VSwitchNode getParent() {
        return this.vSwitchParent;
    }

    public String getVSwitchName() {
        if (this.m_vswitchName != null) {
            return this.m_vswitchName;
        }
        if (this.getParentStub() != null) {
            try {
                return this.getParentStub().getName();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            }
        }
        return Utility.NO_VAL;
    }

    protected void setVSwitchName(String name) {
        this.m_vswitchName = name;
    }
}

