/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.Neighbor;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.vswitch.NeighborEvent;
import com.sanrad.nms.client.event.vswitch.NeighborListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.alarm.SrAlarmsTablePanel;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;

public class NeighborManager
extends ElementManager {
    private static NeighborManager instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer neighborCreatedInformer = new SrEventListenerManager.Informer<NeighborListener, NeighborEvent>(){

        @Override
        public void inform(NeighborListener listener, NeighborEvent event) {
            listener.neighborCreated(event);
        }
    };
    SrEventListenerManager.Informer neighborRemovedInformer = new SrEventListenerManager.Informer<NeighborListener, NeighborEvent>(){

        @Override
        public void inform(NeighborListener listener, NeighborEvent event) {
            listener.neighborRemoved(event);
        }
    };

    private NeighborManager() {
    }

    public static synchronized NeighborManager getInstance() {
        if (instance == null) {
            instance = new NeighborManager();
        }
        return instance;
    }

    public void addNeighborListener(NeighborListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeNeighborListener(NeighborListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        com.sanrad.nms.server.logic.vswitch.Neighbor neighbor = (com.sanrad.nms.server.logic.vswitch.Neighbor)e.getElement();
        try {
            if (this.alreadyExist(neighbor)) {
                return;
            }
            HashMap params = this.getParameterList(e);
            String ipAddress = (String)this.getObjectForParam(params, "Missing code - ClientParameterCode.NEIGHBOR_IP_ADDRESS", true);
            Object lastKeepAlive = this.getObjectForParam(params, ClientParameterCode.NEIGHBOR_LAST_KEEPALIVE, true);
            Object name = this.getObjectForParam(params, "Missing code - ClientParameterCode.NEIGHBOR_NAME", true);
            VSwitch parentVSwitch = (VSwitch)this.getObjectForParam(params, "Missing code - ClientParameterCode.NEIGHBOR_PARENT_VSWITCH", true);
            Object status = this.getObjectForParam(params, "Missing code - ClientParameterCode.NEIGHBOR_STATUS", true);
            if (ipAddress == null) {
                ipAddress = neighbor.getIPAddress();
            }
            if (lastKeepAlive == null) {
                lastKeepAlive = neighbor.getLastKeepAliveReceived();
            }
            if (name == null) {
                name = neighbor.getName();
            }
            if (parentVSwitch == null) {
                parentVSwitch = neighbor.getParentVSwitch();
            }
            if (status == null) {
                status = neighbor.getStatus();
            }
            Neighbor nbr = new Neighbor(neighbor);
            nbr.setIPAddress(ipAddress);
            nbr.setLastKeepAliveReceived((Long)lastKeepAlive);
            nbr.setName((String)name);
            VSwitchNode parent = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(parentVSwitch);
            theLogger.logAndAssert(SrLogCategories.ERROR, parent != null, new Object[]{"Neighbor is created before VSwitch"});
            if (parent == null) {
                return;
            }
            nbr.setVSwitchParent(parent);
            nbr.setNeighborStatus((String)status);
            parent.getNeighbors().add(nbr);
            theLogger.trace(SrLogCategories.LEGACY, "Neighbor created: ", nbr.getName(), " parent= ", parent.getName());
            SystemRootNode.getInstance().putRefAndStub(neighbor, nbr);
            ClusterNode clusterNode = (ClusterNode)parent.getParent();
            boolean wasRemoved = clusterNode.removeGraphicalIndication(clusterNode, ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.ADDING_NEIGHBOR, neighbor.getIPAddress()));
            if (wasRemoved) {
                SrTransientWindowPane.showAddNeighborCompleted(ClientLoader.getMainFrame(), clusterNode.getAlias(), ipAddress, new SrAlarmsTablePanel.SourceAction<ClusterNode>((View<ClusterNode>)new ConstantView<ClusterNode>(Collections.singleton(clusterNode))));
            }
            this.fireNeighborCreated(nbr);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            NeighborManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        boolean wasRemoved;
        RemoteObject obj = e.getElement();
        Neighbor neighbor = (Neighbor)SystemRootNode.getInstance().getRefByStub(obj);
        if (neighbor == null) {
            try {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Neighbor " + ((com.sanrad.nms.server.logic.vswitch.Neighbor)obj).getName() + " is removed but its node does not exist");
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            }
            return;
        }
        neighbor.getVSWitchParent().getNeighbors().remove(neighbor);
        theLogger.trace(SrLogCategories.LEGACY, "Neighbor removed: ", neighbor.getName());
        ClusterNode cluster = (ClusterNode)neighbor.getVSWitchParent().getParent();
        boolean bl = wasRemoved = cluster == null || cluster.removeGraphicalIndication(cluster, ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.REMOVING_NEIGHBOR, neighbor.getIPAddress()));
        if (wasRemoved) {
            String clusterAlias = null;
            if (cluster != null) {
                clusterAlias = cluster.getAlias();
            }
            SrTransientWindowPane.showRemoveNeighborCompleted(ClientLoader.getMainFrame(), clusterAlias, neighbor.getName(), new SrAlarmsTablePanel.SourceAction<ClusterNode>((View<ClusterNode>)new ConstantView<ClusterNode>(Collections.singleton(cluster))));
        }
        this.fireNeighborRemoved(neighbor);
        SystemRootNode.getInstance().removeRefAndIdByStub(obj);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    private void fireNeighborCreated(Neighbor neighbor) {
        NeighborEvent event = new NeighborEvent(this, (RemoteObject)neighbor.getStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire neighbor created event.");
        this.m_listeners.fireEvent(NeighborListener.class, event, this.neighborCreatedInformer);
    }

    private void fireNeighborRemoved(Neighbor neighbor) {
        NeighborEvent event = new NeighborEvent(this, (RemoteObject)neighbor.getStub());
        theLogger.trace(SrLogCategories.LEGACY, "fire neighbor removed event.");
        this.m_listeners.fireEvent(NeighborListener.class, event, this.neighborRemovedInformer);
    }
}

