/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch;

import com.sanrad.nms.client.data.vswitch.TableRowNode;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.IfJumboMtuConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;

public class InterfaceTableRowNode<T extends InterfaceTableRow>
extends TableRowNode<T>
implements Comparable {
    private String alias;
    private String name;
    private String descriptor;
    private String physAddress;
    private String type;
    private BigInteger highSpeed;
    private String operStatus;
    private IfJumboMtuConstant myJumboMtuVal = null;

    public InterfaceTableRowNode(T stub, VSwitch parentStub, String alias, String descriptor, BigInteger highSpeed, String name, String physAddress, String type, String operStatus) throws RemoteException {
        super(stub, parentStub);
        this.setAlias(alias);
        this.setOperStatus(operStatus);
        this.descriptor = descriptor;
        this.highSpeed = highSpeed;
        this.name = name;
        this.physAddress = physAddress;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setOperStatus(String operStatus) {
        this.operStatus = operStatus;
    }

    public String getOperStatus() {
        return this.operStatus;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setHighSpeed(BigInteger highSpeed) {
        this.highSpeed = highSpeed;
    }

    public BigInteger getHighSpeed() {
        return this.highSpeed;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public IfJumboMtuConstant getJumboMtu() {
        return this.myJumboMtuVal;
    }

    public void setJumboMtu(IfJumboMtuConstant aMtu) {
        this.myJumboMtuVal = aMtu;
    }

    public void setPhysAddress(String physAddress) {
        this.physAddress = physAddress;
    }

    public String getPhysAddress() {
        return this.physAddress;
    }

    @Override
    public String toString() {
        return this.alias;
    }

    @Override
    public String type() {
        return "Interface";
    }

    public boolean isMgntInterface() {
        return this.getName().equals("mgnt");
    }

    @Override
    public int compareTo(Object o) {
        int answer = Integer.MIN_VALUE;
        if (o instanceof InterfaceTableRowNode) {
            InterfaceTableRowNode comp2 = (InterfaceTableRowNode)o;
            String val1 = this.getAlias();
            answer = val1.compareTo(comp2.getAlias());
        }
        return answer;
    }

    public boolean canBeReset() {
        String type = this.getType();
        return !type.equalsIgnoreCase("rs232");
    }

    public boolean isSupportsJumboMtu() {
        if (!"ethernetCsmacd".equals(this.getType())) {
            return false;
        }
        return !this.isMgntInterface();
    }
}

