/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.InterfaceTableRowNode;
import com.sanrad.nms.client.data.vswitch.TableRowNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.util.Util;
import java.rmi.RemoteException;

public class IPRouteTableRow
extends TableRowNode<com.sanrad.nms.server.logic.vswitch.IPRouteTableRow> {
    private static final String IP_ROUTE_TABLE_ROW_TYPE = ClientLoader.BUNDLE.getString(SrClientBundleKeys.IP_ROUTE_TABLE_ROW_TYPE);
    private String myDestIPAddress;
    private String myDestIPMask;
    private String gateway;
    private InterfaceTableRowNode interfaceRow;

    public IPRouteTableRow(com.sanrad.nms.server.logic.vswitch.IPRouteTableRow stub, VSwitch parentStub, String destIPAddress, String destIPMask, String gateway, InterfaceTableRow interfaceStub) throws RemoteException {
        super(stub, parentStub);
        this.myDestIPAddress = destIPAddress;
        this.myDestIPMask = destIPMask;
        this.gateway = gateway;
        this.interfaceRow = (InterfaceTableRowNode)SystemRootNode.getInstance().getRefByStub(interfaceStub);
    }

    public void setDestIPAddress(String destIPAddress) {
        this.myDestIPAddress = destIPAddress;
    }

    public String getDestIPAddress() {
        return this.myDestIPAddress;
    }

    public void setDestIPMask(String destIPMask) {
        this.myDestIPMask = destIPMask;
    }

    public String getDestIPMask() {
        return this.myDestIPMask;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getGateway() {
        return this.gateway;
    }

    public InterfaceTableRowNode getInterface() {
        return this.interfaceRow;
    }

    @Override
    public String type() {
        return IP_ROUTE_TABLE_ROW_TYPE;
    }

    @Override
    public String getProblemOnDeletion() {
        if (!this.getParent().isConnected()) {
            return ClientLoader.VSWITCH_DISPLAY_STRING + " " + this.getParent() + " is disconnected";
        }
        return super.getProblemOnDeletion();
    }

    @Override
    public String toString() {
        return IPRouteTableRow.getCIDRNotation(this.myDestIPAddress, this.myDestIPMask);
    }

    public static String getCIDRNotation(String aIPAddress, String aIPMask) {
        int maskSize = 0;
        boolean foundClear = false;
        for (long ip : Util.stringToLongArray(aIPMask)) {
            if (foundClear && ip != 0L) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Illegal IP mask", aIPMask);
                return "<Illegal mask of " + aIPMask + ">";
            }
            if (ip == 255L) {
                maskSize += 8;
                continue;
            }
            while (ip != 0L) {
                if (ip < 128L) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "Illegal IP mask", aIPMask);
                    return "<Illegal mask of " + aIPMask + ">";
                }
                ++maskSize;
                ip = (ip - 128L) * 2L;
            }
            foundClear = true;
        }
        return aIPAddress + "/" + maskSize;
    }
}

