/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.snapshot;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.CopyOperationNode;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotsTableHeader;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationEvent;
import com.sanrad.nms.client.event.volume.copy.CopyOperationListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.List;
import java.util.Vector;

public class SrSnapshotsTableModel
extends SrTableModel
implements CopyOperationListener {
    private ClusterNode m_clusterNode;
    private VolumeTreeNode m_sourceVolume;
    private VolumeAdapter m_volumeAdapter;

    public SrSnapshotsTableModel(ClusterNode clusterNode, VolumeTreeNode sourceVolume) {
        super(new SrDefaultTableColumns(SnapshotsTableHeader.getColumnNames()));
        this.m_clusterNode = clusterNode;
        this.m_sourceVolume = sourceVolume;
        this.initModel();
        this.m_volumeAdapter = new VolumeAdapter(){

            @Override
            public void volumeRemove(VolumeEvent e) {
                RemoteObject volStub = e.getStub();
                ClusterNode cluster = e.getClusterNode();
                SrTreeNode node = SystemRootNode.getInstance().getRefByStub(volStub);
                if (node instanceof SnapshotVolumeNode) {
                    SrSnapshotsTableModel.this.removeSnapshot(cluster, (SnapshotVolumeNode)node);
                }
            }

            @Override
            public void volumeCreate(VolumeEvent e) {
                RemoteObject volStub = e.getStub();
                ClusterNode cluster = e.getClusterNode();
                SrTreeNode node = SystemRootNode.getInstance().getRefByStub(volStub);
                if (node instanceof SnapshotVolumeNode) {
                    SrSnapshotsTableModel.this.addSnapshot(cluster, (SnapshotVolumeNode)node);
                }
            }

            @Override
            public void volumeAliasChanged(VolumeEvent e) {
                SrSnapshotsTableModel.this.fireTableRowsUpdated(0, SrSnapshotsTableModel.this.getLastRowIndex());
            }

            @Override
            public void volumeStatusChanged(VolumeEvent e) {
                SrSnapshotsTableModel.this.fireTableRowsUpdated(0, SrSnapshotsTableModel.this.getLastRowIndex());
            }

            @Override
            public void volumeParametersChanged(VolumeEvent e) {
                RemoteObject stub = e.getStub();
                ClusterNode cluster = e.getClusterNode();
                SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
                if (node instanceof SnapshotVolumeNode) {
                    SrSnapshotsTableModel.this.updateSnapshot(cluster, (SnapshotVolumeNode)node);
                }
            }

            @Override
            public void snapshotSourceChanged(VolumeEvent e) {
                SrSnapshotsTableModel.this.removeAllRows();
                SrSnapshotsTableModel.this.initModel();
            }
        };
    }

    @Override
    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this.m_volumeAdapter);
        CopyOperManager.getInstance().removeCopyOperationListener(this);
    }

    @Override
    public void addListeners() {
        VolumeManager.getInstance().addVolumeListener(this.m_volumeAdapter);
        CopyOperManager.getInstance().addCopyOperationListener(this);
    }

    protected void initModel() {
        if (this.m_clusterNode == null && this.m_sourceVolume == null) {
            return;
        }
        List<SnapshotVolumeNode> snapshots = null;
        snapshots = this.m_sourceVolume == null ? VolumeManager.getInstance().getClusterSnapshotMap().getAllSnapshotsVolumes(this.m_clusterNode) : VolumeManager.getInstance().getClusterSnapshotMap().getSnapshotsForSource(this.m_clusterNode, this.m_sourceVolume);
        if (snapshots != null && !snapshots.isEmpty()) {
            for (SnapshotVolumeNode curObj : snapshots) {
                this.addSnapshot(curObj);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    protected void addSnapshot(SnapshotVolumeNode snapshot) {
        Vector<Object> rowData = new Vector<Object>(SnapshotsTableHeader.getColumnNames().size());
        rowData.addElement(snapshot.getSourceVolume());
        rowData.addElement(snapshot);
        rowData.addElement(snapshot.getDateAndTime());
        rowData.addElement(new Integer(snapshot.getPercentageLoad()));
        if (snapshot.getRestoreOperation() != null) {
            rowData.addElement(snapshot.getRestoreOperation().getCopyStatus());
            rowData.addElement(snapshot.getRestoreOperation().getProgress());
        } else {
            rowData.addElement("----");
            rowData.addElement("----");
        }
        this.addRowQuetly(rowData.toArray(), -1);
    }

    protected void removeSnapshot(ClusterNode cluster, SnapshotVolumeNode snapshot) {
        if (cluster.equals(this.m_clusterNode)) {
            int snapshotCol = this.getColumnIndex(SnapshotsTableHeader.SNAPSHOT.getColumnName());
            for (int i = 0; i < this.getRowCount(); ++i) {
                Object nextSnapshot = this.getValueAt(i, snapshotCol);
                if (!snapshot.equals(nextSnapshot)) continue;
                this.removeRow(i);
                return;
            }
        }
    }

    protected void addSnapshot(ClusterNode cluster, SnapshotVolumeNode snapshot) {
        if (cluster.equals(this.m_clusterNode)) {
            this.addSnapshot(snapshot);
            this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
        }
    }

    public void updateSnapshot(ClusterNode cluster, SnapshotVolumeNode snapshot) {
        if (cluster.equals(this.m_clusterNode)) {
            int snapCol = this.getColumnIndex(SnapshotsTableHeader.SNAPSHOT.getColumnName());
            int loadCol = this.getColumnIndex(SnapshotsTableHeader.UTILIZATION.getColumnName());
            int dateAndTimeCol = this.getColumnIndex(SnapshotsTableHeader.DATE_AND_TIME.getColumnName());
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getValueAt(i, snapCol).equals(snapshot)) continue;
                this.setValueAt(new Integer(snapshot.getPercentageLoad()), i, loadCol);
                this.setValueAt(snapshot.getDateAndTime(), i, dateAndTimeCol);
                return;
            }
        }
    }

    @Override
    public void copyOperationCreate(CopyOperationEvent e) {
        ClusterNode cluster;
        CopyOperationNode node = e.getNode();
        if (node instanceof RestoreOperationNode && (cluster = e.getClusterNode()).equals(this.m_clusterNode)) {
            int snapCol = this.getColumnIndex(SnapshotsTableHeader.SNAPSHOT.getColumnName());
            int restoreProgress = this.getColumnIndex(SnapshotsTableHeader.RESTORE_PROGRESS.getColumnName());
            int restoreStatus = this.getColumnIndex(SnapshotsTableHeader.RESTORE_OPER_STATUS.getColumnName());
            RestoreOperationNode restoreNode = (RestoreOperationNode)node;
            SnapshotVolumeNode snapshotNode = (SnapshotVolumeNode)restoreNode.getSource();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getValueAt(i, snapCol).equals(snapshotNode)) continue;
                this.setValueAt(restoreNode.getProgress(), i, restoreProgress);
                this.setValueAt(restoreNode.getCopyStatus(), i, restoreStatus);
                return;
            }
        }
    }

    @Override
    public void copyOperationRemove(CopyOperationEvent e) {
        ClusterNode cluster;
        CopyOperationNode node = e.getNode();
        if (node instanceof RestoreOperationNode && (cluster = e.getClusterNode()).equals(this.m_clusterNode)) {
            int snapCol = this.getColumnIndex(SnapshotsTableHeader.SNAPSHOT.getColumnName());
            int restoreProgress = this.getColumnIndex(SnapshotsTableHeader.RESTORE_PROGRESS.getColumnName());
            int restoreStatus = this.getColumnIndex(SnapshotsTableHeader.RESTORE_OPER_STATUS.getColumnName());
            RestoreOperationNode restoreNode = (RestoreOperationNode)node;
            SnapshotVolumeNode snapshotNode = (SnapshotVolumeNode)restoreNode.getSource();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getValueAt(i, snapCol).equals(snapshotNode)) continue;
                this.setValueAt("----", i, restoreProgress);
                this.setValueAt("----", i, restoreStatus);
                return;
            }
        }
    }

    @Override
    public void copyOperationChange(CopyOperationEvent e) {
        ClusterNode cluster;
        CopyOperationNode node = e.getNode();
        if (node instanceof RestoreOperationNode && (cluster = e.getClusterNode()).equals(this.m_clusterNode)) {
            int snapCol = this.getColumnIndex(SnapshotsTableHeader.SNAPSHOT.getColumnName());
            int restoreStatus = this.getColumnIndex(SnapshotsTableHeader.RESTORE_OPER_STATUS.getColumnName());
            int restoreProgress = this.getColumnIndex(SnapshotsTableHeader.RESTORE_PROGRESS.getColumnName());
            RestoreOperationNode restoreNode = (RestoreOperationNode)node;
            SnapshotVolumeNode snapshotNode = (SnapshotVolumeNode)restoreNode.getSource();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getValueAt(i, snapCol).equals(snapshotNode)) continue;
                this.setValueAt(restoreNode.getCopyStatus(), i, restoreStatus);
                this.setValueAt(restoreNode.getProgress(), i, restoreProgress);
                return;
            }
        }
    }

    @Override
    public void getAllCopyOperations(CopyOperationEvent e) {
    }

    public boolean canBeAborted(int[] selectedRows) {
        int statusCol = this.getColumnIndex(SnapshotsTableHeader.RESTORE_OPER_STATUS.getColumnName());
        boolean canAbort = selectedRows.length > 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            List<Object> rowData = this.getRow(selectedRows[i]);
            VolumeOperationOperStatusConstant operStat = (VolumeOperationOperStatusConstant)rowData.get(statusCol);
            if (this.operationStatusActive(operStat)) continue;
            canAbort = false;
            break;
        }
        return canAbort;
    }

    private boolean operationStatusActive(VolumeOperationOperStatusConstant operStat) {
        return operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING);
    }
}

