/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.snapshot;

import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotScheduler;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;

public class SnapshotSchedulerNode
extends SrTreeNode<SnapshotScheduler, CommKeyClassId> {
    private int mySnapCount;
    private BigInteger mySnapshotsSize;
    private Long myStartAt;
    private SnapshotSchedulerStateConstant myState;
    private CommKeyClassId mySourceVolumeId;
    private BigInteger myPeriodSec;

    public SnapshotSchedulerNode(SnapshotScheduler aStub) throws RemoteException {
        super(aStub, aStub.getCommKeyClassId());
    }

    @Override
    public String type() {
        return "Snapshot Scheduler";
    }

    public BigInteger getPeriod() {
        return this.myPeriodSec;
    }

    public void setPeriodSeconds(BigInteger aPeriod) {
        this.myPeriodSec = aPeriod;
    }

    public int getSnapCount() {
        return this.mySnapCount;
    }

    public void setSnapCount(int aSnapCount) {
        this.mySnapCount = aSnapCount;
    }

    public BigInteger getSnapshotsSize() {
        return this.mySnapshotsSize;
    }

    public void setSnapshotsSize(BigInteger aSnapshotsSize) {
        this.mySnapshotsSize = aSnapshotsSize;
    }

    public CommKeyClassId getSourceVolumeId() {
        return this.mySourceVolumeId;
    }

    public void setSourceVolumeId(CommKeyClassId aSourceVolumeId) {
        this.mySourceVolumeId = aSourceVolumeId;
    }

    public Long getStartAt() {
        return this.myStartAt;
    }

    public void setStartAt(Long aStartAt) {
        this.myStartAt = aStartAt;
    }

    public SnapshotSchedulerStateConstant getState() {
        return this.myState;
    }

    public void setState(SnapshotSchedulerStateConstant aState) {
        this.myState = aState;
    }

    public int getSnapshotSizePercentage() {
        VolumeTreeNode sourceVolume = this.getSourceVolume();
        if (sourceVolume != null) {
            BigInteger volumeSpace = sourceVolume.getAccessibleSpace();
            BigInteger snapshotBlocks = this.getSnapshotsSize();
            BigInteger snapshotSize = Util.blocksToBytes(snapshotBlocks, sourceVolume.getBlockSize());
            double percentageDouble = snapshotSize.doubleValue() / volumeSpace.doubleValue() * 100.0;
            return Util.round(percentageDouble, 0).intValue();
        }
        return 0;
    }

    public VolumeTreeNode getSourceVolume() {
        return (VolumeTreeNode)Manager.getRefById(this.mySourceVolumeId);
    }

    public boolean isRunning() {
        return SnapshotSchedulerStateConstant.RUNNING.equals(this.myState);
    }

    @Override
    public String getProblemOnDeletion() {
        if (this.isRunning()) {
            return "Scheduler is running";
        }
        return super.getProblemOnDeletion();
    }

    public List<SnapshotVolumeNode> getSnapshotVolumes() {
        return SnapshotSchedulerManager.getInstance().getSchedulerSnapshots(this);
    }

    @Override
    public String toString() {
        return this.type() + ':' + this.getSourceVolume();
    }
}

