/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.snapshot;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerNode;
import com.sanrad.nms.client.event.volume.snapshot.SnapshotSchedulerEvent;
import com.sanrad.nms.client.event.volume.snapshot.SnapshotSchedulerListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotScheduler;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SnapshotSchedulerManager
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static SnapshotSchedulerManager theInstance = new SnapshotSchedulerManager();
    private HashMap<ClusterNode, ArrayList<SnapshotSchedulerNode>> myClusterToSchedulersMap = new HashMap();
    SrEventListenerManager.Informer mySnapshotSchedulerRemovedInformer = new SrEventListenerManager.Informer<SnapshotSchedulerListener, SnapshotSchedulerEvent>(){

        @Override
        public void inform(SnapshotSchedulerListener listener, SnapshotSchedulerEvent aEvent) {
            listener.snapshotSchedulerRemoved(aEvent);
        }
    };
    SrEventListenerManager.Informer mySnapshotSchedulerCreatedInformer = new SrEventListenerManager.Informer<SnapshotSchedulerListener, SnapshotSchedulerEvent>(){

        @Override
        public void inform(SnapshotSchedulerListener listener, SnapshotSchedulerEvent aEvent) {
            listener.snapshotSchedulerCreated(aEvent);
        }
    };
    SrEventListenerManager.Informer mySnapshotSchedulerChangedInformer = new SrEventListenerManager.Informer<SnapshotSchedulerListener, SnapshotSchedulerEvent>(){

        @Override
        public void inform(SnapshotSchedulerListener listener, SnapshotSchedulerEvent aEvent) {
            listener.snapshotSchedulerChanged(aEvent);
        }
    };

    private SnapshotSchedulerManager() {
    }

    public static SnapshotSchedulerManager getInstance() {
        return theInstance;
    }

    public void addSnapshotSchedulerListener(SnapshotSchedulerListener aListener) {
        this.m_listeners.add(aListener);
    }

    public void removeSnapshotSchedulerListener(SnapshotSchedulerListener aListener) {
        this.m_listeners.remove(aListener);
    }

    private boolean isSchedulerExists(ClusterNode aCluster, SnapshotSchedulerNode aScheduler) {
        Util.validateInputNotNull(aCluster, "ClusterNode");
        List<SnapshotSchedulerNode> schedulers = this.getSnapshotSchedulers(aCluster);
        return schedulers.contains(aScheduler);
    }

    private void addSnapshotScheduler(ClusterNode aCluster, SnapshotSchedulerNode aSnapshotSchedulerNode) {
        Util.validateInputNotNull(aCluster, "ClusterNode");
        Util.validateInputNotNull(aSnapshotSchedulerNode, "Snapshot Scheduler");
        if (this.isSchedulerExists(aCluster, aSnapshotSchedulerNode)) {
            throw new IllegalArgumentException("Snapshot scheduler " + aSnapshotSchedulerNode + " already exists");
        }
        ArrayList<SnapshotSchedulerNode> schedulers = this.myClusterToSchedulersMap.get(aCluster);
        if (schedulers == null) {
            schedulers = new ArrayList();
            this.myClusterToSchedulersMap.put(aCluster, schedulers);
        }
        SystemRootNode.getInstance().putRefAndStub((RemoteObject)aSnapshotSchedulerNode.getStub(), aSnapshotSchedulerNode);
        schedulers.add(aSnapshotSchedulerNode);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        SnapshotScheduler snapshotSchedulerStub = (SnapshotScheduler)e.getElement();
        SnapshotSchedulerNode snapshotSchedulerNode = (SnapshotSchedulerNode)SystemRootNode.getInstance().getRefByStub(snapshotSchedulerStub);
        if (snapshotSchedulerNode == null) {
            return;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, "SnapshotSchedulerManager: snapshot scheduler removed: ", snapshotSchedulerNode);
        ClusterNode cluster = this.getSnapshotSchedulerCluster(snapshotSchedulerNode);
        this.removeSnapshotScheduler(snapshotSchedulerNode, cluster);
        this.fireSnapshotSchedulerRemoved(snapshotSchedulerNode, cluster);
    }

    private void removeSnapshotScheduler(SnapshotSchedulerNode aSnapshotScheduler, ClusterNode aCluster) {
        Util.validateInputNotNull(aCluster, "ClusterNode");
        Util.validateInputNotNull(aSnapshotScheduler, "Snapshot Scheduler");
        SystemRootNode.getInstance().removeRefAndIdByStub((RemoteObject)aSnapshotScheduler.getStub());
        Manager.removeStubAndId(aSnapshotScheduler);
        ArrayList<SnapshotSchedulerNode> schedulers = this.myClusterToSchedulersMap.get(aCluster);
        if (schedulers == null) {
            return;
        }
        schedulers.remove(aSnapshotScheduler);
        if (schedulers.isEmpty()) {
            this.myClusterToSchedulersMap.remove(aCluster);
        }
    }

    private ClusterNode getSnapshotSchedulerCluster(SnapshotSchedulerNode aSnapshotSchedulerNode) {
        for (ClusterNode cluster : this.myClusterToSchedulersMap.keySet()) {
            ArrayList<SnapshotSchedulerNode> schedulers = this.myClusterToSchedulersMap.get(cluster);
            if (schedulers == null) {
                throw new IllegalStateException("The mapping contains null for cluster: " + cluster);
            }
            if (!schedulers.contains(aSnapshotSchedulerNode)) continue;
            return cluster;
        }
        return null;
    }

    public List<SnapshotSchedulerNode> getSnapshotSchedulers(ClusterNode aCluster) {
        Util.validateInputNotNull(aCluster, "Cluster");
        ArrayList<SnapshotSchedulerNode> retSchedulers = new ArrayList<SnapshotSchedulerNode>();
        ArrayList<SnapshotSchedulerNode> schedulers = this.myClusterToSchedulersMap.get(aCluster);
        if (schedulers != null) {
            retSchedulers.addAll(schedulers);
        }
        return retSchedulers;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        SnapshotScheduler stub = (SnapshotScheduler)e.getElement();
        SnapshotSchedulerNode scheduler = (SnapshotSchedulerNode)SystemRootNode.getInstance().getRefByStub(stub);
        if (scheduler == null) {
            return;
        }
        HashMap params = this.getParameterList(e);
        BigInteger period = (BigInteger)params.get(ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD);
        Long startAt = (Long)params.get(ClientParameterCode.SNAPSHOT_SCHEDULER_START_AT);
        BigInteger snapCount = (BigInteger)params.get(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT);
        SnapshotSchedulerStateConstant state = (SnapshotSchedulerStateConstant)params.get(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE);
        BigInteger snapshotSize = (BigInteger)params.get(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE);
        if (period != null) {
            scheduler.setPeriodSeconds(period);
        }
        if (startAt != null) {
            scheduler.setStartAt(startAt);
        }
        if (snapCount != null) {
            scheduler.setSnapCount(snapCount.intValue());
        }
        if (state != null) {
            scheduler.setState(state);
        }
        if (snapshotSize != null) {
            scheduler.setSnapshotsSize(snapshotSize);
        }
        ClusterNode cluster = e.getClusterNode();
        this.fireSnapshotSchedulerChanged(scheduler, cluster);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        SnapshotSchedulerNode snapshotSchedulerNode;
        SnapshotScheduler stub = (SnapshotScheduler)e.getElement();
        HashMap params = this.getParameterList(e);
        try {
            snapshotSchedulerNode = this.createSnapshotSchedulerNode(stub, params);
        }
        catch (RemoteException e1) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e1, new Object[0]);
            return;
        }
        ClusterNode cluster = e.getClusterNode();
        if (snapshotSchedulerNode != null && cluster != null) {
            this.addSnapshotScheduler(cluster, snapshotSchedulerNode);
            this.fireSnapshotSchedulerCreated(snapshotSchedulerNode, cluster);
        }
    }

    private void fireSnapshotSchedulerCreated(SnapshotSchedulerNode aScheduler, ClusterNode aCluster) {
        SnapshotSchedulerEvent event = new SnapshotSchedulerEvent((Object)this, aScheduler);
        this.m_listeners.fireEvent(SnapshotSchedulerListener.class, event, this.mySnapshotSchedulerCreatedInformer);
    }

    private void fireSnapshotSchedulerRemoved(SnapshotSchedulerNode aScheduler, ClusterNode aCluster) {
        SnapshotSchedulerEvent event = new SnapshotSchedulerEvent((Object)this, aScheduler);
        this.m_listeners.fireEvent(SnapshotSchedulerListener.class, event, this.mySnapshotSchedulerRemovedInformer);
    }

    private void fireSnapshotSchedulerChanged(SnapshotSchedulerNode aScheduler, ClusterNode aCluster) {
        SnapshotSchedulerEvent event = new SnapshotSchedulerEvent((Object)this, aScheduler);
        this.m_listeners.fireEvent(SnapshotSchedulerListener.class, event, this.mySnapshotSchedulerChangedInformer);
    }

    private SnapshotSchedulerNode createSnapshotSchedulerNode(SnapshotScheduler aStub, HashMap aParams) throws RemoteException {
        BigInteger period = (BigInteger)aParams.get(ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD);
        Long startAt = (Long)aParams.get(ClientParameterCode.SNAPSHOT_SCHEDULER_START_AT);
        BigInteger snapCount = (BigInteger)aParams.get(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT);
        CommKeyClassId sourceVolume = (CommKeyClassId)aParams.get(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
        SnapshotSchedulerStateConstant state = (SnapshotSchedulerStateConstant)aParams.get(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE);
        BigInteger snapshotSize = (BigInteger)aParams.get(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE);
        if (period == null || startAt == null || snapCount == null || sourceVolume == null || state == null || snapshotSize == null) {
            theLogger.error(SrLogCategories.ILLEGAL_ARGUMENT, new IllegalStateException(), "The snapshot scheduler stub = ", aStub, " with params ", aParams, " received with empty or missing elements.");
            return null;
        }
        SnapshotSchedulerNode scheduler = new SnapshotSchedulerNode(aStub);
        scheduler.setPeriodSeconds(period);
        scheduler.setStartAt(startAt);
        scheduler.setSnapCount(snapCount.intValue());
        scheduler.setSourceVolumeId(sourceVolume);
        scheduler.setState(state);
        scheduler.setSnapshotsSize(snapshotSize);
        return scheduler;
    }

    public void readDataFromServer(ClusterNode aCluster) {
        try {
            for (SnapshotScheduler g : ((Cluster)aCluster.getStub()).getSnapshotSchedulers()) {
                HashMap params;
                SnapshotSchedulerNode curSchedNode = this.createSnapshotSchedulerNode(g, params = g.getClientParameterList());
                if (curSchedNode == null) continue;
                this.addSnapshotScheduler(aCluster, curSchedNode);
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e.getMessage());
        }
        catch (IllegalValueException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e.getMessage());
        }
    }

    public void readDataFromServer() {
        for (ClusterNode cluster : SystemRootNode.getInstance().getClusterNodes()) {
            this.readDataFromServer(cluster);
        }
    }

    public void removeSnapshotSchedulers(ClusterNode aCluster) {
        ArrayList<SnapshotSchedulerNode> snapshotSchedulers = this.myClusterToSchedulersMap.remove(aCluster);
        if (snapshotSchedulers == null) {
            return;
        }
        for (SnapshotSchedulerNode node : snapshotSchedulers) {
            this.removeSnapshotScheduler(node, aCluster);
        }
    }

    public SnapshotSchedulerNode getSnapshotSchedulerOfSource(VolumeTreeNode aVolumeNode) {
        Util.validateInputNotNull(aVolumeNode, "Volume node");
        for (ArrayList<SnapshotSchedulerNode> currSchedulerList : this.myClusterToSchedulersMap.values()) {
            for (SnapshotSchedulerNode currScheduler : currSchedulerList) {
                if (!Util.equals(currScheduler.getSourceVolumeId(), aVolumeNode.getIdentifier())) continue;
                return currScheduler;
            }
        }
        return null;
    }

    public SnapshotSchedulerNode getSchedulerOfSnapshot(SnapshotVolumeNode aSnapshot) {
        Util.validateInputNotNull(aSnapshot, "Snapshot volume");
        if (aSnapshot.isScheduled()) {
            VolumeTreeNode<?> sourceVolume = aSnapshot.getSourceVolume();
            if (sourceVolume == null) {
                throw new IllegalStateException("The snapshot " + aSnapshot + " has no source volume");
            }
            return this.getSnapshotSchedulerOfSource(sourceVolume);
        }
        return null;
    }

    public List<SnapshotVolumeNode> getSchedulerSnapshots(SnapshotSchedulerNode aSchedulerNode) {
        Util.validateInputNotNull(aSchedulerNode, "Scheduler Node");
        ClusterNode cluster = this.getSnapshotSchedulerCluster(aSchedulerNode);
        if (cluster == null) {
            throw new IllegalStateException("No cluster found for Snapshot Scheduler - " + aSchedulerNode);
        }
        List<SnapshotVolumeNode> allSnapshots = VolumeManager.getInstance().getClusterSnapshotMap().getSnapshotsForSource(cluster, aSchedulerNode.getSourceVolume());
        Iterator<SnapshotVolumeNode> i = allSnapshots.iterator();
        while (i.hasNext()) {
            if (i.next().isScheduled()) continue;
            i.remove();
        }
        return allSnapshots;
    }
}

