/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.snapshot;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeOperationHandler;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.util.concurrent.SrFuture;
import java.util.Collection;
import java.util.Collections;

public class SnapshotOperationHandler
extends VolumeOperationHandler {
    private static final SrLogger theLogger = SrLogger.getLogger();

    public SnapshotOperationHandler(VolumeTreeNode source) {
        super(source);
    }

    public Collection<SrFuture<Void>> operate(VolumeTreeNode targetVolume) {
        theLogger.logAndAssert(SrLogCategories.ERROR, "Running operate() method is not supported on SnapshotOperationHandler");
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isVolumeOperation() {
        return false;
    }

    public String isOperationLegitimate(VolumeTreeNode volumeNode) {
        if (CopyOperManager.getInstance().isInvolvedInOfflineCopy(volumeNode)) {
            return "The selected volume is involved in an offline copy";
        }
        if (volumeNode instanceof JournalVolumeNode) {
            return "The selected volume is journal";
        }
        if (VolumeManager.getInstance().isPartOfTheSameTree(this.mySourceVolume, volumeNode)) {
            return "The source and the selected volume are parts of the same tree";
        }
        return null;
    }

    @Override
    public String getOperationName() {
        return "Create Snapshot Volume";
    }

    @Override
    public boolean shouldBlockAction() {
        return false;
    }
}

