/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.volume.snapshot;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.client.data.volume.copy.RestoreOperationNode;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.server.RemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ClusterSnapshotMap {
    private HashMap<ClusterNode, SnapshotMap> myClusterToSnapshotMap = new HashMap();

    public void addSnapshotVolume(ClusterNode clusterNode, SnapshotVolumeNode snapshot) {
        SnapshotMap snapshotsMap = this.getOrCreateSnapshotMap(clusterNode);
        snapshotsMap.addSnapshotVolume(snapshot);
    }

    public void clearAll(ClusterNode clusterNode) {
        SnapshotMap snapshotsMap = this.myClusterToSnapshotMap.remove(clusterNode);
        if (snapshotsMap != null) {
            snapshotsMap.removeNotify();
        }
    }

    public void removeSnapshotVolume(ClusterNode clusterNode, SnapshotVolumeNode snapshot) {
        SnapshotMap snapshotsMap = this.getOrCreateSnapshotMap(clusterNode);
        snapshotsMap.removeSnapshotVolume(snapshot);
    }

    public boolean isSourceOfSnapshot(ClusterNode clusterNode, VolumeTreeNode volumeNode) {
        SnapshotMap snapshotsMap = this.getOrCreateSnapshotMap(clusterNode);
        return snapshotsMap.isSourceOfSnapshot(volumeNode);
    }

    public boolean isSnapshotOfSource(ClusterNode aClusterNode, VolumeTreeNode aVolumeNode, SnapshotVolumeNode aSnapshot) {
        SnapshotMap snapMap = this.myClusterToSnapshotMap.get(aClusterNode);
        if (snapMap == null) {
            return false;
        }
        List<SnapshotVolumeNode> snapshots = snapMap.getSnapshotsForSource(aVolumeNode);
        return snapshots.contains(aSnapshot);
    }

    public List<SnapshotVolumeNode> getSnapshotsForSource(ClusterNode clusterNode, VolumeTreeNode volumeNode) {
        SnapshotMap snapshotsMap = this.getOrCreateSnapshotMap(clusterNode);
        return snapshotsMap.getSnapshotsForSource(volumeNode);
    }

    public int getSnapshotCount(ClusterNode clusterNode, VolumeTreeNode volumeNode) {
        SnapshotMap snapshotsMap = this.getOrCreateSnapshotMap(clusterNode);
        return snapshotsMap.getSnapshotCount(volumeNode);
    }

    public List getAllSnapshotsVolumes(ClusterNode clusterNode) {
        SnapshotMap snapshotsMap = this.getOrCreateSnapshotMap(clusterNode);
        return snapshotsMap.getAllSnapshotsVolumes();
    }

    private SnapshotMap getOrCreateSnapshotMap(ClusterNode clusterNode) {
        SnapshotMap snapshotsMap = this.myClusterToSnapshotMap.get(clusterNode);
        if (snapshotsMap == null) {
            snapshotsMap = new SnapshotMap();
            this.myClusterToSnapshotMap.put(clusterNode, snapshotsMap);
        }
        return snapshotsMap;
    }

    public boolean isInvolvedInActiveRestore(VolumeTreeNode vol) {
        if (this.isActiveRestoreDst(vol)) {
            return true;
        }
        if (vol instanceof SnapshotVolumeNode) {
            return this.isActiveRestoreSrc((SnapshotVolumeNode)vol);
        }
        return false;
    }

    public boolean isInvolvedInRestore(VolumeTreeNode vol) {
        if (this.isRestoreDst(vol)) {
            return true;
        }
        if (vol instanceof SnapshotVolumeNode) {
            return this.isRestoreSrc((SnapshotVolumeNode)vol);
        }
        return false;
    }

    public boolean isActiveRestoreDst(VolumeTreeNode vol) {
        List<SnapshotVolumeNode> snapshotsOfSource;
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfStub((RemoteObject)vol.getStub());
        if (this.isSourceOfSnapshot(clusterNode, vol) && (snapshotsOfSource = this.getSnapshotsForSource(clusterNode, vol)) != null) {
            for (int index = 0; index < snapshotsOfSource.size(); ++index) {
                SnapshotVolumeNode snapshotVolumeNode = snapshotsOfSource.get(index);
                RestoreOperationNode restoreOperationNode = snapshotVolumeNode.getRestoreOperation();
                if (restoreOperationNode == null || !CopyOperManager.getInstance().operationStatusActive(restoreOperationNode.getCopyStatus())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRestoreDst(VolumeTreeNode vol) {
        List<SnapshotVolumeNode> snapshotsOfSource;
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfStub((RemoteObject)vol.getStub());
        if (this.isSourceOfSnapshot(clusterNode, vol) && (snapshotsOfSource = this.getSnapshotsForSource(clusterNode, vol)) != null) {
            for (int index = 0; index < snapshotsOfSource.size(); ++index) {
                SnapshotVolumeNode snapshotVolumeNode = snapshotsOfSource.get(index);
                RestoreOperationNode restoreOperationNode = snapshotVolumeNode.getRestoreOperation();
                if (restoreOperationNode == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActiveRestoreSrc(SnapshotVolumeNode snapshotVolume) {
        RestoreOperationNode restoreOperationNode = snapshotVolume.getRestoreOperation();
        return restoreOperationNode != null && CopyOperManager.getInstance().operationStatusActive(restoreOperationNode.getCopyStatus());
    }

    public boolean isRestoreSrc(SnapshotVolumeNode snapshotVolume) {
        RestoreOperationNode restoreOperationNode = snapshotVolume.getRestoreOperation();
        return restoreOperationNode != null;
    }

    class SnapshotMap {
        private HashMap<VolumeTreeNode, ArrayList<SnapshotVolumeNode>> snapshotMap = new HashMap();
        private VolumeAdapter m_volListener;

        public SnapshotMap() {
            this.m_volListener = new VolumeAdapter(){

                @Override
                public void snapshotSourceChanged(VolumeEvent e) {
                    RemoteObject stub = e.getStub();
                    SnapshotVolumeNode snap = (SnapshotVolumeNode)SystemRootNode.getInstance().getRefByStub(stub);
                    Iterator itr = SnapshotMap.this.snapshotMap.keySet().iterator();
                    while (itr.hasNext()) {
                        List snapsForKey = (List)SnapshotMap.this.snapshotMap.get(itr.next());
                        if (!snapsForKey.contains(snap)) continue;
                        snapsForKey.remove(snap);
                        if (!snapsForKey.isEmpty()) break;
                        itr.remove();
                        break;
                    }
                    SnapshotMap.this.addSnapshotVolume(snap);
                }
            };
            VolumeManager.getInstance().addVolumeListener(this.m_volListener);
        }

        private void removeNotify() {
            VolumeManager.getInstance().removeVolumeListener(this.m_volListener);
        }

        public void addSnapshotVolume(SnapshotVolumeNode snapshot) {
            VolumeTreeNode<?> sourceVol = snapshot.getSourceVolume();
            if (sourceVol == null) {
                return;
            }
            ArrayList<SnapshotVolumeNode> snapsList = this.snapshotMap.get(sourceVol);
            if (snapsList == null) {
                snapsList = new ArrayList();
                this.snapshotMap.put(sourceVol, snapsList);
            }
            snapsList.add(snapshot);
        }

        public void removeSnapshotVolume(SnapshotVolumeNode snapshot) {
            VolumeTreeNode<?> sourceVol = snapshot.getSourceVolume();
            ArrayList<SnapshotVolumeNode> snapsForSource = this.snapshotMap.get(sourceVol);
            if (snapsForSource != null) {
                snapsForSource.remove(snapshot);
                if (snapsForSource.isEmpty()) {
                    this.snapshotMap.remove(sourceVol);
                }
            }
        }

        public boolean isSourceOfSnapshot(VolumeTreeNode volumeNode) {
            if (!this.snapshotMap.containsKey(volumeNode)) {
                return false;
            }
            List snapshotsList = this.snapshotMap.get(volumeNode);
            return !snapshotsList.isEmpty();
        }

        public List<SnapshotVolumeNode> getSnapshotsForSource(VolumeTreeNode volumeNode) {
            ArrayList<SnapshotVolumeNode> retList = new ArrayList<SnapshotVolumeNode>();
            ArrayList<SnapshotVolumeNode> snapshots = this.snapshotMap.get(volumeNode);
            if (snapshots != null) {
                retList.addAll(snapshots);
            }
            return retList;
        }

        public List<SnapshotVolumeNode> getAllSnapshotsVolumes() {
            ArrayList<SnapshotVolumeNode> allSnaps = new ArrayList<SnapshotVolumeNode>();
            for (ArrayList<SnapshotVolumeNode> snaps : this.snapshotMap.values()) {
                allSnaps.addAll(snaps);
            }
            return allSnaps;
        }

        public int getSnapshotCount(VolumeTreeNode volumeNode) {
            ArrayList<SnapshotVolumeNode> snapsList = this.snapshotMap.get(volumeNode);
            if (snapsList == null) {
                return 0;
            }
            return snapsList.size();
        }
    }
}

